<?php

namespace Drupal\Tests\acquia_cookie_vary\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Test cases for the settings form.
 *
 * @group acquia_cookie_vary
 */
class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['acquia_cookie_vary'];

  /**
   * {@inheritdoc}
   */
  public $defaultTheme = 'stark';

  /**
   * Test case for the settings form.
   */
  public function testSettingsForm() {

    $assert = $this->assertSession();

    // Access denied by default.
    $this->drupalGet(Url::fromRoute('acquia_cookie_vary.settings'));
    $assert->statusCodeEquals(403);

    // Access granted by administer site configuration.
    $this->drupalLogin($this->drupalCreateUser(['administer site configuration']));
    $this->drupalGet(Url::fromRoute('acquia_cookie_vary.settings'));
    $assert->statusCodeEquals(200);

    // Ensure that settings are persisted.
    $this->submitForm(['custom_cookie' => 'test', 'debug' => TRUE], 'Save configuration');
    $config = $this->config('acquia_cookie_vary.settings');
    static::assertSame('test', $config->get('custom_cookie'));
    static::assertTrue($config->get('debug'));
  }

}
