<?php

declare(strict_types=1);

namespace Drupal\Tests\acquiadam_asset_import\FunctionalJavascript;

use Drupal\Tests\acquia_dam\FunctionalJavascript\AcquiaDamWebDriverTestBase;
use Drupal\Tests\field\Traits\EntityReferenceFieldCreationTrait;

// Workaround to support tests against both Drupal 10.1 and Drupal 11.0.
// @todo Remove once we depend on Drupal 10.2.
if (!trait_exists(EntityReferenceFieldCreationTrait::class)) {
  class_alias('\Drupal\Tests\field\Traits\EntityReferenceTestTrait', EntityReferenceFieldCreationTrait::class);
}

/**
 * Tests config form submission.
 *
 * @tests \Drupal\acquiadam_asset_import\Form\BulkImportConfigForm
 *
 * @group acquia_dam
 */
class BulkImportConfigFormSubmitTest extends AcquiaDamWebDriverTestBase {

  use EntityReferenceFieldCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'starterkit_theme';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'acquia_dam',
    'acquiadam_asset_import',
  ];

  /**
   * Tests that the form can be submitted.
   *
   * @throws \Behat\Mink\Exception\ElementNotFoundException
   * @throws \Drupal\Core\Entity\EntityStorageException|\Behat\Mink\Exception\ResponseTextException
   */
  public function testFormSubmit(): void {
    $user = $this->createUser(['administer site configuration']);
    $this->drupalLogin($user);
    $this->grantSiteRegistrationToken();
    $this->grantCurrentUserDamToken();
    $this->drupalGet('/admin/config/acquia-dam/bulk-import');

    // Check the initial state of the form.
    $this->assertSession()->pageTextContains('Acquia DAM bulk import');
    $category_select_list = $this->assertSession()->selectExists('edit-category-uuid');
    $this->assertSession()->pageTextContains('List of categories in the remote DAM system available for the authorized user account. Please choose which of them the media assets should be imported from. When adding the same category multiple times, only the last row of them will be considered and saved.');
    $assignment_table_wrapper = $this->assertSession()->elementExists('css', '#assignment-list-wrapper');
    $assignment_table_wrapper->hasTable('edit-assignment-list');
    $this->assertSession()->pageTextContains('No category has been selected yet.');

    // Select a category.
    $category_select_list->selectOption('Testing');
    $this->assertSession()->pageTextContains('The website automatically detects the file type of each asset in remote DAM and does its best to guess which media type it should be assigned to. In the case of a category containing various types of assets, this filtering option allows you to import only those assets which would be assigned to the given media types.');
    $asset_filtering_checkbox = $this->assertSession()->elementExists('css', '#edit-activate-filtering');
    $category_add_button = $this->assertSession()->buttonExists('edit-add-button');

    // Enable filtering.
    $asset_filtering_checkbox->check();
    $this->assertSession()->pageTextContains('Import only assets which would be assigned to these media types');
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-image-asset');
    $this->assertSession()->pageTextContains('List of DAM-capable media types currently existing on this site. Set the filtration by specifying those media types that are allowed to receive assets during the import process. Any other assets within the defined category not fitting any allowed media type listed here will be skipped.');

    // Add the current assignment to the list.
    $category_add_button->click();

    // Check the table content.
    $this->getSession()->wait(1000);
    $this->assertSession()->elementExists('css', 'tr[data-drupal-selector="edit-assignment-list-0"].odd');
    $this->assertSession()->elementTextContains('css', '#assignment-list-wrapper > table > tbody > tr:nth-child(1) > td:nth-child(1)', 'Testing');
    $this->assertSession()->elementTextContains('css', '#assignment-list-wrapper > table > tbody > tr:nth-child(1) > td:nth-child(2)', 'All assets (no filtering)');

    // Now the first row is added to the table, let's check resetting the form.
    $category_select_list->selectOption('Please choose one…');
    $this->assertSession()->pageTextNotContains('The website automatically detects the file type of each asset in remote DAM and does its best to guess which media type it should be assigned to. In the case of a category containing various types of assets, this filtering option allows you to import only those assets which would be assigned to the given media types.');
    // $this->assertSession()->elementNotExists('css',
    // '#edit-activate-filtering');
    // $this->assertSession()->buttonNotExists('edit-add-button');
    // Delete the first row.
    $this->assertSession()->buttonExists('Remove')->click();
    $this->getSession()->wait(1000);
    $this->assertSession()->pageTextContains('No category has been selected yet.');

    // Select a category again.
    $category_select_list->selectOption('Testing');
    $this->assertSession()->elementExists('css', '#edit-activate-filtering')->check();

    // Select all the media types.
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-documents-asset')->check();
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-image-asset')->check();
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-pdf-asset')->check();
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-spinset-asset')->check();
    $this->assertSession()->elementExists('css', '#edit-filter-media-bundles-acquia-dam-video-asset')->check();

    // Add the current assignment to the list again.
    $category_add_button->click();

    // Finally submit the form.
    $this->assertSession()->buttonExists('edit-submit')->click();
    $this->assertSession()->pageTextContains('No asset was queued for later importing which can be normal if all assets from these categories have been imported already earlier. Depending on cron runs, some of their corresponding media items should appear on the DAM media list soon.');
  }

}
