<?php

declare(strict_types=1);

namespace Drupal\acquia_dam\Plugin\media\acquia_dam;

use Drupal\acquia_dam\Entity\ManagedFileField;
use Drupal\acquia_dam\Entity\MediaSourceField;
use Drupal\Core\Plugin\PluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Media Source Type for DAM Assets.
 */
abstract class MediaSourceTypeBase extends PluginBase implements MediaSourceTypeInterface {

  /**
   * Field name when using embed codes.
   */
  protected string $embedCodeAssetField = MediaSourceField::SOURCE_FIELD_NAME;

  /**
   * Field name when using download/sync.
   */
  protected string $localFileAssetField = ManagedFileField::MANAGED_FILE_FIELD_NAME;

  /**
   * Array of field configurations keyed by the base field name.
   *
   * @var array|array[]
   */
  protected array $assetFieldFormatterConfiguration = [
    MediaSourceField::SOURCE_FIELD_NAME => [
      'type' => 'acquia_dam_embed_code',
      'label' => 'hidden',
      'settings' => [
        'embed_style' => 'original',
      ],
      'third_party_settings' => [],
      'region' => 'content',
    ],
    ManagedFileField::MANAGED_FILE_FIELD_NAME => [
      'type' => 'file_default',
      'settings' => [
        'use_description_as_link_text' => TRUE,
      ],
      'third_party_settings' => [],
      'weight' => 0,
      'label' => 'hidden',
      'region' => 'content',
    ],
  ];

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
          $configuration,
          $plugin_id,
          $plugin_definition
      );
  }

  /**
   * {@inheritdoc}
   */
  public function setConfiguration(array $configuration): void {
    $this->configuration = $configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration(): array {
    return $this->configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function getActiveFieldName(): string {
    if ($this->configuration['download_assets']) {
      return $this->localFileAssetField;
    }
    return $this->embedCodeAssetField;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormatter($managed_field_name): array
  {
    if (isset($this->assetFieldFormatterConfiguration[$managed_field_name])) {
      return $this->assetFieldFormatterConfiguration[$managed_field_name];
    }
    // Return the generic embed code asset field if no matches are found.
    return $this->assetFieldFormatterConfiguration[MediaSourceField::SOURCE_FIELD_NAME];
  }
}
