<?php

declare(strict_types=1);

namespace Drupal\acquia_dam\Plugin\media\acquia_dam;

use Drupal\acquia_dam\Entity\ManagedImageField;
use Drupal\Core\Config\Config;
use Drupal\Core\Entity\Entity\EntityViewDisplay;

/**
 * Image Media Source Type.
 *
 * @AssetMediaSource(
 *   id = "image",
 *   label = @Translation("Acquia DAM: Image"),
 *   default_thumbnail_filename = "generic.png",
 *   asset_search_key = "ft",
 *   asset_search_value = "image",
 * )
 */
final class Image extends MediaSourceTypeBase implements MediaSourceTypeInterface {

  /**
   * {@inheritdoc}
   */
  protected string $localFileAssetField = ManagedImageField::MANAGED_IMAGE_FIELD_NAME;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition)  {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->assetFieldFormatterConfiguration[$this->localFileAssetField] = [
      'type' => 'image',
      'label' => 'hidden',
      'settings' => [
        'image_link' => '',
        'image_style' => '',
        'image_loading' => ['attribute' => 'lazy'],
      ],
      'third_party_settings' => [],
      'region' => 'content',
    ];
  }

  /**
   * Helper function to get content region.
   *
   * @param array $content_region
   *    The content region.
   * @param string $existing_field_name
   *    Existing field to disable in the display.
   * @param string $active_field_name
   *    Name of the (newly) active field.
   * @param array $active_field
   *    Settings for the (newly) active field.
   *
   * @return array
   *   Return the active field data.
   */
  protected function setSettings(array $content_region, string $existing_field_name, string $active_field_name, array $active_field): array {
    // Get the existing field settings.
    $settings = $content_region[$existing_field_name]['settings'];

    // Get the style key of existing field.
    $existing_style_key = $existing_field_name === $this->localFileAssetField ? 'image_style' : 'embed_style';
    // Get the style key of new field.
    $new_style_key = $existing_field_name === $this->localFileAssetField ? 'embed_style' : 'image_style';
    // Get the style value of existing field.
    $style_value = $settings[$existing_style_key] === 'remotely_referenced_thumbnail_image' ? 'original' : $settings[$existing_style_key];
    // Get the style value to new field.
    $active_field['settings'][$new_style_key] = $style_value;

    return $active_field;
  }

}
