# Acquia Optimize Module

Module that implements the Acquia Optimize Quick Scan for editors in Drupal to see potential SEO and accessibility issues on any page.

## Features

- Checks the page for accessibility problems against a range of guidelines
- Offers suggestions to improve Search Engine Optimization of a page
- Gives a "reading level" to a page to assess the difficulty of a page

## Installation

1. Install with Composer:  
```sh  
composer require drupal/acquia_optimize
```

2. Enable the module from `/admin/modules`.

## Configuration

**Configuration changes can only be made those who have been given the `administer acquia optimize` permission on Drupal**

1. Go to the module configuration page on your Drupal installation:
```sh
/admin/config/content/acquia-optimize
```
2. Set the API Key and API Url to the ones from your account on https://new.monsido.com

3. Choose an `Accessibility Guideline` level from the dropdown. There are many options that will determine the level of check performed by the API.

## Usage

**The quick scan can be performed by any editor with the permission `scan acquia optimize`**

The Quick Scan can be performed on content pages in Drupal. This can be found in the side bar under the name `Acquia Optimize`

The plugin cannot be used until the node has been saved. The button will be greyed out if the node is not saved. If the node has been saved, the `Start Quick Scan` button will be clickable, and will perform a quick scan on the node as if it was loaded to a user reading the page.

## Tests

Tests can be run with `phpunit --group acquia-optimize`.
