(function (Drupal) {
  Drupal.AjaxCommands.prototype.pagePreprocess = function (ajax, response, status) {
    const container = document.getElementById('acquia-optimize-ajax-container');

    const iframe = document.createElement('iframe');
    iframe.style.width = '100vw';
    iframe.style.height = '100vh';
    iframe.style.visibility = 'hidden';
    iframe.style.position = 'absolute';
    iframe.srcdoc = response.html;
    container.after(iframe);

    iframe.onload = function() {
      const iframeDocument = iframe.contentWindow.document;
      const iframeHtml = iframeDocument.documentElement;
      const dataCollector = new DataCollector();
      dataCollector.collectData(iframeHtml).then((output) => {
        document.getElementById('acquia_optimize_encoded_page_value').value = JSON.stringify(output);
        document.querySelector('#acquia-optimize-ajax-container [type="submit"]').dispatchEvent(new Event('click'));
        iframe.remove();
      });


    };
  };
})(Drupal);
