(function($) {
  $(document).ready(function() {
    $('.scan-results__expansion').hide()

    $(document).on('click', '#seo-results', toggleSeoResults)
    $(document).on('click', '.scan-results__expansion__details', toggleAccessibilityContainer)
    $(document).on('click', '.scan-results__back-button', handleBackButtonClick)
    $(document).on('click', '.scan-results__label', toggleExpansion)
    $(document).on('click', '.issue-list__item', showDrilldown)
  })

  function toggleSeoResults() {
    $('.scan-results__container').toggle()
    $('.scan-results__seo-container').toggle()
    $('.acquia-optimize-quick-scan-button').hide()
  }

  function toggleAccessibilityContainer() {
    $('.scan-results__container').toggle()
    $(`.scan-results__accessibility-container-${$(this).attr('id')}`).toggle()
    $('.acquia-optimize-quick-scan-button').hide()
  }

  function handleBackButtonClick() {
    $('.scan-results__container').toggle()
    $('.scan-results__seo-container').hide()
    $('.acquia-optimize-quick-scan-button').show()
    hideAllAccessibilityContainers()
  }

  function toggleExpansion() {
    $(this).siblings('.scan-results__expansion').slideToggle()
  }

  function showDrilldown() {
    const itemIdentity = $(this).attr('class').split(' ')[1]
    $(`.${itemIdentity}__drilldown`).show()
    hideAllAccessibilityContainers()
    handleDrilldownBackButtonClick(itemIdentity)
  }

  function handleDrilldownBackButtonClick(itemIdentity) {
    $(`.${itemIdentity}__drilldown`).children('.accessibility-issues__back-button').on('click', function() {
      $(`.${itemIdentity}__drilldown`).hide()
      $(`.scan-results__accessibility-container-${itemIdentity.split('-')[0]}-issues`).show()
    })
  }

  function hideAllAccessibilityContainers() {
    $('.scan-results__accessibility-container-a-issues').hide()
    $('.scan-results__accessibility-container-aa-issues').hide()
    $('.scan-results__accessibility-container-aaa-issues').hide()
  }
})(jQuery)