<?php

namespace Drupal\acquia_optimize\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Custom AJAX command to preprocess the HTML.
 */
class PreprocessPageCommand implements CommandInterface {

  public function __construct(
    private readonly string $html,
    private readonly string $css,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'pagePreprocess',
      'html' => $this->html,
      'css' => $this->css,
    ];
  }

}
