<?php

namespace Drupal\acquia_optimize\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Custom AJAX command to wait and poll for a scan to complete.
 */
class WaitAndPollCommand implements CommandInterface {

  public function __construct(private readonly string $scanId) {}

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'waitAndPoll',
      'scanId' => $this->scanId,
    ];
  }

}
