<?php

namespace Drupal\acquia_optimize\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\acquia_optimize\ApiClient;
use Drupal\acquia_optimize\Utilities;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configuration form for Acquia Optimize.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * Constructor.
   *
   * @param \Drupal\acquia_optimize\ApiClient $apiClient
   *   The API client service.
   */
  public function __construct(
    private readonly ApiClient $apiClient,
  ) {}

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'acquia_optimize.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('acquia_optimize.api_client'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'acquia_optimize_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['api_key'] = [
      '#type' => 'textarea',
      '#title' => $this->t('API Key'),
      '#default_value' => $this->config('acquia_optimize.settings')->get('api_key'),
    ];
    $form['api_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API URL'),
      '#default_value' => $this->config('acquia_optimize.settings')->get('api_url'),
    ];
    $guidelines = Utilities::ACCESSIBILITY_GUIDELINES;
    $form['accessibility'] = [
      '#type' => 'select',
      '#title' => $this->t('Accessibility Guideline'),
      '#default_value' => $this->config('acquia_optimize.settings')->get('accessibility'),
      '#options' => array_combine($guidelines, $guidelines),
    ];
    $response = $this->apiClient->testApi();
    if (isset($response['error'])) {
      $this->messenger()->addError($response['error']);
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('acquia_optimize.settings')
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('api_url', $form_state->getValue('api_url'))
      ->set('accessibility', $form_state->getValue('accessibility'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
