<?php

namespace Drupal\Tests\acquia_optimize\Browser;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Acquia Optimize admin form access.
 *
 * @group acquia_optimize
 */
class AdminFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['acquia_optimize'];

  /**
   * A user with admin permissions.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $adminUser;

  /**
   * A user without admin permissions.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $normalUser;

  /**
   * Theme to enable.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser(['administer acquia optimize']);
    $this->normalUser = $this->drupalCreateUser();
  }

  /**
   * Tests that the admin form is accessible by users with role.
   */
  public function testAdminCanAccessSettingsForm() {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests that the admin can change the form configuration.
   */
  public function testAdminCanChangeSettingsForm() {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(200);
    $edit = [
      'api_key' => 'supersecretapikey',
      'api_url' => 'https://example.com',
      'accessibility' => 'WCAG2-A',
    ];
    $this->submitForm($edit, 'Save configuration');
    $config = \Drupal::config('acquia_optimize.settings');
    $this->assertEquals('supersecretapikey', $config->get('api_key'));
    $this->assertEquals('https://example.com', $config->get('api_url'));
    $this->assertEquals('WCAG2-A', $config->get('accessibility'));
    $this->assertSession()->pageTextContains('The configuration options have been saved.');
  }

  /**
   * Tests that the admin form is inaccessible by users without role.
   */
  public function testNormalUserCannotAccessSettingsForm() {
    $this->drupalLogin($this->normalUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(403);
  }

}
