<?php

namespace Drupal\Tests\acquia_optimize\Functional;

use weitzman\DrupalTestTraits\ExistingSiteBase;

/**
 * Tests the Acquia Optimize admin form access.
 *
 * @group acquia_optimize
 */
class CreatePageContentTest extends ExistingSiteBase {

  /**
   * A user with permissions to view Optimize button.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $acquiaOptimizeUser;

  /**
   * A user without permissions to view Optimize button.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $normalContentEditor;

  /**
   * Theme to enable.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->acquiaOptimizeUser = $this->createUser(['create page content', 'scan acquia optimize'], NULL, FALSE);
    $this->normalContentEditor = $this->createUser(['create page content'], NULL, FALSE);
  }

  /**
   * Tests that the button is visible to user with the correct permission.
   */
  public function testButtonIsVisibleToAdminUsers() {
    $this->drupalLogin($this->acquiaOptimizeUser);
    $this->drupalGet('/node/add/page');
    $this->assertSession()->pageTextContains('Acquia Optimize');
  }

  /**
   * Tests that the button isnt visible to users with the correct permissions.
   */
  public function testButtonIsNotVisibleToNormalUsers() {
    $this->drupalLogin($this->normalContentEditor);
    $this->drupalGet('/node/add/page');
    $this->assertSession()->pageTextNotContains('Acquia Optimize');
  }

}
