<?php

namespace Drupal\Tests\acquia_optimize\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the rendering of the optimize results.
 *
 * @group acquia_optimize
 */
class OptimizeResultsRenderTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['acquia_optimize'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests the rendering of the optimize results with the twig template.
   */
  public function testOptimizeResultsRender() {
    $modulePath = \Drupal::service('extension.path.resolver')->getPath('module', 'acquia_optimize');
    $mockScanResult = json_decode(file_get_contents($modulePath . '/tests/mocks/mockScanResult.json'), TRUE);

    $build = [
      '#theme' => 'acquia_optimize_results',
      '#date' => '2025-01-15T15:42:30+01:00',
      '#results' => $mockScanResult,
    ];

    template_preprocess_acquia_optimize_results($build);
    $render = \Drupal::service('renderer')->renderInIsolation($build);
    $modulePath = \Drupal::service('extension.path.resolver')->getPath('module', 'acquia_optimize');
    $expectedRenderWithoutWhiteSpace = preg_replace('/\s+/', '', file_get_contents($modulePath . '/tests/renders/exampleRender.txt'));
    $receivedRenderWithoutWhiteSpace = preg_replace('/\s+/', '', $render);

    $this->assertEquals($expectedRenderWithoutWhiteSpace, $receivedRenderWithoutWhiteSpace);
  }

}
