# Documentation Directories

This directory (`docs`) contains various documentation and analysis files related to the ActiveNet module. It is structured to help manage documentation generated through different processes.

## `docs/ai/`

This directory contains documentation files that have been generated primarily by Artificial Intelligence tools. These files are intended to serve as:

*   **Drafts:** Initial versions of documentation based on code analysis.
*   **Starting Points:** Content that provides a foundation for human writers.
*   **Exploration:** Automated summaries or analyses that highlight aspects of the codebase.

**Crucially, documents in `docs/ai/` should NOT be considered the final, authoritative source of information.** They may contain inaccuracies, require verification, or need refinement for clarity and completeness.

## `docs/human/`

This directory contains the **canonical and authoritative documentation** for the ActiveNet module. The documents within this directory are intended to be:

*   **Human-reviewed:** Content has been read, verified, and corrected by human contributors.
*   **Edited:** Refined for accuracy, clarity, tone, and consistency.
*   **Final:** Represents the official documentation for the project.

Any documentation intended for general consumption (users, developers) should be sourced from or reside within the `docs/human/` directory.

By separating AI-generated drafts from human-approved content, we aim to streamline the documentation process while ensuring the quality and reliability of the final output.