<?php

namespace Drupal\Tests\ad_content_scheduler\Functional;

use Drupal\ad_content\Entity\AdContent;
use Drupal\ad_content\Entity\AdContentType;
use Drupal\ad\Entity\AdPlacement;
use Drupal\Tests\BrowserTestBase;

/**
 * Tests the AdContentScheduler integration.
 *
 * @group ad_content_scheduler
 */
class AdContentSchedulerTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ad',
    'ad_content',
    'ad_track',
    'ad_content_scheduler',
    'scheduler',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permission to administer ads.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * A test ad content type.
   *
   * @var \Drupal\ad_content\Entity\AdContentType
   */
  protected $adContentType;

  /**
   * A test ad placement.
   *
   * @var \Drupal\ad\Entity\AdPlacement
   */
  protected $placement;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer ads',
      'administer ad settings',
      'view ads',
    ]);

    // Create a test placement.
    $this->placement = AdPlacement::create([
      'id' => 'test_placement',
      'label' => 'Test Placement',
      'description' => 'Test description',
    ]);
    $this->placement->save();

    // Create a test ad content type.
    $this->adContentType = AdContentType::create([
      'id' => 'test_type',
      'label' => 'Test Type',
    ]);
    $this->adContentType->save();
  }

  /**
   * Tests scheduling an ad for publishing.
   */
  public function testSchedulePublish() {
    $this->drupalLogin($this->adminUser);

    // Create an ad with a publish date in the future.
    $this->drupalGet('/admin/content/ad/add/test_type');

    $futureDate = date('Y-m-d', strtotime('+1 day'));
    $edit = [
      'title[0][value]' => 'Scheduled Ad',
      'placement' => 'test_placement',
      'target_url[0][uri]' => 'https://example.com',
      'status[value]' => FALSE,
      'created[0][value][date]' => $futureDate,
    ];
    $this->submitForm($edit, 'Save');

    // Verify the ad was created.
    $this->assertSession()->pageTextContains('Scheduled Ad');

    // Verify the ad is unpublished initially.
    $ads = \Drupal::entityTypeManager()
      ->getStorage('ad_content')
      ->loadByProperties(['title' => 'Scheduled Ad']);
    $this->assertNotEmpty($ads);
    $ad = reset($ads);
    $this->assertFalse($ad->isPublished());
  }

}
