<?php

namespace Drupal\ad\Track;

use Drupal\ad\AdInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Common interface for ad event trackers.
 */
interface TrackerInterface {

  const EVENT_IMPRESSION = 'impression';
  const EVENT_CLICK = 'click';

  const PLACEHOLDER_IMPRESSION = 'AD_TRACK_IMPRESSION_ID_PLACEHOLDER';

  /**
   * Returns the tracker ID.
   *
   * @return string
   *   A machine name.
   */
  public function id(): string;

  /**
   * Tracks an ad impression.
   *
   * @param \Drupal\ad\AdInterface $ad
   *   The ad to be tracked.
   * @param \Drupal\Core\Session\AccountInterface $user
   *   The user triggering the ad event.
   * @param array $context
   *   The context.
   *
   * @return string|null
   *   The event identifier or NULL if an error occurred or the user has
   *   permission to bypass ad tracking.
   */
  public function trackImpression(AdInterface $ad, AccountInterface $user, array $context = []): ?string;

  /**
   * Tracks an ad click.
   *
   * @param \Drupal\ad\AdInterface $ad
   *   The ad to be tracked.
   * @param \Drupal\Core\Session\AccountInterface $user
   *   The user triggering the ad event.
   * @param array $context
   *   The context.
   *
   * @return string|null
   *   The event identifier or NULL if an error occurred or the user has
   *   permission to bypass ad tracking.
   */
  public function trackClick(AdInterface $ad, AccountInterface $user, array $context = []): ?string;

}
