<?php
// $Id: adbard.admin.inc,v 1.1.2.1 2008/04/07 15:40:00 jeremy Exp $

/**
 * @file
 * Admin page callbacks for the adbard module.
 *
 * Visit http://adbard.net/ for for more information on the Ad Bard Network.
 *
 * Copyright (c) 2008.
 *   Jeremy Andrews <jeremy@tag1consulting.com>.  All rights reserved.
 */

function adbard_settings() {
  $form = array();

  $form['adbard_instructions'] = array(
    '#type' => 'fieldset',
    '#title' => t('Instructions'),
    '#collapsible' => TRUE,
    '#collapsed' => variable_get('adbard_key', '') ? TRUE : FALSE,
  );
  $form['adbard_instructions']['text'] = array(
    '#value' => t('<p>The Ad Bard Network is dedicated to fostering a friendly and useful advertising community, built from and focused on Free and Open Source Software.  In order to display ads from the Ad Bard Network on your website, you first have to <a href="http://adbard.net/user/">create an Ad Bard user account</a>.  Your website must be somehow related to Free and Open Source Software to join the Ad Bard Network.</p><p>Once you have logged in to your Ad Bard account, you can find your Ad Bard key by clicking "Status" in your Website Controls.  On the resulting screen, click "Instructions" at the top of the page.  You will now find a screen offering you HTML snippets that are supposed to be installed on your website.  This module makes it so you don\'t have to manually install the snippets.  Instead, from within a provided snippet, find a line that reads something like:<pre>    var adbard_key="a0b1c2d3e4f5a6b7c8d9e0f1a2b3c4e"</pre></p><p>Copy the lower-case letters and numbers that appear in quotes after adbard_key, and paste them into the Ad Bard key textfield below.  They key is the same in all snippets, so it does not matter from which snippet you copy it.'),
    '#prefix' => '<div>',
    '#suffix' => '</div>',
  );

  $form['adbard_key'] = array(
    '#type' => 'textfield',
    '#title' => t('Ad Bard key'),
    '#size' => 33,
    '#maxlength' => 34,
    '#default_value' => variable_get('adbard_key', ''),
    '#description' => t('Enter the 32-character adbard_key assigned to you by the Ad Bard Network.  If you don\'t know what this is, refer to the instructions at the top of this screen.'),
    '#required' => TRUE,
  );

  $form['save'] = array(
    '#type' => 'submit',
    '#value' => t('Save'),
  );

  return $form;
}

/**
 * Perform some sanity tests on the entered adbard_key.
 */
function adbard_settings_validate($form, &$form_state) {
  $adbard_key = preg_replace('/["]/', '', $form_state['values']['adbard_key']);
  $adbard_key_validate = preg_replace('/[^a-f0-9]/', '', $adbard_key);
  if ($adbard_key == 'a0b1c2d3e4f5a6b7c8d9e0f1a2b3c4e') {
    form_set_error('adbard_key', t('You must use the adbard_key provided by <a href="http://adbard.net/user">logging in to your account on the Ad Bard Network</a>, not the example provided in the instructions on this page.'));
  }
  else if ($adbard_key != $adbard_key_validate) {
    form_set_error('adbard_key', t('There are invalid characters in the key you have entered.  Please double check the key provided by the Ad Bard Network and try again.'));
  }
  else if (strlen($adbard_key) != 32) {
    form_set_error('adbard_key', t('Please be sure to include the entire key, it must be exactly 32 characters long.'));
  }
}

/**
 * Save the validate adbard_key.
 */
function adbard_settings_submit($form, &$form_state) {
  $adbard_key = preg_replace('/"/', '', $form_state['values']['adbard_key']);
  variable_set('adbard_key', $adbard_key);
  drupal_set_message(t('Please visit the <a href="@url">blocks administration page</a> to enable Ad Bard Network blocks.', array('@url' => url('admin/build/block'))));
}

