<?php

namespace Drupal\additional_js_css;

/**
 * Provides an interface for managing additional JavaScript and CSS files.
 */
interface AdditionalJSCSSManagerInterface {

  /**
   * The file path for the additional JavaScript file.
   *
   * @var string
   */
  const JS_FILE_PATH = 'public://additional_js_css/script.js';

  /**
   * The file path for the additional CSS file.
   *
   * @var string
   */
  const CSS_FILE_PATH = 'public://additional_js_css/styles.css';

  /**
   * Retrieves the contents of an additional file based on the specified type.
   *
   * @param string $type
   *   The type of file to retrieve, either 'js' or 'css'.
   *
   * @return string
   *   The file content as a string if the file could not be retrieved.
   */
  public function getAdditionalFile(string $type);

  /**
   * Saves content to an additional file based on the specified type.
   *
   * If the directory does not exist, it is created. If a file already exists,
   * it will be replaced.
   *
   * @param string $type
   *   The type of file to save, either 'js' for JavaScript or 'css' for CSS.
   * @param string $value
   *   The content to save to the file.
   *
   * @return bool
   *   TRUE if the file was successfully saved, FALSE otherwise.
   */
  public function saveAdditionalFile(string $type, string $value);

}
