(function ($, Drupal, once) {

  'use strict';

  Drupal.behaviors.additionalJSCSS = {
    attach: function (context, settings) {
      var aceEditor = $(once('ace_editor_init', '.ace-editor', context));
      aceEditor.each(function () {
        var textarea = $(this).parent().siblings().find('textarea');
        var aceMode = $(textarea).attr('data-ace-mode');
        if (aceMode) {
          $(textarea).hide();
          var editor = ace.edit(this);
          editor.getSession().setMode('ace/mode/' + aceMode);
          editor.getSession().setTabSize(2);

          editor.getSession().on('change', function () {
            textarea.val(editor.getSession().getValue());
          });

          editor.setValue(textarea.val(), -1);

          $('.resizable-editor--wrapper').resizable({
            resize: function () {
              editor.resize();
            }
          });

        }
      });
    }
  };
})(jQuery, Drupal, once);
