<?php

namespace Drupal\additional_js_css\Form;

use Drupal\additional_js_css\AdditionalJSCSSManagerInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Additional JS CSS form.
 */
class AdditionalJSCSSForm extends FormBase {

  /**
   * The additional JS CSS manager service.
   *
   * @var \Drupal\additional_js_css\AdditionalJSCSSManagerInterface
   */
  protected $additionalJSCSSManager;

  /**
   * Constructs a new AdditionalJSForm.
   *
   * @param \Drupal\additional_js_css\AdditionalJSCSSManagerInterface $additional_js_css_manager
   *   The additional JS CSS manager service.
   */
  public function __construct(AdditionalJSCSSManagerInterface $additional_js_css_manager) {
    $this->additionalJSCSSManager = $additional_js_css_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('additional_js_css.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'additional_js_css_css_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['description'] = [
      '#type' => 'item',
      '#markup' => $this->t('JS CSS Editor. Please clear all caches after updating JS and CSS for changes to take effect.'),
    ];
    $form['css_details'] = [
      '#type' => 'details',
      '#title' => $this->t('CSS Details'),
      '#open' => TRUE,
    ];
    $form['css_details']['css'] = [
      '#type' => 'textarea',
      '#attributes' => [
        'data-ace-mode' => 'css',
      ],
      '#prefix' => '<div class="additional-js-css--wrapper">',
      '#suffix' => '<div class="resizable-editor--wrapper"><div class="ace-editor"></div></div></div>',
      '#default_value' => $this->additionalJSCSSManager->getAdditionalFile('css'),
    ];
    $form['js_details'] = [
      '#type' => 'details',
      '#title' => $this->t('JS Details'),
      '#open' => TRUE,
    ];
    $form['js_details']['js'] = [
      '#type' => 'textarea',
      '#attributes' => [
        'data-ace-mode' => 'js',
      ],
      '#prefix' => '<div class="additional-js-css--wrapper">',
      '#suffix' => '<div class="resizable-editor--wrapper"><div class="ace-editor"></div></div></div>',
      '#default_value' => $this->additionalJSCSSManager->getAdditionalFile('js'),
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];
    $form['#attached']['library'][] = 'additional_js_css/additional_js_css';

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();

    if ($this->additionalJSCSSManager->saveAdditionalFile('css', $values['css'])) {
      $this->messenger()->addMessage($this->t('The CSS has been saved successfully.'));
    }
    else {
      $this->messenger()->addMessage($this->t('An error occurred while saving the CSS file. Please try again.'), 'error');
    }

    if ($this->additionalJSCSSManager->saveAdditionalFile('js', $values['js'])) {
      $this->messenger()->addMessage($this->t('The JS has been saved successfully.'));
    }
    else {
      $this->messenger()->addMessage($this->t('An error occurred while saving the JS file. Please try again.'), 'error');
    }
  }

}
