<?php

/**
 * @file
 * AddonChat Module: Admin/Advanced
 */

/**
 * http://www.addoninteractive.com
 * support@addoninteractive.com
 */

/**
 *  AddonChat Account Integration Settings Form
 * Administer: Site Configuration: AddonChat: Advanced Settings
 */
function addonchat_advanced_integration() {
  $form = array();

  /* Custom Parameters (RAS) */
  $form['custom_ras'] = array(
    '#type' => 'fieldset',
    '#title' => t('Advanced remote authentication settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['custom_ras']['instructions'] = array(
    '#type' => 'markup',
    '#value' => t("Advanced users may add additional output to their remote
      authentication script here:"),
  );

  $form['custom_ras']['addonchat_ras_params'] = array(
    '#type' => 'textarea',
    '#title' => 'AddonChat remote authentication system parameters',
    '#required' => FALSE,
    '#attributes' => array('style' => 'font-family: Courier', 'wrap' => 'off'),
    '#default_value' => variable_get('addonchat_ras_params',
      "drupal.auth.comment = custom parameters"),
  );

  return system_settings_form($form);
}

/**
 * Unused.
 */
function addonchat_advanced_integration_validate($form, &$form_state) {
}
