(function ($, Drupal, once) {
  Drupal.behaviors.address_autocomplete = {
    attach: function (context, settings) {

      $(once('initiate-autocomplete', 'input.address-line1', context)).each(function () {
        var form_wrapper = $(this).closest('.js-form-wrapper');
        var ui_autocomplete = $(this).data('ui-autocomplete');

        ui_autocomplete.options.select = function (event, ui) {
          event.preventDefault();
          form_wrapper.find('input.address-line1').val(ui.item.street_name);
          form_wrapper.find('input.postal-code').val(ui.item.zip_code);
          form_wrapper.find('input.locality').val(ui.item.town_name);
          form_wrapper.find('select.administrative-area, input.administrative-area').val(ui.item.administrative_area);
        };

      });
    }
  };
}(jQuery, Drupal, once));
