/**
* @file
*/

(function ($, Drupal) {
  Drupal.AjaxCommands.prototype.geocode_address = function (ajax, response, status) {
    // response.message: message from Command;
    // response.address_coordinates: coordinates as object with:
    //  - longitude
    //  - latitude
    // response.field_address: relevant info from address field:
    //  - widget: the data-drupal-selector of the wrapper of the field_address;
    //  - field_name: the field name of the address field.
    // response.geofield_target: Relevant info about target geofield:
    //  - widget: the data-drupal-selector of the wrapper of the target geofield
    //  - field_name: the field name of the target geofield.

    // If is needed the selected coordinates address string:
    // jQuery("[data-drupal-selector='" + response.field_address.widget + "'] select[name='" + response.field_address.field_name + "[0][geocoded_select]']");
    $("[name='" + response.geofield_target.field_name + "[0][value][lat]']").val( response.address_coordinates.latitude );
    $("[name='" + response.geofield_target.field_name + "[0][value][lon]']").val( response.address_coordinates.longitude).trigger("change");
}

Drupal.behaviors.address_js_geocoder = {
  attach: function (context, settings) {
    // must implode adrress to start geocode automatically
    var parsed_address = "";
    var field_address_context = $("[data-drupal-selector='" + settings.address_selector + "']");
    $('input.address-line1, input.address-line2, input.postal-code, input.locality, select.country', field_address_context ).once('watch_address').each(function (){
      $(this).on('change', function(){ 
        var add1 = $('input.address-line1', field_address_context).val()
        var add2 = $('input.address-line2', field_address_context).val() + ","
        var postal_code = $('input.postal-code', field_address_context).val()
        var locality = $('input.locality', field_address_context).val() + ","
        var country = $('select.country', field_address_context).val()
        var autoupdate = $('input[data-drupal-selector="' + settings.address_selector + '-autogeocode"]', field_address_context).prop('checked')
        parsed_address = `${add1} ${add2} ${locality} ${postal_code} ${country}`.replace(/  +/g, ' ');
        $("[data-drupal-selector='" + settings.address_selector + "-container-resolved-address']", field_address_context).val(parsed_address)
        if ( add1 && add1.length > 3 && locality && locality.length > 2 && country && country.length > 1 && autoupdate){
          $("input[data-drupal-selector='" + settings.address_selector + "-request-geocode']", field_address_context).trigger("mousedown");
        }
      });
    })
  }
}
})(jQuery, Drupal);
