!function(e,n){"object"==typeof exports&&"object"==typeof module?module.exports=n():"function"==typeof define&&define.amd?define([],n):"object"==typeof exports?exports.CKEditor5=n():(e.CKEditor5=e.CKEditor5||{},e.CKEditor5.addressSuggestion=n())}(self,(()=>(()=>{var __webpack_modules__={"./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestion.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* binding */ AddressSuggestion)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ "ckeditor5/src/core.js");\n/* harmony import */ var _AddressSuggestionEditing__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AddressSuggestionEditing */ "./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionEditing.js");\n/* harmony import */ var _AddressSuggestionUI__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AddressSuggestionUI */ "./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionUI.js");\n\n\n\n\n/**\n * The Address suggestion plugin.\n *\n * @internal\n */\nclass AddressSuggestion extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  static get requires() {\n    return [_AddressSuggestionEditing__WEBPACK_IMPORTED_MODULE_1__["default"], _AddressSuggestionUI__WEBPACK_IMPORTED_MODULE_2__["default"]];\n  }\n  /**\n   * @inheritdoc\n   */\n  static get pluginName() {\n    return "addressSuggestion";\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestion.js?')},"./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionEditing.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AddressSuggestionEditing)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/widget */ \"ckeditor5/src/widget.js\");\n/* harmony import */ var _InsertAddressCommand__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InsertAddressCommand */ \"./js/ckeditor5_plugins/addressSuggestion/src/InsertAddressCommand.js\");\n\n\n\n\n// cSpell:ignore UrlParser InsertAddressCommand\nclass AddressSuggestionEditing extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  static get requires() {\n    return [ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.Widget];\n  }\n\n  init() {\n    this._defineSchema();\n    this._defineConverters();\n    this._defineCommands();\n  }\n\n  _defineSchema() {\n    // Schemas are registered via the central `editor` object.\n    const schema = this.editor.model.schema;\n\n    schema.register('addressSuggestion', {\n      // Behaves like a self-contained object (e.g. an image).\n      isObject: true,\n      // Allow in places where other blocks are allowed (e.g. directly in the root).\n      allowWhere: '$text',\n      isInline: true,\n      allowAttributes: ['class'],\n    });\n  }\n\n  /**\n   * Converters determine how CKEditor 5 models are converted into markup and\n   * vice-versa.\n   */\n  _defineConverters() {\n    // Converters are registered via the central editor object.\n    const { conversion } = this.editor;\n    // Data Downcast Converters: converts stored model data into HTML.\n    // These trigger when content is saved.\n    //\n    // Instances of <urlParser> are saved as\n    // <div class=\"simple-box\">{{inner content}}</div>.\n    conversion.for('downcast').elementToElement({\n      model: 'addressSuggestion',\n      view: {\n        name: 'div',\n        classes: 'address-suggestion',\n      },\n    });\n\n    // Upcast Converters: determine how existing HTML is interpreted by the\n    // editor. These trigger when an editor instance loads.\n    //\n    // If <div class=\"urlparser\"> is present in the existing markup\n    // processed by CKEditor, then CKEditor recognizes and loads it as a\n    // <urlParser> model.\n    conversion.for('upcast').elementToElement({\n      model: 'addressSuggestion',\n      view: {\n        name: 'div',\n        classes: 'address-suggestion',\n      },\n    });\n  }\n\n  _defineCommands() {\n    const editor = this.editor;\n    editor.commands.add(\n      'InsertAddressCommand',\n      new _InsertAddressCommand__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.editor),\n    );\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionEditing.js?")},"./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionIcon-view.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AddressSuggestionIconView)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/ui */ \"ckeditor5/src/ui.js\");\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n\n\n\n/**\n * A class rendering the information required from user input.\n *\n * @extends module:ui/view~View\n *\n * @internal\n */\nclass AddressSuggestionIconView extends ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.View {\n\n  /**\n   * @inheritdoc\n   */\n  constructor(editor) {\n    const locale = editor.locale;\n    super(locale);\n    let addressList = [];\n    this.searchInputView = this._createInput(editor.t('Address'));\n    this.addressList = this._createAddressList(addressList);\n\n    const config = editor.config.get('address_suggestion');\n    let url = config['endpoint'] + '&q=';\n    this.searchInputView.fieldView.on('input', (event) => {\n      let search = event.source.element.value.toLowerCase();\n      sessionStorage.setItem('addressSearch', search);\n      let ajaxUrl = url + search;\n      if (search.length > 3) {\n        fetch(ajaxUrl).then(function (response) {\n          if (!response.ok) {\n            throw new Error('Request error: ' + response.status);\n          }\n          return response.json();\n        }).then((data) => {\n          if (data.length && !data.status) {\n            this.addressList = this._createAddressList(data);\n            // @todo It must add to this.addressList. I don't know how to do that\n            // so I insert the results manually.\n            document.querySelector('.ck-address-suggestion ul.ck-list').innerHTML = '';\n            const inputElement = document.querySelector('.ck-address-suggestion .ck-input');\n            data.forEach(item => {\n              const newLi = document.createElement('li');\n              const btn = document.createElement('button');\n              newLi.className = 'ck ck-list__item';\n              newLi.setAttribute('role', 'presentation');\n              btn.className = 'ck ck-button ck-off ck-button_with-text';\n              btn.textContent = item.label;\n              newLi.append(btn);\n              btn.addEventListener('click', function () {\n                const selectedLabel = this.textContent;\n                inputElement.value = selectedLabel;\n              });\n              document.querySelector('.ck-address-suggestion ul.ck-list').appendChild(newLi);\n            });\n          }\n        });\n      }\n    });\n    // Create the save and cancel buttons.\n    this.saveButtonView = this._createButton(\n      editor.t('Save'), ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_1__.icons.check, 'ck-button-save'\n    );\n    this.saveButtonView.type = 'submit';\n    this.cancelButtonView = this._createButton(\n      editor.t('Cancel'), ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_1__.icons.cancel, 'ck-button-cancel'\n    );\n    // Delegate ButtonView#execute to FormView#cancel.\n    this.cancelButtonView.delegate('execute').to(this, 'cancel');\n    this.childViews = this.createCollection([\n      this.searchInputView,\n      this.addressList,\n      this.saveButtonView,\n      this.cancelButtonView\n    ]);\n    this.setTemplate({\n      tag: 'form',\n      attributes: {\n        class: ['ck', 'ck-responsive-form', 'ck-address-suggestion'],\n        tabindex: '-1'\n      },\n      children: this.childViews\n    });\n  }\n\n  /**\n   * @inheritdoc\n   */\n  render() {\n    super.render();\n    // Submit the form when the user clicked the save button or\n    // pressed enter the input.\n    (0,ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.submitHandler)({\n      view: this\n    });\n  }\n\n  /**\n   * @inheritdoc\n   */\n  focus() {\n    this.childViews.first.focus();\n  }\n\n  // Create a generic input field.\n  _createInput(label) {\n    const labeledInput = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.LabeledFieldView(this.locale, ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.createLabeledInputText);\n    labeledInput.label = label;\n    labeledInput.inputMode = 'search';\n    return labeledInput;\n  }\n\n  // Create a generic button.\n  _createButton(label, icon, className) {\n    const button = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.ButtonView();\n\n    button.set({\n      label,\n      icon,\n      tooltip: true,\n      class: className,\n    });\n\n    return button;\n  }\n\n  _createAddressSuggestion(address) {\n    const button = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.ButtonView();\n    button.set({\n      label: address.label,\n      withText: true\n    });\n    button.on('execute', () => {\n      this.searchInputView.fieldView.element.focus();\n    });\n    const liView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.ListItemView();\n    liView.children.add(button)\n    return liView;\n  }\n\n  // Create list address suggestion.\n  _createAddressList(address) {\n    const list = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_0__.ListView();\n    address.forEach((element) => {\n      let location = this._createAddressSuggestion(element);\n      list.items.add(location);\n    });\n    list.set('attributes', {\n      class: ['ck', 'ck-reset', 'ck-list', 'ck-address-list'],\n    });\n    return list;\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionIcon-view.js?")},"./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionUI.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ UrlParserUI)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/ui */ \"ckeditor5/src/ui.js\");\n/* harmony import */ var _AddressSuggestionIcon_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AddressSuggestionIcon-view */ \"./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionIcon-view.js\");\n/* harmony import */ var _icons_address_suggestion_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../icons/address-suggestion.svg */ \"./icons/address-suggestion.svg\");\n/**\n * @file registers the bootstrapIcons toolbar button and binds functionality to it.\n */\n\n\n\n\n\n\nclass UrlParserUI extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  init() {\n    const editor = this.editor;\n    this._balloon = this.editor.plugins.get(ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ContextualBalloon);\n    this.formView = this._createFormView();\n\n    // This will register the UrlParserIcons toolbar button.\n    editor.ui.componentFactory.add('addressSuggestion', (locale) => {\n      const buttonView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);\n\n      // Create the toolbar button.\n      buttonView.set({\n        label: editor.t('Address'),\n        icon: _icons_address_suggestion_svg__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n        tooltip: true,\n      });\n\n      // Bind the state of the button to the command.\n      const command = editor.commands.get('InsertAddressCommand');\n      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');\n\n      // Execute the command when the button is clicked (executed).\n      this.listenTo(buttonView, 'execute', () => {\n        this._showUI();\n      });\n\n      return buttonView;\n    });\n\n  }\n\n  _createFormView() {\n    const editor = this.editor;\n    const formView = new _AddressSuggestionIcon_view__WEBPACK_IMPORTED_MODULE_2__[\"default\"](editor);\n\n    // On submit send the user data to the writer, then hide the form view.\n    this.listenTo(formView, 'submit', () => {\n      let address = formView.searchInputView.fieldView.element.value;\n      editor.execute('InsertAddressCommand', address);\n      this._hideUI();\n    });\n\n    // Hide the form view after clicking the \"Cancel\" button.\n    this.listenTo(formView, 'cancel', () => {\n      this._hideUI();\n    });\n\n    // Hide the form view when clicking outside the balloon.\n    (0,ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.clickOutsideHandler)({\n      emitter: formView,\n      activator: () => this._balloon.visibleView === formView,\n      contextElements: [this._balloon.view.element],\n      callback: () => this._hideUI()\n    });\n\n    return formView;\n  }\n\n  _hideUI() {\n    this.formView.searchInputView.fieldView.value = '';\n    this.formView.element.reset();\n    this._balloon.remove(this.formView);\n\n    // Focus the editing view after closing the form view.\n    this.editor.editing.view.focus();\n  }\n\n  _showUI() {\n    this._balloon.add({\n      view: this.formView,\n      position: this._getBalloonPositionData(),\n    });\n    this.formView.focus();\n  }\n\n  _getBalloonPositionData() {\n    const view = this.editor.editing.view;\n    const viewDocument = view.document;\n    let target = null;\n\n    // Set a target position by converting view selection range to DOM.\n    target = () => view.domConverter.viewRangeToDom(\n      viewDocument.selection.getFirstRange()\n    );\n\n    return {\n      target\n    };\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestionUI.js?")},"./js/ckeditor5_plugins/addressSuggestion/src/InsertAddressCommand.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* binding */ InsertAddressCommand)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ "ckeditor5/src/core.js");\n\n\nclass InsertAddressCommand extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Command {\n  execute(addresseText) {\n    const { editor } = this;\n    const { model } = editor;\n    let langCode = drupalSettings.path.currentLanguage;\n    let address = `<address class=\'address-suggestion\'>${addresseText}</address>`;\n    let srcMap = \'https://maps.google.com/maps?t=&z=14&ie=UTF8&iwloc=B&output=embed&hl=\' + langCode + \'&q=\' + addresseText;\n    let map = `<iframe src="${srcMap}" class="address-suggestion" width="100%" height="450" allowfullscreen=""\n    loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>`;\n    model.change(writer => {\n      const content = writer.createElement(\'addressSuggestion\');\n      const docFrag = writer.createDocumentFragment();\n      const viewFragment = editor.data.processor.toView(map + address);\n      const modelFragment = editor.data.toModel(viewFragment);\n      writer.append(content, docFrag);\n      writer.append(modelFragment, content);\n      model.insertContent(docFrag);\n    });\n  }\n\n  refresh() {\n    const {model} = this.editor;\n    const {selection} = model.document;\n    const allowedIn = model.schema.findAllowedParent(\n      selection.getFirstPosition(),\n      \'addressSuggestion\',\n    );\n    this.isEnabled = allowedIn !== null;\n  }\n\n}\n\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/InsertAddressCommand.js?')},"./js/ckeditor5_plugins/addressSuggestion/src/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _AddressSuggestion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AddressSuggestion */ "./js/ckeditor5_plugins/addressSuggestion/src/AddressSuggestion.js");\n/**\n * @file The build process always expects an index.js file. Anything exported\n * here will be recognized by CKEditor 5 as an available plugin. Multiple\n * plugins can be exported in this one file.\n *\n * I.e. this file\'s purpose is to make plugin(s) discoverable.\n */\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({ AddressSuggestion: _AddressSuggestion__WEBPACK_IMPORTED_MODULE_0__["default"] });\n\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./js/ckeditor5_plugins/addressSuggestion/src/index.js?')},"./icons/address-suggestion.svg":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\r\\n\x3c!-- Generator: Adobe Illustrator 24.1.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  --\x3e\\r\\n<svg version=\\"1.1\\" id=\\"Layer_1\\" xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\" x=\\"0px\\" y=\\"0px\\"\\r\\n\\t viewBox=\\"0 0 512 512\\" style=\\"enable-background:new 0 0 512 512;\\" xml:space=\\"preserve\\">\\r\\n<g>\\r\\n\\t<path d=\\"M364.5,163.2l104.8,47.6v231.2l-127.5-54.6l-170.7,64L42.7,396.4V164.7l77.4,31l15.8-39.6L0,101.6v322.9l170.1,72.9\\r\\n\\t\\tl170.7-64L512,506.8V183.4l-129.8-59L364.5,163.2L364.5,163.2z M362.7,410.5V261.2H320v149.3H362.7z M192,474.5V261.2h-42.7v213.3\\r\\n\\t\\tH192z M256,352.3l13.3-16.7l-0.2-0.2c-3.1-2.5-34.2-28-63.7-63.3c-14.8-17.6-29.1-37.7-39.5-58.1c-10.4-20.4-16.6-41-16.6-59.6\\r\\n\\t\\tc0.1-34.2,13.3-59.9,33.1-78.3C202.3,58,229.3,47.8,256,47.8c26.7,0,53.7,10.1,73.6,28.4c19.8,18.3,33,44,33.1,78.3\\r\\n\\t\\tc0.1,19.2-6.6,40.5-17.6,61.6c-16.4,31.6-42.2,62-63.8,84.1c-10.8,11-20.6,20-27.6,26.2c-3.5,3.1-6.3,5.5-8.2,7.1l-2.1,1.8\\r\\n\\t\\tl-0.6,0.5L256,352.3l13.3-16.7L256,352.3l13.3,16.7c0.6-0.5,33.5-26.6,66.9-65.7c16.7-19.6,33.6-42.5,46.7-67.5\\r\\n\\t\\tc13-25,22.4-52.5,22.4-81.3c0.1-45.8-18.7-84.1-46.9-109.7C330.3,19,293.3,5.2,256,5.2c-37.3,0-74.3,13.9-102.4,39.6\\r\\n\\t\\tc-28.2,25.7-47,64-46.9,109.7c0.1,28.8,9.4,56.2,22.4,81.3c19.6,37.5,47.8,70.3,71.2,94.2c23.4,23.8,42,38.7,42.5,39l13.3,10.6\\r\\n\\t\\tl13.3-10.6L256,352.3z M277.3,154.5h21.3c0-23.6-19.1-42.7-42.7-42.7c-23.6,0-42.7,19.1-42.7,42.7c0,23.6,19.1,42.7,42.7,42.7\\r\\n\\t\\tc23.6,0,42.7-19.1,42.7-42.7H277.3H256l0,0v0v0H277.3z\\"/>\\r\\n</g>\\r\\n</svg>\\r\\n");\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/./icons/address-suggestion.svg?')},"ckeditor5/src/core.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/core.js");\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/delegated_./core.js_from_dll-reference_CKEditor5.dll?')},"ckeditor5/src/ui.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/ui.js");\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/delegated_./ui.js_from_dll-reference_CKEditor5.dll?')},"ckeditor5/src/widget.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/widget.js");\n\n//# sourceURL=webpack://CKEditor5.addressSuggestion/delegated_./widget.js_from_dll-reference_CKEditor5.dll?')},"dll-reference CKEditor5.dll":e=>{"use strict";e.exports=CKEditor5.dll}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e](t,t.exports,__webpack_require__),t.exports}__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./js/ckeditor5_plugins/addressSuggestion/src/index.js");return __webpack_exports__=__webpack_exports__.default,__webpack_exports__})()));