<?php

namespace Drupal\address_suggestion\Controller;

use Drupal\Component\Utility\Xss;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Defines a route controller for watches autocomplete form elements.
 */
class AddressSuggestion extends ControllerBase {

  /**
   * Handler for the autocomplete request.
   */
  public function handleAutocomplete(Request $request, $entity_type, $bundle, $field_name) {
    $results = [];
    $input = Xss::filter($request->query->get('q'));

    if (empty($input)) {
      return new JsonResponse($results);
    }
    $results = \Drupal::service('address_suggestion.query_services')
      ->getData($entity_type, $bundle, $field_name, $input);
    return new JsonResponse($results);
  }

}
