<?php

/**
 * @file
 * A list of all locality blocks.
 */

/**
 * @return
 *   Administrative area, locality and dependent locality array.
 */
function addressfield_id_locality_block() {
  $locality_blocks = array(
    "Bali" => array(
      "Badung" => drupal_map_assoc(array(
        t("Abiansemal"),
        t("Kuta"),
        t("Kuta Selatan"),
        t("Kuta Utara"),
        t("Mengwi"),
        t("Petang"),
      )),
      "Bangli" => drupal_map_assoc(array(
        t("Bangli"),
        t("Kintamani"),
        t("Susut"),
        t("Tembuku"),
      )),
      "Buleleng" => drupal_map_assoc(array(
        t("Banjar"),
        t("Buleleng"),
        t("Busungbiu"),
        t("Gerokgak"),
        t("Kubutambahan"),
        t("Sawan"),
        t("Seririt"),
        t("Sukasada"),
        t("Tejakula"),
      )),
      "Denpasar" => drupal_map_assoc(array(
        t("Denpasar Barat"),
        t("Denpasar Selatan"),
        t("Denpasar Timur"),
        t("Denpasar Utara"),
      )),
      "Gianyar" => drupal_map_assoc(array(
        t("Belah Batuh (Blahbatuh)"),
        t("Gianyar"),
        t("Payangan"),
        t("Sukawati"),
        t("Tampak Siring"),
        t("Tegallalang"),
        t("Ubud"),
      )),
      "Jembrana" => drupal_map_assoc(array(
        t("Jembrana"),
        t("Melaya"),
        t("Mendoyo"),
        t("Negara"),
        t("Pekutatan"),
      )),
      "Karangasem" => drupal_map_assoc(array(
        t("Abang"),
        t("Bebandem"),
        t("Karang Asem"),
        t("Kubu"),
        t("Manggis"),
        t("Rendang"),
        t("Selat"),
        t("Sidemen"),
      )),
      "Klungkung" => drupal_map_assoc(array(
        t("Banjarangkan"),
        t("Dawan"),
        t("Klungkung"),
        t("Nusapenida"),
      )),
      "Tabanan" => drupal_map_assoc(array(
        t("Baturiti"),
        t("Kediri"),
        t("Kerambitan"),
        t("Marga"),
        t("Penebel"),
        t("Pupuan"),
        t("Selemadeg"),
        t("Selemadeg / Salamadeg Timur"),
        t("Selemadeg / Salemadeg Barat"),
        t("Tabanan"),
      )),
    ),
    "Bangka Belitung" => array(
      "Bangka" => drupal_map_assoc(array(
        t("Bakam"),
        t("Belinyu"),
        t("Mendo Barat"),
        t("Merawang"),
        t("Pemali"),
        t("Puding Besar"),
        t("Riau Silip"),
        t("Sungai Liat"),
      )),
      "Bangka Barat" => drupal_map_assoc(array(
        t("Jebus"),
        t("Kelapa"),
        t("Mentok (Muntok)"),
        t("Parittiga"),
        t("Simpang Teritip"),
        t("Tempilang"),
      )),
      "Bangka Selatan" => drupal_map_assoc(array(
        t("Air Gegas"),
        t("Kepulauan Pongok"),
        t("Lepar Pongok"),
        t("Payung"),
        t("Pulau Besar"),
        t("Simpang Rimba"),
        t("Toboali"),
        t("Tukak Sadai"),
      )),
      "Bangka Tengah" => drupal_map_assoc(array(
        t("Koba"),
        t("Lubuk Besar"),
        t("Namang"),
        t("Pangkalan Baru"),
        t("Simpang Katis"),
        t("Sungai Selan"),
      )),
      "Belitung" => drupal_map_assoc(array(
        t("Badau"),
        t("Membalong"),
        t("Selat Nasik"),
        t("Sijuk"),
        t("Tanjung Pandan"),
      )),
      "Belitung Timur" => drupal_map_assoc(array(
        t("Damar"),
        t("Dendang"),
        t("Gantung"),
        t("Kelapa Kampit"),
        t("Manggar"),
        t("Simpang Pesak"),
        t("Simpang Renggiang"),
      )),
      "Pangkal Pinang" => drupal_map_assoc(array(
        t("Bukit Intan"),
        t("Gabek"),
        t("Gerunggang"),
        t("Girimaya"),
        t("Pangkal Balam"),
        t("Rangkui"),
        t("Taman Sari"),
      )),
    ),
    "Banten" => array(
      "Cilegon" => drupal_map_assoc(array(
        t("Cibeber"),
        t("Cilegon"),
        t("Citangkil"),
        t("Ciwandan"),
        t("Gerogol"),
        t("Jombang"),
        t("Pulomerak"),
        t("Purwakarta"),
      )),
      "Lebak" => drupal_map_assoc(array(
        t("Banjarsari"),
        t("Bayah"),
        t("Bojongmanik"),
        t("Cibadak"),
        t("Cibeber"),
        t("Cigemblong"),
        t("Cihara"),
        t("Cijaku"),
        t("Cikulur"),
        t("Cileles"),
        t("Cilograng"),
        t("Cimarga"),
        t("Cipanas"),
        t("Cirinten"),
        t("Curugbitung"),
        t("Gunung Kencana"),
        t("Kalanganyar"),
        t("Lebakgedong"),
        t("Leuwidamar"),
        t("Maja"),
        t("Malingping"),
        t("Muncang"),
        t("Panggarangan"),
        t("Rangkasbitung"),
        t("Sajira"),
        t("Sobang"),
        t("Wanasalam"),
        t("Warunggunung"),
      )),
      "Pandeglang" => drupal_map_assoc(array(
        t("Angsana"),
        t("Banjar"),
        t("Bojong"),
        t("Cadasari"),
        t("Carita"),
        t("Cibaliung"),
        t("Cibitung"),
        t("Cigeulis"),
        t("Cikeudal (Cikedal)"),
        t("Cikeusik"),
        t("Cimanggu"),
        t("Cimanuk"),
        t("Cipeucang"),
        t("Cisata"),
        t("Jiput"),
        t("Kaduhejo"),
        t("Karang Tanjung"),
        t("Koroncong"),
        t("Labuan"),
        t("Majasari"),
        t("Mandalawangi"),
        t("Mekarjaya"),
        t("Menes"),
        t("Munjul"),
        t("Pagelaran"),
        t("Pandeglang"),
        t("Panimbang"),
        t("Patia"),
        t("Picung"),
        t("Pulosari"),
        t("Saketi"),
        t("Sindangresmi"),
        t("Sobang"),
        t("Sukaresmi"),
        t("Sumur"),
      )),
      "Serang (Kabupaten)" => drupal_map_assoc(array(
        t("Anyar"),
        t("Bandung"),
        t("Baros"),
        t("Binuang"),
        t("Bojonegara"),
        t("Carenang (Cerenang)"),
        t("Cikande"),
        t("Cikeusal"),
        t("Cinangka"),
        t("Ciomas"),
        t("Ciruas"),
        t("Gunungsari"),
        t("Jawilan"),
        t("Kibin"),
        t("Kopo"),
        t("Kragilan"),
        t("Kramatwatu"),
        t("Lebak Wangi"),
        t("Mancak"),
        t("Pabuaran"),
        t("Padarincang"),
        t("Pamarayan"),
        t("Petir"),
        t("Pontang"),
        t("Pulo Ampel"),
        t("Tanara"),
        t("Tirtayasa"),
        t("Tunjung Teja"),
        t("Waringin Kurung"),
      )),
      "Serang (Kota)" => drupal_map_assoc(array(
        t("Cipocok Jaya"),
        t("Curug"),
        t("Kasemen"),
        t("Serang"),
        t("Taktakan"),
        t("Walantaka"),
      )),
      "Tangerang (Kabupaten)" => drupal_map_assoc(array(
        t("Balaraja"),
        t("Cikupa"),
        t("Cisauk"),
        t("Cisoka"),
        t("Curug"),
        t("Gunung Kaler"),
        t("Jambe"),
        t("Jayanti"),
        t("Kelapa Dua"),
        t("Kemiri"),
        t("Kosambi"),
        t("Kresek"),
        t("Kronjo"),
        t("Legok"),
        t("Mauk"),
        t("Mekar Baru"),
        t("Pagedangan"),
        t("Pakuhaji"),
        t("Panongan"),
        t("Pasar Kemis"),
        t("Rajeg"),
        t("Sepatan"),
        t("Sepatan Timur"),
        t("Sindang Jaya"),
        t("Solear"),
        t("Sukadiri"),
        t("Sukamulya"),
        t("Teluknaga"),
        t("Tigaraksa"),
      )),
      "Tangerang (Kota)" => drupal_map_assoc(array(
        t("Batuceper"),
        t("Benda"),
        t("Cibodas"),
        t("Ciledug"),
        t("Cipondoh"),
        t("Jatiuwung"),
        t("Karang Tengah"),
        t("Karawaci"),
        t("Larangan"),
        t("Neglasari"),
        t("Periuk"),
        t("Pinang (Penang)"),
        t("Tangerang"),
      )),
      "Tangerang Selatan" => drupal_map_assoc(array(
        t("Ciputat"),
        t("Ciputat Timur"),
        t("Pamulang"),
        t("Pondok Aren"),
        t("Serpong"),
        t("Serpong Utara"),
        t("Setu"),
      )),
    ),
    "Bengkulu" => array(
      "Bengkulu" => drupal_map_assoc(array(
        t("Gading Cempaka"),
        t("Kampung Melayu"),
        t("Muara Bangka Hulu"),
        t("Ratu Agung"),
        t("Ratu Samban"),
        t("Selebar"),
        t("Singaran Pati"),
        t("Sungai Serut"),
        t("Teluk Segara"),
      )),
      "Bengkulu Selatan" => drupal_map_assoc(array(
        t("Air Nipis"),
        t("Bunga Mas"),
        t("Kedurang"),
        t("Kedurang Ilir"),
        t("Kota Manna"),
        t("Manna"),
        t("Pasar Manna"),
        t("Pino"),
        t("Pinoraya"),
        t("Seginim"),
        t("Ulu Manna"),
      )),
      "Bengkulu Tengah" => drupal_map_assoc(array(
        t("Bang Haji"),
        t("Karang Tinggi"),
        t("Merigi Kelindang"),
        t("Merigi Sakti"),
        t("Pagar Jati"),
        t("Pematang Tiga"),
        t("Pondok Kelapa"),
        t("Pondok Kubang"),
        t("Taba Penanjung"),
        t("Talang Empat"),
      )),
      "Bengkulu Utara" => drupal_map_assoc(array(
        t("Air Besi"),
        t("Air Napal"),
        t("Air Padang"),
        t("Arga Makmur"),
        t("Arma Jaya"),
        t("Batik Nau"),
        t("Enggano"),
        t("Giri Mulia"),
        t("Hulu Palik"),
        t("Kerkap"),
        t("Ketahun"),
        t("Lais"),
        t("Napal Putih"),
        t("Padang Jaya"),
        t("Putri Hijau"),
        t("Tanjung Agung Palik"),
        t("Ulok Kupai"),
      )),
      "Kaur" => drupal_map_assoc(array(
        t("Kaur Selatan"),
        t("Kaur Tengah"),
        t("Kaur Utara"),
        t("Kelam Tengah"),
        t("Kinal"),
        t("Luas"),
        t("Lungkang Kule"),
        t("Maje"),
        t("Muara Sahung"),
        t("Nasal"),
        t("Padang Guci Hilir"),
        t("Padang Guci Hulu"),
        t("Semidang Gumai (Gumay)"),
        t("Tanjung Kemuning"),
        t("Tetap (Muara Tetap)"),
      )),
      "Kepahiang" => drupal_map_assoc(array(
        t("Bermani Ilir"),
        t("Kebawetan (Kabawetan)"),
        t("Kepahiang"),
        t("Merigi"),
        t("Muara Kemumu"),
        t("Seberang Musi"),
        t("Tebat Karai"),
        t("Ujan Mas"),
      )),
      "Lebong" => drupal_map_assoc(array(
        t("Amen"),
        t("Bingin Kuning"),
        t("Lebong Atas"),
        t("Lebong Sakti"),
        t("Lebong Selatan"),
        t("Lebong Tengah"),
        t("Lebong Utara"),
        t("Pelabai"),
        t("Pinang Belapis"),
        t("Rimbo Pengadang"),
        t("Topos"),
        t("Uram Jaya"),
      )),
      "Muko Muko" => drupal_map_assoc(array(
        t("Air Dikit"),
        t("Air Majunto"),
        t("Air Rami"),
        t("Ipuh (Muko-Muko Selatan)"),
        t("Kota Mukomuko (Mukomuko Utara)"),
        t("Lubuk Pinang"),
        t("Malin Deman"),
        t("Penarik"),
        t("Pondok Suguh"),
        t("Selagan Raya"),
        t("Sungai Rumbai"),
        t("Teramang Jaya"),
        t("Teras Terunjam"),
        t("V Koto"),
        t("XIV Koto"),
      )),
      "Rejang Lebong" => drupal_map_assoc(array(
        t("Bermani Ulu"),
        t("Bermani Ulu Raya"),
        t("Binduriang"),
        t("Curup"),
        t("Curup Selatan"),
        t("Curup Tengah"),
        t("Curup Timur"),
        t("Curup Utara"),
        t("Kota Padang"),
        t("Padang Ulak Tanding"),
        t("Selupu Rejang"),
        t("Sindang Beliti Ilir"),
        t("Sindang Beliti Ulu"),
        t("Sindang Daratan"),
        t("Sindang Kelingi"),
      )),
      "Seluma" => drupal_map_assoc(array(
        t("Air Periukan"),
        t("Ilir Talo"),
        t("Lubuk Sandi"),
        t("Seluma"),
        t("Seluma Barat"),
        t("Seluma Selatan"),
        t("Seluma Timur"),
        t("Seluma Utara"),
        t("Semidang Alas"),
        t("Semidang Alas Maras"),
        t("Sukaraja"),
        t("Talo"),
        t("Talo Kecil"),
        t("Ulu Talo"),
      )),
    ),
    "DI Yogyakarta" => array(
      "Bantul" => drupal_map_assoc(array(
        t("Bambang Lipuro"),
        t("Banguntapan"),
        t("Bantul"),
        t("Dlingo"),
        t("Imogiri"),
        t("Jetis"),
        t("Kasihan"),
        t("Kretek"),
        t("Pajangan"),
        t("Pandak"),
        t("Piyungan"),
        t("Pleret"),
        t("Pundong"),
        t("Sanden"),
        t("Sedayu"),
        t("Sewon"),
        t("Srandakan"),
      )),
      "Gunung Kidul" => drupal_map_assoc(array(
        t("Gedang Sari"),
        t("Girisubo"),
        t("Karangmojo"),
        t("Ngawen"),
        t("Nglipar"),
        t("Paliyan"),
        t("Panggang"),
        t("Patuk"),
        t("Playen"),
        t("Ponjong"),
        t("Purwosari"),
        t("Rongkop"),
        t("Sapto Sari"),
        t("Semanu"),
        t("Semin"),
        t("Tanjungsari"),
        t("Tepus"),
        t("Wonosari"),
      )),
      "Kulon Progo" => drupal_map_assoc(array(
        t("Galur"),
        t("Girimulyo"),
        t("Kalibawang"),
        t("Kokap"),
        t("Lendah"),
        t("Nanggulan"),
        t("Panjatan"),
        t("Pengasih"),
        t("Samigaluh"),
        t("Sentolo"),
        t("Temon"),
        t("Wates"),
      )),
      "Sleman" => drupal_map_assoc(array(
        t("Berbah"),
        t("Cangkringan"),
        t("Depok"),
        t("Gamping"),
        t("Godean"),
        t("Kalasan"),
        t("Minggir"),
        t("Mlati"),
        t("Moyudan"),
        t("Ngaglik"),
        t("Ngemplak"),
        t("Pakem"),
        t("Prambanan"),
        t("Seyegan"),
        t("Sleman"),
        t("Tempel"),
        t("Turi"),
      )),
      "Yogyakarta" => drupal_map_assoc(array(
        t("Danurejan"),
        t("Gedong Tengen"),
        t("Gondokusuman"),
        t("Gondomanan"),
        t("Jetis"),
        t("Kotagede"),
        t("Kraton"),
        t("Mantrijeron"),
        t("Mergangsan"),
        t("Ngampilan"),
        t("Pakualaman"),
        t("Tegalrejo"),
        t("Umbulharjo"),
        t("Wirobrajan"),
      )),
    ),
    "DKI Jakarta" => array(
      "Jakarta Barat" => drupal_map_assoc(array(
        t("Cengkareng"),
        t("Grogol Petamburan"),
        t("Kalideres"),
        t("Kebon Jeruk"),
        t("Kembangan"),
        t("Palmerah"),
        t("Taman Sari"),
        t("Tambora"),
      )),
      "Jakarta Pusat" => drupal_map_assoc(array(
        t("Cempaka Putih"),
        t("Gambir"),
        t("Johar Baru"),
        t("Kemayoran"),
        t("Menteng"),
        t("Sawah Besar"),
        t("Senen"),
        t("Tanah Abang"),
      )),
      "Jakarta Selatan" => drupal_map_assoc(array(
        t("Cilandak"),
        t("Jagakarsa"),
        t("Kebayoran Baru"),
        t("Kebayoran Lama"),
        t("Mampang Prapatan"),
        t("Pancoran"),
        t("Pasar Minggu"),
        t("Pesanggrahan"),
        t("Setia Budi"),
        t("Tebet"),
      )),
      "Jakarta Timur" => drupal_map_assoc(array(
        t("Cakung"),
        t("Cipayung"),
        t("Ciracas"),
        t("Duren Sawit"),
        t("Jatinegara"),
        t("Kramat Jati"),
        t("Makasar"),
        t("Matraman"),
        t("Pasar Rebo"),
        t("Pulo Gadung"),
      )),
      "Jakarta Utara" => drupal_map_assoc(array(
        t("Cilincing"),
        t("Kelapa Gading"),
        t("Koja"),
        t("Pademangan"),
        t("Penjaringan"),
        t("Tanjung Priok"),
      )),
      "Kepulauan Seribu" => drupal_map_assoc(array(
        t("Kepulauan Seribu Selatan"),
        t("Kepulauan Seribu Utara"),
      )),
    ),
    "Gorontalo" => array(
      "Boalemo" => drupal_map_assoc(array(
        t("Botumoita (Botumoito)"),
        t("Dulupi"),
        t("Mananggu"),
        t("Paguyaman"),
        t("Paguyaman Pantai"),
        t("Tilamuta"),
        t("Wonosari"),
      )),
      "Bone Bolango" => drupal_map_assoc(array(
        t("Bone"),
        t("Bone Raya"),
        t("Bonepantai"),
        t("Botu Pingge"),
        t("Bulango Selatan"),
        t("Bulango Timur"),
        t("Bulango Ulu"),
        t("Bulango Utara"),
        t("Bulawa"),
        t("Kabila"),
        t("Kabila Bone"),
        t("Pinogu"),
        t("Suwawa"),
        t("Suwawa Selatan"),
        t("Suwawa Tengah"),
        t("Suwawa Timur"),
        t("Tapa"),
        t("Tilongkabila"),
      )),
      "Gorontalo (Kabupaten)" => drupal_map_assoc(array(
        t("Asparaga"),
        t("Batudaa"),
        t("Batudaa Pantai"),
        t("Bilato"),
        t("Biluhu"),
        t("Boliohuto (Boliyohuto)"),
        t("Bongomeme"),
        t("Dungaliyo"),
        t("Limboto"),
        t("Limboto Barat"),
        t("Mootilango"),
        t("Pulubala"),
        t("Tabongo"),
        t("Telaga"),
        t("Telaga Biru"),
        t("Telaga Jaya"),
        t("Tibawa"),
        t("Tilango"),
        t("Tolangohula"),
      )),
      "Gorontalo (Kota)" => drupal_map_assoc(array(
        t("Dumbo Raya"),
        t("Dungingi"),
        t("Hulonthalangi"),
        t("Kota Barat"),
        t("Kota Selatan"),
        t("Kota Tengah"),
        t("Kota Timur"),
        t("Kota Utara"),
        t("Sipatana"),
      )),
      "Gorontalo Utara" => drupal_map_assoc(array(
        t("Anggrek"),
        t("Atinggola"),
        t("Biau"),
        t("Gentuma Raya"),
        t("Kwandang"),
        t("Monano"),
        t("Ponelo Kepulauan"),
        t("Sumalata"),
        t("Sumalata Timur"),
        t("Tolinggula"),
        t("Tomolito"),
      )),
      "Pohuwato" => drupal_map_assoc(array(
        t("Buntulia"),
        t("Dengilo"),
        t("Duhiadaa"),
        t("Lemito"),
        t("Marisa"),
        t("Paguat"),
        t("Patilanggio"),
        t("Popayato"),
        t("Popayato Barat"),
        t("Popayato Timur"),
        t("Randangan"),
        t("Taluditi (Taluduti)"),
        t("Wanggarasi"),
      )),
    ),
    "Jambi" => array(
      "Batang Hari" => drupal_map_assoc(array(
        t("Bajubang"),
        t("Batin XXIV"),
        t("Maro Sebo Ilir"),
        t("Maro Sebo Ulu"),
        t("Mersam"),
        t("Muara Bulian"),
        t("Muara Tembesi"),
        t("Pemayung"),
      )),
      "Bungo" => drupal_map_assoc(array(
        t("Bathin II Babeko"),
        t("Bathin II Pelayang"),
        t("Bathin III"),
        t("Bathin III Ulu"),
        t("Bungo Dani"),
        t("Jujuhan"),
        t("Jujuhan Ilir"),
        t("Limbur Lubuk Mengkuang"),
        t("Muko-Muko Batin VII"),
        t("Pasar Muara Bungo"),
        t("Pelepat"),
        t("Pelepat Ilir"),
        t("Rantau Pandan"),
        t("Rimbo Tengah"),
        t("Tanah Sepenggal"),
        t("Tanah Sepenggal Lintas"),
        t("Tanah Tumbuh"),
      )),
      "Jambi" => drupal_map_assoc(array(
        t("Danau Teluk"),
        t("Jambi Selatan"),
        t("Jambi Timur"),
        t("Jelutung"),
        t("Kota Baru"),
        t("Pasar Jambi"),
        t("Pelayangan"),
        t("Telanaipura"),
      )),
      "Kerinci" => drupal_map_assoc(array(
        t("Air Hangat"),
        t("Air Hangat Barat"),
        t("Air Hangat Timur"),
        t("Batang Merangin"),
        t("Bukitkerman"),
        t("Danau Kerinci"),
        t("Depati Tujuh"),
        t("Gunung Kerinci"),
        t("Gunung Raya"),
        t("Gunung Tujuh"),
        t("Kayu Aro"),
        t("Kayu Aro Barat"),
        t("Keliling Danau"),
        t("Sitinjau Laut"),
        t("Siulak"),
        t("Siulak Mukai"),
      )),
      "Merangin" => drupal_map_assoc(array(
        t("Bangko"),
        t("Bangko Barat"),
        t("Batang Masumai"),
        t("Jangkat"),
        t("Lembah Masurai"),
        t("Margo Tabir"),
        t("Muara Siau"),
        t("Nalo Tantan"),
        t("Pamenang"),
        t("Pamenang Barat"),
        t("Pamenang Selatan"),
        t("Pangkalan Jambu"),
        t("Renah Pembarap"),
        t("Renah Pemenang"),
        t("Sungai Manau"),
        t("Sungai Tenang"),
        t("Tabir"),
        t("Tabir Barat"),
        t("Tabir Ilir"),
        t("Tabir Lintas"),
        t("Tabir Selatan"),
        t("Tabir Timur"),
        t("Tabir Ulu"),
        t("Tiang Pumpung"),
      )),
      "Muaro Jambi" => drupal_map_assoc(array(
        t("Bahar Selatan"),
        t("Bahar Utara"),
        t("Jambi Luar Kota"),
        t("Kumpeh"),
        t("Kumpeh Ulu"),
        t("Maro Sebo"),
        t("Mestong"),
        t("Sekernan"),
        t("Sungai Bahar"),
        t("Sungai Gelam"),
        t("Taman Rajo / Rejo"),
      )),
      "Sarolangun" => drupal_map_assoc(array(
        t("Air Hitam"),
        t("Batang Asai"),
        t("Bathin VIII (Batin VIII)"),
        t("Cermin Nan Gadang"),
        t("Limun"),
        t("Mandiangin"),
        t("Pauh"),
        t("Pelawan"),
        t("Sarolangun"),
        t("Singkut"),
      )),
      "Sungaipenuh" => drupal_map_assoc(array(
        t("Hamparan Rawang"),
        t("Koto Baru"),
        t("Kumun Debai"),
        t("Pesisir Bukit"),
        t("Pondok Tinggi"),
        t("Sungai Bungkal"),
        t("Sungai Penuh"),
        t("Tanah Kampung"),
      )),
      "Tanjung Jabung Barat" => drupal_map_assoc(array(
        t("Batang Asam"),
        t("Betara"),
        t("Bram Itam"),
        t("Kuala Betara"),
        t("Merlung"),
        t("Muara Papalik"),
        t("Pengabuan"),
        t("Renah Mendaluh"),
        t("Seberang Kota"),
        t("Senyerang"),
        t("Tebing Tinggi"),
        t("Tungkal Ilir"),
        t("Tungkal Ulu"),
      )),
      "Tanjung Jabung Timur" => drupal_map_assoc(array(
        t("Berbak"),
        t("Dendang"),
        t("Geragai"),
        t("Kuala Jambi"),
        t("Mendahara"),
        t("Mendahara Ulu"),
        t("Muara Sabak Barat"),
        t("Muara Sabak Timur"),
        t("Nipah Panjang"),
        t("Rantau Rasau"),
        t("Sadu"),
      )),
      "Tebo" => drupal_map_assoc(array(
        t("Muara Tabir"),
        t("Rimbo Bujang"),
        t("Rimbo Ilir"),
        t("Rimbo Ulu"),
        t("Serai Serumpun"),
        t("Sumay"),
        t("Tebo Ilir"),
        t("Tebo Tengah"),
        t("Tebo Ulu"),
        t("Tengah Ilir"),
        t("VII Koto"),
        t("VII Koto Ilir"),
      )),
    ),
    "Jawa Barat" => array(
      "Bandung (Kabupaten)" => drupal_map_assoc(array(
        t("Arjasari"),
        t("Baleendah"),
        t("Banjaran"),
        t("Bojongsoang"),
        t("Cangkuang"),
        t("Cicalengka"),
        t("Cikancung"),
        t("Cilengkrang"),
        t("Cileunyi"),
        t("Cimaung"),
        t("Cimeunyan"),
        t("Ciparay"),
        t("Ciwidey"),
        t("Dayeuhkolot"),
        t("Ibun"),
        t("Katapang"),
        t("Kertasari"),
        t("Kutawaringin"),
        t("Majalaya"),
        t("Margaasih"),
        t("Margahayu"),
        t("Nagreg"),
        t("Pacet"),
        t("Pameungpeuk"),
        t("Pangalengan"),
        t("Paseh"),
        t("Pasirjambu"),
        t("Ranca Bali"),
        t("Rancaekek"),
        t("Solokan Jeruk"),
        t("Soreang"),
      )),
      "Bandung (Kota)" => drupal_map_assoc(array(
        t("Andir"),
        t("Antapani (Cicadas)"),
        t("Arcamanik"),
        t("Astana Anyar"),
        t("Babakan Ciparay"),
        t("Bandung Kidul"),
        t("Bandung Kulon"),
        t("Bandung Wetan"),
        t("Batununggal"),
        t("Bojongloa Kaler"),
        t("Bojongloa Kidul"),
        t("Buahbatu (Margacinta)"),
        t("Cibeunying Kaler"),
        t("Cibeunying Kidul"),
        t("Cibiru"),
        t("Cicendo"),
        t("Cidadap"),
        t("Cinambo"),
        t("Coblong"),
        t("Gedebage"),
        t("Kiaracondong"),
        t("Lengkong"),
        t("Mandalajati"),
        t("Panyileukan"),
        t("Rancasari"),
        t("Regol"),
        t("Sukajadi"),
        t("Sukasari"),
        t("Sumur Bandung"),
        t("Ujung Berung"),
      )),
      "Bandung Barat" => drupal_map_assoc(array(
        t("Batujajar"),
        t("Cihampelas"),
        t("Cikalong Wetan"),
        t("Cililin"),
        t("Cipatat"),
        t("Cipeundeuy"),
        t("Cipongkor"),
        t("Cisarua"),
        t("Gununghalu"),
        t("Lembang"),
        t("Ngamprah"),
        t("Padalarang"),
        t("Parongpong"),
        t("Rongga"),
        t("Saguling"),
        t("Sindangkerta"),
      )),
      "Banjar (Kota)" => drupal_map_assoc(array(
        t("Banjar"),
        t("Langensari"),
        t("Pataruman"),
        t("Purwaharja"),
      )),
      "Bekasi (Kabupaten)" => drupal_map_assoc(array(
        t("Babelan"),
        t("Bojongmangu"),
        t("Cabangbungin"),
        t("Cibarusah"),
        t("Cibitung"),
        t("Cikarang Barat"),
        t("Cikarang Pusat"),
        t("Cikarang Selatan"),
        t("Cikarang Timur"),
        t("Cikarang Utara"),
        t("Karangbahagia"),
        t("Kedung Waringin"),
        t("Muara Gembong"),
        t("Pebayuran"),
        t("Serang Baru"),
        t("Setu"),
        t("Sukakarya"),
        t("Sukatani"),
        t("Sukawangi"),
        t("Tambelang"),
        t("Tambun Selatan"),
        t("Tambun Utara"),
        t("Tarumajaya"),
      )),
      "Bekasi (Kota)" => drupal_map_assoc(array(
        t("Bantar Gebang"),
        t("Bekasi Barat"),
        t("Bekasi Selatan"),
        t("Bekasi Timur"),
        t("Bekasi Utara"),
        t("Jati Sampurna"),
        t("Jatiasih"),
        t("Medan Satria"),
        t("Mustika Jaya"),
        t("Pondok Gede"),
        t("Pondok Melati"),
        t("Rawalumbu"),
      )),
      "Bogor (Kabupaten)" => drupal_map_assoc(array(
        t("Babakan Madang"),
        t("Bojonggede"),
        t("Caringin"),
        t("Cariu"),
        t("Ciampea"),
        t("Ciawi"),
        t("Cibinong"),
        t("Cibungbulang"),
        t("Cigombong"),
        t("Cigudeg"),
        t("Cijeruk"),
        t("Cileungsi"),
        t("Ciomas"),
        t("Cisarua"),
        t("Ciseeng"),
        t("Citeureup"),
        t("Dramaga"),
        t("Gunung Putri"),
        t("Gunung Sindur"),
        t("Jasinga"),
        t("Jonggol"),
        t("Kemang"),
        t("Klapa Nunggal (Kelapa Nunggal)"),
        t("Leuwiliang"),
        t("Leuwisadeng"),
        t("Megamendung"),
        t("Nanggung"),
        t("Pamijahan"),
        t("Parung"),
        t("Parung Panjang"),
        t("Ranca Bungur"),
        t("Rumpin"),
        t("Sukajaya"),
        t("Sukamakmur"),
        t("Sukaraja"),
        t("Tajurhalang"),
        t("Tamansari"),
        t("Tanjungsari"),
        t("Tenjo"),
        t("Tenjolaya"),
      )),
      "Bogor (Kota)" => drupal_map_assoc(array(
        t("Bogor Barat - Kota"),
        t("Bogor Selatan - Kota"),
        t("Bogor Tengah - Kota"),
        t("Bogor Timur - Kota"),
        t("Bogor Utara - Kota"),
        t("Tanah Sereal"),
      )),
      "Ciamis" => drupal_map_assoc(array(
        t("Banjarsari"),
        t("Baregbeg"),
        t("Ciamis"),
        t("Cidolog"),
        t("Cihaurbeuti"),
        t("Cijeungjing"),
        t("Cikoneng"),
        t("Cimaragas"),
        t("Cipaku"),
        t("Cisaga"),
        t("Jatinagara"),
        t("Kawali"),
        t("Lakbok"),
        t("Lumbung"),
        t("Pamarican"),
        t("Panawangan"),
        t("Panjalu"),
        t("Panumbangan"),
        t("Purwadadi"),
        t("Rajadesa"),
        t("Rancah"),
        t("Sadananya"),
        t("Sindangkasih"),
        t("Sukadana"),
        t("Sukamantri"),
        t("Tambaksari"),
      )),
      "Cianjur" => drupal_map_assoc(array(
        t("Agrabinta"),
        t("Bojongpicung"),
        t("Campaka"),
        t("Campaka Mulya"),
        t("Cianjur"),
        t("Cibeber"),
        t("Cibinong"),
        t("Cidaun"),
        t("Cijati"),
        t("Cikadu"),
        t("Cikalongkulon"),
        t("Cilaku"),
        t("Cipanas"),
        t("Ciranjang"),
        t("Cugenang"),
        t("Gekbrong"),
        t("Haurwangi"),
        t("Kadupandak"),
        t("Karangtengah"),
        t("Leles"),
        t("Mande"),
        t("Naringgul"),
        t("Pacet"),
        t("Pagelaran"),
        t("Pasirkuda"),
        t("Sindangbarang"),
        t("Sukaluyu"),
        t("Sukanagara"),
        t("Sukaresmi"),
        t("Takokak"),
        t("Tanggeung"),
        t("Warungkondang"),
      )),
      "Cimahi" => drupal_map_assoc(array(
        t("Cimahi Selatan"),
        t("Cimahi Tengah"),
        t("Cimahi Utara"),
      )),
      "Cirebon (Kabupaten)" => drupal_map_assoc(array(
        t("Arjawinangun"),
        t("Astanajapura"),
        t("Babakan"),
        t("Beber"),
        t("Ciledug"),
        t("Ciwaringin"),
        t("Depok"),
        t("Dukupuntang"),
        t("Gebang"),
        t("Gegesik"),
        t("Gempol"),
        t("Greged (Greget)"),
        t("Gunung Jati (Cirebon Utara)"),
        t("Jamblang"),
        t("Kaliwedi"),
        t("Kapetakan"),
        t("Karangsembung"),
        t("Karangwareng"),
        t("Kedawung"),
        t("Klangenan"),
        t("Lemahabang"),
        t("Losari"),
        t("Mundu"),
        t("Pabedilan"),
        t("Pabuaran"),
        t("Palimanan"),
        t("Pangenan"),
        t("Panguragan"),
        t("Pasaleman"),
        t("Plered"),
        t("Plumbon"),
        t("Sedong"),
        t("Sumber"),
        t("Suranenggala"),
        t("Susukan"),
        t("Susukan Lebak"),
        t("Talun (Cirebon Selatan)"),
        t("Tengah Tani"),
        t("Waled"),
        t("Weru"),
      )),
      "Cirebon (Kota)" => drupal_map_assoc(array(
        t("Harjamukti"),
        t("Kejaksan"),
        t("Kesambi"),
        t("Lemahwungkuk"),
        t("Pekalipan"),
      )),
      "Depok" => drupal_map_assoc(array(
        t("Beji"),
        t("Bojongsari"),
        t("Cilodong"),
        t("Cimanggis"),
        t("Cinere"),
        t("Cipayung"),
        t("Limo"),
        t("Pancoran Mas"),
        t("Sawangan"),
        t("Sukmajaya"),
        t("Tapos"),
      )),
      "Garut" => drupal_map_assoc(array(
        t("Banjarwangi"),
        t("Banyuresmi"),
        t("Bayongbong"),
        t("Blubur Limbangan"),
        t("Bungbulang"),
        t("Caringin"),
        t("Cibalong"),
        t("Cibatu"),
        t("Cibiuk"),
        t("Cigedug"),
        t("Cihurip"),
        t("Cikajang"),
        t("Cikelet"),
        t("Cilawu"),
        t("Cisewu"),
        t("Cisompet"),
        t("Cisurupan"),
        t("Garut Kota"),
        t("Kadungora"),
        t("Karangpawitan"),
        t("Karangtengah"),
        t("Kersamanah"),
        t("Leles"),
        t("Leuwigoong"),
        t("Malangbong"),
        t("Mekarmukti"),
        t("Pakenjeng"),
        t("Pameungpeuk"),
        t("Pamulihan"),
        t("Pangatikan"),
        t("Pasirwangi"),
        t("Peundeuy"),
        t("Samarang"),
        t("Selaawi"),
        t("Singajaya"),
        t("Sucinaraja"),
        t("Sukaresmi"),
        t("Sukawening"),
        t("Talegong"),
        t("Tarogong Kaler"),
        t("Tarogong Kidul"),
        t("Wanaraja"),
      )),
      "Indramayu" => drupal_map_assoc(array(
        t("Anjatan"),
        t("Arahan"),
        t("Balongan"),
        t("Bangodua"),
        t("Bongas"),
        t("Cantigi"),
        t("Cikedung"),
        t("Gabuswetan"),
        t("Gantar"),
        t("Haurgeulis"),
        t("Indramayu"),
        t("Jatibarang"),
        t("Juntinyuat"),
        t("Kandanghaur"),
        t("Karangampel"),
        t("Kedokan Bunder"),
        t("Kertasemaya"),
        t("Krangkeng"),
        t("Kroya"),
        t("Lelea"),
        t("Lohbener"),
        t("Losarang"),
        t("Pasekan"),
        t("Patrol"),
        t("Sindang"),
        t("Sliyeg"),
        t("Sukagumiwang"),
        t("Sukra"),
        t("Trisi/Terisi"),
        t("Tukdana"),
        t("Widasari"),
      )),
      "Karawang" => drupal_map_assoc(array(
        t("Banyusari"),
        t("Batujaya"),
        t("Ciampel"),
        t("Cibuaya"),
        t("Cikampek"),
        t("Cilamaya Kulon"),
        t("Cilamaya Wetan"),
        t("Cilebar"),
        t("Jatisari"),
        t("Jayakerta"),
        t("Karawang Barat"),
        t("Karawang Timur"),
        t("Klari"),
        t("Kotabaru"),
        t("Kutawaluya"),
        t("Lemahabang"),
        t("Majalaya"),
        t("Pakisjaya"),
        t("Pangkalan"),
        t("Pedes"),
        t("Purwasari"),
        t("Rawamerta"),
        t("Rengasdengklok"),
        t("Talagasari"),
        t("Tegalwaru"),
        t("Telukjambe Barat"),
        t("Telukjambe Timur"),
        t("Tempuran"),
        t("Tirtajaya"),
        t("Tirtamulya"),
      )),
      "Kuningan" => drupal_map_assoc(array(
        t("Ciawigebang"),
        t("Cibeureum"),
        t("Cibingbin"),
        t("Cidahu"),
        t("Cigandamekar"),
        t("Cigugur"),
        t("Cilebak"),
        t("Cilimus"),
        t("Cimahi"),
        t("Ciniru"),
        t("Cipicung"),
        t("Ciwaru"),
        t("Darma"),
        t("Garawangi"),
        t("Hantara"),
        t("Jalaksana"),
        t("Japara"),
        t("Kadugede"),
        t("Kalimanggis"),
        t("Karangkancana"),
        t("Kramat Mulya"),
        t("Kuningan"),
        t("Lebakwangi"),
        t("Luragung"),
        t("Maleber"),
        t("Mandirancan"),
        t("Nusaherang"),
        t("Pancalang"),
        t("Pasawahan"),
        t("Selajambe"),
        t("Sindangagung"),
        t("Subang"),
      )),
      "Majalengka" => drupal_map_assoc(array(
        t("Argapura"),
        t("Banjaran"),
        t("Bantarujeg"),
        t("Cigasong"),
        t("Cikijing"),
        t("Cingambul"),
        t("Dawuan"),
        t("Jatitujuh"),
        t("Jatiwangi"),
        t("Kadipaten"),
        t("Kasokandel"),
        t("Kertajati"),
        t("Lemahsugih"),
        t("Leuwimunding"),
        t("Ligung"),
        t("Maja"),
        t("Majalengka"),
        t("Malausma"),
        t("Palasah"),
        t("Panyingkiran"),
        t("Rajagaluh"),
        t("Sindang"),
        t("Sindangwangi"),
        t("Sukahaji"),
        t("Sumberjaya"),
        t("Talaga"),
      )),
      "Pangandaran" => drupal_map_assoc(array(
        t("Cigugur"),
        t("Cijulang"),
        t("Cimerak"),
        t("Kalipucang"),
        t("Langkaplancar"),
        t("Mangunjaya"),
        t("Padaherang"),
        t("Pangandaran"),
        t("Parigi"),
        t("Sidamulih"),
      )),
      "Purwakarta" => drupal_map_assoc(array(
        t("Babakancikao"),
        t("Bojong"),
        t("Bungursari"),
        t("Campaka"),
        t("Cibatu"),
        t("Darangdan"),
        t("Jatiluhur"),
        t("Kiarapedes"),
        t("Maniis"),
        t("Pasawahan"),
        t("Plered"),
        t("Pondoksalam"),
        t("Purwakarta"),
        t("Sukasari"),
        t("Sukatani"),
        t("Tegal Waru"),
        t("Wanayasa"),
      )),
      "Subang" => drupal_map_assoc(array(
        t("Binong"),
        t("Blanakan"),
        t("Ciasem"),
        t("Ciater"),
        t("Cibogo"),
        t("Cijambe"),
        t("Cikaum"),
        t("Cipeundeuy"),
        t("Cipunagara"),
        t("Cisalak"),
        t("Compreng"),
        t("Dawuan"),
        t("Jalancagak"),
        t("Kalijati"),
        t("Kasomalang"),
        t("Legonkulon"),
        t("Pabuaran"),
        t("Pagaden"),
        t("Pagaden Barat"),
        t("Pamanukan"),
        t("Patokbeusi"),
        t("Purwadadi"),
        t("Pusakajaya"),
        t("Pusakanagara"),
        t("Sagalaherang"),
        t("Serangpanjang"),
        t("Subang"),
        t("Sukasari"),
        t("Tambakdahan"),
        t("Tanjungsiang"),
      )),
      "Sukabumi (Kabupaten)" => drupal_map_assoc(array(
        t("Bantargadung"),
        t("Bojong Genteng"),
        t("Caringin"),
        t("Ciambar"),
        t("Cibadak"),
        t("Cibitung"),
        t("Cicantayan"),
        t("Cicurug"),
        t("Cidadap"),
        t("Cidahu"),
        t("Cidolog"),
        t("Ciemas"),
        t("Cikakak"),
        t("Cikembar"),
        t("Cikidang"),
        t("Cimanggu"),
        t("Ciracap"),
        t("Cireunghas"),
        t("Cisaat"),
        t("Cisolok"),
        t("Curugkembar"),
        t("Geger Bitung"),
        t("Gunung Guruh"),
        t("Jampang Kulon"),
        t("Jampang Tengah"),
        t("Kabandungan"),
        t("Kadudampit"),
        t("Kalapa Nunggal"),
        t("Kali Bunder"),
        t("Kebonpedes"),
        t("Lengkong"),
        t("Nagrak"),
        t("Nyalindung"),
        t("Pabuaran"),
        t("Parakan Salak"),
        t("Parung Kuda"),
        t("Pelabuhan/Palabuhan Ratu"),
        t("Purabaya"),
        t("Sagaranten"),
        t("Simpenan"),
        t("Sukabumi"),
        t("Sukalarang"),
        t("Sukaraja"),
        t("Surade"),
        t("Tegal Buleud"),
        t("Waluran"),
        t("Warung Kiara"),
      )),
      "Sukabumi (Kota)" => drupal_map_assoc(array(
        t("Baros"),
        t("Cibeureum"),
        t("Cikole"),
        t("Citamiang"),
        t("Gunung Puyuh"),
        t("Lembursitu"),
        t("Warudoyong"),
      )),
      "Sumedang" => drupal_map_assoc(array(
        t("Buahdua"),
        t("Cibugel"),
        t("Cimalaka"),
        t("Cimanggung"),
        t("Cisarua"),
        t("Cisitu"),
        t("Conggeang"),
        t("Darmaraja"),
        t("Ganeas"),
        t("Jatigede"),
        t("Jatinangor"),
        t("Jatinunggal"),
        t("Pamulihan"),
        t("Paseh"),
        t("Rancakalong"),
        t("Situraja"),
        t("Sukasari"),
        t("Sumedang Selatan"),
        t("Sumedang Utara"),
        t("Surian"),
        t("Tanjungkerta"),
        t("Tanjungmedar"),
        t("Tanjungsari"),
        t("Tomo"),
        t("Ujungjaya"),
        t("Wado"),
      )),
      "Tasikmalaya (Kabupaten)" => drupal_map_assoc(array(
        t("Bantarkalong"),
        t("Bojongasih"),
        t("Bojonggambir"),
        t("Ciawi"),
        t("Cibalong"),
        t("Cigalontang"),
        t("Cikalong"),
        t("Cikatomas"),
        t("Cineam"),
        t("Cipatujah"),
        t("Cisayong"),
        t("Culamega"),
        t("Gunung Tanjung"),
        t("Jamanis"),
        t("Jatiwaras"),
        t("Kadipaten"),
        t("Karang Jaya"),
        t("Karangnunggal"),
        t("Leuwisari"),
        t("Mangunreja"),
        t("Manonjaya"),
        t("Padakembang"),
        t("Pagerageung"),
        t("Pancatengah"),
        t("Parungponteng"),
        t("Puspahiang"),
        t("Rajapolah"),
        t("Salawu"),
        t("Salopa"),
        t("Sariwangi"),
        t("Singaparna"),
        t("Sodonghilir"),
        t("Sukahening"),
        t("Sukaraja"),
        t("Sukarame"),
        t("Sukaratu"),
        t("Sukaresik"),
        t("Tanjungjaya"),
        t("Taraju"),
      )),
      "Tasikmalaya (Kota)" => drupal_map_assoc(array(
        t("Bungursari"),
        t("Cibeureum"),
        t("Cihideung"),
        t("Cipedes"),
        t("Indihiang"),
        t("Kawalu"),
        t("Mangkubumi"),
        t("Purbaratu"),
        t("Tamansari"),
        t("Tawang"),
      )),
    ),
    "Jawa Tengah" => array(
      "Banjarnegara" => drupal_map_assoc(array(
        t("Banjarmangu"),
        t("Banjarnegara"),
        t("Batur"),
        t("Bawang"),
        t("Kalibening"),
        t("Karangkobar"),
        t("Madukara"),
        t("Mandiraja"),
        t("Pagedongan"),
        t("Pagentan"),
        t("Pandanarum"),
        t("Pejawaran"),
        t("Punggelan"),
        t("Purwonegoro"),
        t("Purworejo Klampok"),
        t("Rakit"),
        t("Sigaluh"),
        t("Susukan"),
        t("Wanadadi (Wonodadi)"),
        t("Wanayasa"),
      )),
      "Banyumas" => drupal_map_assoc(array(
        t("Ajibarang"),
        t("Banyumas"),
        t("Baturaden"),
        t("Cilongok"),
        t("Gumelar"),
        t("Jatilawang"),
        t("Kalibagor"),
        t("Karanglewas"),
        t("Kebasen"),
        t("Kedung Banteng"),
        t("Kembaran"),
        t("Kemranjen"),
        t("Lumbir"),
        t("Patikraja"),
        t("Pekuncen"),
        t("Purwojati"),
        t("Purwokerto Barat"),
        t("Purwokerto Selatan"),
        t("Purwokerto Timur"),
        t("Purwokerto Utara"),
        t("Rawalo"),
        t("Sokaraja"),
        t("Somagede"),
        t("Sumbang"),
        t("Sumpiuh"),
        t("Tambak"),
        t("Wangon"),
      )),
      "Batang" => drupal_map_assoc(array(
        t("Bandar"),
        t("Banyuputih"),
        t("Batang"),
        t("Bawang"),
        t("Blado"),
        t("Gringsing"),
        t("Kandeman"),
        t("Limpung"),
        t("Pecalungan"),
        t("Reban"),
        t("Subah"),
        t("Tersono"),
        t("Tulis"),
        t("Warungasem"),
        t("Wonotunggal"),
      )),
      "Blora" => drupal_map_assoc(array(
        t("Banjarejo"),
        t("Blora kota"),
        t("Bogorejo"),
        t("Cepu"),
        t("Japah"),
        t("Jati"),
        t("Jepon"),
        t("Jiken"),
        t("Kedungtuban"),
        t("Kradenan"),
        t("Kunduran"),
        t("Ngawen"),
        t("Randublatung"),
        t("Sambong"),
        t("Todanan"),
        t("Tunjungan"),
      )),
      "Boyolali" => drupal_map_assoc(array(
        t("Ampel"),
        t("Andong"),
        t("Banyudono"),
        t("Boyolali"),
        t("Cepogo"),
        t("Juwangi"),
        t("Karanggede"),
        t("Kemusu"),
        t("Klego"),
        t("Mojosongo"),
        t("Musuk"),
        t("Ngemplak"),
        t("Nogosari"),
        t("Sambi"),
        t("Sawit"),
        t("Selo"),
        t("Simo"),
        t("Teras"),
        t("Wonosegoro"),
      )),
      "Brebes" => drupal_map_assoc(array(
        t("Banjarharjo"),
        t("Bantarkawung"),
        t("Brebes"),
        t("Bulakamba"),
        t("Bumiayu"),
        t("Jatibarang"),
        t("Kersana"),
        t("Ketanggungan"),
        t("Larangan"),
        t("Losari"),
        t("Paguyangan"),
        t("Salem"),
        t("Sirampog"),
        t("Songgom"),
        t("Tanjung"),
        t("Tonjong"),
        t("Wanasari"),
      )),
      "Cilacap" => drupal_map_assoc(array(
        t("Adipala"),
        t("Bantarsari"),
        t("Binangun"),
        t("Cilacap Selatan"),
        t("Cilacap Tengah"),
        t("Cilacap Utara"),
        t("Cimanggu"),
        t("Cipari"),
        t("Dayeuhluhur"),
        t("Gandrungmangu"),
        t("Jeruklegi"),
        t("Kampung Laut"),
        t("Karangpucung"),
        t("Kawunganten"),
        t("Kedungreja"),
        t("Kesugihan"),
        t("Kroya"),
        t("Majenang"),
        t("Maos"),
        t("Nusawungu"),
        t("Patimuan"),
        t("Sampang"),
        t("Sidareja"),
        t("Wanareja"),
      )),
      "Demak" => drupal_map_assoc(array(
        t("Bonang"),
        t("Demak"),
        t("Dempet"),
        t("Gajah"),
        t("Guntur"),
        t("Karang Tengah"),
        t("Karanganyar"),
        t("Karangawen"),
        t("Kebonagung"),
        t("Mijen"),
        t("Mranggen"),
        t("Sayung"),
        t("Wedung"),
        t("Wonosalam"),
      )),
      "Grobogan" => drupal_map_assoc(array(
        t("Brati"),
        t("Gabus"),
        t("Geyer"),
        t("Godong"),
        t("Grobogan"),
        t("Gubug"),
        t("Karangrayung"),
        t("Kedungjati"),
        t("Klambu"),
        t("Kradenan"),
        t("Ngaringan"),
        t("Penawangan"),
        t("Pulokulon"),
        t("Purwodadi"),
        t("Tanggungharjo"),
        t("Tawangharjo"),
        t("Tegowanu"),
        t("Toroh"),
        t("Wirosari"),
      )),
      "Jepara" => drupal_map_assoc(array(
        t("Bangsri"),
        t("Batealit"),
        t("Donorojo"),
        t("Jepara"),
        t("Kalinyamatan"),
        t("Karimunjawa"),
        t("Kedung"),
        t("Keling"),
        t("Kembang"),
        t("Mayong"),
        t("Mlonggo"),
        t("Nalumsari"),
        t("Pakis Aji"),
        t("Pecangaan"),
        t("Tahunan"),
        t("Welahan"),
      )),
      "Karanganyar" => drupal_map_assoc(array(
        t("Colomadu"),
        t("Gondangrejo"),
        t("Jaten"),
        t("Jatipuro"),
        t("Jatiyoso"),
        t("Jenawi"),
        t("Jumantono"),
        t("Jumapolo"),
        t("Karanganyar"),
        t("Karangpandan"),
        t("Kebakkramat"),
        t("Kerjo"),
        t("Matesih"),
        t("Mojogedang"),
        t("Ngargoyoso"),
        t("Tasikmadu"),
        t("Tawangmangu"),
      )),
      "Kebumen" => drupal_map_assoc(array(
        t("Adimulyo"),
        t("Alian/Aliyan"),
        t("Ambal"),
        t("Ayah"),
        t("Bonorowo"),
        t("Buayan"),
        t("Buluspesantren"),
        t("Gombong"),
        t("Karanganyar"),
        t("Karanggayam"),
        t("Karangsambung"),
        t("Kebumen"),
        t("Klirong"),
        t("Kutowinangun"),
        t("Kuwarasan"),
        t("Mirit"),
        t("Padureso"),
        t("Pejagoan"),
        t("Petanahan"),
        t("Poncowarno"),
        t("Prembun"),
        t("Puring"),
        t("Rowokele"),
        t("Sadang"),
        t("Sempor"),
        t("Sruweng"),
      )),
      "Kendal" => drupal_map_assoc(array(
        t("Boja"),
        t("Brangsong"),
        t("Cepiring"),
        t("Gemuh"),
        t("Kaliwungu"),
        t("Kaliwungu Selatan"),
        t("Kangkung"),
        t("Kendal"),
        t("Limbangan"),
        t("Ngampel"),
        t("Pagerruyung"),
        t("Patean"),
        t("Patebon"),
        t("Pegandon"),
        t("Plantungan"),
        t("Ringinarum"),
        t("Rowosari"),
        t("Singorojo"),
        t("Sukorejo"),
        t("Weleri"),
      )),
      "Klaten" => drupal_map_assoc(array(
        t("Bayat"),
        t("Cawas"),
        t("Ceper"),
        t("Delanggu"),
        t("Gantiwarno"),
        t("Jatinom"),
        t("Jogonalan"),
        t("Juwiring"),
        t("Kalikotes"),
        t("Karanganom"),
        t("Karangdowo"),
        t("Karangnongko"),
        t("Kebonarum"),
        t("Kemalang"),
        t("Klaten Selatan"),
        t("Klaten Tengah"),
        t("Klaten Utara"),
        t("Manisrenggo"),
        t("Ngawen"),
        t("Pedan"),
        t("Polanharjo"),
        t("Prambanan"),
        t("Trucuk"),
        t("Tulung"),
        t("Wedi"),
        t("Wonosari"),
      )),
      "Kudus" => drupal_map_assoc(array(
        t("Bae"),
        t("Dawe"),
        t("Gebog"),
        t("Jati"),
        t("Jekulo"),
        t("Kaliwungu"),
        t("Kudus Kota"),
        t("Mejobo"),
        t("Undaan"),
      )),
      "Magelang (Kabupaten)" => drupal_map_assoc(array(
        t("Bandongan"),
        t("Borobudur"),
        t("Candimulyo"),
        t("Dukun"),
        t("Grabag"),
        t("Kajoran"),
        t("Kaliangkrik"),
        t("Mertoyudan"),
        t("Mungkid"),
        t("Muntilan"),
        t("Ngablak"),
        t("Ngluwar"),
        t("Pakis"),
        t("Salam"),
        t("Salaman"),
        t("Sawangan"),
        t("Secang"),
        t("Srumbung"),
        t("Tegalrejo"),
        t("Tempuran"),
        t("Windusari"),
      )),
      "Magelang (Kota)" => drupal_map_assoc(array(
        t("Magelang Selatan"),
        t("Magelang Tengah"),
        t("Magelang Utara"),
      )),
      "Pati" => drupal_map_assoc(array(
        t("Batangan"),
        t("Cluwak"),
        t("Dukuhseti"),
        t("Gabus"),
        t("Gembong"),
        t("Gunungwungkal"),
        t("Jaken"),
        t("Jakenan"),
        t("Juwana"),
        t("Kayen"),
        t("Margorejo"),
        t("Margoyoso"),
        t("Pati"),
        t("Pucakwangi"),
        t("Sukolilo"),
        t("Tambakromo"),
        t("Tayu"),
        t("Tlogowungu"),
        t("Trangkil"),
        t("Wedarijaksa"),
        t("Winong"),
      )),
      "Pekalongan (Kabupaten)" => drupal_map_assoc(array(
        t("Bojong"),
        t("Buaran"),
        t("Doro"),
        t("Kajen"),
        t("Kandangserang"),
        t("Karanganyar"),
        t("Karangdadap"),
        t("Kedungwuni"),
        t("Kesesi"),
        t("Lebakbarang"),
        t("Paninggaran"),
        t("Petungkriono/Petungkriyono"),
        t("Siwalan"),
        t("Sragi"),
        t("Talun"),
        t("Tirto"),
        t("Wiradesa"),
        t("Wonokerto"),
        t("Wonopringgo"),
      )),
      "Pekalongan (Kota)" => drupal_map_assoc(array(
        t("Pekalongan Barat"),
        t("Pekalongan Selatan"),
        t("Pekalongan Timur"),
        t("Pekalongan Utara"),
      )),
      "Pemalang" => drupal_map_assoc(array(
        t("Ampelgading"),
        t("Bantarbolang"),
        t("Belik"),
        t("Bodeh"),
        t("Comal"),
        t("Moga"),
        t("Pemalang"),
        t("Petarukan"),
        t("Pulosari"),
        t("Randudongkal"),
        t("Taman"),
        t("Ulujami"),
        t("Warungpring"),
        t("Watukumpul"),
      )),
      "Purbalingga" => drupal_map_assoc(array(
        t("Bobotsari"),
        t("Bojongsari"),
        t("Bukateja"),
        t("Kaligondang"),
        t("Kalimanah"),
        t("Karanganyar"),
        t("Karangjambu"),
        t("Karangmoncol"),
        t("Karangreja"),
        t("Kejobong"),
        t("Kemangkon"),
        t("Kertanegara"),
        t("Kutasari"),
        t("Mrebet"),
        t("Padamara"),
        t("Pengadegan"),
        t("Purbalingga"),
        t("Rembang"),
      )),
      "Purworejo" => drupal_map_assoc(array(
        t("Bagelen"),
        t("Banyuurip"),
        t("Bayan"),
        t("Bener"),
        t("Bruno"),
        t("Butuh"),
        t("Gebang"),
        t("Grabag"),
        t("Kaligesing"),
        t("Kemiri"),
        t("Kutoarjo"),
        t("Loano"),
        t("Ngombol"),
        t("Pituruh"),
        t("Purwodadi"),
        t("Purworejo"),
      )),
      "Rembang" => drupal_map_assoc(array(
        t("Bulu"),
        t("Gunem"),
        t("Kaliori"),
        t("Kragan"),
        t("Lasem"),
        t("Pamotan"),
        t("Pancur"),
        t("Rembang"),
        t("Sale"),
        t("Sarang"),
        t("Sedan"),
        t("Sluke"),
        t("Sulang"),
        t("Sumber"),
      )),
      "Salatiga" => drupal_map_assoc(array(
        t("Argomulyo"),
        t("Sidomukti"),
        t("Sidorejo"),
        t("Tingkir"),
      )),
      "Semarang (Kabupaten)" => drupal_map_assoc(array(
        t("Ambarawa"),
        t("Bancak"),
        t("Bandungan"),
        t("Banyubiru"),
        t("Bawen"),
        t("Bergas"),
        t("Bringin"),
        t("Getasan"),
        t("Jambu"),
        t("Kaliwungu"),
        t("Pabelan"),
        t("Pringapus"),
        t("Sumowono"),
        t("Suruh"),
        t("Susukan"),
        t("Tengaran"),
        t("Tuntang"),
        t("Ungaran Barat"),
        t("Ungaran Timur"),
      )),
      "Semarang (Kota)" => drupal_map_assoc(array(
        t("Banyumanik"),
        t("Candisari"),
        t("Gajah Mungkur"),
        t("Gayamsari"),
        t("Genuk"),
        t("Gunungpati"),
        t("Mijen"),
        t("Ngaliyan"),
        t("Pedurungan"),
        t("Semarang Barat"),
        t("Semarang Selatan"),
        t("Semarang Tengah"),
        t("Semarang Timur"),
        t("Semarang Utara"),
        t("Tembalang"),
        t("Tugu"),
      )),
      "Sragen" => drupal_map_assoc(array(
        t("Gemolong"),
        t("Gesi"),
        t("Gondang"),
        t("Jenar"),
        t("Kalijambe"),
        t("Karangmalang"),
        t("Kedawung"),
        t("Masaran"),
        t("Miri"),
        t("Mondokan"),
        t("Ngrampal"),
        t("Plupuh"),
        t("Sambirejo"),
        t("Sambung Macan"),
        t("Sidoharjo"),
        t("Sragen"),
        t("Sukodono"),
        t("Sumberlawang"),
        t("Tangen"),
        t("Tanon"),
      )),
      "Sukoharjo" => drupal_map_assoc(array(
        t("Baki"),
        t("Bendosari"),
        t("Bulu"),
        t("Gatak"),
        t("Grogol"),
        t("Kartasura"),
        t("Mojolaban"),
        t("Nguter"),
        t("Polokarto"),
        t("Sukoharjo"),
        t("Tawangsari"),
        t("Weru"),
      )),
      "Surakarta (Solo)" => drupal_map_assoc(array(
        t("Banjarsari"),
        t("Jebres"),
        t("Laweyan"),
        t("Pasar Kliwon"),
        t("Serengan"),
      )),
      "Tegal (Kabupaten)" => drupal_map_assoc(array(
        t("Adiwerna"),
        t("Balapulang"),
        t("Bojong"),
        t("Bumijawa"),
        t("Dukuhturi"),
        t("Dukuhwaru"),
        t("Jatinegara"),
        t("Kedung Banteng"),
        t("Kramat"),
        t("Lebaksiu"),
        t("Margasari"),
        t("Pagerbarang"),
        t("Pangkah"),
        t("Slawi"),
        t("Surodadi"),
        t("Talang"),
        t("Tarub"),
        t("Warurejo"),
      )),
      "Tegal (Kota)" => drupal_map_assoc(array(
        t("Margadana"),
        t("Tegal Barat"),
        t("Tegal Selatan"),
        t("Tegal Timur"),
      )),
      "Temanggung" => drupal_map_assoc(array(
        t("Bansari"),
        t("Bejen"),
        t("Bulu"),
        t("Candiroto"),
        t("Gemawang"),
        t("Jumo"),
        t("Kaloran"),
        t("Kandangan"),
        t("Kedu"),
        t("Kledung"),
        t("Kranggan"),
        t("Ngadirejo"),
        t("Parakan"),
        t("Pringsurat"),
        t("Selopampang"),
        t("Temanggung"),
        t("Tembarak"),
        t("Tlogomulyo"),
        t("Tretep"),
        t("Wonoboyo"),
      )),
      "Wonogiri" => drupal_map_assoc(array(
        t("Baturetno"),
        t("Batuwarno"),
        t("Bulukerto"),
        t("Eromoko"),
        t("Girimarto"),
        t("Giritontro"),
        t("Giriwoyo"),
        t("Jatipurno"),
        t("Jatiroto"),
        t("Jatisrono"),
        t("Karangtengah"),
        t("Kismantoro"),
        t("Manyaran"),
        t("Ngadirojo"),
        t("Nguntoronadi"),
        t("Paranggupito"),
        t("Pracimantoro"),
        t("Puhpelem"),
        t("Purwantoro"),
        t("Selogiri"),
        t("Sidoharjo"),
        t("Slogohimo"),
        t("Tirtomoyo"),
        t("Wonogiri"),
        t("Wuryantoro"),
      )),
      "Wonosobo" => drupal_map_assoc(array(
        t("Garung"),
        t("Kalibawang"),
        t("Kalikajar"),
        t("Kaliwiro"),
        t("Kejajar"),
        t("Kepil"),
        t("Kertek"),
        t("Leksono"),
        t("Mojotengah"),
        t("Sapuran"),
        t("Selomerto"),
        t("Sukoharjo"),
        t("Wadaslintang"),
        t("Watumalang"),
        t("Wonosobo"),
      )),
    ),
    "Jawa Timur" => array(
      "Bangkalan" => drupal_map_assoc(array(
        t("Arosbaya"),
        t("Bangkalan"),
        t("Blega"),
        t("Burneh"),
        t("Galis"),
        t("Geger"),
        t("Kamal"),
        t("Klampis"),
        t("Kokop"),
        t("Konang"),
        t("Kwanyar"),
        t("Labang"),
        t("Modung"),
        t("Sepulu"),
        t("Socah"),
        t("Tanah Merah"),
        t("Tanjungbumi"),
        t("Tragah"),
      )),
      "Banyuwangi" => drupal_map_assoc(array(
        t("Bangorejo"),
        t("Banyuwangi"),
        t("Cluring"),
        t("Gambiran"),
        t("Genteng"),
        t("Giri"),
        t("Glagah"),
        t("Glenmore"),
        t("Kabat"),
        t("Kalibaru"),
        t("Kalipuro"),
        t("Licin"),
        t("Muncar"),
        t("Pesanggaran"),
        t("Purwoharjo"),
        t("Rogojampi"),
        t("Sempu"),
        t("Siliragung"),
        t("Singojuruh"),
        t("Songgon"),
        t("Srono"),
        t("Tegaldlimo"),
        t("Tegalsari"),
        t("Wongsorejo"),
      )),
      "Batu" => drupal_map_assoc(array(
        t("Batu"),
        t("Bumiaji"),
        t("Junrejo"),
      )),
      "Blitar (Kabupaten)" => drupal_map_assoc(array(
        t("Bakung"),
        t("Binangun"),
        t("Doko"),
        t("Gandusari"),
        t("Garum"),
        t("Kademangan"),
        t("Kanigoro"),
        t("Kesamben"),
        t("Nglegok"),
        t("Panggungrejo"),
        t("Ponggok"),
        t("Sanan Kulon"),
        t("Selopuro"),
        t("Selorejo"),
        t("Srengat"),
        t("Sutojayan"),
        t("Talun"),
        t("Udanawu"),
        t("Wates"),
        t("Wlingi"),
        t("Wonodadi"),
        t("Wonotirto"),
      )),
      "Blitar (Kota)" => drupal_map_assoc(array(
        t("Kepanjen Kidul"),
        t("Sanan Wetan"),
        t("Sukorejo"),
      )),
      "Bojonegoro" => drupal_map_assoc(array(
        t("Balen"),
        t("Baureno"),
        t("Bojonegoro"),
        t("Bubulan"),
        t("Dander"),
        t("Gayam"),
        t("Gondang"),
        t("Kalitidu"),
        t("Kanor"),
        t("Kapas"),
        t("Kasiman"),
        t("Kedewan"),
        t("Kedungadem"),
        t("Kepoh Baru"),
        t("Malo"),
        t("Margomulyo"),
        t("Ngambon"),
        t("Ngasem"),
        t("Ngraho"),
        t("Padangan"),
        t("Purwosari"),
        t("Sekar"),
        t("Sugihwaras"),
        t("Sukosewu"),
        t("Sumberrejo"),
        t("Tambakrejo"),
        t("Temayang"),
        t("Trucuk"),
      )),
      "Bondowoso" => drupal_map_assoc(array(
        t("Binakal"),
        t("Bondowoso"),
        t("Botolinggo"),
        t("Cermee"),
        t("Curahdami"),
        t("Grujugan"),
        t("Jambe Sari Darus Sholah"),
        t("Klabang"),
        t("Maesan"),
        t("Pakem"),
        t("Prajekan"),
        t("Pujer"),
        t("Sempol"),
        t("Sukosari"),
        t("Sumber Wringin"),
        t("Taman Krocok"),
        t("Tamanan"),
        t("Tapen"),
        t("Tegalampel"),
        t("Tenggarang"),
        t("Tlogosari"),
        t("Wonosari"),
        t("Wringin"),
      )),
      "Gresik" => drupal_map_assoc(array(
        t("Balong Panggang"),
        t("Benjeng"),
        t("Bungah"),
        t("Cerme"),
        t("Driyorejo"),
        t("Duduk Sampeyan"),
        t("Dukun"),
        t("Gresik"),
        t("Kebomas"),
        t("Kedamean"),
        t("Manyar"),
        t("Menganti"),
        t("Panceng"),
        t("Sangkapura"),
        t("Sidayu"),
        t("Tambak"),
        t("Ujung Pangkah"),
        t("Wringin Anom"),
      )),
      "Jember" => drupal_map_assoc(array(
        t("Ajung"),
        t("Ambulu"),
        t("Arjasa"),
        t("Balung"),
        t("Bangsalsari"),
        t("Gumuk Mas"),
        t("Jelbuk"),
        t("Jenggawah"),
        t("Jombang"),
        t("Kalisat"),
        t("Kaliwates"),
        t("Kencong"),
        t("Ledokombo"),
        t("Mayang"),
        t("Mumbulsari"),
        t("Pakusari"),
        t("Panti"),
        t("Patrang"),
        t("Puger"),
        t("Rambipuji"),
        t("Semboro"),
        t("Silo"),
        t("Sukorambi"),
        t("Sukowono"),
        t("Sumber Baru"),
        t("Sumber Jambe"),
        t("Sumber Sari"),
        t("Tanggul"),
        t("Tempurejo"),
        t("Umbulsari"),
        t("Wuluhan"),
      )),
      "Jombang" => drupal_map_assoc(array(
        t("Bandar Kedung Mulyo"),
        t("Bareng"),
        t("Diwek"),
        t("Gudo"),
        t("Jogoroto"),
        t("Jombang"),
        t("Kabuh"),
        t("Kesamben"),
        t("Kudu"),
        t("Megaluh"),
        t("Mojoagung"),
        t("Mojowarno"),
        t("Ngoro"),
        t("Ngusikan"),
        t("Perak"),
        t("Peterongan"),
        t("Plandaan"),
        t("Ploso"),
        t("Sumobito"),
        t("Tembelang"),
        t("Wonosalam"),
      )),
      "Kediri (Kabupaten)" => drupal_map_assoc(array(
        t("Badas"),
        t("Banyakan"),
        t("Gampengrejo"),
        t("Grogol"),
        t("Gurah"),
        t("Kandangan"),
        t("Kandat"),
        t("Kayen Kidul"),
        t("Kepung"),
        t("Kras"),
        t("Kunjang"),
        t("Mojo"),
        t("Ngadiluwih"),
        t("Ngancar"),
        t("Ngasem"),
        t("Pagu"),
        t("Papar"),
        t("Pare"),
        t("Plemahan"),
        t("Plosoklaten"),
        t("Puncu"),
        t("Purwoasri"),
        t("Ringinrejo"),
        t("Semen"),
        t("Tarokan"),
        t("Wates"),
      )),
      "Kediri (Kota)" => drupal_map_assoc(array(
        t("Kediri Kota"),
        t("Mojoroto"),
        t("Pesantren"),
      )),
      "Lamongan" => drupal_map_assoc(array(
        t("Babat"),
        t("Bluluk"),
        t("Brondong"),
        t("Deket"),
        t("Glagah"),
        t("Kalitengah"),
        t("Karang Geneng"),
        t("Karangbinangun"),
        t("Kedungpring"),
        t("Kembangbahu"),
        t("Lamongan"),
        t("Laren"),
        t("Maduran"),
        t("Mantup"),
        t("Modo"),
        t("Ngimbang"),
        t("Paciran"),
        t("Pucuk"),
        t("Sambeng"),
        t("Sarirejo"),
        t("Sekaran"),
        t("Solokuro"),
        t("Sugio"),
        t("Sukodadi"),
        t("Sukorame"),
        t("Tikung"),
        t("Turi"),
      )),
      "Lumajang" => drupal_map_assoc(array(
        t("Candipuro"),
        t("Gucialit"),
        t("Jatiroto"),
        t("Kedungjajang"),
        t("Klakah"),
        t("Kunir"),
        t("Lumajang"),
        t("Padang"),
        t("Pasirian"),
        t("Pasrujambe/Pasujambe"),
        t("Pronojiwo"),
        t("Randuagung"),
        t("Ranuyoso"),
        t("Rowokangkung"),
        t("Senduro"),
        t("Sukodono"),
        t("Sumbersuko"),
        t("Tekung"),
        t("Tempeh"),
        t("Tempursari"),
        t("Yosowilangun"),
      )),
      "Madiun (Kabupaten)" => drupal_map_assoc(array(
        t("Balerejo"),
        t("Dagangan"),
        t("Dolopo"),
        t("Geger"),
        t("Gemarang"),
        t("Jiwan"),
        t("Kare"),
        t("Kebonsari"),
        t("Madiun"),
        t("Mejayan"),
        t("Pilangkenceng"),
        t("Saradan"),
        t("Sawahan"),
        t("Wonoasri"),
        t("Wungu"),
      )),
      "Madiun (Kota)" => drupal_map_assoc(array(
        t("Kartoharjo"),
        t("Manguharjo"),
        t("Taman"),
      )),
      "Magetan" => drupal_map_assoc(array(
        t("Barat"),
        t("Bendo"),
        t("Karangrejo"),
        t("Karas"),
        t("Kartoharjo (Kertoharjo)"),
        t("Kawedanan"),
        t("Lembeyan"),
        t("Magetan"),
        t("Maospati"),
        t("Ngariboyo"),
        t("Nguntoronadi"),
        t("Panekan"),
        t("Parang"),
        t("Plaosan"),
        t("Poncol"),
        t("Sidorejo"),
        t("Sukomoro"),
        t("Takeran"),
      )),
      "Malang (Kabupaten)" => drupal_map_assoc(array(
        t("Ampelgading"),
        t("Bantur"),
        t("Bululawang"),
        t("Dampit"),
        t("Dau"),
        t("Donomulyo"),
        t("Gedangan"),
        t("Gondanglegi"),
        t("Jabung"),
        t("Kalipare"),
        t("Karangploso"),
        t("Kasembon"),
        t("Kepanjen"),
        t("Kromengan"),
        t("Lawang"),
        t("Ngajung (Ngajum)"),
        t("Ngantang"),
        t("Pagak"),
        t("Pagelaran"),
        t("Pakis"),
        t("Pakisaji"),
        t("Poncokusumo"),
        t("Pujon"),
        t("Singosari"),
        t("Sumbermanjing Wetan"),
        t("Sumberpucung"),
        t("Tajinan"),
        t("Tirtoyudo"),
        t("Tumpang"),
        t("Turen"),
        t("Wagir"),
        t("Wajak"),
        t("Wonosari"),
      )),
      "Malang (Kota)" => drupal_map_assoc(array(
        t("Blimbing"),
        t("Kedungkandang"),
        t("Klojen"),
        t("Lowokwaru"),
        t("Sukun"),
      )),
      "Mojokerto (Kabupaten)" => drupal_map_assoc(array(
        t("Bangsal"),
        t("Dawar Blandong"),
        t("Dlanggu"),
        t("Gedeg"),
        t("Gondang"),
        t("Jatirejo"),
        t("Jetis"),
        t("Kemlagi"),
        t("Kutorejo"),
        t("Mojoanyar"),
        t("Mojosari"),
        t("Ngoro"),
        t("Pacet"),
        t("Pungging"),
        t("Puri"),
        t("Sooko"),
        t("Trawas"),
        t("Trowulan"),
      )),
      "Mojokerto (Kota)" => drupal_map_assoc(array(
        t("Magersari"),
        t("Prajurit Kulon"),
      )),
      "Nganjuk" => drupal_map_assoc(array(
        t("Bagor"),
        t("Baron"),
        t("Berbek"),
        t("Gondang"),
        t("Jatikalen"),
        t("Kertosono"),
        t("Lengkong"),
        t("Loceret"),
        t("Nganjuk"),
        t("Ngetos"),
        t("Ngluyu"),
        t("Ngronggot"),
        t("Pace"),
        t("Patianrowo"),
        t("Prambon"),
        t("Rejoso"),
        t("Sawahan"),
        t("Sukomoro"),
        t("Tanjunganom"),
        t("Wilangan"),
      )),
      "Ngawi" => drupal_map_assoc(array(
        t("Bringin"),
        t("Geneng"),
        t("Gerih"),
        t("Jogorogo"),
        t("Karanganyar"),
        t("Karangjati"),
        t("Kasreman"),
        t("Kedunggalar"),
        t("Kendal"),
        t("Kwadungan"),
        t("Mantingan"),
        t("Ngawi"),
        t("Ngrambe"),
        t("Padas"),
        t("Pangkur"),
        t("Paron"),
        t("Pitu"),
        t("Sine"),
        t("Widodaren"),
      )),
      "Pacitan" => drupal_map_assoc(array(
        t("Arjosari"),
        t("Bandar"),
        t("Donorojo"),
        t("Kebon Agung"),
        t("Nawangan"),
        t("Ngadirojo"),
        t("Pacitan"),
        t("Pringkuku"),
        t("Punung"),
        t("Sudimoro"),
        t("Tegalombo"),
        t("Tulakan"),
      )),
      "Pamekasan" => drupal_map_assoc(array(
        t("Batumarmar"),
        t("Galis"),
        t("Kadur"),
        t("Larangan"),
        t("Pademawu"),
        t("Pakong"),
        t("Palenga'an"),
        t("Pamekasan"),
        t("Pasean"),
        t("Pegantenan"),
        t("Proppo"),
        t("Tlanakan"),
        t("Waru"),
      )),
      "Pasuruan (Kabupaten)" => drupal_map_assoc(array(
        t("Bangil"),
        t("Beji"),
        t("Gempol"),
        t("Gondang Wetan"),
        t("Grati"),
        t("Kejayan"),
        t("Kraton"),
        t("Lekok"),
        t("Lumbang"),
        t("Nguling"),
        t("Pandaan"),
        t("Pasrepan"),
        t("Pohjentrek"),
        t("Prigen"),
        t("Purwodadi"),
        t("Purwosari"),
        t("Puspo"),
        t("Rejoso"),
        t("Rembang"),
        t("Sukorejo"),
        t("Tosari"),
        t("Tutur"),
        t("Winongan"),
        t("Wonorejo"),
      )),
      "Pasuruan (Kota)" => drupal_map_assoc(array(
        t("Bugul Kidul"),
        t("Gadingrejo"),
        t("Panggungrejo"),
        t("Purworejo"),
      )),
      "Ponorogo" => drupal_map_assoc(array(
        t("Babadan"),
        t("Badegan"),
        t("Balong"),
        t("Bungkal"),
        t("Jambon"),
        t("Jenangan"),
        t("Jetis"),
        t("Kauman"),
        t("Mlarak"),
        t("Ngebel"),
        t("Ngrayun"),
        t("Ponorogo"),
        t("Pudak"),
        t("Pulung"),
        t("Sambit"),
        t("Sampung"),
        t("Sawoo"),
        t("Siman"),
        t("Slahung"),
        t("Sooko"),
        t("Sukorejo"),
      )),
      "Probolinggo (Kabupaten)" => drupal_map_assoc(array(
        t("Bantaran"),
        t("Banyu Anyar"),
        t("Besuk"),
        t("Dringu"),
        t("Gading"),
        t("Gending"),
        t("Kota Anyar"),
        t("Kraksaan"),
        t("Krejengan"),
        t("Krucil"),
        t("Kuripan"),
        t("Leces"),
        t("Lumbang"),
        t("Maron"),
        t("Paiton"),
        t("Pajarakan"),
        t("Pakuniran"),
        t("Sukapura"),
        t("Sumber"),
        t("Sumberasih"),
        t("Tegal Siwalan"),
        t("Tiris"),
        t("Tongas"),
        t("Wonomerto"),
      )),
      "Probolinggo (Kota)" => drupal_map_assoc(array(
        t("Kademangan"),
        t("Kanigaran"),
        t("Kedopok (Kedopak)"),
        t("Mayangan"),
        t("Wonoasih"),
      )),
      "Sampang" => drupal_map_assoc(array(
        t("Banyuates"),
        t("Camplong"),
        t("Jrengik"),
        t("Karang Penang"),
        t("Kedungdung"),
        t("Ketapang"),
        t("Omben"),
        t("Pangarengan"),
        t("Robatal"),
        t("Sampang"),
        t("Sokobanah"),
        t("Sreseh"),
        t("Tambelangan"),
        t("Torjun"),
      )),
      "Sidoarjo" => drupal_map_assoc(array(
        t("Balongbendo"),
        t("Buduran"),
        t("Candi"),
        t("Gedangan"),
        t("Jabon"),
        t("Krembung"),
        t("Krian"),
        t("Porong"),
        t("Prambon"),
        t("Sedati"),
        t("Sidoarjo"),
        t("Sukodono"),
        t("Taman"),
        t("Tanggulangin"),
        t("Tarik"),
        t("Tulangan"),
        t("Waru"),
        t("Wonoayu"),
      )),
      "Situbondo" => drupal_map_assoc(array(
        t("Arjasa"),
        t("Asembagus"),
        t("Banyuglugur"),
        t("Banyuputih"),
        t("Besuki"),
        t("Bungatan"),
        t("Jangkar"),
        t("Jatibanteng"),
        t("Kapongan"),
        t("Kendit"),
        t("Mangaran"),
        t("Mlandingan"),
        t("Panarukan"),
        t("Panji"),
        t("Situbondo"),
        t("Suboh"),
        t("Sumbermalang"),
      )),
      "Sumenep" => drupal_map_assoc(array(
        t("Ambunten"),
        t("Arjasa"),
        t("Batang Batang"),
        t("Batuan"),
        t("Batuputih"),
        t("Bluto"),
        t("Dasuk"),
        t("Dungkek"),
        t("Ganding"),
        t("Gapura"),
        t("Gayam"),
        t("Gili Ginting (Giligenteng)"),
        t("Guluk Guluk"),
        t("Kalianget"),
        t("Kangayan"),
        t("Kota Sumenep"),
        t("Lenteng"),
        t("Manding"),
        t("Masalembu"),
        t("Nonggunong"),
        t("Pasongsongan"),
        t("Pragaan"),
        t("Ra'as (Raas)"),
        t("Rubaru"),
        t("Sapeken"),
        t("Saronggi"),
        t("Talango"),
      )),
      "Surabaya" => drupal_map_assoc(array(
        t("Asemrowo"),
        t("Benowo"),
        t("Bubutan"),
        t("Bulak"),
        t("Dukuh Pakis"),
        t("Gayungan"),
        t("Genteng"),
        t("Gubeng"),
        t("Gununganyar"),
        t("Jambangan"),
        t("Karangpilang"),
        t("Kenjeran"),
        t("Krembangan"),
        t("Lakar Santri"),
        t("Mulyorejo"),
        t("Pabean Cantikan"),
        t("Pakal"),
        t("Rungkut"),
        t("Sambikerep"),
        t("Sawahan"),
        t("Semampir"),
        t("Simokerto"),
        t("Sukolilo"),
        t("Sukomanunggal"),
        t("Tambaksari"),
        t("Tandes"),
        t("Tegalsari"),
        t("Tenggilis Mejoyo"),
        t("Wiyung"),
        t("Wonocolo"),
        t("Wonokromo"),
      )),
      "Trenggalek" => drupal_map_assoc(array(
        t("Bendungan"),
        t("Dongko"),
        t("Durenan"),
        t("Gandusari"),
        t("Kampak"),
        t("Karangan"),
        t("Munjungan"),
        t("Panggul"),
        t("Pogalan"),
        t("Pule"),
        t("Suruh"),
        t("Trenggalek"),
        t("Tugu"),
        t("Watulimo"),
      )),
      "Tuban" => drupal_map_assoc(array(
        t("Bancar"),
        t("Bangilan"),
        t("Grabagan"),
        t("Jatirogo"),
        t("Jenu"),
        t("Kenduruan"),
        t("Kerek"),
        t("Merakurak"),
        t("Montong"),
        t("Palang"),
        t("Parengan"),
        t("Plumpang"),
        t("Rengel"),
        t("Semanding"),
        t("Senori"),
        t("Singgahan"),
        t("Soko"),
        t("Tambakboyo"),
        t("Tuban"),
        t("Widang"),
      )),
      "Tulungagung" => drupal_map_assoc(array(
        t("Bandung"),
        t("Besuki"),
        t("Boyolangu"),
        t("Campur Darat"),
        t("Gondang"),
        t("Kalidawir"),
        t("Karang Rejo"),
        t("Kauman"),
        t("Kedungwaru"),
        t("Ngantru"),
        t("Ngunut"),
        t("Pagerwojo"),
        t("Pakel"),
        t("Pucanglaban"),
        t("Rejotangan"),
        t("Sendang"),
        t("Sumbergempol"),
        t("Tanggung Gunung"),
        t("Tulungagung"),
      )),
    ),
    "Kalimantan Barat" => array(
      "Bengkayang" => drupal_map_assoc(array(
        t("Bengkayang"),
        t("Capkala"),
        t("Jagoi Babang"),
        t("Ledo"),
        t("Lembah Bawang"),
        t("Lumar"),
        t("Monterado"),
        t("Samalantan"),
        t("Sanggau Ledo"),
        t("Seluas"),
        t("Siding"),
        t("Sungai Betung"),
        t("Sungai Raya"),
        t("Sungai Raya Kepulauan"),
        t("Suti Semarang"),
        t("Teriak"),
        t("Tujuh Belas"),
      )),
      "Kapuas Hulu" => drupal_map_assoc(array(
        t("Badau"),
        t("Batang Lupar"),
        t("Bika"),
        t("Boyan Tanjung"),
        t("Bunut Hilir"),
        t("Bunut Hulu"),
        t("Embaloh Hilir"),
        t("Embaloh Hulu"),
        t("Empanang"),
        t("Hulu Gurung"),
        t("Jongkong (Jengkong)"),
        t("Kalis"),
        t("Mentebah"),
        t("Pengkadan (Batu Datu)"),
        t("Puring Kencana"),
        t("Putussibau Selatan"),
        t("Putussibau Utara"),
        t("Seberuang"),
        t("Selimbau"),
        t("Semitau"),
        t("Silat Hilir"),
        t("Silat Hulu"),
        t("Suhaid"),
      )),
      "Kayong Utara" => drupal_map_assoc(array(
        t("Kepulauan Karimata"),
        t("Pulau Maya (Pulau Maya Karimata)"),
        t("Seponti"),
        t("Simpang Hilir"),
        t("Sukadana"),
        t("Teluk Batang"),
      )),
      "Ketapang" => drupal_map_assoc(array(
        t("Air Upas"),
        t("Benua Kayong"),
        t("Delta Pawan"),
        t("Hulu Sungai"),
        t("Jelai Hulu"),
        t("Kendawangan"),
        t("Manis Mata"),
        t("Marau"),
        t("Matan Hilir Selatan"),
        t("Matan Hilir Utara"),
        t("Muara Pawan"),
        t("Nanga Tayap"),
        t("Pemahan"),
        t("Sandai"),
        t("Simpang Dua"),
        t("Simpang Hulu"),
        t("Singkup"),
        t("Sungai Laur"),
        t("Sungai Melayu Rayak"),
        t("Tumbang Titi"),
      )),
      "Kubu Raya" => drupal_map_assoc(array(
        t("Batu Ampar"),
        t("Kuala Mandor-B"),
        t("Kubu"),
        t("Rasau Jaya"),
        t("Sei/Sungai Ambawang"),
        t("Sei/Sungai Kakap"),
        t("Sei/Sungai Raya"),
        t("Teluk/Telok Pakedai"),
        t("Terentang"),
      )),
      "Landak" => drupal_map_assoc(array(
        t("Air Besar"),
        t("Banyuke Hulu"),
        t("Jelimpo"),
        t("Kuala Behe"),
        t("Mandor"),
        t("Mempawah Hulu"),
        t("Menjalin"),
        t("Menyuke"),
        t("Meranti"),
        t("Ngabang"),
        t("Sebangki"),
        t("Sengah Temila"),
        t("Sompak"),
      )),
      "Melawi" => drupal_map_assoc(array(
        t("Belimbing"),
        t("Belimbing Hulu"),
        t("Ella Hilir"),
        t("Menukung"),
        t("Nanga Pinoh"),
        t("Pinoh Selatan"),
        t("Pinoh Utara"),
        t("Sayan"),
        t("Sokan"),
        t("Tanah Pinoh"),
        t("Tanah Pinoh Barat"),
      )),
      "Pontianak (Kabupaten)" => drupal_map_assoc(array(
        t("Anjongan"),
        t("Mempawah Hilir"),
        t("Mempawah Timur"),
        t("Sadaniang"),
        t("Segedong"),
        t("Sei/Sungai Kunyit"),
        t("Sei/Sungai Pinyuh"),
        t("Siantan"),
        t("Toho"),
      )),
      "Pontianak (Kota)" => drupal_map_assoc(array(
        t("Pontianak Barat"),
        t("Pontianak Kota"),
        t("Pontianak Selatan"),
        t("Pontianak Tenggara"),
        t("Pontianak Timur"),
        t("Pontianak Utara"),
      )),
      "Sambas" => drupal_map_assoc(array(
        t("Galing"),
        t("Jawai"),
        t("Jawai Selatan"),
        t("Paloh"),
        t("Pemangkat"),
        t("Sajad"),
        t("Sajingan Besar"),
        t("Salatiga"),
        t("Sambas"),
        t("Sebawi"),
        t("Sejangkung"),
        t("Selakau"),
        t("Selakau Timur"),
        t("Semparuk"),
        t("Subah"),
        t("Tangaran"),
        t("Tebas"),
        t("Tekarang"),
        t("Teluk Keramat"),
      )),
      "Sanggau" => drupal_map_assoc(array(
        t("Balai"),
        t("Beduai (Beduwai)"),
        t("Bonti"),
        t("Entikong"),
        t("Jangkang"),
        t("Kapuas (Sanggau Kapuas)"),
        t("Kembayan"),
        t("Meliau"),
        t("Mukok"),
        t("Noyan"),
        t("Parindu"),
        t("Sekayam"),
        t("Tayan Hilir"),
        t("Tayan Hulu"),
        t("Toba"),
      )),
      "Sekadau" => drupal_map_assoc(array(
        t("Belitang"),
        t("Belitang Hilir"),
        t("Belitang Hulu"),
        t("Nanga Mahap"),
        t("Nanga Taman"),
        t("Sekadau Hilir"),
        t("Sekadau Hulu"),
      )),
      "Singkawang" => drupal_map_assoc(array(
        t("Singkawang Barat"),
        t("Singkawang Selatan"),
        t("Singkawang Tengah"),
        t("Singkawang Timur"),
        t("Singkawang Utara"),
      )),
      "Sintang" => drupal_map_assoc(array(
        t("Ambalau"),
        t("Binjai Hulu"),
        t("Dedai"),
        t("Kayan Hilir"),
        t("Kayan Hulu"),
        t("Kelam Permai"),
        t("Ketungau Hilir"),
        t("Ketungau Hulu"),
        t("Ketungau Tengah"),
        t("Sepauk"),
        t("Serawai (Nanga Serawai)"),
        t("Sintang"),
        t("Sungai Tebelian"),
        t("Tempunak"),
      )),
    ),
    "Kalimantan Selatan" => array(
      "Balangan" => drupal_map_assoc(array(
        t("Awayan"),
        t("Batu Mandi"),
        t("Halong"),
        t("Juai"),
        t("Lampihong"),
        t("Paringin"),
        t("Paringin Selatan"),
        t("Tebing Tinggi"),
      )),
      "Banjar (Kabupaten)" => drupal_map_assoc(array(
        t("Aluh-Aluh"),
        t("Aranio"),
        t("Astambul"),
        t("Beruntung Baru"),
        t("Gambut"),
        t("Karang Intan"),
        t("Kertak Hanyar"),
        t("Martapura Barat"),
        t("Martapura Kota"),
        t("Martapura Timur"),
        t("Mataraman"),
        t("Pengaron"),
        t("Peramasan"),
        t("Sambung Makmur"),
        t("Sei/Sungai Pinang"),
        t("Sei/Sungai Tabuk"),
        t("Simpang Empat"),
        t("Tatah Makmur"),
        t("Telaga Bauntung"),
      )),
      "Banjarbaru" => drupal_map_assoc(array(
        t("Banjar Baru Selatan"),
        t("Banjar Baru Utara"),
        t("Cempaka"),
        t("Landasan Ulin"),
        t("Liang Anggang"),
      )),
      "Banjarmasin" => drupal_map_assoc(array(
        t("Banjarmasin Barat"),
        t("Banjarmasin Selatan"),
        t("Banjarmasin Tengah"),
        t("Banjarmasin Timur"),
        t("Banjarmasin Utara"),
      )),
      "Barito Kuala" => drupal_map_assoc(array(
        t("Alalak"),
        t("Anjir Muara"),
        t("Anjir Pasar"),
        t("Bakumpai"),
        t("Barambai"),
        t("Belawang"),
        t("Cerbon"),
        t("Jejangkit"),
        t("Kuripan"),
        t("Mandastana"),
        t("Marabahan"),
        t("Mekar Sari"),
        t("Rantau Badauh"),
        t("Tabukan"),
        t("Tabunganen"),
        t("Tamban"),
        t("Wanaraya"),
      )),
      "Hulu Sungai Selatan" => drupal_map_assoc(array(
        t("Angkinang"),
        t("Daha Barat"),
        t("Daha Selatan"),
        t("Daha Utara"),
        t("Kalumpang (Kelumpang)"),
        t("Kandangan"),
        t("Loksado"),
        t("Padang Batung"),
        t("Simpur"),
        t("Sungai Raya"),
        t("Telaga Langsat"),
      )),
      "Hulu Sungai Tengah" => drupal_map_assoc(array(
        t("Barabai"),
        t("Batang Alai Selatan"),
        t("Batang Alai Timur"),
        t("Batang Alai Utara"),
        t("Batu Benawa"),
        t("Hantakan"),
        t("Haruyan"),
        t("Labuan Amas Selatan"),
        t("Labuan Amas Utara"),
        t("Limpasu"),
        t("Pandawan"),
      )),
      "Hulu Sungai Utara" => drupal_map_assoc(array(
        t("Amuntai Selatan"),
        t("Amuntai Tengah"),
        t("Amuntai Utara"),
        t("Babirik"),
        t("Banjang"),
        t("Danau Panggang"),
        t("Haur Gading"),
        t("Paminggir"),
        t("Sungai Pandan"),
        t("Sungai Tabukan"),
      )),
      "Kotabaru" => drupal_map_assoc(array(
        t("Hampang"),
        t("Kelumpang Barat"),
        t("Kelumpang Hilir"),
        t("Kelumpang Hulu"),
        t("Kelumpang Selatan"),
        t("Kelumpang Tengah"),
        t("Kelumpang Utara"),
        t("Pamukan Barat"),
        t("Pamukan Selatan"),
        t("Pamukan Utara"),
        t("Pulau Laut Barat"),
        t("Pulau Laut Kepulauan"),
        t("Pulau Laut Selatan"),
        t("Pulau Laut Tanjung Selayar"),
        t("Pulau Laut Tengah"),
        t("Pulau Laut Timur"),
        t("Pulau Laut Utara"),
        t("Pulau Sebuku"),
        t("Pulau Sembilan"),
        t("Sampanahan"),
        t("Sungai Durian"),
      )),
      "Tabalong" => drupal_map_assoc(array(
        t("Banua Lawas"),
        t("Bintang Ara"),
        t("Haruai"),
        t("Jaro"),
        t("Kelua (Klua)"),
        t("Muara Harus"),
        t("Muara Uya"),
        t("Murung Pudak"),
        t("Pugaan"),
        t("Tanjung"),
        t("Tanta"),
        t("Upau"),
      )),
      "Tanah Bumbu" => drupal_map_assoc(array(
        t("Angsana"),
        t("Batulicin"),
        t("Karang Bintang"),
        t("Kuranji"),
        t("Kusan Hilir"),
        t("Kusan Hulu"),
        t("Mantewe"),
        t("Satui"),
        t("Simpang Empat"),
        t("Sungai Loban"),
      )),
      "Tanah Laut" => drupal_map_assoc(array(
        t("Bajuin"),
        t("Bati-Bati"),
        t("Batu Ampar"),
        t("Bumi Makmur"),
        t("Jorong"),
        t("Kintap"),
        t("Kurau"),
        t("Panyipatan"),
        t("Pelaihari"),
        t("Takisung"),
        t("Tambang Ulang"),
      )),
      "Tapin" => drupal_map_assoc(array(
        t("Bakarangan"),
        t("Binuang"),
        t("Bungur"),
        t("Candi Laras Selatan"),
        t("Candi Laras Utara"),
        t("Hatungun"),
        t("Lokpaikat"),
        t("Piani"),
        t("Salam Babaris"),
        t("Tapin Selatan"),
        t("Tapin Tengah"),
        t("Tapin Utara"),
      )),
    ),
    "Kalimantan Tengah" => array(
      "Barito Selatan" => drupal_map_assoc(array(
        t("Dusun Hilir"),
        t("Dusun Selatan"),
        t("Dusun Utara"),
        t("Gunung Bintang Awai"),
        t("Jenamas"),
        t("Karau Kuala"),
      )),
      "Barito Timur" => drupal_map_assoc(array(
        t("Awang"),
        t("Benua Lima"),
        t("Dusun Tengah"),
        t("Dusun Timur"),
        t("Karusen Janang"),
        t("Paju Epat"),
        t("Paku"),
        t("Patangkep Tutui"),
        t("Pematang Karau"),
        t("Raren Batuah"),
      )),
      "Barito Utara" => drupal_map_assoc(array(
        t("Gunung Purei"),
        t("Gunung Timang"),
        t("Lahei"),
        t("Lahei Barat"),
        t("Montallat (Montalat)"),
        t("Teweh Baru"),
        t("Teweh Selatan"),
        t("Teweh Tengah"),
        t("Teweh Timur"),
      )),
      "Gunung Mas" => drupal_map_assoc(array(
        t("Damang Batu"),
        t("Kahayan Hulu Utara"),
        t("Kurun"),
        t("Manuhing"),
        t("Manuhing Raya"),
        t("Mihing Raya"),
        t("Miri Manasa"),
        t("Rungan"),
        t("Rungan Barat"),
        t("Rungan Hulu"),
        t("Sepang (Sepang Simin)"),
        t("Tewah"),
      )),
      "Kapuas" => drupal_map_assoc(array(
        t("Basarang"),
        t("Bataguh"),
        t("Dadahup"),
        t("Kapuas Barat"),
        t("Kapuas Hilir"),
        t("Kapuas Hulu"),
        t("Kapuas Kuala"),
        t("Kapuas Murung"),
        t("Kapuas Tengah"),
        t("Kapuas Timur"),
        t("Mandau Talawang"),
        t("Mantangai"),
        t("Pasak Talawang"),
        t("Pulau Petak"),
        t("Selat"),
        t("Tamban Catur"),
        t("Timpah"),
      )),
      "Katingan" => drupal_map_assoc(array(
        t("Bukit Raya"),
        t("Kamipang"),
        t("Katingan Hilir"),
        t("Katingan Hulu"),
        t("Katingan Kuala"),
        t("Katingan Tengah"),
        t("Marikit"),
        t("Mendawai"),
        t("Petak Malai"),
        t("Pulau Malan"),
        t("Sanaman Mantikei (Senamang Mantikei)"),
        t("Tasik Payawan"),
        t("Tewang Sanggalang Garing (Sangalang)"),
      )),
      "Kotawaringin Barat" => drupal_map_assoc(array(
        t("Arut Selatan"),
        t("Arut Utara"),
        t("Kotawaringin Lama"),
        t("Kumai"),
        t("Pangkalan Banteng"),
        t("Pangkalan Lada"),
      )),
      "Kotawaringin Timur" => drupal_map_assoc(array(
        t("Antang Kalang"),
        t("Baamang"),
        t("Bukit Santuei"),
        t("Cempaga"),
        t("Cempaga Hulu"),
        t("Kota Besi"),
        t("Mentawa Baru (Ketapang)"),
        t("Mentaya Hilir Selatan"),
        t("Mentaya Hilir Utara"),
        t("Mentaya Hulu"),
        t("Parenggean"),
        t("Pulau Hanaut"),
        t("Seranau"),
        t("Telaga Antang"),
        t("Telawang"),
        t("Teluk Sampit"),
        t("Tualan Hulu"),
      )),
      "Lamandau" => drupal_map_assoc(array(
        t("Batangkawa"),
        t("Belantikan Raya"),
        t("Bulik"),
        t("Bulik Timur"),
        t("Delang"),
        t("Lamandau"),
        t("Menthobi Raya"),
        t("Sematu Jaya"),
      )),
      "Murung Raya" => drupal_map_assoc(array(
        t("Barito Tuhup Raya"),
        t("Laung Tuhup"),
        t("Murung"),
        t("Permata Intan"),
        t("Seribu Riam"),
        t("Sumber Barito"),
        t("Sungai Babuat"),
        t("Tanah Siang"),
        t("Tanah Siang Selatan"),
        t("Uut Murung"),
      )),
      "Palangka Raya" => drupal_map_assoc(array(
        t("Bukit Batu"),
        t("Jekan Raya"),
        t("Pahandut"),
        t("Rakumpit"),
        t("Sebangau"),
      )),
      "Pulang Pisau" => drupal_map_assoc(array(
        t("Banama Tingang"),
        t("Jabiren Raya"),
        t("Kahayan Hilir"),
        t("Kahayan Kuala"),
        t("Kahayan Tengah"),
        t("Maliku"),
        t("Pandih Batu"),
        t("Sebangau Kuala"),
      )),
      "Seruyan" => drupal_map_assoc(array(
        t("Batu Ampar"),
        t("Danau Seluluk"),
        t("Danau Sembuluh"),
        t("Hanau"),
        t("Seruyan Hilir"),
        t("Seruyan Hilir Timur"),
        t("Seruyan Hulu"),
        t("Seruyan Raya"),
        t("Seruyan Tengah"),
        t("Suling Tambun"),
      )),
      "Sukamara" => drupal_map_assoc(array(
        t("Balai Riam"),
        t("Jelai"),
        t("Pantai Lunci"),
        t("Permata Kecubung"),
        t("Sukamara"),
      )),
    ),
    "Kalimantan Timur" => array(
      "Balikpapan" => drupal_map_assoc(array(
        t("Balikpapan Barat"),
        t("Balikpapan Kota"),
        t("Balikpapan Selatan"),
        t("Balikpapan Tengah"),
        t("Balikpapan Timur"),
        t("Balikpapan Utara"),
      )),
      "Berau" => drupal_map_assoc(array(
        t("Batu Putih"),
        t("Biatan"),
        t("Biduk-Biduk"),
        t("Derawan (Pulau Derawan)"),
        t("Gunung Tabur"),
        t("Kelay"),
        t("Maratua"),
        t("Sambaliung"),
        t("Segah"),
        t("Tabalar"),
        t("Talisayan"),
        t("Tanjung Redeb"),
        t("Teluk Bayur"),
      )),
      "Bontang" => drupal_map_assoc(array(
        t("Bontang Barat"),
        t("Bontang Selatan"),
        t("Bontang Utara"),
      )),
      "Kutai Barat" => drupal_map_assoc(array(
        t("Barong Tongkok"),
        t("Bentian Besar"),
        t("Bongan"),
        t("Damai"),
        t("Jempang"),
        t("Laham"),
        t("Linggang Bigung"),
        t("Long Apari"),
        t("Long Bagun"),
        t("Long Hubung"),
        t("Long Iram"),
        t("Long Pahangai"),
        t("Manor Bulatin (Mook Manaar Bulatn)"),
        t("Melak"),
        t("Muara Lawa"),
        t("Muara Pahu"),
        t("Nyuatan"),
        t("Penyinggahan"),
        t("Sekolaq Darat"),
        t("Siluq Ngurai"),
        t("Tering"),
      )),
      "Kutai Kartanegara" => drupal_map_assoc(array(
        t("Anggana"),
        t("Kembang Janggut"),
        t("Kenohan"),
        t("Kota Bangun"),
        t("Loa Janan"),
        t("Loa Kulu"),
        t("Marang Kayu"),
        t("Muara Badak"),
        t("Muara Jawa"),
        t("Muara Kaman"),
        t("Muara Muntai"),
        t("Muara Wis"),
        t("Samboja (Semboja)"),
        t("Sanga-Sanga"),
        t("Sebulu"),
        t("Tabang"),
        t("Tenggarong"),
        t("Tenggarong Seberang"),
      )),
      "Kutai Timur" => drupal_map_assoc(array(
        t("Batu Ampar"),
        t("Bengalon"),
        t("Busang"),
        t("Kaliorang"),
        t("Karangan"),
        t("Kaubun"),
        t("Kongbeng"),
        t("Long Mesangat (Mesengat)"),
        t("Muara Ancalong"),
        t("Muara Bengkal"),
        t("Muara Wahau"),
        t("Rantau Pulung"),
        t("Sandaran"),
        t("Sangatta Selatan"),
        t("Sangatta Utara"),
        t("Sangkulirang"),
        t("Telen"),
        t("Teluk Pandan"),
      )),
      "Paser" => drupal_map_assoc(array(
        t("Batu Engau"),
        t("Batu Sopang"),
        t("Kuaro"),
        t("Long Ikis"),
        t("Long Kali"),
        t("Muara Komam"),
        t("Muara Samu"),
        t("Pasir Belengkong"),
        t("Tanah Grogot"),
        t("Tanjung Harapan"),
      )),
      "Penajam Paser Utara" => drupal_map_assoc(array(
        t("Babulu"),
        t("Penajam"),
        t("Sepaku"),
        t("Waru"),
      )),
      "Samarinda" => drupal_map_assoc(array(
        t("Loa Janan Ilir"),
        t("Palaran"),
        t("Samarinda Ilir"),
        t("Samarinda Kota"),
        t("Samarinda Seberang"),
        t("Samarinda Ulu"),
        t("Samarinda Utara"),
        t("Sambutan"),
        t("Sungai Kunjang"),
        t("Sungai Pinang"),
      )),
    ),
    "Kalimantan Utara" => array(
      "Bulungan (Bulongan)" => drupal_map_assoc(array(
        t("Peso"),
        t("Peso Hilir/Ilir"),
        t("Pulau Bunyu"),
        t("Sekatak"),
        t("Tanjung Palas"),
        t("Tanjung Palas Barat"),
        t("Tanjung Palas Tengah"),
        t("Tanjung Palas Timur"),
        t("Tanjung Palas Utara"),
        t("Tanjung Selor"),
      )),
      "Malinau" => drupal_map_assoc(array(
        t("Bahau Hulu"),
        t("Kayan Hilir"),
        t("Kayan Hulu"),
        t("Kayan Selatan"),
        t("Malinau Barat"),
        t("Malinau Kota"),
        t("Malinau Selatan"),
        t("Malinau Selatan Hilir"),
        t("Malinau Selatan Hulu"),
        t("Malinau Utara"),
        t("Mentarang"),
        t("Mentarang Hulu"),
        t("Pujungan"),
        t("Sungai Boh"),
        t("Sungai Tubu"),
      )),
      "Nunukan" => drupal_map_assoc(array(
        t("Krayan"),
        t("Krayan Selatan"),
        t("Lumbis"),
        t("Lumbis Ogong"),
        t("Nunukan"),
        t("Nunukan Selatan"),
        t("Sebatik"),
        t("Sebatik Barat"),
        t("Sebatik Tengah"),
        t("Sebatik Timur"),
        t("Sebatik Utara"),
        t("Sebuku"),
        t("Sei Menggaris"),
        t("Sembakung"),
        t("Tulin Onsoi"),
      )),
      "Tana Tidung" => drupal_map_assoc(array(
        t("Betayau"),
        t("Sesayap"),
        t("Sesayap Hilir"),
        t("Tana Lia (Tanah Lia)"),
      )),
      "Tarakan" => drupal_map_assoc(array(
        t("Tarakan Barat"),
        t("Tarakan Tengah"),
        t("Tarakan Timur"),
        t("Tarakan Utara"),
      )),
    ),
    "Kepulauan Riau" => array(
      "Batam" => drupal_map_assoc(array(
        t("Batam Kota"),
        t("Batu Aji"),
        t("Batu Ampar"),
        t("Belakang Padang"),
        t("Bengkong"),
        t("Bulang"),
        t("Galang"),
        t("Lubuk Baja"),
        t("Nongsa"),
        t("Sagulung"),
        t("Sei/Sungai Beduk"),
        t("Sekupang"),
      )),
      "Bintan" => drupal_map_assoc(array(
        t("Bintan Pesisir"),
        t("Bintan Timur"),
        t("Bintan Utara"),
        t("Gunung Kijang"),
        t("Mantang"),
        t("Seri/Sri Kuala Lobam"),
        t("Tambelan"),
        t("Teluk Bintan"),
        t("Teluk Sebong"),
        t("Toapaya"),
      )),
      "Karimun" => drupal_map_assoc(array(
        t("Belat"),
        t("Buru"),
        t("Durai"),
        t("Karimun"),
        t("Kundur"),
        t("Kundur Barat"),
        t("Kundur Utara"),
        t("Meral"),
        t("Meral Barat"),
        t("Moro"),
        t("Tebing"),
        t("Ungar"),
      )),
      "Kepulauan Anambas" => drupal_map_assoc(array(
        t("Jemaja"),
        t("Jemaja Timur"),
        t("Palmatak"),
        t("Siantan"),
        t("Siantan Selatan"),
        t("Siantan Tengah"),
        t("Siantan Timur"),
      )),
      "Lingga" => drupal_map_assoc(array(
        t("Lingga"),
        t("Lingga Timur"),
        t("Lingga Utara"),
        t("Selayar"),
        t("Senayang"),
        t("Singkep"),
        t("Singkep Barat"),
        t("Singkep Pesisir"),
      )),
      "Natuna" => drupal_map_assoc(array(
        t("Bunguran Barat"),
        t("Bunguran Selatan"),
        t("Bunguran Tengah"),
        t("Bunguran Timur"),
        t("Bunguran Timur Laut"),
        t("Bunguran Utara"),
        t("Midai"),
        t("Pulau Laut"),
        t("Pulau Tiga"),
        t("Serasan"),
        t("Serasan Timur"),
        t("Subi"),
      )),
      "Tanjung Pinang" => drupal_map_assoc(array(
        t("Bukit Bestari"),
        t("Tanjung Pinang Barat"),
        t("Tanjung Pinang Kota"),
        t("Tanjung Pinang Timur"),
      )),
    ),
    "Lampung" => array(
      "Bandar Lampung" => drupal_map_assoc(array(
        t("Bumi Waras"),
        t("Enggal"),
        t("Kedamaian"),
        t("Kedaton"),
        t("Kemiling"),
        t("Labuhan Ratu"),
        t("Langkapura"),
        t("Panjang"),
        t("Rajabasa"),
        t("Sukabumi"),
        t("Sukarame"),
        t("Tanjung Karang Barat"),
        t("Tanjung Karang Pusat"),
        t("Tanjung Karang Timur"),
        t("Tanjung Senang"),
        t("Telukbetung Barat"),
        t("Telukbetung Selatan"),
        t("Telukbetung Timur"),
        t("Telukbetung Utara"),
        t("Way Halim"),
      )),
      "Lampung Barat" => drupal_map_assoc(array(
        t("Air Hitam"),
        t("Balik Bukit"),
        t("Bandar Negeri Suoh"),
        t("Batu Brak"),
        t("Batu Ketulis"),
        t("Belalau"),
        t("Gedung Surian"),
        t("Kebun Tebu"),
        t("Lumbok Seminung"),
        t("Pagar Dewa"),
        t("Sekincau"),
        t("Sukau"),
        t("Sumber Jaya"),
        t("Suoh"),
        t("Way Tenong"),
      )),
      "Lampung Selatan" => drupal_map_assoc(array(
        t("Bakauheni"),
        t("Candipuro"),
        t("Jati Agung"),
        t("Kalianda"),
        t("Katibung"),
        t("Ketapang"),
        t("Merbau Mataram"),
        t("Natar"),
        t("Palas"),
        t("Penengahan"),
        t("Rajabasa"),
        t("Sidomulyo"),
        t("Sragi"),
        t("Tanjung Bintang"),
        t("Tanjung Sari"),
        t("Way Panji"),
        t("Way Sulan"),
      )),
      "Lampung Tengah" => drupal_map_assoc(array(
        t("Anak Ratu Aji"),
        t("Anak Tuha"),
        t("Bandar Mataram"),
        t("Bandar Surabaya"),
        t("Bangunrejo"),
        t("Bekri"),
        t("Bumi Nabung"),
        t("Bumi Ratu Nuban"),
        t("Gunung Sugih"),
        t("Kalirejo"),
        t("Kota Gajah"),
        t("Padang Ratu"),
        t("Pubian"),
        t("Punggur"),
        t("Putra Rumbia"),
        t("Rumbia"),
        t("Selagai Lingga"),
        t("Sendang Agung"),
        t("Seputih Agung"),
        t("Seputih Banyak"),
        t("Seputih Mataram"),
        t("Seputih Raman"),
        t("Seputih Surabaya"),
        t("Terbanggi Besar"),
        t("Terusan Nunyai"),
        t("Trimurjo"),
        t("Way Pangubuan (Pengubuan)"),
        t("Way Seputih"),
      )),
      "Lampung Timur" => drupal_map_assoc(array(
        t("Bandar Sribawono"),
        t("Batanghari"),
        t("Batanghari Nuban"),
        t("Braja Slebah"),
        t("Bumi Agung"),
        t("Gunung Pelindung"),
        t("Jabung"),
        t("Labuhan Maringgai"),
        t("Labuhan Ratu"),
        t("Marga Sekampung"),
        t("Margatiga"),
        t("Mataram Baru"),
        t("Melinting"),
        t("Metro Kibang"),
        t("Pasir Sakti"),
        t("Pekalongan"),
        t("Purbolinggo"),
        t("Raman Utara"),
        t("Sekampung"),
        t("Sekampung Udik"),
        t("Sukadana"),
        t("Waway Karya"),
        t("Way Bungur (Purbolinggo Utara)"),
        t("Way Jepara"),
      )),
      "Lampung Utara" => drupal_map_assoc(array(
        t("Abung Barat"),
        t("Abung Kunang"),
        t("Abung Pekurun"),
        t("Abung Selatan"),
        t("Abung Semuli"),
        t("Abung Surakarta"),
        t("Abung Tengah"),
        t("Abung Timur"),
        t("Abung Tinggi"),
        t("Blambangan Pagar"),
        t("Bukit Kemuning"),
        t("Bunga Mayang"),
        t("Hulu Sungkai"),
        t("Kotabumi"),
        t("Kotabumi Selatan"),
        t("Kotabumi Utara"),
        t("Muara Sungkai"),
        t("Sungkai Barat"),
        t("Sungkai Jaya"),
        t("Sungkai Selatan"),
        t("Sungkai Tengah"),
        t("Sungkai Utara"),
        t("Tanjung Raja"),
      )),
      "Mesuji" => drupal_map_assoc(array(
        t("Mesuji"),
        t("Mesuji Timur"),
        t("Panca Jaya"),
        t("Rawa Jitu Utara"),
        t("Simpang Pematang"),
        t("Tanjung Raya"),
        t("Way Serdang"),
      )),
      "Metro" => drupal_map_assoc(array(
        t("Metro Barat"),
        t("Metro Pusat"),
        t("Metro Selatan"),
        t("Metro Timur"),
        t("Metro Utara"),
      )),
      "Pesawaran" => drupal_map_assoc(array(
        t("Gedong Tataan (Gedung Tataan)"),
        t("Kedondong"),
        t("Marga Punduh"),
        t("Negeri Katon"),
        t("Padang Cermin"),
        t("Punduh Pidada (Pedada)"),
        t("Tegineneng"),
        t("Way Khilau"),
        t("Way Lima"),
      )),
      "Pesisir Barat" => drupal_map_assoc(array(
        t("Bengkunat"),
        t("Bengkunat Belimbing"),
        t("Karya Penggawa"),
        t("Krui Selatan"),
        t("Lemong"),
        t("Ngambur"),
        t("Pesisir Selatan"),
        t("Pesisir Tengah"),
        t("Pesisir Utara"),
        t("Pulau Pisang"),
        t("Way Krui"),
      )),
      "Pringsewu" => drupal_map_assoc(array(
        t("Adi Luwih"),
        t("Ambarawa"),
        t("Banyumas"),
        t("Gading Rejo"),
        t("Pagelaran"),
        t("Pagelaran Utara"),
        t("Pardasuka"),
        t("Pringsewu"),
        t("Sukoharjo"),
      )),
      "Tanggamus" => drupal_map_assoc(array(
        t("Air Naningan"),
        t("Bandar Negeri Semuong"),
        t("Bulok"),
        t("Cukuh Balak"),
        t("Gisting"),
        t("Gunung Alip"),
        t("Kelumbayan"),
        t("Kelumbayan Barat"),
        t("Kota Agung (Kota Agung Pusat)"),
        t("Kota Agung Barat"),
        t("Kota Agung Timur"),
        t("Limau"),
        t("Pematang Sawa"),
        t("Pugung"),
        t("Pulau Panggung"),
        t("Semaka"),
        t("Sumberejo"),
        t("Talang Padang"),
        t("Ulubelu"),
        t("Wonosobo"),
      )),
      "Tulang Bawang" => drupal_map_assoc(array(
        t("Banjar Agung"),
        t("Banjar Baru"),
        t("Banjar Margo"),
        t("Dente Teladas"),
        t("Gedung Aji"),
        t("Gedung Aji Baru"),
        t("Gedung Meneng"),
        t("Menggala"),
        t("Menggala Timur"),
        t("Meraksa Aji"),
        t("Penawar Aji"),
        t("Penawar Tama"),
        t("Rawa Pitu"),
        t("Rawajitu Selatan"),
        t("Rawajitu Timur"),
      )),
      "Tulang Bawang Barat" => drupal_map_assoc(array(
        t("Gunung Agung"),
        t("Gunung Terang"),
        t("Lambu Kibang"),
        t("Pagar Dewa"),
        t("Tulang Bawang Tengah"),
        t("Tulang Bawang Udik"),
        t("Tumijajar"),
        t("Way Kenanga"),
      )),
      "Way Kanan" => drupal_map_assoc(array(
        t("Bahuga"),
        t("Banjit"),
        t("Baradatu"),
        t("Blambangan Umpu"),
        t("Buay Bahuga"),
        t("Bumi Agung"),
        t("Gunung Labuhan"),
        t("Kasui"),
        t("Negara Batin"),
        t("Negeri Agung"),
        t("Negeri Besar"),
        t("Pakuan Ratu"),
        t("Rebang Tangkas"),
        t("Way Tuba"),
      )),
    ),
    "Maluku" => array(
      "Ambon" => drupal_map_assoc(array(
        t("Baguala"),
        t("Leitimur Selatan"),
        t("Nusaniwe (Nusanive)"),
        t("Sirimau"),
        t("Teluk Ambon"),
      )),
      "Buru" => drupal_map_assoc(array(
        t("Airbuaya"),
        t("Batabual"),
        t("Fena Leisela"),
        t("Lilialy"),
        t("Lolong Guba"),
        t("Namlea"),
        t("Teluk Kaiely"),
        t("Waeapo"),
        t("Waelata"),
        t("Waplau"),
      )),
      "Buru Selatan" => drupal_map_assoc(array(
        t("Ambalau"),
        t("Fena Fafan"),
        t("Kepala Madan"),
        t("Leksula"),
        t("Namrole"),
        t("Waesama"),
      )),
      "Kepulauan Aru" => drupal_map_assoc(array(
        t("Aru Selatan"),
        t("Aru Selatan Timur"),
        t("Aru Selatan Utara"),
        t("Aru Tengah"),
        t("Aru Tengah Selatan"),
        t("Aru Tengah Timur"),
        t("Aru Utara"),
        t("Aru Utara Timur Batuley"),
        t("Pulau-Pulau Aru"),
        t("Sir-Sir"),
      )),
      "Maluku Barat Daya" => drupal_map_assoc(array(
        t("Damer"),
        t("Dawelor Dawera"),
        t("Kepulauan Romang"),
        t("Kisar Utara"),
        t("Mdona Hyera/Hiera"),
        t("Moa Lakor"),
        t("Pulau Lakor"),
        t("Pulau Letti (Leti Moa Lakor)"),
        t("Pulau Masela"),
        t("Pulau Pulau Babar"),
        t("Pulau Pulau Terselatan"),
        t("Pulau Wetang"),
        t("Pulau-Pulau Babar Timur"),
        t("Wetar"),
        t("Wetar Barat"),
        t("Wetar Timur"),
        t("Wetar Utara"),
      )),
      "Maluku Tengah" => drupal_map_assoc(array(
        t("Amahai"),
        t("Banda"),
        t("Leihitu"),
        t("Leihitu Barat"),
        t("Masohi Kota"),
        t("Nusalaut"),
        t("Pulau Haruku"),
        t("Salahutu"),
        t("Saparua"),
        t("Saparua Timur"),
        t("Seram Utara"),
        t("Seram Utara Barat"),
        t("Seram Utara Timur Kobi"),
        t("Seram Utara Timur Seti"),
        t("Tehoru"),
        t("Teluk Elpaputih"),
        t("Telutih"),
        t("Teon Nila Serua"),
      )),
      "Maluku Tenggara" => drupal_map_assoc(array(
        t("Hoat Sorbay"),
        t("Kei Besar"),
        t("Kei Besar Selatan"),
        t("Kei Besar Selatan Barat"),
        t("Kei Besar Utara Barat"),
        t("Kei Besar Utara Timur"),
        t("Kei Kecil"),
        t("Kei Kecil Barat"),
        t("Kei Kecil Timur"),
        t("Kei Kecil Timur Selatan"),
        t("Manyeuw"),
      )),
      "Maluku Tenggara Barat" => drupal_map_assoc(array(
        t("Kormomolin"),
        t("Molu Maru"),
        t("Nirunmas"),
        t("Selaru"),
        t("Tanimbar Selatan"),
        t("Tanimbar Utara"),
        t("Wermakatian (Wer Maktian)"),
        t("Wertamrian"),
        t("Wuarlabobar"),
        t("Yaru"),
      )),
      "Seram Bagian Barat" => drupal_map_assoc(array(
        t("Amalatu"),
        t("Elpaputih"),
        t("Huamual"),
        t("Huamual Belakang (Waisala)"),
        t("Inamosol"),
        t("Kairatu"),
        t("Kairatu Barat"),
        t("Kepulauan Manipa"),
        t("Seram Barat"),
        t("Taniwel"),
        t("Taniwel Timur"),
      )),
      "Seram Bagian Timur" => drupal_map_assoc(array(
        t("Bula"),
        t("Bula Barat"),
        t("Gorom Timur"),
        t("Kian Darat"),
        t("Kilmury"),
        t("Pulau Gorong (Gorom)"),
        t("Pulau Panjang"),
        t("Seram Timur"),
        t("Siritaun Wida Timur"),
        t("Siwalalat"),
        t("Teluk Waru"),
        t("Teor"),
        t("Tutuk Tolu"),
        t("Wakate"),
        t("Werinama"),
      )),
      "Tual" => drupal_map_assoc(array(
        t("Kur Selatan"),
        t("Pulau Dullah Selatan"),
        t("Pulau Dullah Utara"),
        t("Pulau Tayando Tam"),
        t("Pulau-Pulau Kur"),
      )),
    ),
    "Maluku Utara" => array(
      "Halmahera Barat" => drupal_map_assoc(array(
        t("Ibu"),
        t("Ibu Selatan"),
        t("Ibu Utara"),
        t("Jailolo"),
        t("Jailolo Selatan"),
        t("Loloda"),
        t("Sahu"),
        t("Sahu Timur"),
      )),
      "Halmahera Selatan" => drupal_map_assoc(array(
        t("Bacan"),
        t("Bacan Barat"),
        t("Bacan Barat Utara"),
        t("Bacan Selatan"),
        t("Bacan Timur"),
        t("Bacan Timur Selatan"),
        t("Bacan Timur Tengah"),
        t("Gane Barat"),
        t("Gane Barat Selatan"),
        t("Gane Barat Utara"),
        t("Gane Timur"),
        t("Gane Timur Selatan"),
        t("Gane Timur Tengah"),
        t("Kasiruta Barat"),
        t("Kasiruta Timur"),
        t("Kayoa"),
        t("Kayoa Barat"),
        t("Kayoa Selatan"),
        t("Kayoa Utara"),
        t("Kepulauan Botanglomang"),
        t("Kepulauan Joronga"),
        t("Makian (Pulau Makian)"),
        t("Makian Barat (Pulau Makian)"),
        t("Mandioli Selatan"),
        t("Mandioli Utara"),
        t("Obi"),
        t("Obi Barat"),
        t("Obi Selatan"),
        t("Obi Timur"),
        t("Obi Utara"),
      )),
      "Halmahera Tengah" => drupal_map_assoc(array(
        t("Patani"),
        t("Patani Barat"),
        t("Patani Utara"),
        t("Pulau Gebe"),
        t("Weda"),
        t("Weda Selatan"),
        t("Weda Tengah"),
        t("Weda Utara"),
      )),
      "Halmahera Timur" => drupal_map_assoc(array(
        t("Kota Maba"),
        t("Maba"),
        t("Maba Selatan"),
        t("Maba Tengah"),
        t("Maba Utara"),
        t("Wasile"),
        t("Wasile Selatan"),
        t("Wasile Tengah"),
        t("Wasile Timur"),
        t("Wasile Utara"),
      )),
      "Halmahera Utara" => drupal_map_assoc(array(
        t("Galela"),
        t("Galela Barat"),
        t("Galela Selatan"),
        t("Galela Utara"),
        t("Kao"),
        t("Kao Barat"),
        t("Kao Teluk"),
        t("Kao Utara"),
        t("Loloda Kepulauan"),
        t("Loloda Utara"),
        t("Malifut"),
        t("Tobelo"),
        t("Tobelo Barat"),
        t("Tobelo Selatan"),
        t("Tobelo Tengah"),
        t("Tobelo Timur"),
        t("Tobelo Utara"),
      )),
      "Kepulauan Sula" => drupal_map_assoc(array(
        t("Lede"),
        t("Mangoli Barat"),
        t("Mangoli Selatan"),
        t("Mangoli Tengah"),
        t("Mangoli Timur"),
        t("Mangoli Utara"),
        t("Mangoli Utara Timur"),
        t("Sanana"),
        t("Sanana Utara"),
        t("Sulabesi Barat"),
        t("Sulabesi Selatan"),
        t("Sulabesi Tengah"),
        t("Sulabesi Timur"),
        t("Taliabu Barat"),
        t("Taliabu Barat Laut"),
        t("Taliabu Selatan"),
        t("Taliabu Timur"),
        t("Taliabu Timur Selatan"),
        t("Taliabu Utara"),
      )),
      "Pulau Morotai" => drupal_map_assoc(array(
        t("Morotai Jaya"),
        t("Morotai Selatan"),
        t("Morotai Selatan Barat"),
        t("Morotai Timur"),
        t("Morotai Utara"),
      )),
      "Ternate" => drupal_map_assoc(array(
        t("Moti (Pulau Moti)"),
        t("Pulau Batang Dua"),
        t("Pulau Hiri"),
        t("Pulau Ternate"),
        t("Ternate Selatan (Kota)"),
        t("Ternate Tengah (Kota)"),
        t("Ternate Utara (Kota)"),
      )),
      "Tidore Kepulauan" => drupal_map_assoc(array(
        t("Oba"),
        t("Oba Selatan"),
        t("Oba Tengah"),
        t("Oba Utara"),
        t("Tidore (Pulau Tidore)"),
        t("Tidore Selatan"),
        t("Tidore Timur (Pulau Tidore)"),
        t("Tidore Utara"),
      )),
    ),
    "Nanggroe Aceh Darussalam (NAD)" => array(
      "Aceh Barat" => drupal_map_assoc(array(
        t("Arongan Lambalek"),
        t("Bubon"),
        t("Johan Pahlawan"),
        t("Kaway XVI"),
        t("Meureubo"),
        t("Pante Ceureumen (Pantai Ceuremen)"),
        t("Panton Reu"),
        t("Samatiga"),
        t("Sungai Mas"),
        t("Woyla"),
        t("Woyla Barat"),
        t("Woyla Timur"),
      )),
      "Aceh Barat Daya" => drupal_map_assoc(array(
        t("Babah Rot"),
        t("Blang Pidie"),
        t("Jeumpa"),
        t("Kuala Batee"),
        t("Lembah Sabil"),
        t("Manggeng"),
        t("Setia"),
        t("Susoh"),
        t("Tangan-Tangan"),
      )),
      "Aceh Besar" => drupal_map_assoc(array(
        t("Baitussalam"),
        t("Blank Bintang"),
        t("Darul Imarah"),
        t("Darul Kamal"),
        t("Darussalam"),
        t("Indrapuri"),
        t("Ingin Jaya"),
        t("Kota Cot Glie (Kuta Cot Glie)"),
        t("Kota Jantho"),
        t("Kota Malaka (Kuta Malaka)"),
        t("Krueng Barona Jaya"),
        t("Kuta Baro"),
        t("Lembah Seulawah"),
        t("Leupung"),
        t("Lhoknga (Lho'nga)"),
        t("Lhoong"),
        t("Mantasiek (Montasik)"),
        t("Mesjid Raya"),
        t("Peukan Bada"),
        t("Pulo Aceh"),
        t("Seulimeum"),
        t("Simpang Tiga"),
        t("Suka Makmur"),
      )),
      "Aceh Jaya" => drupal_map_assoc(array(
        t("Darul Hikmah"),
        t("Indra Jaya"),
        t("Jaya"),
        t("Keude Panga"),
        t("Krueng Sabee"),
        t("Pasie Raya"),
        t("Sampoiniet"),
        t("Setia Bakti"),
        t("Teunom"),
      )),
      "Aceh Selatan" => drupal_map_assoc(array(
        t("Bakongan"),
        t("Bakongan Timur"),
        t("Kluet Selatan"),
        t("Kluet Tengah"),
        t("Kluet Timur"),
        t("Kluet Utara"),
        t("Kota Bahagia"),
        t("Labuhan Haji"),
        t("Labuhan Haji Barat"),
        t("Labuhan Haji Timur"),
        t("Meukek"),
        t("Pasie Raja"),
        t("Sama Dua"),
        t("Sawang"),
        t("Tapak Tuan"),
        t("Trumon"),
        t("Trumon Tengah"),
        t("Trumon Timur"),
      )),
      "Aceh Singkil" => drupal_map_assoc(array(
        t("Danau Paris"),
        t("Gunung Meriah (Mariah)"),
        t("Kota Baharu"),
        t("Kuala Baru"),
        t("Pulau Banyak"),
        t("Pulau Banyak Barat"),
        t("Simpang Kanan"),
        t("Singkil"),
        t("Singkil Utara"),
        t("Singkohor"),
        t("Suro Makmur"),
      )),
      "Aceh Tamiang" => drupal_map_assoc(array(
        t("Banda Mulia"),
        t("Bandar Pusaka"),
        t("Bendahara"),
        t("Karang Baru"),
        t("Kejuruan Muda"),
        t("Kota Kuala Simpang"),
        t("Manyak Payed"),
        t("Rantau"),
        t("Sekerak"),
        t("Seruway"),
        t("Tamiang Hulu"),
        t("Tenggulun"),
      )),
      "Aceh Tengah" => drupal_map_assoc(array(
        t("Atu Lintang"),
        t("Bebesen"),
        t("Bies"),
        t("Bintang"),
        t("Celala"),
        t("Jagong Jeget"),
        t("Kebayakan"),
        t("Ketol"),
        t("Kute Panang"),
        t("Linge"),
        t("Lut Tawar"),
        t("Pegasing"),
        t("Rusip Antara"),
        t("Silih Nara"),
      )),
      "Aceh Tenggara" => drupal_map_assoc(array(
        t("Babul Makmur"),
        t("Babul Rahmah"),
        t("Babussalam"),
        t("Badar"),
        t("Bambel"),
        t("Bukit Tusam"),
        t("Darul Hasanah"),
        t("Deleng Pokhisen"),
        t("Ketambe"),
        t("Lawe Alas"),
        t("Lawe Bulan"),
        t("Lawe Sigala-Gala"),
        t("Lawe Sumur"),
        t("Leuser"),
        t("Semadam"),
        t("Tanah Alas"),
      )),
      "Aceh Timur" => drupal_map_assoc(array(
        t("Banda Alam"),
        t("Birem Bayeun"),
        t("Darul Aman"),
        t("Darul Falah"),
        t("Darul Iksan (Ihsan)"),
        t("Idi Rayeuk"),
        t("Idi Timur"),
        t("Idi Tunong"),
        t("Indra Makmur"),
        t("Julok"),
        t("Madat"),
        t("Nurussalam"),
        t("Pante Bidari (Beudari)"),
        t("Peudawa"),
        t("Peunaron"),
        t("Peureulak"),
        t("Peureulak Barat"),
        t("Peureulak Timur"),
        t("Rantau Selamat"),
        t("Ranto Peureulak"),
        t("Serba Jadi"),
        t("Simpang Jernih"),
        t("Simpang Ulim"),
        t("Sungai Raya"),
      )),
      "Aceh Utara" => drupal_map_assoc(array(
        t("Baktiya"),
        t("Baktiya Barat"),
        t("Banda Baro"),
        t("Cot Girek"),
        t("Dewantara"),
        t("Geuredong Pase"),
        t("Kuta Makmur"),
        t("Langkahan"),
        t("Lapang"),
        t("Lhoksukon"),
        t("Matangkuli"),
        t("Meurah Mulia"),
        t("Muara Batu"),
        t("Nibong"),
        t("Nisam"),
        t("Nisam Antara"),
        t("Paya Bakong"),
        t("Pirak Timur"),
        t("Samudera"),
        t("Sawang"),
        t("Seunuddon (Seunudon)"),
        t("Simpang Kramat (Keramat)"),
        t("Syamtalira Aron"),
        t("Syamtalira Bayu"),
        t("Tanah Jambo Aye"),
        t("Tanah Luas"),
        t("Tanah Pasir"),
      )),
      "Banda Aceh" => drupal_map_assoc(array(
        t("Baiturrahman"),
        t("Banda Raya"),
        t("Jaya Baru"),
        t("Kuta Alam"),
        t("Kuta Raja"),
        t("Lueng Bata"),
        t("Meuraxa"),
        t("Syiah Kuala"),
        t("Ulee Kareng"),
      )),
      "Bener Meriah" => drupal_map_assoc(array(
        t("Bandar"),
        t("Bener Kelipah"),
        t("Bukit"),
        t("Gajah Putih"),
        t("Mesidah"),
        t("Permata"),
        t("Pintu Rime Gayo"),
        t("Syiah Utama"),
        t("Timang Gajah"),
        t("Wih Pesam"),
      )),
      "Bireuen" => drupal_map_assoc(array(
        t("Ganda Pura"),
        t("Jangka"),
        t("Jeumpa"),
        t("Jeunieb"),
        t("Juli"),
        t("Kota Juang"),
        t("Kuala"),
        t("Kuta Blang"),
        t("Makmur"),
        t("Pandrah"),
        t("Peudada"),
        t("Peulimbang (Plimbang)"),
        t("Peusangan"),
        t("Peusangan Selatan"),
        t("Peusangan Siblah Krueng"),
        t("Samalanga"),
        t("Simpang Mamplam"),
      )),
      "Gayo Lues" => drupal_map_assoc(array(
        t("Blang Jerango"),
        t("Blang Kejeren"),
        t("Blang Pegayon"),
        t("Dabun Gelang (Debun Gelang)"),
        t("Kuta Panjang"),
        t("Pantan Cuaca"),
        t("Pining (Pinding)"),
        t("Putri Betung"),
        t("Rikit Gaib"),
        t("Terangun (Terangon)"),
        t("Teripe/Tripe Jaya"),
      )),
      "Langsa" => drupal_map_assoc(array(
        t("Langsa Barat"),
        t("Langsa Baro"),
        t("Langsa Kota"),
        t("Langsa Lama"),
        t("Langsa Timur"),
      )),
      "Lhokseumawe" => drupal_map_assoc(array(
        t("Banda Sakti"),
        t("Blang Mangat"),
        t("Muara Dua"),
        t("Muara Satu"),
      )),
      "Nagan Raya" => drupal_map_assoc(array(
        t("Beutong"),
        t("Beutong Ateuh Banggalang"),
        t("Darul Makmur"),
        t("Kuala"),
        t("Kuala Pesisir"),
        t("Seunagan"),
        t("Seunagan Timur"),
        t("Suka Makmue"),
        t("Tadu Raya"),
        t("Tripa Makmur"),
      )),
      "Pidie" => drupal_map_assoc(array(
        t("Batee"),
        t("Delima"),
        t("Geumpang"),
        t("Glumpang Baro"),
        t("Glumpang Tiga (Geulumpang Tiga)"),
        t("Grong Grong"),
        t("Indrajaya"),
        t("Kembang Tanjong (Tanjung)"),
        t("Keumala"),
        t("Kota Sigli"),
        t("Mane"),
        t("Mila"),
        t("Muara Tiga"),
        t("Mutiara"),
        t("Mutiara Timur"),
        t("Padang Tiji"),
        t("Peukan Baro"),
        t("Pidie"),
        t("Sakti"),
        t("Simpang Tiga"),
        t("Tangse"),
        t("Tiro/Truseb"),
        t("Titeue"),
      )),
      "Pidie Jaya" => drupal_map_assoc(array(
        t("Bandar Baru"),
        t("Bandar Dua"),
        t("Jangka Buya"),
        t("Meurah Dua"),
        t("Meureudu"),
        t("Panteraja"),
        t("Trienggadeng"),
        t("Ulim"),
      )),
      "Sabang" => drupal_map_assoc(array(
        t("Sukajaya"),
        t("Sukakarya"),
      )),
      "Simeulue" => drupal_map_assoc(array(
        t("Alapan (Alafan)"),
        t("Salang"),
        t("Simeuleu Barat"),
        t("Simeuleu Tengah"),
        t("Simeuleu Timur"),
        t("Simeulue Cut"),
        t("Teluk Dalam"),
        t("Teupah Barat"),
        t("Teupah Selatan"),
        t("Teupah Tengah"),
      )),
      "Subulussalam" => drupal_map_assoc(array(
        t("Longkib"),
        t("Penanggalan"),
        t("Rundeng"),
        t("Simpang Kiri"),
        t("Sultan Daulat"),
      )),
    ),
    "Nusa Tenggara Barat (NTB)" => array(
      "Bima (Kabupaten)" => drupal_map_assoc(array(
        t("Ambalawi"),
        t("Belo"),
        t("Bolo"),
        t("Donggo"),
        t("Lambitu"),
        t("Lambu"),
        t("Langgudu"),
        t("Madapangga"),
        t("Monta"),
        t("Palibelo"),
        t("Parado"),
        t("Sanggar"),
        t("Sape"),
        t("Soromandi"),
        t("Tambora"),
        t("Wawo"),
        t("Wera"),
        t("Woha"),
      )),
      "Bima (Kota)" => drupal_map_assoc(array(
        t("Asakota"),
        t("Mpunda"),
        t("Raba"),
        t("Rasanae Barat"),
        t("Rasanae Timur"),
      )),
      "Dompu" => drupal_map_assoc(array(
        t("Dompu"),
        t("Hu'u"),
        t("Kempo"),
        t("Kilo"),
        t("Menggelewa (Manggelewa)"),
        t("Pajo"),
        t("Pekat"),
        t("Woja"),
      )),
      "Lombok Barat" => drupal_map_assoc(array(
        t("Batu Layar"),
        t("Gerung"),
        t("Gunungsari"),
        t("Kediri"),
        t("Kuripan"),
        t("Labuapi"),
        t("Lembar"),
        t("Lingsar"),
        t("Narmada"),
        t("Sekotong"),
      )),
      "Lombok Tengah" => drupal_map_assoc(array(
        t("Batukliang"),
        t("Batukliang Utara"),
        t("Janapria"),
        t("Jonggat"),
        t("Kopang"),
        t("Praya"),
        t("Praya Barat"),
        t("Praya Barat Daya"),
        t("Praya Tengah"),
        t("Praya Timur"),
        t("Pringgarata"),
        t("Pujut"),
      )),
      "Lombok Timur" => drupal_map_assoc(array(
        t("Aikmel"),
        t("Jerowaru"),
        t("Keruak"),
        t("Labuhan Haji"),
        t("Masbagik"),
        t("Montong Gading"),
        t("Pringgabaya"),
        t("Pringgasela"),
        t("Sakra"),
        t("Sakra Barat"),
        t("Sakra Timur"),
        t("Sambalia (Sambelia)"),
        t("Selong"),
        t("Sembalun"),
        t("Sikur"),
        t("Suela (Suwela)"),
        t("Sukamulia"),
        t("Suralaga"),
        t("Terara"),
        t("Wanasaba"),
      )),
      "Lombok Utara" => drupal_map_assoc(array(
        t("Bayan"),
        t("Gangga"),
        t("Kayangan"),
        t("Pemenang"),
        t("Tanjung"),
      )),
      "Mataram" => drupal_map_assoc(array(
        t("Ampenan"),
        t("Cakranegara"),
        t("Mataram"),
        t("Sandubaya (Sandujaya)"),
        t("Sekarbela"),
        t("Selaparang (Selaprang)"),
      )),
      "Sumbawa" => drupal_map_assoc(array(
        t("Alas"),
        t("Alas Barat"),
        t("Batulanteh"),
        t("Buer"),
        t("Empang"),
        t("Labangka"),
        t("Labuhan Badas"),
        t("Lantung"),
        t("Lape (Lape Lopok)"),
        t("Lenangguar"),
        t("Lopok"),
        t("Lunyuk"),
        t("Maronge"),
        t("Moyo Hilir"),
        t("Moyo Hulu"),
        t("Moyo Utara"),
        t("Orong Telu"),
        t("Plampang"),
        t("Rhee"),
        t("Ropang"),
        t("Sumbawa"),
        t("Tarano"),
        t("Unter Iwes (Unterwiris)"),
        t("Utan"),
      )),
      "Sumbawa Barat" => drupal_map_assoc(array(
        t("Brang Ene"),
        t("Brang Rea"),
        t("Jereweh"),
        t("Maluk"),
        t("Poto Tano"),
        t("Sateluk (Seteluk)"),
        t("Sekongkang"),
        t("Taliwang"),
      )),
    ),
    "Nusa Tenggara Timur (NTT)" => array(
      "Alor" => drupal_map_assoc(array(
        t("Alor Barat Daya"),
        t("Alor Barat Laut"),
        t("Alor Selatan"),
        t("Alor Tengah Utara"),
        t("Alor Timur"),
        t("Alor Timur Laut"),
        t("Kabola"),
        t("Lembur"),
        t("Mataru"),
        t("Pantar"),
        t("Pantar Barat"),
        t("Pantar Barat Laut"),
        t("Pantar Tengah"),
        t("Pantar Timur"),
        t("Pulau Pura"),
        t("Pureman"),
        t("Teluk Mutiara"),
      )),
      "Belu" => drupal_map_assoc(array(
        t("Atambua Barat"),
        t("Atambua Kota"),
        t("Atambua Selatan"),
        t("Botin Leo Bele"),
        t("Io Kufeu"),
        t("Kakuluk Mesak"),
        t("Kobalima"),
        t("Kobalima Timur"),
        t("Laen Manen"),
        t("Lamaknen"),
        t("Lamaknen Selatan"),
        t("Lasiolat"),
        t("Malaka Barat"),
        t("Malaka Tengah"),
        t("Malaka Timur"),
        t("Nanaet Duabesi"),
        t("Raihat"),
        t("Raimanuk"),
        t("Rinhat"),
        t("Sasitamean"),
        t("Tasifeto Barat"),
        t("Tasifeto Timur"),
        t("Weliman"),
        t("Wewiku"),
      )),
      "Ende" => drupal_map_assoc(array(
        t("Detukeli"),
        t("Detusoko"),
        t("Ende"),
        t("Ende Selatan"),
        t("Ende Tengah"),
        t("Ende Timur"),
        t("Ende Utara"),
        t("Kelimutu"),
        t("Kotabaru"),
        t("Lepembusu Kelisoke"),
        t("Lio Timur"),
        t("Maukaro"),
        t("Maurole"),
        t("Nangapanda"),
        t("Ndona"),
        t("Ndona Timur"),
        t("Ndori"),
        t("Pulau Ende"),
        t("Wewaria"),
        t("Wolojita"),
        t("Wolowaru"),
      )),
      "Flores Timur" => drupal_map_assoc(array(
        t("Adonara"),
        t("Adonara Barat"),
        t("Adonara Tengah"),
        t("Adonara Timur"),
        t("Demon Pagong"),
        t("Ile Boleng"),
        t("Ile Bura"),
        t("Ile Mandiri"),
        t("Kelubagolit (Klubagolit)"),
        t("Larantuka"),
        t("Lewolema"),
        t("Solor Barat"),
        t("Solor Selatan"),
        t("Solor Timur"),
        t("Tanjung Bunga"),
        t("Titehena"),
        t("Witihama (Watihama)"),
        t("Wotan Ulumado"),
        t("Wulanggitang"),
      )),
      "Kupang (Kabupaten)" => drupal_map_assoc(array(
        t("Amabi Oefeto"),
        t("Amabi Oefeto Timur"),
        t("Amarasi"),
        t("Amarasi Barat"),
        t("Amarasi Selatan"),
        t("Amarasi Timur"),
        t("Amfoang Barat Daya"),
        t("Amfoang Barat Laut"),
        t("Amfoang Selatan"),
        t("Amfoang Tengah"),
        t("Amfoang Timur"),
        t("Amfoang Utara"),
        t("Fatuleu"),
        t("Fatuleu Barat"),
        t("Fatuleu Tengah"),
        t("Kupang Barat"),
        t("Kupang Tengah"),
        t("Kupang Timur"),
        t("Nekamese"),
        t("Semau"),
        t("Semau Selatan"),
        t("Sulamu"),
        t("Taebenu"),
        t("Takari"),
      )),
      "Kupang (Kota)" => drupal_map_assoc(array(
        t("Alak"),
        t("Kelapa Lima"),
        t("Kota Lama"),
        t("Kota Raja"),
        t("Maulafa"),
        t("Oebobo"),
      )),
      "Lembata" => drupal_map_assoc(array(
        t("Atadei"),
        t("Buyasuri (Buyasari)"),
        t("Ile Ape"),
        t("Ile Ape Timur"),
        t("Lebatukan"),
        t("Nagawutung"),
        t("Nubatukan"),
        t("Omesuri"),
        t("Wulandoni (Wulandioni)"),
      )),
      "Manggarai" => drupal_map_assoc(array(
        t("Cibal"),
        t("Cibal Barat"),
        t("Langke Rembong"),
        t("Lelak"),
        t("Rahong Utara"),
        t("Reok"),
        t("Reok Barat"),
        t("Ruteng"),
        t("Satar Mese"),
        t("Satar Mese Barat"),
        t("Wae Rii"),
      )),
      "Manggarai Barat" => drupal_map_assoc(array(
        t("Boleng"),
        t("Komodo"),
        t("Kuwus"),
        t("Lembor"),
        t("Lembor Selatan"),
        t("Macang Pacar"),
        t("Mbeliling"),
        t("Ndoso"),
        t("Sano Nggoang"),
        t("Welak"),
      )),
      "Manggarai Timur" => drupal_map_assoc(array(
        t("Borong"),
        t("Elar"),
        t("Elar Selatan"),
        t("Kota Komba"),
        t("Lamba Leda"),
        t("Poco Ranaka"),
        t("Poco Ranaka Timur"),
        t("Rana Mese"),
        t("Sambi Rampas"),
      )),
      "Nagekeo" => drupal_map_assoc(array(
        t("Aesesa"),
        t("Aesesa Selatan"),
        t("Boawae"),
        t("Keo Tengah"),
        t("Mauponggo"),
        t("Nangaroro"),
        t("Wolowae"),
      )),
      "Ngada" => drupal_map_assoc(array(
        t("Aimere"),
        t("Bajawa"),
        t("Bajawa Utara"),
        t("Golewa"),
        t("Golewa Barat"),
        t("Golewa Selatan"),
        t("Inerie"),
        t("Jerebuu"),
        t("Riung"),
        t("Riung Barat"),
        t("Soa"),
        t("Wolomeze (Riung Selatan)"),
      )),
      "Rote Ndao" => drupal_map_assoc(array(
        t("Landu Leko"),
        t("Lobalain"),
        t("Ndao Nuse"),
        t("Pantai Baru"),
        t("Rote Barat"),
        t("Rote Barat Daya"),
        t("Rote Barat Laut"),
        t("Rote Selatan"),
        t("Rote Tengah"),
        t("Rote Timur"),
      )),
      "Sabu Raijua" => drupal_map_assoc(array(
        t("Hawu Mehara"),
        t("Raijua"),
        t("Sabu Barat"),
        t("Sabu Liae"),
        t("Sabu Tengah"),
        t("Sabu Timur"),
      )),
      "Sikka" => drupal_map_assoc(array(
        t("Alok"),
        t("Alok Barat"),
        t("Alok Timur"),
        t("Bola"),
        t("Doreng"),
        t("Hewokloang"),
        t("Kangae"),
        t("Kewapante"),
        t("Koting"),
        t("Lela"),
        t("Magepanda"),
        t("Mapitara"),
        t("Mego"),
        t("Nelle (Maumerei)"),
        t("Nita"),
        t("Paga"),
        t("Palue"),
        t("Talibura"),
        t("Tana Wawo"),
        t("Waiblama"),
        t("Waigete"),
      )),
      "Sumba Barat" => drupal_map_assoc(array(
        t("Kota Waikabubak"),
        t("Lamboya"),
        t("Lamboya Barat"),
        t("Loli"),
        t("Tana Righu"),
        t("Wanokaka"),
      )),
      "Sumba Barat Daya" => drupal_map_assoc(array(
        t("Kodi"),
        t("Kodi Balaghar"),
        t("Kodi Bangedo"),
        t("Kodi Utara"),
        t("Kota Tambolaka"),
        t("Loura (Laura)"),
        t("Wewewa Barat"),
        t("Wewewa Selatan"),
        t("Wewewa Tengah (Wewera Tengah)"),
        t("Wewewa Timur"),
        t("Wewewa Utara"),
      )),
      "Sumba Tengah" => drupal_map_assoc(array(
        t("Katikutana"),
        t("Katikutana Selatan"),
        t("Mamboro"),
        t("Umbu Ratu Nggay"),
        t("Umbu Ratu Nggay Barat"),
      )),
      "Sumba Timur" => drupal_map_assoc(array(
        t("Haharu"),
        t("Kahaunguweti (Kahaungu Eti)"),
        t("Kambata Mapambuhang"),
        t("Kambera"),
        t("Kanatang"),
        t("Karera"),
        t("Katala Hamu Lingu"),
        t("Kota Waingapu"),
        t("Lewa"),
        t("Lewa Tidahu"),
        t("Mahu"),
        t("Matawai Lappau (La Pawu)"),
        t("Ngadu Ngala"),
        t("Nggaha Oriangu"),
        t("Paberiwai"),
        t("Pahunga Lodu"),
        t("Pandawai"),
        t("Pinupahar (Pirapahar)"),
        t("Rindi"),
        t("Tabundung"),
        t("Umalulu"),
        t("Wula Waijelu"),
      )),
      "Timor Tengah Selatan" => drupal_map_assoc(array(
        t("Amanatun Selatan"),
        t("Amanatun Utara"),
        t("Amanuban Barat"),
        t("Amanuban Selatan"),
        t("Amanuban Tengah"),
        t("Amanuban Timur"),
        t("Batu Putih"),
        t("Boking"),
        t("Fatukopa"),
        t("Fatumnasi"),
        t("Fautmolo"),
        t("Kie (Ki'e)"),
        t("Kok Baun"),
        t("Kolbano"),
        t("Kot Olin"),
        t("Kota Soe"),
        t("Kualin"),
        t("Kuanfatu"),
        t("Kuatnana"),
        t("Mollo Barat"),
        t("Mollo Selatan"),
        t("Mollo Tengah"),
        t("Mollo Utara"),
        t("Noebana"),
        t("Noebeba"),
        t("Nunbena"),
        t("Nunkolo"),
        t("Oenino"),
        t("Polen"),
        t("Santian"),
        t("Tobu"),
        t("Toianas"),
      )),
      "Timor Tengah Utara" => drupal_map_assoc(array(
        t("Biboki Anleu"),
        t("Biboki Feotleu"),
        t("Biboki Moenleu"),
        t("Biboki Selatan"),
        t("Biboki Tan Pah"),
        t("Biboki Utara"),
        t("Bikomi Nilulat"),
        t("Bikomi Selatan"),
        t("Bikomi Tengah"),
        t("Bikomi Utara"),
        t("Insana"),
        t("Insana Barat"),
        t("Insana Fafinesu"),
        t("Insana Tengah"),
        t("Insana Utara"),
        t("Kota Kefamenanu"),
        t("Miomaffo Barat"),
        t("Miomaffo Tengah"),
        t("Miomaffo Timur"),
        t("Musi"),
        t("Mutis"),
        t("Naibenu"),
        t("Noemuti"),
        t("Noemuti Timur"),
      )),
    ),
    "Papua" => array(
      "Asmat" => drupal_map_assoc(array(
        t("Agats"),
        t("Akat"),
        t("Atsy / Atsj"),
        t("Ayip"),
        t("Betcbamu"),
        t("Der Koumur"),
        t("Fayit"),
        t("Jetsy"),
        t("Joerat"),
        t("Kolf Braza"),
        t("Kopay"),
        t("Pantai Kasuari"),
        t("Pulau Tiga"),
        t("Safan"),
        t("Sawa Erma"),
        t("Sirets"),
        t("Suator"),
        t("Suru-suru"),
        t("Unir Sirau"),
      )),
      "Biak Numfor" => drupal_map_assoc(array(
        t("Aimando Padaido"),
        t("Andey (Andei)"),
        t("Biak Barat"),
        t("Biak Kota"),
        t("Biak Timur"),
        t("Biak Utara"),
        t("Bondifuar"),
        t("Bruyadori"),
        t("Numfor Barat"),
        t("Numfor Timur"),
        t("Oridek"),
        t("Orkeri"),
        t("Padaido"),
        t("Poiru"),
        t("Samofa"),
        t("Swandiwe"),
        t("Warsa"),
        t("Yawosi"),
        t("Yendidori"),
      )),
      "Boven Digoel" => drupal_map_assoc(array(
        t("Ambatkwi (Ambatkui)"),
        t("Arimop"),
        t("Bomakia"),
        t("Firiwage"),
        t("Fofi"),
        t("Iniyandit"),
        t("Jair"),
        t("Kawagit"),
        t("Ki"),
        t("Kombay"),
        t("Kombut"),
        t("Kouh"),
        t("Mandobo"),
        t("Manggelum"),
        t("Mindiptana"),
        t("Ninati"),
        t("Sesnuk"),
        t("Subur"),
        t("Waropko"),
        t("Yaniruma"),
      )),
      "Deiyai (Deliyai)" => drupal_map_assoc(array(
        t("Bowobado"),
        t("Kapiraya"),
        t("Tigi"),
        t("Tigi Barat"),
        t("Tigi Timur"),
      )),
      "Dogiyai" => drupal_map_assoc(array(
        t("Dogiyai"),
        t("Kamu"),
        t("Kamu Selatan"),
        t("Kamu Timur"),
        t("Kamu Utara (Ikrar/Ikrat)"),
        t("Mapia"),
        t("Mapia Barat"),
        t("Mapia Tengah"),
        t("Piyaiye (Sukikai)"),
        t("Sukikai Selatan"),
      )),
      "Intan Jaya" => drupal_map_assoc(array(
        t("Agisiga"),
        t("Biandoga"),
        t("Hitadipa"),
        t("Homeo (Homeyo)"),
        t("Sugapa"),
        t("Wandai"),
      )),
      "Jayapura (Kabupaten)" => drupal_map_assoc(array(
        t("Airu"),
        t("Demta"),
        t("Depapre"),
        t("Ebungfau (Ebungfa)"),
        t("Gresi Selatan"),
        t("Kaureh"),
        t("Kemtuk"),
        t("Kemtuk Gresi"),
        t("Nambluong"),
        t("Nimbokrang"),
        t("Nimboran"),
        t("Ravenirara"),
        t("Sentani"),
        t("Sentani Barat"),
        t("Sentani Timur"),
        t("Unurum Guay"),
        t("Waibu"),
        t("Yapsi"),
        t("Yokari"),
      )),
      "Jayapura (Kota)" => drupal_map_assoc(array(
        t("Abepura"),
        t("Heram"),
        t("Jayapura Selatan"),
        t("Jayapura Utara"),
        t("Muara Tami"),
      )),
      "Jayawijaya" => drupal_map_assoc(array(
        t("Asologaima (Asalogaima)"),
        t("Asolokobal"),
        t("Asotipo"),
        t("Bolakme"),
        t("Bpiri"),
        t("Bugi"),
        t("Hubikiak"),
        t("Hubikosi (Hobikosi)"),
        t("Ibele"),
        t("Itlay Hisage"),
        t("Koragi"),
        t("Kurulu"),
        t("Libarek"),
        t("Maima"),
        t("Molagalome"),
        t("Muliama"),
        t("Musatfak"),
        t("Napua"),
        t("Pelebaga"),
        t("Piramid"),
        t("Pisugi"),
        t("Popugoba"),
        t("Siepkosi"),
        t("Silo Karno Doga"),
        t("Taelarek"),
        t("Tagime"),
        t("Tagineri"),
        t("Trikora"),
        t("Usilimo"),
        t("Wadangku"),
        t("Walaik"),
        t("Walelagama"),
        t("Wame"),
        t("Wamena"),
        t("Welesi"),
        t("Wesaput"),
        t("Wita Waya"),
        t("Wollo (Wolo)"),
        t("Wouma"),
        t("Yalengga"),
      )),
      "Keerom" => drupal_map_assoc(array(
        t("Arso"),
        t("Arso Timur"),
        t("Senggi"),
        t("Skamto (Skanto)"),
        t("Towe"),
        t("Waris"),
        t("Web"),
      )),
      "Kepulauan Yapen (Yapen Waropen)" => drupal_map_assoc(array(
        t("Angkaisera"),
        t("Kepulauan Ambai"),
        t("Kosiwo"),
        t("Poom"),
        t("Pulau Kurudu"),
        t("Pulau Yerui"),
        t("Raimbawi"),
        t("Teluk Ampimoi"),
        t("Windesi"),
        t("Wonawa"),
        t("Yapen Barat"),
        t("Yapen Selatan"),
        t("Yapen Timur"),
        t("Yapen Utara"),
      )),
      "Lanny Jaya" => drupal_map_assoc(array(
        t("Balingga"),
        t("Dimba"),
        t("Gamelia"),
        t("Kuyawage"),
        t("Makki (Maki)"),
        t("Malagaineri (Malagineri)"),
        t("Pirime"),
        t("Poga"),
        t("Tiom"),
        t("Tiomneri"),
      )),
      "Mamberamo Raya" => drupal_map_assoc(array(
        t("Benuki"),
        t("Mamberamo Hilir/Ilir"),
        t("Mamberamo Hulu/Ulu"),
        t("Mamberamo Tengah"),
        t("Mamberamo Tengah Timur"),
        t("Rofaer (Rufaer)"),
        t("Sawai"),
        t("Waropen Atas"),
      )),
      "Mamberamo Tengah" => drupal_map_assoc(array(
        t("Eragayam"),
        t("Ilugwa"),
        t("Kelila"),
        t("Kobakma"),
        t("Megabilis (Megambilis)"),
      )),
      "Mappi" => drupal_map_assoc(array(
        t("Assue"),
        t("Bamgi"),
        t("Citakmitak"),
        t("Edera"),
        t("Haju"),
        t("Kaibar"),
        t("Minyamur"),
        t("Nambioman Bapai (Mambioman)"),
        t("Obaa"),
        t("Passue"),
        t("Passue Bawah"),
        t("Syahcame"),
        t("Ti Zain"),
        t("Venaha"),
        t("Yakomi"),
      )),
      "Merauke" => drupal_map_assoc(array(
        t("Animha"),
        t("Eligobel"),
        t("Ilyawab"),
        t("Jagebob"),
        t("Kaptel"),
        t("Kimaam"),
        t("Kurik"),
        t("Malind"),
        t("Merauke"),
        t("Muting"),
        t("Naukenjerai"),
        t("Ngguti (Nggunti)"),
        t("Okaba"),
        t("Semangga"),
        t("Sota"),
        t("Tabonji"),
        t("Tanah Miring"),
        t("Tubang"),
        t("Ulilin"),
        t("Waan"),
      )),
      "Mimika" => drupal_map_assoc(array(
        t("Agimuga"),
        t("Jila"),
        t("Jita"),
        t("Kuala Kencana"),
        t("Mimika Barat (Mibar)"),
        t("Mimika Barat Jauh"),
        t("Mimika Barat Tengah"),
        t("Mimika Baru"),
        t("Mimika Timur"),
        t("Mimika Timur Jauh"),
        t("Mimika Timur Tengah"),
        t("Tembagapura"),
      )),
      "Nabire" => drupal_map_assoc(array(
        t("Dipa"),
        t("Makimi"),
        t("Menou"),
        t("Moora"),
        t("Nabire"),
        t("Nabire Barat"),
        t("Napan"),
        t("Siriwo"),
        t("Teluk Kimi"),
        t("Teluk Umar"),
        t("Uwapa"),
        t("Wanggar"),
        t("Wapoga"),
        t("Yaro (Yaro Kabisay)"),
        t("Yaur"),
      )),
      "Nduga" => drupal_map_assoc(array(
        t("Alama"),
        t("Dal"),
        t("Embetpen"),
        t("Gearek"),
        t("Geselma (Geselema)"),
        t("Inikgal"),
        t("Iniye"),
        t("Kegayem"),
        t("Kenyam"),
        t("Kilmid"),
        t("Kora"),
        t("Koroptak"),
        t("Krepkuri"),
        t("Mam"),
        t("Mapenduma"),
        t("Mbua (Mbuga)"),
        t("Mbua Tengah"),
        t("Mbulmu Yalma"),
        t("Mebarok"),
        t("Moba"),
        t("Mugi"),
        t("Nenggeagin"),
        t("Nirkuri"),
        t("Paro"),
        t("Pasir Putih"),
        t("Pija"),
        t("Wosak"),
        t("Wusi"),
        t("Wutpaga"),
        t("Yal"),
        t("Yenggelo"),
        t("Yigi"),
      )),
      "Paniai" => drupal_map_assoc(array(
        t("Aradide"),
        t("Bibida"),
        t("Bogobaida"),
        t("Dumadama"),
        t("Ekadide"),
        t("Kebo"),
        t("Paniai Barat"),
        t("Paniai Timur"),
        t("Siriwo"),
        t("Yatamo"),
      )),
      "Pegunungan Bintang" => drupal_map_assoc(array(
        t("Aboy"),
        t("Alemsom"),
        t("Awinbon"),
        t("Batani"),
        t("Batom"),
        t("Bime"),
        t("Borme"),
        t("Eipumek"),
        t("Iwur (Okiwur)"),
        t("Jetfa"),
        t("Kalomdol"),
        t("Kawor"),
        t("Kiwirok"),
        t("Kiwirok Timur"),
        t("Mofinop"),
        t("Murkim"),
        t("Nongme"),
        t("Ok Aom"),
        t("Okbab"),
        t("Okbape"),
        t("Okbemtau"),
        t("Okbibab"),
        t("Okhika"),
        t("Oklip"),
        t("Oksamol"),
        t("Oksebang"),
        t("Oksibil"),
        t("Oksop"),
        t("Pamek"),
        t("Pepera"),
        t("Serambakon"),
        t("Tarup"),
        t("Teiraplu"),
        t("Weime"),
      )),
      "Puncak" => drupal_map_assoc(array(
        t("Agadugume"),
        t("Beoga"),
        t("Doufu"),
        t("Gome"),
        t("Ilaga"),
        t("Pogoma"),
        t("Sinak"),
        t("Wangbe"),
      )),
      "Puncak Jaya" => drupal_map_assoc(array(
        t("Fawi"),
        t("Ilu"),
        t("Jigonikme"),
        t("Mewoluk (Mewulok)"),
        t("Mulia"),
        t("Tingginambut"),
        t("Torere"),
        t("Yamo"),
      )),
      "Sarmi" => drupal_map_assoc(array(
        t("Apawer Hulu"),
        t("Bonggo"),
        t("Bonggo Timur"),
        t("Pantai Barat"),
        t("Pantai Timur"),
        t("Pantai Timur Barat"),
        t("Sarmi"),
        t("Sarmi Selatan"),
        t("Sarmi Timur"),
        t("Tor Atas"),
      )),
      "Supiori" => drupal_map_assoc(array(
        t("Kepulauan Aruri"),
        t("Supiori Barat"),
        t("Supiori Selatan"),
        t("Supiori Timur"),
        t("Supiori Utara"),
      )),
      "Tolikara" => drupal_map_assoc(array(
        t("Airgaram"),
        t("Anawi"),
        t("Aweku"),
        t("Bewani"),
        t("Biuk"),
        t("Bogonuk"),
        t("Bokondini"),
        t("Bokoneri"),
        t("Danime"),
        t("Dow"),
        t("Dundu (Ndundu)"),
        t("Egiam"),
        t("Geya"),
        t("Gika"),
        t("Gilubandu (Gilumbandu/Gilimbandu)"),
        t("Goyage"),
        t("Gundagi (Gudage)"),
        t("Kai"),
        t("Kamboneri"),
        t("Kanggime (Kanggima )"),
        t("Karubaga"),
        t("Kembu"),
        t("Kondaga (Konda)"),
        t("Kuari"),
        t("Kubu"),
        t("Li Anogomma"),
        t("Nabunage"),
        t("Nelawi"),
        t("Numba"),
        t("Nunggawi (Munggawi)"),
        t("Panaga"),
        t("Poganeri"),
        t("Tagime"),
        t("Tagineri"),
        t("Telenggeme"),
        t("Timori"),
        t("Umagi"),
        t("Wakuwo"),
        t("Wari (Taiyeve)"),
        t("Wenam"),
        t("Wina"),
        t("Wonoki (Woniki)"),
        t("Wugi"),
        t("Wunin (Wumin)"),
        t("Yuko"),
        t("Yuneri"),
      )),
      "Waropen" => drupal_map_assoc(array(
        t("Demba Masirei"),
        t("Inggerus"),
        t("Kirihi"),
        t("Masirei"),
        t("Oudate Waropen"),
        t("Risei Sayati"),
        t("Ureifasei"),
        t("Wapoga Inggerus"),
        t("Waropen Bawah"),
      )),
      "Yahukimo" => drupal_map_assoc(array(
        t("Amuma"),
        t("Anggruk"),
        t("Bomela"),
        t("Dekai"),
        t("Dirwemna (Diruwena)"),
        t("Duram"),
        t("Endomen"),
        t("Hereapini (Hereanini)"),
        t("Hilipuk"),
        t("Hogio (Hugio)"),
        t("Holuon"),
        t("Kabianggama (Kabianggema)"),
        t("Kayo"),
        t("Kona"),
        t("Koropun (Korupun)"),
        t("Kosarek"),
        t("Kurima"),
        t("Kwelemdua (Kwelamdua)"),
        t("Kwikma"),
        t("Langda"),
        t("Lolat"),
        t("Mugi"),
        t("Musaik"),
        t("Nalca"),
        t("Ninia"),
        t("Nipsan"),
        t("Obio"),
        t("Panggema"),
        t("Pasema"),
        t("Pronggoli (Proggoli)"),
        t("Puldama"),
        t("Samenage"),
        t("Sela"),
        t("Seredela (Seredala)"),
        t("Silimo"),
        t("Soba"),
        t("Sobaham"),
        t("Soloikma"),
        t("Sumo"),
        t("Suntamon"),
        t("Suru Suru"),
        t("Talambo"),
        t("Tangma"),
        t("Ubahak"),
        t("Ubalihi"),
        t("Ukha"),
        t("Walma"),
        t("Werima"),
        t("Wusuma"),
        t("Yahuliambut"),
        t("Yogosem"),
      )),
      "Yalimo" => drupal_map_assoc(array(
        t("Abenaho"),
        t("Apalapsili"),
        t("Benawa"),
        t("Elelim"),
        t("Welarek"),
      )),
    ),
    "Papua Barat" => array(
      "Fakfak" => drupal_map_assoc(array(
        t("Bombarai (Bomberay)"),
        t("Fakfak"),
        t("Fakfak Barat"),
        t("Fakfak Tengah"),
        t("Fakfak Timur"),
        t("Karas"),
        t("Kokas"),
        t("Kramongmongga (Kramamongga)"),
        t("Teluk Patipi"),
      )),
      "Kaimana" => drupal_map_assoc(array(
        t("Buruway"),
        t("Kaimana"),
        t("Kambraw (Kamberau)"),
        t("Teluk Arguni Atas"),
        t("Teluk Arguni Bawah (Yerusi)"),
        t("Teluk Etna"),
        t("Yamor"),
      )),
      "Manokwari" => drupal_map_assoc(array(
        t("Manokwari Barat"),
        t("Manokwari Selatan"),
        t("Manokwari Timur"),
        t("Manokwari Utara"),
        t("Masni"),
        t("Prafi"),
        t("Sidey"),
        t("Tanah Rubuh"),
        t("Warmare"),
      )),
      "Manokwari Selatan" => drupal_map_assoc(array(
        t("Dataran Isim"),
        t("Momi Waren"),
        t("Neney (Nenei)"),
        t("Oransbari"),
        t("Ransiki"),
        t("Tahota (Tohota)"),
      )),
      "Maybrat" => drupal_map_assoc(array(
        t("Aifat"),
        t("Aifat Selatan"),
        t("Aifat Timur"),
        t("Aifat Timur Jauh"),
        t("Aifat Timur Selatan"),
        t("Aifat Timur Tengah"),
        t("Aifat Utara"),
        t("Aitinyo"),
        t("Aitinyo Barat"),
        t("Aitinyo Raya"),
        t("Aitinyo Tengah"),
        t("Aitinyo Utara"),
        t("Ayamaru"),
        t("Ayamaru Barat"),
        t("Ayamaru Jaya"),
        t("Ayamaru Selatan"),
        t("Ayamaru Selatan Jaya"),
        t("Ayamaru Tengah"),
        t("Ayamaru Timur"),
        t("Ayamaru Timur Selatan"),
        t("Ayamaru Utara"),
        t("Ayamaru Utara Timur"),
        t("Mare"),
        t("Mare Selatan"),
      )),
      "Pegunungan Arfak" => drupal_map_assoc(array(
        t("Anggi"),
        t("Anggi Gida"),
        t("Catubouw"),
        t("Didohu"),
        t("Hingk"),
        t("Membey"),
        t("Menyambouw (Minyambouw)"),
        t("Sururey"),
        t("Taige"),
        t("Testega"),
      )),
      "Raja Ampat" => drupal_map_assoc(array(
        t("Ayau"),
        t("Batanta Selatan"),
        t("Batanta Utara"),
        t("Kepulauan Ayau"),
        t("Kepulauan Sembilan"),
        t("Kofiau"),
        t("Kota Waisai"),
        t("Meos Mansar"),
        t("Misool (Misool Utara)"),
        t("Misool Barat"),
        t("Misool Selatan"),
        t("Misool Timur"),
        t("Salawati Barat"),
        t("Salawati Tengah"),
        t("Salawati Utara (Samate)"),
        t("Supnin"),
        t("Teluk Mayalibit"),
        t("Tiplol Mayalibit"),
        t("Waigeo Barat"),
        t("Waigeo Barat Kepulauan"),
        t("Waigeo Selatan"),
        t("Waigeo Timur"),
        t("Waigeo Utara"),
        t("Warwabomi"),
      )),
      "Sorong (Kabupaten)" => drupal_map_assoc(array(
        t("Aimas"),
        t("Beraur"),
        t("Klabot"),
        t("Klamono"),
        t("Klaso"),
        t("Klawak"),
        t("Klayili"),
        t("Makbon"),
        t("Mariat"),
        t("Maudus"),
        t("Mayamuk"),
        t("Moisegen"),
        t("Salawati"),
        t("Salawati Selatan"),
        t("Sayosa"),
        t("Seget"),
        t("Segun"),
      )),
      "Sorong (Kota)" => drupal_map_assoc(array(
        t("Sorong"),
        t("Sorong Barat"),
        t("Sorong Kepulauan"),
        t("Sorong Manoi"),
        t("Sorong Timur"),
        t("Sorong Utara"),
      )),
      "Sorong Selatan" => drupal_map_assoc(array(
        t("Fokour"),
        t("Inanwatan (Inawatan)"),
        t("Kais (Matemani Kais)"),
        t("Kokoda"),
        t("Kokoda Utara"),
        t("Konda"),
        t("Matemani"),
        t("Moswaren"),
        t("Saifi"),
        t("Sawiat"),
        t("Seremuk"),
        t("Teminabuan"),
        t("Wayer"),
      )),
      "Tambrauw" => drupal_map_assoc(array(
        t("Abun"),
        t("Amberbaken"),
        t("Fef (Peef)"),
        t("Kebar"),
        t("Kwoor"),
        t("Miyah (Meyah)"),
        t("Moraid"),
        t("Mubrani"),
        t("Sausapor"),
        t("Senopi"),
        t("Syujak"),
        t("Yembun"),
      )),
      "Teluk Bintuni" => drupal_map_assoc(array(
        t("Aranday"),
        t("Aroba"),
        t("Babo"),
        t("Bintuni"),
        t("Biscoop"),
        t("Dataran Beimes"),
        t("Fafurwar (Irorutu)"),
        t("Kaitaro"),
        t("Kamundan"),
        t("Kuri"),
        t("Manimeri"),
        t("Masyeta"),
        t("Mayado"),
        t("Merdey"),
        t("Moskona Barat"),
        t("Moskona Selatan"),
        t("Moskona Timur"),
        t("Moskona Utara"),
        t("Sumuri (Simuri)"),
        t("Tembuni"),
        t("Tomu"),
        t("Tuhiba"),
        t("Wamesa (Idoor)"),
        t("Weriagar"),
      )),
      "Teluk Wondama" => drupal_map_assoc(array(
        t("Kuri Wamesa"),
        t("Naikere (Wasior Barat)"),
        t("Nikiwar"),
        t("Rasiei"),
        t("Roon"),
        t("Roswar"),
        t("Rumberpon"),
        t("Soug Jaya"),
        t("Teluk Duairi (Wasior Utara)"),
        t("Wamesa"),
        t("Wasior"),
        t("Windesi"),
        t("Wondiboy (Wasior Selatan)"),
      )),
    ),
    "Riau" => array(
      "Bengkalis" => drupal_map_assoc(array(
        t("Bantan"),
        t("Bengkalis"),
        t("Bukit Batu"),
        t("Mandau"),
        t("Pinggir"),
        t("Rupat"),
        t("Rupat Utara"),
        t("Siak Kecil"),
      )),
      "Dumai" => drupal_map_assoc(array(
        t("Bukit Kapur"),
        t("Dumai Barat"),
        t("Dumai Kota"),
        t("Dumai Selatan"),
        t("Dumai Timur"),
        t("Medang Kampai"),
        t("Sungai Sembilan"),
      )),
      "Indragiri Hilir" => drupal_map_assoc(array(
        t("Batang Tuaka"),
        t("Concong"),
        t("Enok"),
        t("Gaung"),
        t("Gaung Anak Serka"),
        t("Kateman"),
        t("Kempas"),
        t("Kemuning"),
        t("Keritang"),
        t("Kuala Indragiri"),
        t("Mandah"),
        t("Pelangiran"),
        t("Pulau Burung"),
        t("Reteh"),
        t("Sungai Batang"),
        t("Tanah Merah"),
        t("Teluk Belengkong"),
        t("Tembilahan"),
        t("Tembilahan Hulu"),
        t("Tempuling"),
      )),
      "Indragiri Hulu" => drupal_map_assoc(array(
        t("Batang Cenaku"),
        t("Batang Gansal"),
        t("Batang Peranap"),
        t("Kelayang"),
        t("Kuala Cenaku"),
        t("Lirik"),
        t("Lubuk Batu Jaya"),
        t("Pasir Penyu"),
        t("Peranap"),
        t("Rakit Kulim"),
        t("Rengat"),
        t("Rengat Barat"),
        t("Seberida"),
        t("Sungai Lala"),
      )),
      "Kampar" => drupal_map_assoc(array(
        t("Bangkinang"),
        t("Bangkinang Seberang"),
        t("Gunung Sahilan"),
        t("Kampar"),
        t("Kampar Kiri"),
        t("Kampar Kiri Hilir"),
        t("Kampar Kiri Hulu"),
        t("Kampar Kiri Tengah"),
        t("Kampar Timur"),
        t("Kampar Utara"),
        t("Koto Kampar Hulu"),
        t("Kuok (Bangkinang Barat)"),
        t("Perhentian Raja"),
        t("Rumbio Jaya"),
        t("Salo"),
        t("Siak Hulu"),
        t("Tambang"),
        t("Tapung"),
        t("Tapung Hilir"),
        t("Tapung Hulu"),
        t("XIII Koto Kampar"),
      )),
      "Kepulauan Meranti" => drupal_map_assoc(array(
        t("Merbau"),
        t("Pulaumerbau"),
        t("Rangsang"),
        t("Rangsang Barat"),
        t("Rangsang Pesisir"),
        t("Tasik Putri Puyu"),
        t("Tebing Tinggi"),
        t("Tebing Tinggi Barat"),
        t("Tebing Tinggi Timur"),
      )),
      "Kuantan Singingi" => drupal_map_assoc(array(
        t("Benai"),
        t("Cerenti"),
        t("Gunung Toar"),
        t("Hulu Kuantan"),
        t("Inuman"),
        t("Kuantan Hilir"),
        t("Kuantan Hilir Seberang"),
        t("Kuantan Mudik"),
        t("Kuantan Tengah"),
        t("Logas Tanah Darat"),
        t("Pangean"),
        t("Pucuk Rantau"),
        t("Sentajo Raya"),
        t("Singingi"),
        t("Singingi Hilir"),
      )),
      "Pekanbaru" => drupal_map_assoc(array(
        t("Bukit Raya"),
        t("Lima Puluh"),
        t("Marpoyan Damai"),
        t("Payung Sekaki"),
        t("Pekanbaru Kota"),
        t("Rumbai"),
        t("Rumbai Pesisir"),
        t("Sail"),
        t("Senapelan"),
        t("Sukajadi"),
        t("Tampan"),
        t("Tenayan Raya"),
      )),
      "Pelalawan" => drupal_map_assoc(array(
        t("Bandar Petalangan"),
        t("Bandar Sei Kijang"),
        t("Bunut"),
        t("Kerumutan"),
        t("Kuala Kampar"),
        t("Langgam"),
        t("Pangkalan Kerinci"),
        t("Pangkalan Kuras"),
        t("Pangkalan Lesung"),
        t("Pelalawan"),
        t("Teluk Meranti"),
        t("Ukui"),
      )),
      "Rokan Hilir" => drupal_map_assoc(array(
        t("Bagan Sinembah"),
        t("Bangko"),
        t("Bangko Pusaka (Pusako)"),
        t("Batu Hampar"),
        t("Kubu"),
        t("Kubu Babussalam"),
        t("Pasir Limau Kapas"),
        t("Pekaitan"),
        t("Pujud"),
        t("Rantau Kopar"),
        t("Rimba Melintang"),
        t("Simpang Kanan"),
        t("Sinaboi (Senaboi)"),
        t("Tanah Putih"),
        t("Tanah Putih Tanjung Melawan"),
      )),
      "Rokan Hulu" => drupal_map_assoc(array(
        t("Bangun Purba"),
        t("Bonai Darussalam"),
        t("Kabun"),
        t("Kepenuhan"),
        t("Kepenuhan Hulu"),
        t("Kunto Darussalam"),
        t("Pagaran Tapah Darussalam"),
        t("Pendalian IV Koto"),
        t("Rambah"),
        t("Rambah Hilir"),
        t("Rambah Samo"),
        t("Rokan IV Koto"),
        t("Tambusai"),
        t("Tambusai Utara"),
        t("Tandun"),
        t("Ujung Batu"),
      )),
      "Siak" => drupal_map_assoc(array(
        t("Bunga Raya"),
        t("Dayun"),
        t("Kandis"),
        t("Kerinci Kanan"),
        t("Koto Gasib"),
        t("Lubuk Dalam"),
        t("Mempura"),
        t("Minas"),
        t("Pusako"),
        t("Sabak Auh"),
        t("Siak"),
        t("Sungai Apit"),
        t("Sungai Mandau"),
        t("Tualang"),
      )),
    ),
    "Sulawesi Barat" => array(
      "Majene" => drupal_map_assoc(array(
        t("Banggae"),
        t("Banggae Timur"),
        t("Malunda"),
        t("Pamboang"),
        t("Sendana"),
        t("Tammeredo Sendana"),
        t("Tubo (Tubo Sendana)"),
        t("Ulumunda"),
      )),
      "Mamasa" => drupal_map_assoc(array(
        t("Aralle (Arrale)"),
        t("Balla"),
        t("Bambang"),
        t("Buntumalangka"),
        t("Mamasa"),
        t("Mambi"),
        t("Mehalaan"),
        t("Messawa"),
        t("Nosu"),
        t("Pana"),
        t("Rantebulahan Timur"),
        t("Sesena Padang"),
        t("Sumarorong"),
        t("Tabang"),
        t("Tabulahan"),
        t("Tanduk Kalua"),
        t("Tawalian"),
      )),
      "Mamuju" => drupal_map_assoc(array(
        t("Bonehau"),
        t("Budong-Budong"),
        t("Kalukku"),
        t("Kalumpang"),
        t("Karossa"),
        t("Kep. Bala Balakang"),
        t("Mamuju"),
        t("Pangale"),
        t("Papalang"),
        t("Sampaga"),
        t("Simboro dan Kepulauan"),
        t("Tapalang"),
        t("Tapalang Barat"),
        t("Tobadak"),
        t("Tommo"),
        t("Topoyo"),
      )),
      "Mamuju Utara" => drupal_map_assoc(array(
        t("Bambaira"),
        t("Bambalamotu"),
        t("Baras"),
        t("Bulu Taba"),
        t("Dapurang"),
        t("Duripoku"),
        t("Lariang"),
        t("Pasangkayu"),
        t("Pedongga"),
        t("Sarjo"),
        t("Sarudu"),
        t("Tikke Raya"),
      )),
      "Polewali Mandar" => drupal_map_assoc(array(
        t("Alu (Allu)"),
        t("Anreapi"),
        t("Balanipa"),
        t("Binuang"),
        t("Bulo"),
        t("Campalagian"),
        t("Limboro"),
        t("Luyo"),
        t("Mapilli"),
        t("Matakali"),
        t("Matangnga"),
        t("Polewali"),
        t("Tapango"),
        t("Tinambung"),
        t("Tubbi Taramanu (Tutar/Tutallu)"),
        t("Wonomulyo"),
      )),
    ),
    "Sulawesi Selatan" => array(
      "Bantaeng" => drupal_map_assoc(array(
        t("Bantaeng"),
        t("Bissappu"),
        t("Eremerasa"),
        t("Gantarang Keke (Gantareng Keke)"),
        t("Pajukukang"),
        t("Sinoa"),
        t("Tompobulu"),
        t("Uluere"),
      )),
      "Barru" => drupal_map_assoc(array(
        t("Balusu"),
        t("Barru"),
        t("Mallusetasi"),
        t("Pujananting"),
        t("Soppeng Riaja"),
        t("Tanete Riaja"),
        t("Tanete Rilau"),
      )),
      "Bone" => drupal_map_assoc(array(
        t("Ajangale"),
        t("Amali"),
        t("Awangpone"),
        t("Barebbo"),
        t("Bengo"),
        t("Bontocani"),
        t("Cenrana"),
        t("Cina"),
        t("Dua Boccoe"),
        t("Kahu"),
        t("Kajuara"),
        t("Lamuru"),
        t("Lappariaja"),
        t("Libureng"),
        t("Mare"),
        t("Palakka"),
        t("Patimpeng"),
        t("Ponre"),
        t("Salomekko"),
        t("Sibulue"),
        t("Tanete Riattang"),
        t("Tanete Riattang Barat"),
        t("Tanete Riattang Timur"),
        t("Tellu Limpoe"),
        t("Tellu Siattinge"),
        t("Tonra"),
        t("Ulaweng"),
      )),
      "Bulukumba" => drupal_map_assoc(array(
        t("Bonto Bahari"),
        t("Bontotiro"),
        t("Bulukumba (Bulukumpa)"),
        t("Gantorang/Gantarang (Gangking)"),
        t("Hero Lange-Lange (Herlang)"),
        t("Kajang"),
        t("Kindang"),
        t("Rilau Ale"),
        t("Ujung Bulu"),
        t("Ujung Loe"),
      )),
      "Enrekang" => drupal_map_assoc(array(
        t("Alla"),
        t("Anggeraja"),
        t("Baraka"),
        t("Baroko"),
        t("Bungin"),
        t("Buntu Batu"),
        t("Cendana"),
        t("Curio"),
        t("Enrekang"),
        t("Maiwa"),
        t("Malua"),
        t("Masalle"),
      )),
      "Gowa" => drupal_map_assoc(array(
        t("Bajeng"),
        t("Bajeng Barat"),
        t("Barombong"),
        t("Biringbulu"),
        t("Bontolempangang"),
        t("Bontomarannu"),
        t("Bontonompo"),
        t("Bontonompo Selatan"),
        t("Bungaya"),
        t("Manuju"),
        t("Pallangga"),
        t("Parangloe"),
        t("Parigi"),
        t("Pattallassang"),
        t("Somba Opu (Upu)"),
        t("Tinggimoncong"),
        t("Tombolo Pao"),
        t("Tompobulu"),
      )),
      "Jeneponto" => drupal_map_assoc(array(
        t("Arungkeke"),
        t("Bangkala"),
        t("Bangkala Barat"),
        t("Batang"),
        t("Binamu"),
        t("Bontoramba"),
        t("Kelara"),
        t("Rumbia"),
        t("Tamalatea"),
        t("Tarowang"),
        t("Turatea"),
      )),
      "Luwu" => drupal_map_assoc(array(
        t("Bajo"),
        t("Bajo Barat"),
        t("Basse Sangtempe Utara"),
        t("Bassesang Tempe (Bastem)"),
        t("Belopa"),
        t("Belopa Utara"),
        t("Bua"),
        t("Bua Ponrang (Bupon)"),
        t("Kamanre"),
        t("Lamasi"),
        t("Lamasi Timur"),
        t("Larompong"),
        t("Larompong Selatan"),
        t("Latimojong"),
        t("Ponrang"),
        t("Ponrang Selatan"),
        t("Suli"),
        t("Suli Barat"),
        t("Walenrang"),
        t("Walenrang Barat"),
        t("Walenrang Timur"),
        t("Walenrang Utara"),
      )),
      "Luwu Timur" => drupal_map_assoc(array(
        t("Angkona"),
        t("Burau"),
        t("Kalaena"),
        t("Malili"),
        t("Mangkutana"),
        t("Nuha"),
        t("Tomoni"),
        t("Tomoni Timur"),
        t("Towuti"),
        t("Wasuponda"),
        t("Wotu"),
      )),
      "Luwu Utara" => drupal_map_assoc(array(
        t("Baebunta"),
        t("Bone-Bone"),
        t("Limbong"),
        t("Malangke"),
        t("Malangke Barat"),
        t("Mappedeceng"),
        t("Masamba"),
        t("Rampi"),
        t("Sabbang"),
        t("Seko"),
        t("Sukamaju"),
        t("Tana Lili"),
      )),
      "Makassar" => drupal_map_assoc(array(
        t("Biring Kanaya"),
        t("Bontoala"),
        t("Makassar"),
        t("Mamajang"),
        t("Manggala"),
        t("Mariso"),
        t("Panakkukang"),
        t("Rappocini"),
        t("Tallo"),
        t("Tamalanrea"),
        t("Tamalate"),
        t("Ujung Pandang"),
        t("Ujung Tanah"),
        t("Wajo"),
      )),
      "Maros" => drupal_map_assoc(array(
        t("Bantimurung"),
        t("Bontoa (Maros Utara)"),
        t("Camba"),
        t("Cenrana"),
        t("Lau"),
        t("Mallawa"),
        t("Mandai"),
        t("Maros Baru"),
        t("Marusu"),
        t("Moncongloe"),
        t("Simbang"),
        t("Tanralili"),
        t("Tompu Bulu"),
        t("Turikale"),
      )),
      "Palopo" => drupal_map_assoc(array(
        t("Bara"),
        t("Mungkajang"),
        t("Sendana"),
        t("Telluwanua"),
        t("Wara"),
        t("Wara Barat"),
        t("Wara Selatan"),
        t("Wara Timur"),
        t("Wara Utara"),
      )),
      "Pangkajene Kepulauan" => drupal_map_assoc(array(
        t("Balocci"),
        t("Bungoro"),
        t("Labakkang"),
        t("Liukang Kalmas (Kalukuang Masalima)"),
        t("Liukang Tangaya"),
        t("Liukang Tupabbiring"),
        t("Liukang Tupabbiring Utara"),
        t("Mandalle"),
        t("Marang (Ma Rang)"),
        t("Minasa Tene"),
        t("Pangkajene"),
        t("Segeri"),
        t("Tondong Tallasa"),
      )),
      "Parepare" => drupal_map_assoc(array(
        t("Bacukiki"),
        t("Bacukiki Barat"),
        t("Soreang"),
        t("Ujung"),
      )),
      "Pinrang" => drupal_map_assoc(array(
        t("Batulappa"),
        t("Cempa"),
        t("Duampanua"),
        t("Lanrisang"),
        t("Lembang"),
        t("Mattiro Bulu"),
        t("Mattiro Sompe"),
        t("Paleteang"),
        t("Patampanua"),
        t("Suppa"),
        t("Tiroang"),
        t("Watang Sawitto"),
      )),
      "Selayar (Kepulauan Selayar)" => drupal_map_assoc(array(
        t("Benteng"),
        t("Bontoharu"),
        t("Bontomanai"),
        t("Bontomatene"),
        t("Bontosikuyu"),
        t("Buki"),
        t("Pasilambena"),
        t("Pasimarannu"),
        t("Pasimassunggu"),
        t("Pasimasunggu Timur"),
        t("Takabonerate"),
      )),
      "Sidenreng Rappang/Rapang" => drupal_map_assoc(array(
        t("Baranti"),
        t("Dua Pitue"),
        t("Kulo"),
        t("Maritengngae"),
        t("Panca Lautan (Lautang)"),
        t("Panca Rijang"),
        t("Pitu Raise/Riase"),
        t("Pitu Riawa"),
        t("Tellu Limpoe"),
        t("Watang Pulu"),
        t("Wattang Sidenreng (Watang Sidenreng)"),
      )),
      "Sinjai" => drupal_map_assoc(array(
        t("Bulupoddo"),
        t("Pulau Sembilan"),
        t("Sinjai Barat"),
        t("Sinjai Borong"),
        t("Sinjai Selatan"),
        t("Sinjai Tengah"),
        t("Sinjai Timur"),
        t("Sinjai Utara"),
        t("Tellu Limpoe"),
      )),
      "Soppeng" => drupal_map_assoc(array(
        t("Citta"),
        t("Donri-Donri"),
        t("Ganra"),
        t("Lalabata"),
        t("Lili Rilau"),
        t("Liliraja (Lili Riaja)"),
        t("Mario Riawa"),
        t("Mario Riwawo"),
      )),
      "Takalar" => drupal_map_assoc(array(
        t("Galesong"),
        t("Galesong Selatan"),
        t("Galesong Utara"),
        t("Mangara Bombang"),
        t("Mappakasunggu"),
        t("Patallassang"),
        t("Polombangkeng Selatan (Polobangkeng)"),
        t("Polombangkeng Utara (Polobangkeng)"),
        t("Sanrobone"),
      )),
      "Tana Toraja" => drupal_map_assoc(array(
        t("Bittuang"),
        t("Bonggakaradeng"),
        t("Gandang Batu Sillanan"),
        t("Kurra"),
        t("Makale"),
        t("Makale Selatan"),
        t("Makale Utara"),
        t("Malimbong Balepe"),
        t("Mappak"),
        t("Masanda"),
        t("Mengkendek"),
        t("Rano"),
        t("Rantetayo"),
        t("Rembon"),
        t("Saluputti"),
        t("Sangalla (Sanggala)"),
        t("Sangalla Selatan"),
        t("Sangalla Utara"),
        t("Simbuang"),
      )),
      "Toraja Utara" => drupal_map_assoc(array(
        t("Awan Rante Karua"),
        t("Balusu"),
        t("Bangkelekila"),
        t("Baruppu"),
        t("Buntao"),
        t("Buntu Pepasan"),
        t("Dende' Piongan Napo"),
        t("Kapalla Pitu (Kapala Pitu)"),
        t("Kesu"),
        t("Nanggala"),
        t("Rantebua"),
        t("Rantepao"),
        t("Rindingallo"),
        t("Sa'dan"),
        t("Sanggalangi"),
        t("Sesean"),
        t("Sesean Suloara"),
        t("Sopai"),
        t("Tallunglipu"),
        t("Tikala"),
        t("Tondon"),
      )),
      "Wajo" => drupal_map_assoc(array(
        t("Belawa"),
        t("Bola"),
        t("Gilireng"),
        t("Keera"),
        t("Majauleng"),
        t("Maniang Pajo"),
        t("Pammana"),
        t("Penrang"),
        t("Pitumpanua"),
        t("Sabbang Paru"),
        t("Sajoanging"),
        t("Takkalalla"),
        t("Tana Sitolo"),
        t("Tempe"),
      )),
    ),
    "Sulawesi Tengah" => array(
      "Banggai" => drupal_map_assoc(array(
        t("Balantak"),
        t("Balantak Selatan"),
        t("Balantak Utara"),
        t("Batui"),
        t("Batui Selatan"),
        t("Bualemo (Boalemo)"),
        t("Bunta"),
        t("Kintom"),
        t("Lamala"),
        t("Lobu"),
        t("Luwuk"),
        t("Luwuk Selatan"),
        t("Luwuk Timur"),
        t("Luwuk Utara"),
        t("Mantoh"),
        t("Masama"),
        t("Moilong"),
        t("Nambo"),
        t("Nuhon"),
        t("Pagimana"),
        t("Simpang Raya"),
        t("Toili"),
        t("Toili Barat"),
      )),
      "Banggai Kepulauan" => drupal_map_assoc(array(
        t("Banggai"),
        t("Banggai Selatan"),
        t("Banggai Tengah"),
        t("Banggai Utara"),
        t("Bangkurung"),
        t("Bokan Kepulauan"),
        t("Buko"),
        t("Buko Selatan"),
        t("Bulagi"),
        t("Bulagi Selatan"),
        t("Bulagi Utara"),
        t("Labobo (Lobangkurung)"),
        t("Liang"),
        t("Peling Tengah"),
        t("Tinangkung"),
        t("Tinangkung Selatan"),
        t("Tinangkung Utara"),
        t("Totikum (Totikung)"),
        t("Totikum Selatan"),
      )),
      "Buol" => drupal_map_assoc(array(
        t("Biau"),
        t("Bokat"),
        t("Bukal"),
        t("Bunobogu"),
        t("Gadung"),
        t("Karamat"),
        t("Lakea (Lipunoto)"),
        t("Momunu"),
        t("Paleleh"),
        t("Paleleh Barat"),
        t("Tiloan"),
      )),
      "Donggala" => drupal_map_assoc(array(
        t("Balaesang"),
        t("Balaesang Tanjung"),
        t("Banawa"),
        t("Banawa Selatan"),
        t("Banawa Tengah"),
        t("Damsol (Dampelas Sojol)"),
        t("Labuan"),
        t("Pinembani"),
        t("Rio Pakava (Riopakawa)"),
        t("Sindue"),
        t("Sindue Tobata"),
        t("Sindue Tombusabora"),
        t("Sirenja"),
        t("Sojol"),
        t("Sojol Utara"),
        t("Tanantovea"),
      )),
      "Morowali" => drupal_map_assoc(array(
        t("Bahodopi"),
        t("Bumi Raya"),
        t("Bungku Barat"),
        t("Bungku Pesisir"),
        t("Bungku Selatan"),
        t("Bungku Tengah"),
        t("Bungku Timur"),
        t("Bungku Utara"),
        t("Lembo"),
        t("Lembo Raya"),
        t("Mamosalato"),
        t("Menui Kepulauan"),
        t("Mori Atas"),
        t("Mori Utara"),
        t("Petasia"),
        t("Petasia Barat"),
        t("Petasia Timur"),
        t("Soyo Jaya"),
        t("Wita Ponda"),
      )),
      "Palu" => drupal_map_assoc(array(
        t("Mantikulore"),
        t("Palu Barat"),
        t("Palu Selatan"),
        t("Palu Timur"),
        t("Palu Utara"),
        t("Tatanga"),
        t("Tawaeli"),
        t("Ulujadi"),
      )),
      "Parigi Moutong" => drupal_map_assoc(array(
        t("Ampibabo"),
        t("Balinggi"),
        t("Bolano"),
        t("Bolano Lambunu/Lambulu"),
        t("Kasimbar"),
        t("Mepanga"),
        t("Moutong"),
        t("Ongka Malino"),
        t("Palasa"),
        t("Parigi"),
        t("Parigi Barat"),
        t("Parigi Selatan"),
        t("Parigi Tengah"),
        t("Parigi Utara"),
        t("Sausu"),
        t("Siniu"),
        t("Taopa"),
        t("Tinombo"),
        t("Tinombo Selatan"),
        t("Tomini"),
        t("Toribulu"),
        t("Torue"),
      )),
      "Poso" => drupal_map_assoc(array(
        t("Lage"),
        t("Lore Barat"),
        t("Lore Piore"),
        t("Lore Selatan"),
        t("Lore Tengah"),
        t("Lore Timur"),
        t("Lore Utara"),
        t("Pamona Barat"),
        t("Pamona Puselemba"),
        t("Pamona Selatan"),
        t("Pamona Tenggara"),
        t("Pamona Timur"),
        t("Pamona Utara"),
        t("Poso Kota"),
        t("Poso Kota Selatan"),
        t("Poso Kota Utara"),
        t("Poso Pesisir"),
        t("Poso Pesisir Selatan"),
        t("Poso Pesisir Utara"),
      )),
      "Sigi" => drupal_map_assoc(array(
        t("Dolo"),
        t("Dolo Barat"),
        t("Dolo Selatan"),
        t("Gumbasa"),
        t("Kinovaru"),
        t("Kulawi"),
        t("Kulawi Selatan"),
        t("Lindu"),
        t("Marawola"),
        t("Marawola Barat"),
        t("Nokilalaki"),
        t("Palolo"),
        t("Pipikoro"),
        t("Sigi Biromaru"),
        t("Tanambulava"),
      )),
      "Tojo Una-Una" => drupal_map_assoc(array(
        t("Ampana Kota"),
        t("Ampana Tete"),
        t("Togean"),
        t("Tojo"),
        t("Tojo Barat"),
        t("Ulu Bongka"),
        t("Una - Una"),
        t("Walea Besar"),
        t("Walea Kepulauan"),
      )),
      "Toli-Toli" => drupal_map_assoc(array(
        t("Baolan"),
        t("Basidondo"),
        t("Dako Pamean"),
        t("Dampal Selatan"),
        t("Dampal Utara"),
        t("Dondo"),
        t("Galang"),
        t("Lampasio"),
        t("Ogo Deide"),
        t("Tolitoli Utara"),
      )),
    ),
    "Sulawesi Tenggara" => array(
      "Bau-Bau" => drupal_map_assoc(array(
        t("Batupoaro"),
        t("Betoambari"),
        t("Bungi"),
        t("Kokalukuna"),
        t("Lea-Lea"),
        t("Murhum"),
        t("Sora Walio (Sorowalio)"),
        t("Wolio"),
      )),
      "Bombana" => drupal_map_assoc(array(
        t("Kabaena"),
        t("Kabaena Barat"),
        t("Kabaena Selatan"),
        t("Kabaena Tengah"),
        t("Kabaena Timur"),
        t("Kabaena Utara"),
        t("Kepulauan Masaloka Raya"),
        t("Lentarai Jaya S. (Lantari Jaya)"),
        t("Mata Oleo"),
        t("Mata Usu"),
        t("Poleang"),
        t("Poleang Barat"),
        t("Poleang Selatan"),
        t("Poleang Tengah"),
        t("Poleang Tenggara"),
        t("Poleang Timur"),
        t("Poleang Utara"),
        t("Rarowatu"),
        t("Rarowatu Utara"),
        t("Rumbia"),
        t("Rumbia Tengah"),
        t("Tontonunu (Tontonuwu)"),
      )),
      "Buton" => drupal_map_assoc(array(
        t("Batauga"),
        t("Batu Atas"),
        t("Gu"),
        t("Kadatua"),
        t("Kapontori"),
        t("Lakudo"),
        t("Lapandewa"),
        t("Lasalimu"),
        t("Lasalimu Selatan"),
        t("Mawasangka"),
        t("Mawasangka Tengah"),
        t("Mawasangka Timur"),
        t("Pasar Wajo"),
        t("Sampolawa"),
        t("Sangia Mambulu"),
        t("Siompu"),
        t("Siompu Barat"),
        t("Siontapia (Siontapina)"),
        t("Talaga Raya (Telaga Raya)"),
        t("Wabula"),
        t("Wolowa"),
      )),
      "Buton Utara" => drupal_map_assoc(array(
        t("Bonegunu"),
        t("Kambowa"),
        t("Kulisusu (Kalingsusu/Kalisusu)"),
        t("Kulisusu Barat"),
        t("Kulisusu Utara"),
        t("Wakorumba Utara"),
      )),
      "Kendari" => drupal_map_assoc(array(
        t("Abeli"),
        t("Baruga"),
        t("Kadia"),
        t("Kambu"),
        t("Kendari"),
        t("Kendari Barat"),
        t("Mandonga"),
        t("Poasia"),
        t("Puuwatu"),
        t("Wua-Wua"),
      )),
      "Kolaka" => drupal_map_assoc(array(
        t("Baula"),
        t("Kolaka"),
        t("Ladongi"),
        t("Lalolae"),
        t("Lambandia (Lambadia)"),
        t("Latambaga"),
        t("Loea"),
        t("Mowewe"),
        t("Poli Polia"),
        t("Polinggona"),
        t("Pomalaa"),
        t("Samaturu"),
        t("Tanggetada"),
        t("Tinondo"),
        t("Tirawuta"),
        t("Toari"),
        t("Uluiwoi"),
        t("Watumbangga (Watubanggo)"),
        t("Wolo"),
        t("Wundulako"),
      )),
      "Kolaka Utara" => drupal_map_assoc(array(
        t("Batu Putih"),
        t("Katoi"),
        t("Kodeoha"),
        t("Lasusua"),
        t("Lombai (Lambai)"),
        t("Ngapa"),
        t("Pakue"),
        t("Pakue Tengah"),
        t("Pakue Utara"),
        t("Porehu"),
        t("Ranteangin"),
        t("Tiwu"),
        t("Tolala"),
        t("Watunohu"),
        t("Wawo"),
      )),
      "Konawe" => drupal_map_assoc(array(
        t("Abuki"),
        t("Amonggedo"),
        t("Anggaberi"),
        t("Asinua"),
        t("Besulutu"),
        t("Bondoala"),
        t("Kapoiala (Kapoyala)"),
        t("Konawe"),
        t("Lalonggasumeeto"),
        t("Lambuya"),
        t("Latoma"),
        t("Meluhu"),
        t("Onembute"),
        t("Pondidaha"),
        t("Puriala"),
        t("Routa"),
        t("Sampara"),
        t("Soropia"),
        t("Tongauna"),
        t("Uepai (Uwepai)"),
        t("Unaaha"),
        t("Wawonii Barat"),
        t("Wawonii Selatan"),
        t("Wawonii Tengah"),
        t("Wawonii Tenggara"),
        t("Wawonii Timur"),
        t("Wawonii Timur Laut"),
        t("Wawonii Utara"),
        t("Wawotobi"),
        t("Wonggeduku"),
      )),
      "Konawe Selatan" => drupal_map_assoc(array(
        t("Andoolo"),
        t("Angata"),
        t("Baito"),
        t("Basala"),
        t("Benua"),
        t("Buke"),
        t("Kolono"),
        t("Konda"),
        t("Laeya"),
        t("Lainea"),
        t("Lalembuu / Lalumbuu"),
        t("Landono"),
        t("Laonti"),
        t("Moramo"),
        t("Moramo Utara"),
        t("Mowila"),
        t("Palangga"),
        t("Palangga Selatan"),
        t("Ranomeeto"),
        t("Ranomeeto Barat"),
        t("Tinanggea"),
        t("Wolasi"),
      )),
      "Konawe Utara" => drupal_map_assoc(array(
        t("Andowia"),
        t("Asera"),
        t("Langgikima"),
        t("Lasolo"),
        t("Lembo"),
        t("Molawe"),
        t("Motui"),
        t("Oheo"),
        t("Sawa"),
        t("Wiwirano"),
      )),
      "Muna" => drupal_map_assoc(array(
        t("Barangka"),
        t("Batalaiwaru (Batalaiworu)"),
        t("Batukara"),
        t("Bone (Bone Tondo)"),
        t("Duruka"),
        t("Kabangka"),
        t("Kabawo"),
        t("Katobu"),
        t("Kontu Kowuna"),
        t("Kontunaga"),
        t("Kusambi"),
        t("Lasalepa"),
        t("Lawa"),
        t("Lohia"),
        t("Maginti"),
        t("Maligano"),
        t("Marobo"),
        t("Napabalano"),
        t("Napano Kusambi"),
        t("Parigi"),
        t("Pasi Kolaga"),
        t("Pasir Putih"),
        t("Sawerigadi (Sawerigading/Sewergadi)"),
        t("Tiworo Kepulauan"),
        t("Tiworo Selatan"),
        t("Tiworo Tengah"),
        t("Tiworo Utara"),
        t("Tongkuno"),
        t("Tongkuno Selatan"),
        t("Towea"),
        t("Wa Daga"),
        t("Wakorumba Selatan"),
        t("Watopute"),
      )),
      "Wakatobi" => drupal_map_assoc(array(
        t("Binongko"),
        t("Kaledupa"),
        t("Kaledupa Selatan"),
        t("Togo Binongko"),
        t("Tomia"),
        t("Tomia Timur"),
        t("Wangi-Wangi"),
        t("Wangi-Wangi Selatan"),
      )),
    ),
    "Sulawesi Utara" => array(
      "Bitung" => drupal_map_assoc(array(
        t("Aertembaga (Bitung Timur)"),
        t("Girian"),
        t("Lembeh Selatan (Bitung Selatan)"),
        t("Lembeh Utara"),
        t("Madidir (Bitung Tengah)"),
        t("Maesa"),
        t("Matuari (Bitung Barat)"),
        t("Ranowulu (Bitung Utara)"),
      )),
      "Bolaang Mongondow (Bolmong)" => drupal_map_assoc(array(
        t("Bilalang"),
        t("Bolaang"),
        t("Bolaang Timur"),
        t("Dumoga"),
        t("Dumoga Barat"),
        t("Dumoga Tengah"),
        t("Dumoga Tenggara"),
        t("Dumoga Timur"),
        t("Dumoga Utara"),
        t("Lolak"),
        t("Lolayan"),
        t("Passi Barat"),
        t("Passi Timur"),
        t("Poigar"),
        t("Sangtombolang"),
      )),
      "Bolaang Mongondow Selatan" => drupal_map_assoc(array(
        t("Bolaang Uki"),
        t("Pinolosian"),
        t("Pinolosian Tengah"),
        t("Pinolosian Timur"),
        t("Posigadan"),
      )),
      "Bolaang Mongondow Timur" => drupal_map_assoc(array(
        t("Kotabunan"),
        t("Modayag"),
        t("Modayag Barat"),
        t("Nuangan"),
        t("Tutuyan"),
      )),
      "Bolaang Mongondow Utara" => drupal_map_assoc(array(
        t("Bintauna"),
        t("Bolang Itang Barat"),
        t("Bolang Itang Timur"),
        t("Kaidipang"),
        t("Pinogaluman"),
        t("Sangkub"),
      )),
      "Kepulauan Sangihe" => drupal_map_assoc(array(
        t("Kendahe"),
        t("Kepulauan Marore"),
        t("Manganitu"),
        t("Manganitu Selatan"),
        t("Nusa Tabukan"),
        t("Tabukan Selatan"),
        t("Tabukan Selatan Tengah"),
        t("Tabukan Selatan Tenggara"),
        t("Tabukan Tengah"),
        t("Tabukan Utara"),
        t("Tahuna"),
        t("Tahuna Barat"),
        t("Tahuna Timur"),
        t("Tamako"),
        t("Tatoareng"),
      )),
      "Kepulauan Siau Tagulandang Biaro (Sitaro)" => drupal_map_assoc(array(
        t("Biaro"),
        t("Siau Barat"),
        t("Siau Barat Selatan"),
        t("Siau Barat Utara"),
        t("Siau Tengah"),
        t("Siau Timur"),
        t("Siau Timur Selatan"),
        t("Tagulandang"),
        t("Tagulandang Selatan"),
        t("Tagulandang Utara"),
      )),
      "Kepulauan Talaud" => drupal_map_assoc(array(
        t("Beo"),
        t("Beo Selatan"),
        t("Beo Utara"),
        t("Damao (Damau)"),
        t("Essang"),
        t("Essang Selatan"),
        t("Gemeh"),
        t("Kabaruan"),
        t("Kalongan"),
        t("Lirung"),
        t("Melonguane"),
        t("Melonguane Timur"),
        t("Miangas"),
        t("Moronge"),
        t("Nanusa"),
        t("Pulutan"),
        t("Rainis"),
        t("Salibabu"),
        t("Tampan Amma"),
      )),
      "Kotamobagu" => drupal_map_assoc(array(
        t("Kotamobagu Barat"),
        t("Kotamobagu Selatan"),
        t("Kotamobagu Timur"),
        t("Kotamobagu Utara"),
      )),
      "Manado" => drupal_map_assoc(array(
        t("Bunaken"),
        t("Bunaken Kepulauan"),
        t("Malalayang"),
        t("Mapanget"),
        t("Paal Dua"),
        t("Sario"),
        t("Singkil"),
        t("Tikala"),
        t("Tuminiting"),
        t("Wanea"),
        t("Wenang"),
      )),
      "Minahasa" => drupal_map_assoc(array(
        t("Eris"),
        t("Kakas"),
        t("Kakas Barat"),
        t("Kawangkoan"),
        t("Kawangkoan Barat"),
        t("Kawangkoan Utara"),
        t("Kombi"),
        t("Langowan Barat"),
        t("Langowan Selatan"),
        t("Langowan Timur"),
        t("Langowan Utara"),
        t("Lembean Timur"),
        t("Mandolang"),
        t("Pineleng"),
        t("Remboken"),
        t("Sonder"),
        t("Tombariri"),
        t("Tombariri Timur"),
        t("Tombulu"),
        t("Tompaso"),
        t("Tompaso Barat"),
        t("Tondano Barat"),
        t("Tondano Selatan"),
        t("Tondano Timur"),
        t("Tondano Utara"),
      )),
      "Minahasa Selatan" => drupal_map_assoc(array(
        t("Amurang"),
        t("Amurang Barat"),
        t("Amurang Timur"),
        t("Kumelembuai"),
        t("Maesaan"),
        t("Modoinding"),
        t("Motoling"),
        t("Motoling Barat"),
        t("Motoling Timur"),
        t("Ranoyapo"),
        t("Sinonsayang"),
        t("Suluun Tareran"),
        t("Tareran"),
        t("Tatapaan"),
        t("Tenga"),
        t("Tompaso Baru"),
        t("Tumpaan"),
      )),
      "Minahasa Tenggara" => drupal_map_assoc(array(
        t("Belang"),
        t("Pasan"),
        t("Pusomaen"),
        t("Ratahan"),
        t("Ratahan Timur"),
        t("Ratatotok"),
        t("Silian Raya"),
        t("Tombatu"),
        t("Tombatu Timur"),
        t("Tombatu Utara"),
        t("Touluaan"),
        t("Touluaan Selatan"),
      )),
      "Minahasa Utara" => drupal_map_assoc(array(
        t("Airmadidi"),
        t("Dimembe"),
        t("Kalawat"),
        t("Kauditan"),
        t("Kema"),
        t("Likupang Barat"),
        t("Likupang Selatan"),
        t("Likupang Timur"),
        t("Talawaan"),
        t("Wori"),
      )),
      "Tomohon" => drupal_map_assoc(array(
        t("Tomohon Barat"),
        t("Tomohon Selatan"),
        t("Tomohon Tengah"),
        t("Tomohon Timur"),
        t("Tomohon Utara"),
      )),
    ),
    "Sumatera Barat" => array(
      "Agam" => drupal_map_assoc(array(
        t("Ampek Nagari (IV Nagari )"),
        t("Banuhampu"),
        t("Baso"),
        t("Candung"),
        t("IV Angkat Candung (Ampek Angkek)"),
        t("IV Koto (Ampek Koto)"),
        t("Kamang Magek"),
        t("Lubuk Basung"),
        t("Malakak"),
        t("Matur"),
        t("Palembayan"),
        t("Palupuh"),
        t("Sungai Pua (Puar)"),
        t("Tanjung Mutiara"),
        t("Tanjung Raya"),
        t("Tilatang Kamang"),
      )),
      "Bukittinggi" => drupal_map_assoc(array(
        t("Aur Birugo Tigo Baleh"),
        t("Guguk Panjang (Guguak Panjang)"),
        t("Mandiangin Koto Selayan"),
      )),
      "Dharmasraya" => drupal_map_assoc(array(
        t("Asam Jujuhan"),
        t("Koto Baru"),
        t("Koto Besar"),
        t("Koto Salak"),
        t("Padang Laweh"),
        t("Pulau Punjung"),
        t("Sembilan Koto (IX Koto)"),
        t("Sitiung"),
        t("Sungai Rumbai"),
        t("Timpeh"),
        t("Tiumang"),
      )),
      "Kepulauan Mentawai" => drupal_map_assoc(array(
        t("Pagai Selatan"),
        t("Pagai Utara"),
        t("Siberut Barat"),
        t("Siberut Barat Daya"),
        t("Siberut Selatan"),
        t("Siberut Tengah"),
        t("Siberut Utara"),
        t("Sikakap"),
        t("Sipora Selatan"),
        t("Sipora Utara"),
      )),
      "Lima Puluh Koto/Kota" => drupal_map_assoc(array(
        t("Akabiluru"),
        t("Bukik Barisan"),
        t("Guguak (Gugu)"),
        t("Gunuang Omeh (Gunung Mas)"),
        t("Harau"),
        t("Kapur IX/Sembilan"),
        t("Lareh Sago Halaban"),
        t("Luak (Luhak)"),
        t("Mungka"),
        t("Pangkalan Koto Baru"),
        t("Payakumbuh"),
        t("Situjuah Limo/Lima Nagari"),
        t("Suliki"),
      )),
      "Padang" => drupal_map_assoc(array(
        t("Bungus Teluk Kabung"),
        t("Koto Tangah"),
        t("Kuranji"),
        t("Lubuk Begalung"),
        t("Lubuk Kilangan"),
        t("Nanggalo"),
        t("Padang Barat"),
        t("Padang Selatan"),
        t("Padang Timur"),
        t("Padang Utara"),
        t("Pauh"),
      )),
      "Padang Panjang" => drupal_map_assoc(array(
        t("Padang Panjang Barat"),
        t("Padang Panjang Timur"),
      )),
      "Padang Pariaman" => drupal_map_assoc(array(
        t("2 X 11 Enam Lingkung"),
        t("2 X 11 Kayu Tanam"),
        t("Batang Anai"),
        t("Batang Gasan"),
        t("Enam Lingkung"),
        t("IV Koto Aur Malintang"),
        t("Lubuk Alung"),
        t("Nan Sabaris"),
        t("Padang Sago"),
        t("Patamuan"),
        t("Sintuk/Sintuak Toboh Gadang"),
        t("Sungai Geringging/Garingging"),
        t("Sungai Limau"),
        t("Ulakan Tapakih/Tapakis"),
        t("V Koto Kampung Dalam"),
        t("V Koto Timur"),
        t("VII Koto Sungai Sarik"),
      )),
      "Pariaman" => drupal_map_assoc(array(
        t("Pariaman Selatan"),
        t("Pariaman Tengah"),
        t("Pariaman Timur"),
        t("Pariaman Utara"),
      )),
      "Pasaman" => drupal_map_assoc(array(
        t("Bonjol"),
        t("Duo Koto (II Koto)"),
        t("Lubuk Sikaping"),
        t("Mapat Tunggul"),
        t("Mapat Tunggul Selatan"),
        t("Padang Gelugur"),
        t("Panti"),
        t("Rao"),
        t("Rao Selatan"),
        t("Rao Utara"),
        t("Simpang Alahan Mati"),
        t("Tigo Nagari (III Nagari)"),
      )),
      "Pasaman Barat" => drupal_map_assoc(array(
        t("Gunung Tuleh"),
        t("Kinali"),
        t("Koto Balingka"),
        t("Lembah Melintang"),
        t("Luhak Nan Duo"),
        t("Pasaman"),
        t("Ranah Batahan"),
        t("Sasak Ranah Pasisir/Pesisie"),
        t("Sei Beremas"),
        t("Sungai Aur"),
        t("Talamau"),
      )),
      "Payakumbuh" => drupal_map_assoc(array(
        t("Lamposi Tigo Nagari"),
        t("Payakumbuh Barat"),
        t("Payakumbuh Selatan"),
        t("Payakumbuh Timur"),
        t("Payakumbuh Utara"),
      )),
      "Pesisir Selatan" => drupal_map_assoc(array(
        t("Airpura"),
        t("Basa Ampek Balai Tapan"),
        t("Batang Kapas"),
        t("Bayang"),
        t("IV Jurai"),
        t("IV Nagari Bayang Utara"),
        t("Koto XI Tarusan"),
        t("Lengayang"),
        t("Linggo Sari Baganti"),
        t("Lunang"),
        t("Pancung Soal"),
        t("Ranah Ampek Hulu Tapan"),
        t("Ranah Pesisir"),
        t("Silaut"),
        t("Sutera"),
      )),
      "Sawah Lunto" => drupal_map_assoc(array(
        t("Barangin"),
        t("Lembah Segar"),
        t("Silungkang"),
        t("Talawi"),
      )),
      "Sijunjung (Sawah Lunto Sijunjung)" => drupal_map_assoc(array(
        t("IV Nagari"),
        t("Kamang Baru"),
        t("Koto VII"),
        t("Kupitan"),
        t("Lubuak Tarok"),
        t("Sijunjung"),
        t("Sumpur Kudus"),
        t("Tanjung Gadang"),
      )),
      "Solok (Kabupaten)" => drupal_map_assoc(array(
        t("Bukit Sundi"),
        t("Danau Kembar"),
        t("Gunung Talang"),
        t("Hiliran Gumanti"),
        t("IX Koto Sei Lasi"),
        t("Junjung Sirih"),
        t("Kubung"),
        t("Lembah Gumanti"),
        t("Lembang Jaya"),
        t("Pantai Cermin"),
        t("Payung Sekaki"),
        t("Tigo Lurah"),
        t("X Koto Diatas"),
        t("X Koto Singkarak"),
      )),
      "Solok (Kota)" => drupal_map_assoc(array(
        t("Lubuk Sikarah"),
        t("Tanjung Harapan"),
      )),
      "Solok Selatan" => drupal_map_assoc(array(
        t("Koto Parik Gadang Diateh"),
        t("Pauh Duo"),
        t("Sangir"),
        t("Sangir Balai Janggo"),
        t("Sangir Batang Hari"),
        t("Sangir Jujuan"),
        t("Sungai Pagu"),
      )),
      "Tanah Datar" => drupal_map_assoc(array(
        t("Batipuh"),
        t("Batipuh Selatan"),
        t("Lima Kaum"),
        t("Lintau Buo"),
        t("Lintau Buo Utara"),
        t("Padang Ganting"),
        t("Pariangan"),
        t("Rambatan"),
        t("Salimpaung"),
        t("Sepuluh Koto (X Koto)"),
        t("Sungai Tarab"),
        t("Sungayang"),
        t("Tanjung Baru"),
        t("Tanjung Emas"),
      )),
    ),
    "Sumatera Selatan" => array(
      "Banyuasin" => drupal_map_assoc(array(
        t("Air Kumbang"),
        t("Air Salek"),
        t("Banyuasin I"),
        t("Banyuasin II"),
        t("Banyuasin III"),
        t("Betung"),
        t("Makarti Jaya"),
        t("Muara Padang"),
        t("Muara Sugihan"),
        t("Muara Telang"),
        t("Pulau Rimau"),
        t("Rambutan"),
        t("Rantau Bayur"),
        t("Sembawa"),
        t("Suak Tapeh"),
        t("Sumber Marga Telang"),
        t("Talang Kelapa"),
        t("Tanjung Lago"),
        t("Tungkal Ilir"),
      )),
      "Empat Lawang" => drupal_map_assoc(array(
        t("Lintang Kanan"),
        t("Muara Pinang"),
        t("Pasemah Air Keruh"),
        t("Pendopo"),
        t("Pendopo Barat"),
        t("Saling"),
        t("Sikap Dalam"),
        t("Talang Padang"),
        t("Tebing Tinggi"),
        t("Ulu Musi"),
      )),
      "Lahat" => drupal_map_assoc(array(
        t("Gumay Talang"),
        t("Gumay Ulu"),
        t("Jarai"),
        t("Kikim Barat"),
        t("Kikim Selatan"),
        t("Kikim Tengah"),
        t("Kikim Timur"),
        t("Kota Agung"),
        t("Lahat"),
        t("Merapi Barat"),
        t("Merapi Selatan"),
        t("Merapi Timur"),
        t("Muarapayang"),
        t("Mulak Ulu"),
        t("Pagar Gunung"),
        t("Pajar Bulan"),
        t("Pseksu"),
        t("Pulau Pinang"),
        t("Sukamerindu"),
        t("Tanjung Sakti Pumi"),
        t("Tanjung Sakti Pumu"),
        t("Tanjung Tebat"),
      )),
      "Lubuk Linggau" => drupal_map_assoc(array(
        t("Lubuk Linggau Barat Dua (II)"),
        t("Lubuk Linggau Barat Satu (I)"),
        t("Lubuk Linggau Selatan Dua (II)"),
        t("Lubuk Linggau Selatan Satu (I)"),
        t("Lubuk Linggau Timur Dua (II)"),
        t("Lubuk Linggau Timur Satu (I)"),
        t("Lubuk Linggau Utara Dua (II)"),
        t("Lubuk Linggau Utara Satu (I)"),
      )),
      "Muara Enim" => drupal_map_assoc(array(
        t("Abab"),
        t("Benakat"),
        t("Gelumbang"),
        t("Gunung Megang"),
        t("Kelekar"),
        t("Lawang Kidul"),
        t("Lembak"),
        t("Lubai"),
        t("Muara Belida"),
        t("Muara Enim"),
        t("Penukal (Penukal Abab)"),
        t("Penukal Utara"),
        t("Rambang"),
        t("Rambang Dangku"),
        t("Semendo Darat Laut"),
        t("Semendo Darat Tengah"),
        t("Semendo Darat Ulu"),
        t("Sungai Rotan"),
        t("Talang Ubi"),
        t("Tanah Abang"),
        t("Tanjung Agung"),
        t("Ujan Mas"),
      )),
      "Musi Banyuasin" => drupal_map_assoc(array(
        t("Babat Supat"),
        t("Babat Toman"),
        t("Batanghari Leko"),
        t("Bayung Lencir"),
        t("Keluang"),
        t("Lais"),
        t("Lalan (Sungai Lalan)"),
        t("Lawang Wetan"),
        t("Plakat Tinggi (Pelakat Tinggi)"),
        t("Sanga Desa"),
        t("Sekayu"),
        t("Sungai Keruh"),
        t("Sungai Lilin"),
        t("Tungkal Jaya"),
      )),
      "Musi Rawas" => drupal_map_assoc(array(
        t("Batukuning Lakitan Ulu (BTS)/Cecar"),
        t("Jaya Loka"),
        t("Karang Dapo"),
        t("Karang Jaya"),
        t("Megang Sakti"),
        t("Muara Beliti"),
        t("Muara Kelingi"),
        t("Muara Lakitan"),
        t("Nibung"),
        t("Purwodadi"),
        t("Rawas Ilir"),
        t("Rawas Ulu"),
        t("Rupit"),
        t("Selangit"),
        t("STL Ulu Terawas"),
        t("Sukakarya"),
        t("Sumber Harta"),
        t("Tiang Pumpung Kepungut"),
        t("Tuah Negeri"),
        t("Tugumulyo"),
        t("Ulu Rawas"),
      )),
      "Ogan Ilir" => drupal_map_assoc(array(
        t("Indralaya"),
        t("Indralaya Selatan"),
        t("Indralaya Utara"),
        t("Kandis"),
        t("Lubuk Keliat"),
        t("Muara Kuang"),
        t("Payaraman"),
        t("Pemulutan"),
        t("Pemulutan Barat"),
        t("Pemulutan Selatan"),
        t("Rambang Kuang"),
        t("Rantau Alai"),
        t("Rantau Panjang"),
        t("Sungai Pinang"),
        t("Tanjung Batu"),
        t("Tanjung Raja"),
      )),
      "Ogan Komering Ilir" => drupal_map_assoc(array(
        t("Air Sugihan"),
        t("Cengal"),
        t("Jejawi"),
        t("Kayu Agung"),
        t("Lempuing"),
        t("Lempuing Jaya"),
        t("Mesuji"),
        t("Mesuji Makmur"),
        t("Mesuji Raya"),
        t("Pampangan"),
        t("Pangkalan Lampam"),
        t("Pedamaran"),
        t("Pedamaran Timur"),
        t("Sirah Pulau Padang"),
        t("Sungai Menang"),
        t("Tanjung Lubuk"),
        t("Teluk Gelam"),
        t("Tulung Selapan"),
      )),
      "Ogan Komering Ulu" => drupal_map_assoc(array(
        t("Baturaja Barat"),
        t("Baturaja Timur"),
        t("Lengkiti"),
        t("Lubuk Batang"),
        t("Lubuk Raja"),
        t("Muara Jaya"),
        t("Pengandonan"),
        t("Peninjauan"),
        t("Semidang Aji"),
        t("Sinar Peninjauan"),
        t("Sosoh Buay Rayap"),
        t("Ulu Ogan"),
      )),
      "Ogan Komering Ulu Selatan" => drupal_map_assoc(array(
        t("Banding Agung"),
        t("Buana Pemaca"),
        t("Buay Pemaca"),
        t("Buay Pematang Ribu Ranau Tengah"),
        t("Buay Rawan"),
        t("Buay Runjung"),
        t("Buay Sandang Aji"),
        t("Kisam Ilir"),
        t("Kisam Tinggi"),
        t("Mekakau Ilir"),
        t("Muaradua"),
        t("Muaradua Kisam"),
        t("Pulau Beringin"),
        t("Runjung Agung"),
        t("Simpang"),
        t("Sindang Danau"),
        t("Sungai Are"),
        t("Tiga Dihaji"),
        t("Warkuk Ranau Selatan"),
      )),
      "Ogan Komering Ulu Timur" => drupal_map_assoc(array(
        t("Belitang"),
        t("Belitang II"),
        t("Belitang III"),
        t("Belitang Jaya"),
        t("Belitang Madang Raya"),
        t("Belitang Mulya"),
        t("Buay Madang"),
        t("Buay Madang Timur"),
        t("Buay Pemuka Bangsa Raja"),
        t("Buay Pemuka Beliung / Peliung"),
        t("Bunga Mayang"),
        t("Cempaka"),
        t("Jayapura"),
        t("Madang Suku I"),
        t("Madang Suku II"),
        t("Madang Suku III"),
        t("Martapura"),
        t("Semendawai Barat"),
        t("Semendawai Suku III"),
        t("Semendawai Timur"),
      )),
      "Pagar Alam" => drupal_map_assoc(array(
        t("Dempo Selatan"),
        t("Dempo Tengah"),
        t("Dempo Utara"),
        t("Pagar Alam Selatan"),
        t("Pagar Alam Utara"),
      )),
      "Palembang" => drupal_map_assoc(array(
        t("Alang-Alang Lebar"),
        t("Bukit Kecil"),
        t("Gandus"),
        t("Ilir Barat I"),
        t("Ilir Barat II"),
        t("Ilir Timur I"),
        t("Ilir Timur II"),
        t("Kalidoni"),
        t("Kemuning"),
        t("Kertapati"),
        t("Plaju"),
        t("Sako"),
        t("Seberang Ulu I"),
        t("Seberang Ulu II"),
        t("Sematang Borang"),
        t("Sukarami"),
      )),
      "Prabumulih" => drupal_map_assoc(array(
        t("Cambai"),
        t("Prabumulih Barat"),
        t("Prabumulih Selatan"),
        t("Prabumulih Timur"),
        t("Prabumulih Utara"),
        t("Rambang Kapak Tengah"),
      )),
    ),
    "Sumatera Utara" => array(
      "Asahan" => drupal_map_assoc(array(
        t("Aek Kuasan"),
        t("Aek Ledong"),
        t("Aek Songsongan"),
        t("Air Batu"),
        t("Air Joman"),
        t("Bandar Pasir Mandoge"),
        t("Bandar Pulau"),
        t("Buntu Pane"),
        t("Kisaran Barat Kota"),
        t("Kisaran Timur Kota"),
        t("Meranti"),
        t("Pulau Rakyat"),
        t("Pulo Bandring"),
        t("Rahuning"),
        t("Rawang Panca Arga"),
        t("Sei Dadap"),
        t("Sei Kepayang"),
        t("Sei Kepayang Barat"),
        t("Sei Kepayang Timur"),
        t("Setia Janji"),
        t("Silau Laut"),
        t("Simpang Empat"),
        t("Tanjung Balai"),
        t("Teluk Dalam"),
        t("Tinggi Raja"),
      )),
      "Batu Bara" => drupal_map_assoc(array(
        t("Air Putih"),
        t("Limapuluh"),
        t("Medang Deras"),
        t("Sei Balai"),
        t("Sei Suka"),
        t("Talawi"),
        t("Tanjung Tiram"),
      )),
      "Binjai" => drupal_map_assoc(array(
        t("Binjai Barat"),
        t("Binjai Kota"),
        t("Binjai Selatan"),
        t("Binjai Timur"),
        t("Binjai Utara"),
      )),
      "Dairi" => drupal_map_assoc(array(
        t("Berampu (Brampu)"),
        t("Gunung Sitember"),
        t("Lae Parira"),
        t("Parbuluan"),
        t("Pegagan Hilir"),
        t("Sidikalang"),
        t("Siempat Nempu"),
        t("Siempat Nempu Hilir"),
        t("Siempat Nempu Hulu"),
        t("Silahi Sabungan"),
        t("Silima Pungga-Pungga"),
        t("Sitinjo"),
        t("Sumbul"),
        t("Tanah Pinem"),
        t("Tiga Lingga"),
      )),
      "Deli Serdang" => drupal_map_assoc(array(
        t("Bangun Purba"),
        t("Batang Kuis"),
        t("Beringin"),
        t("Biru-Biru"),
        t("Deli Tua"),
        t("Galang"),
        t("Gunung Meriah"),
        t("Hamparan Perak"),
        t("Kutalimbaru"),
        t("Labuhan Deli"),
        t("Lubuk Pakam"),
        t("Namo Rambe"),
        t("Pagar Merbau"),
        t("Pancur Batu"),
        t("Pantai Labu"),
        t("Patumbak"),
        t("Percut Sei Tuan"),
        t("Sibolangit"),
        t("Sinembah Tanjung Muda Hilir"),
        t("Sinembah Tanjung Muda Hulu"),
        t("Sunggal"),
        t("Tanjung Morawa"),
      )),
      "Gunungsitoli" => drupal_map_assoc(array(
        t("Gunungsitoli"),
        t("Gunungsitoli Alo'oa"),
        t("Gunungsitoli Barat"),
        t("Gunungsitoli Idanoi"),
        t("Gunungsitoli Selatan"),
        t("Gunungsitoli Utara"),
      )),
      "Humbang Hasundutan" => drupal_map_assoc(array(
        t("Bakti Raja"),
        t("Dolok Sanggul"),
        t("Lintong Nihuta"),
        t("Onan Ganjang"),
        t("Pakkat"),
        t("Paranginan"),
        t("Parlilitan"),
        t("Pollung"),
        t("Sijama Polang"),
        t("Tara Bintang"),
      )),
      "Karo" => drupal_map_assoc(array(
        t("Barus Jahe"),
        t("Brastagi (Berastagi)"),
        t("Dolat Rayat"),
        t("Juhar"),
        t("Kabanjahe"),
        t("Kuta Buluh"),
        t("Laubaleng"),
        t("Mardinding"),
        t("Merdeka"),
        t("Merek"),
        t("Munte"),
        t("Nama Teran"),
        t("Payung"),
        t("Simpang Empat"),
        t("Tiga Binanga"),
        t("Tiga Panah"),
        t("Tiganderket"),
      )),
      "Labuhan Batu" => drupal_map_assoc(array(
        t("Bilah Barat"),
        t("Bilah Hilir"),
        t("Bilah Hulu"),
        t("Panai Hilir"),
        t("Panai Hulu"),
        t("Panai Tengah"),
        t("Pangkatan"),
        t("Rantau Selatan"),
        t("Rantau Utara"),
      )),
      "Labuhan Batu Selatan" => drupal_map_assoc(array(
        t("Kampung Rakyat"),
        t("Kota Pinang"),
        t("Sei/Sungai Kanan"),
        t("Silangkitang"),
        t("Torgamba"),
      )),
      "Labuhan Batu Utara" => drupal_map_assoc(array(
        t("Aek Kuo"),
        t("Aek Natas"),
        t("Kuala Ledong (Kualuh Leidong)"),
        t("Kualuh Hilir"),
        t("Kualuh Hulu"),
        t("Kualuh Selatan"),
        t("Marbau"),
        t("Na IX-X"),
      )),
      "Langkat" => drupal_map_assoc(array(
        t("Babalan"),
        t("Bahorok"),
        t("Batang Serangan"),
        t("Besitang"),
        t("Binjai"),
        t("Brandan Barat"),
        t("Gebang"),
        t("Hinai"),
        t("Kuala"),
        t("Kutambaru"),
        t("Padang Tualang"),
        t("Pangkalan Susu"),
        t("Pematang Jaya"),
        t("Salapian"),
        t("Sawit Seberang"),
        t("Secanggang"),
        t("Sei Binge (Bingai)"),
        t("Sei Lepan"),
        t("Selesai"),
        t("Sirapit (Serapit)"),
        t("Stabat"),
        t("Tanjungpura"),
        t("Wampu"),
      )),
      "Mandailing Natal" => drupal_map_assoc(array(
        t("Batahan"),
        t("Batang Natal"),
        t("Bukit Malintang"),
        t("Huta Bargot"),
        t("Kotanopan"),
        t("Langga Bayu (Lingga Bayu)"),
        t("Lembah Sorik Merapi"),
        t("Muara Batang Gadis"),
        t("Muara Sipongi"),
        t("Naga Juang"),
        t("Natal"),
        t("Pakantan"),
        t("Panyabungan Barat"),
        t("Panyabungan Kota"),
        t("Panyabungan Selatan"),
        t("Panyabungan Timur"),
        t("Panyabungan Utara"),
        t("Puncak Sorik Marapi/Merapi"),
        t("Ranto Baek/Baik"),
        t("Siabu"),
        t("Sinunukan"),
        t("Tambangan"),
        t("Ulu Pungkut"),
      )),
      "Medan" => drupal_map_assoc(array(
        t("Medan Amplas"),
        t("Medan Area"),
        t("Medan Barat"),
        t("Medan Baru"),
        t("Medan Belawan Kota"),
        t("Medan Deli"),
        t("Medan Denai"),
        t("Medan Helvetia"),
        t("Medan Johor"),
        t("Medan Kota"),
        t("Medan Labuhan"),
        t("Medan Maimun"),
        t("Medan Marelan"),
        t("Medan Perjuangan"),
        t("Medan Petisah"),
        t("Medan Polonia"),
        t("Medan Selayang"),
        t("Medan Sunggal"),
        t("Medan Tembung"),
        t("Medan Timur"),
        t("Medan Tuntungan"),
      )),
      "Nias" => drupal_map_assoc(array(
        t("Bawolato"),
        t("Botomuzoi"),
        t("Gido"),
        t("Hili Serangkai (Hilisaranggu)"),
        t("Hiliduho"),
        t("Idano Gawo"),
        t("Ma'u"),
        t("Sogae Adu (Sogaeadu)"),
        t("Somolo-Molo (Samolo)"),
        t("Ulugawo"),
      )),
      "Nias Barat" => drupal_map_assoc(array(
        t("Lahomi (Gahori)"),
        t("Lolofitu Moi"),
        t("Mandrehe"),
        t("Mandrehe Barat"),
        t("Mandrehe Utara"),
        t("Moro'o"),
        t("Sirombu"),
        t("Ulu Moro'o (Ulu Narwo)"),
      )),
      "Nias Selatan" => drupal_map_assoc(array(
        t("Amandraya"),
        t("Aramo"),
        t("Boronadu"),
        t("Fanayama"),
        t("Gomo"),
        t("Hibala"),
        t("Hilimegai"),
        t("Hilisalawa'ahe (Hilisalawaahe)"),
        t("Huruna"),
        t("Lahusa"),
        t("Lolomatua"),
        t("Lolowau"),
        t("Maniamolo"),
        t("Mazino"),
        t("Mazo"),
        t("O'o'u (Oou)"),
        t("Onohazumba"),
        t("Pulau-Pulau Batu"),
        t("Pulau-Pulau Batu Barat"),
        t("Pulau-Pulau Batu Timur"),
        t("Pulau-Pulau Batu Utara"),
        t("Sidua'ori"),
        t("Simuk"),
        t("Somambawa"),
        t("Susua"),
        t("Tanah Masa"),
        t("Teluk Dalam"),
        t("Toma"),
        t("Ulunoyo"),
        t("Ulususua"),
        t("Umbunasi"),
      )),
      "Nias Utara" => drupal_map_assoc(array(
        t("Afulu"),
        t("Alasa"),
        t("Alasa Talumuzoi"),
        t("Lahewa"),
        t("Lahewa Timur"),
        t("Lotu"),
        t("Namohalu Esiwa"),
        t("Sawo"),
        t("Sitolu Ori"),
        t("Tugala Oyo"),
        t("Tuhemberua"),
      )),
      "Padang Lawas" => drupal_map_assoc(array(
        t("Aek Nabara Barumun"),
        t("Barumun"),
        t("Barumun Selatan"),
        t("Barumun Tengah"),
        t("Batang Lubu Sutam"),
        t("Huristak"),
        t("Huta Raja Tinggi"),
        t("Lubuk Barumun"),
        t("Sihapas Barumun"),
        t("Sosa"),
        t("Sosopan"),
        t("Ulu Barumun"),
      )),
      "Padang Lawas Utara" => drupal_map_assoc(array(
        t("Batang Onang"),
        t("Dolok"),
        t("Dolok Sigompulon"),
        t("Halongonan"),
        t("Hulu Sihapas"),
        t("Padang Bolak"),
        t("Padang Bolak Julu"),
        t("Portibi"),
        t("Simangambat"),
      )),
      "Padang Sidempuan" => drupal_map_assoc(array(
        t("Padang Sidempuan Angkola Julu"),
        t("Padang Sidempuan Batunadua"),
        t("Padang Sidempuan Hutaimbaru"),
        t("Padang Sidempuan Selatan"),
        t("Padang Sidempuan Tenggara"),
        t("Padang Sidempuan Utara (Padangsidimpuan)"),
      )),
      "Pakpak Bharat" => drupal_map_assoc(array(
        t("Kerajaan"),
        t("Pagindar"),
        t("Pergetteng Getteng Sengkut"),
        t("Salak"),
        t("Siempat Rube"),
        t("Sitellu Tali Urang Jehe"),
        t("Sitellu Tali Urang Julu"),
        t("Tinada"),
      )),
      "Pematang Siantar" => drupal_map_assoc(array(
        t("Siantar Barat"),
        t("Siantar Marihat"),
        t("Siantar Marimbun"),
        t("Siantar Martoba"),
        t("Siantar Selatan"),
        t("Siantar Sitalasari"),
        t("Siantar Timur"),
        t("Siantar Utara"),
      )),
      "Samosir" => drupal_map_assoc(array(
        t("Harian"),
        t("Nainggolan"),
        t("Onan Runggu"),
        t("Palipi"),
        t("Pangururan"),
        t("Ronggur Nihuta"),
        t("Sianjur Mula-Mula"),
        t("Simanindo"),
        t("Sitio-Tio"),
      )),
      "Serdang Bedagai" => drupal_map_assoc(array(
        t("Bandar Khalifah"),
        t("Bintang Bayu"),
        t("Dolok Masihul"),
        t("Dolok Merawan"),
        t("Kotarih"),
        t("Pantai Cermin"),
        t("Pegajahan"),
        t("Perbaungan"),
        t("Sei Bamban"),
        t("Sei Rampah"),
        t("Serba Jadi"),
        t("Silinda"),
        t("Sipispis"),
        t("Tanjung Beringin"),
        t("Tebing Syahbandar"),
        t("Tebing Tinggi"),
        t("Teluk Mengkudu"),
      )),
      "Sibolga" => drupal_map_assoc(array(
        t("Sibolga Kota"),
        t("Sibolga Sambas"),
        t("Sibolga Selatan"),
        t("Sibolga Utara"),
      )),
      "Simalungun" => drupal_map_assoc(array(
        t("Bandar"),
        t("Bandar Huluan"),
        t("Bandar Masilam"),
        t("Bosar Maligas"),
        t("Dolok Batu Nanggar"),
        t("Dolok Panribuan"),
        t("Dolok Pardamean"),
        t("Dolok Silau"),
        t("Girsang Sipangan Bolon"),
        t("Gunung Malela"),
        t("Gunung Maligas"),
        t("Haranggaol Horison"),
        t("Hatonduhan"),
        t("Huta Bayu Raja"),
        t("Jawa Maraja Bah Jambi"),
        t("Jorlang Hataran"),
        t("Panei"),
        t("Panombeian Panei"),
        t("Pematang Bandar"),
        t("Pematang Sidamanik"),
        t("Pematang Silima Huta"),
        t("Purba"),
        t("Raya"),
        t("Raya Kahean"),
        t("Siantar"),
        t("Sidamanik"),
        t("Silimakuta"),
        t("Silou Kahean"),
        t("Tanah Jawa"),
        t("Tapian Dolok"),
        t("Ujung Padang"),
      )),
      "Tanjung Balai" => drupal_map_assoc(array(
        t("Datuk Bandar"),
        t("Datuk Bandar Timur"),
        t("Sei Tualang Raso"),
        t("Tanjung Balai Selatan"),
        t("Tanjung Balai Utara"),
        t("Teluk Nibung"),
      )),
      "Tapanuli Selatan" => drupal_map_assoc(array(
        t("Aek Bilah"),
        t("Angkola Barat (Padang Sidempuan)"),
        t("Angkola Sangkunur"),
        t("Angkola Selatan (Siais)"),
        t("Angkola Timur (Padang Sidempuan)"),
        t("Arse"),
        t("Batang Angkola"),
        t("Batang Toru"),
        t("Marancar"),
        t("Muara Batang Toru"),
        t("Saipar Dolok Hole"),
        t("Sayur Matinggi"),
        t("Sipirok"),
        t("Tano Tombangan Angkola"),
      )),
      "Tapanuli Tengah" => drupal_map_assoc(array(
        t("Andam Dewi"),
        t("Badiri"),
        t("Barus"),
        t("Barus Utara"),
        t("Kolang"),
        t("Lumut"),
        t("Manduamas"),
        t("Pandan"),
        t("Pasaribu Tobing"),
        t("Pinangsori"),
        t("Sarudik"),
        t("Sibabangun"),
        t("Sirandorung"),
        t("Sitahuis"),
        t("Sorkam"),
        t("Sorkam Barat"),
        t("Sosor Gadong"),
        t("Suka Bangun"),
        t("Tapian Nauli"),
        t("Tukka"),
      )),
      "Tapanuli Utara" => drupal_map_assoc(array(
        t("Adian Koting"),
        t("Garoga"),
        t("Muara"),
        t("Pagaran"),
        t("Pahae Jae"),
        t("Pahae Julu"),
        t("Pangaribuan"),
        t("Parmonangan"),
        t("Purbatua"),
        t("Siatas Barita"),
        t("Siborong-Borong"),
        t("Simangumban"),
        t("Sipahutar"),
        t("Sipoholon"),
        t("Tarutung"),
      )),
      "Tebing Tinggi" => drupal_map_assoc(array(
        t("Bajenis"),
        t("Padang Hilir"),
        t("Padang Hulu"),
        t("Rambutan"),
        t("Tebing Tinggi Kota"),
      )),
      "Toba Samosir" => drupal_map_assoc(array(
        t("Ajibata"),
        t("Balige"),
        t("Bonatua Lunasi"),
        t("Bor-Bor"),
        t("Habinsaran"),
        t("Laguboti"),
        t("Lumban Julu"),
        t("Nassau"),
        t("Parmaksian"),
        t("Pintu Pohan Meranti"),
        t("Porsea"),
        t("Siantar Narumonda"),
        t("Sigumpar"),
        t("Silaen"),
        t("Tampahan"),
        t("Uluan"),
      )),
    ),
  );

  return $locality_blocks;
}
