<?php

/**
 * @file
 * A list of all locality blocks.
 */

/**
 * @return
 *   Administrative area, locality and dependent locality array.
 */
function addressfield_id_locality_block() {
  $locality_blocks = array(
    "Bali" => array(
      "Badung" => drupal_map_assoc(array(
        "Abiansemal",
        "Kuta",
        "Kuta Selatan",
        "Kuta Utara",
        "Mengwi",
        "Petang",
      )),
      "Bangli" => drupal_map_assoc(array(
        "Bangli",
        "Kintamani",
        "Susut",
        "Tembuku",
      )),
      "Buleleng" => drupal_map_assoc(array(
        "Banjar",
        "Buleleng",
        "Busungbiu",
        "Gerokgak",
        "Kubutambahan",
        "Sawan",
        "Seririt",
        "Sukasada",
        "Tejakula",
      )),
      "Denpasar" => drupal_map_assoc(array(
        "Denpasar Barat",
        "Denpasar Selatan",
        "Denpasar Timur",
        "Denpasar Utara",
      )),
      "Gianyar" => drupal_map_assoc(array(
        "Belah Batuh (Blahbatuh)",
        "Gianyar",
        "Payangan",
        "Sukawati",
        "Tampak Siring",
        "Tegallalang",
        "Ubud",
      )),
      "Jembrana" => drupal_map_assoc(array(
        "Jembrana",
        "Melaya",
        "Mendoyo",
        "Negara",
        "Pekutatan",
      )),
      "Karangasem" => drupal_map_assoc(array(
        "Abang",
        "Bebandem",
        "Karang Asem",
        "Kubu",
        "Manggis",
        "Rendang",
        "Selat",
        "Sidemen",
      )),
      "Klungkung" => drupal_map_assoc(array(
        "Banjarangkan",
        "Dawan",
        "Klungkung",
        "Nusapenida",
      )),
      "Tabanan" => drupal_map_assoc(array(
        "Baturiti",
        "Kediri",
        "Kerambitan",
        "Marga",
        "Penebel",
        "Pupuan",
        "Selemadeg",
        "Selemadeg / Salamadeg Timur",
        "Selemadeg / Salemadeg Barat",
        "Tabanan",
      )),
    ),
    "Bangka Belitung" => array(
      "Bangka" => drupal_map_assoc(array(
        "Bakam",
        "Belinyu",
        "Mendo Barat",
        "Merawang",
        "Pemali",
        "Puding Besar",
        "Riau Silip",
        "Sungai Liat",
      )),
      "Bangka Barat" => drupal_map_assoc(array(
        "Jebus",
        "Kelapa",
        "Mentok (Muntok)",
        "Parittiga",
        "Simpang Teritip",
        "Tempilang",
      )),
      "Bangka Selatan" => drupal_map_assoc(array(
        "Air Gegas",
        "Kepulauan Pongok",
        "Lepar Pongok",
        "Payung",
        "Pulau Besar",
        "Simpang Rimba",
        "Toboali",
        "Tukak Sadai",
      )),
      "Bangka Tengah" => drupal_map_assoc(array(
        "Koba",
        "Lubuk Besar",
        "Namang",
        "Pangkalan Baru",
        "Simpang Katis",
        "Sungai Selan",
      )),
      "Belitung" => drupal_map_assoc(array(
        "Badau",
        "Membalong",
        "Selat Nasik",
        "Sijuk",
        "Tanjung Pandan",
      )),
      "Belitung Timur" => drupal_map_assoc(array(
        "Damar",
        "Dendang",
        "Gantung",
        "Kelapa Kampit",
        "Manggar",
        "Simpang Pesak",
        "Simpang Renggiang",
      )),
      "Pangkal Pinang" => drupal_map_assoc(array(
        "Bukit Intan",
        "Gabek",
        "Gerunggang",
        "Girimaya",
        "Pangkal Balam",
        "Rangkui",
        "Taman Sari",
      )),
    ),
    "Banten" => array(
      "Cilegon" => drupal_map_assoc(array(
        "Cibeber",
        "Cilegon",
        "Citangkil",
        "Ciwandan",
        "Gerogol",
        "Jombang",
        "Pulomerak",
        "Purwakarta",
      )),
      "Lebak" => drupal_map_assoc(array(
        "Banjarsari",
        "Bayah",
        "Bojongmanik",
        "Cibadak",
        "Cibeber",
        "Cigemblong",
        "Cihara",
        "Cijaku",
        "Cikulur",
        "Cileles",
        "Cilograng",
        "Cimarga",
        "Cipanas",
        "Cirinten",
        "Curugbitung",
        "Gunung Kencana",
        "Kalanganyar",
        "Lebakgedong",
        "Leuwidamar",
        "Maja",
        "Malingping",
        "Muncang",
        "Panggarangan",
        "Rangkasbitung",
        "Sajira",
        "Sobang",
        "Wanasalam",
        "Warunggunung",
      )),
      "Pandeglang" => drupal_map_assoc(array(
        "Angsana",
        "Banjar",
        "Bojong",
        "Cadasari",
        "Carita",
        "Cibaliung",
        "Cibitung",
        "Cigeulis",
        "Cikeudal (Cikedal)",
        "Cikeusik",
        "Cimanggu",
        "Cimanuk",
        "Cipeucang",
        "Cisata",
        "Jiput",
        "Kaduhejo",
        "Karang Tanjung",
        "Koroncong",
        "Labuan",
        "Majasari",
        "Mandalawangi",
        "Mekarjaya",
        "Menes",
        "Munjul",
        "Pagelaran",
        "Pandeglang",
        "Panimbang",
        "Patia",
        "Picung",
        "Pulosari",
        "Saketi",
        "Sindangresmi",
        "Sobang",
        "Sukaresmi",
        "Sumur",
      )),
      "Serang (Kabupaten)" => drupal_map_assoc(array(
        "Anyar",
        "Bandung",
        "Baros",
        "Binuang",
        "Bojonegara",
        "Carenang (Cerenang)",
        "Cikande",
        "Cikeusal",
        "Cinangka",
        "Ciomas",
        "Ciruas",
        "Gunungsari",
        "Jawilan",
        "Kibin",
        "Kopo",
        "Kragilan",
        "Kramatwatu",
        "Lebak Wangi",
        "Mancak",
        "Pabuaran",
        "Padarincang",
        "Pamarayan",
        "Petir",
        "Pontang",
        "Pulo Ampel",
        "Tanara",
        "Tirtayasa",
        "Tunjung Teja",
        "Waringin Kurung",
      )),
      "Serang (Kota)" => drupal_map_assoc(array(
        "Cipocok Jaya",
        "Curug",
        "Kasemen",
        "Serang",
        "Taktakan",
        "Walantaka",
      )),
      "Tangerang (Kabupaten)" => drupal_map_assoc(array(
        "Balaraja",
        "Cikupa",
        "Cisauk",
        "Cisoka",
        "Curug",
        "Gunung Kaler",
        "Jambe",
        "Jayanti",
        "Kelapa Dua",
        "Kemiri",
        "Kosambi",
        "Kresek",
        "Kronjo",
        "Legok",
        "Mauk",
        "Mekar Baru",
        "Pagedangan",
        "Pakuhaji",
        "Panongan",
        "Pasar Kemis",
        "Rajeg",
        "Sepatan",
        "Sepatan Timur",
        "Sindang Jaya",
        "Solear",
        "Sukadiri",
        "Sukamulya",
        "Teluknaga",
        "Tigaraksa",
      )),
      "Tangerang (Kota)" => drupal_map_assoc(array(
        "Batuceper",
        "Benda",
        "Cibodas",
        "Ciledug",
        "Cipondoh",
        "Jatiuwung",
        "Karang Tengah",
        "Karawaci",
        "Larangan",
        "Neglasari",
        "Periuk",
        "Pinang (Penang)",
        "Tangerang",
      )),
      "Tangerang Selatan" => drupal_map_assoc(array(
        "Ciputat",
        "Ciputat Timur",
        "Pamulang",
        "Pondok Aren",
        "Serpong",
        "Serpong Utara",
        "Setu",
      )),
    ),
    "Bengkulu" => array(
      "Bengkulu" => drupal_map_assoc(array(
        "Gading Cempaka",
        "Kampung Melayu",
        "Muara Bangka Hulu",
        "Ratu Agung",
        "Ratu Samban",
        "Selebar",
        "Singaran Pati",
        "Sungai Serut",
        "Teluk Segara",
      )),
      "Bengkulu Selatan" => drupal_map_assoc(array(
        "Air Nipis",
        "Bunga Mas",
        "Kedurang",
        "Kedurang Ilir",
        "Kota Manna",
        "Manna",
        "Pasar Manna",
        "Pino",
        "Pinoraya",
        "Seginim",
        "Ulu Manna",
      )),
      "Bengkulu Tengah" => drupal_map_assoc(array(
        "Bang Haji",
        "Karang Tinggi",
        "Merigi Kelindang",
        "Merigi Sakti",
        "Pagar Jati",
        "Pematang Tiga",
        "Pondok Kelapa",
        "Pondok Kubang",
        "Taba Penanjung",
        "Talang Empat",
      )),
      "Bengkulu Utara" => drupal_map_assoc(array(
        "Air Besi",
        "Air Napal",
        "Air Padang",
        "Arga Makmur",
        "Arma Jaya",
        "Batik Nau",
        "Enggano",
        "Giri Mulia",
        "Hulu Palik",
        "Kerkap",
        "Ketahun",
        "Lais",
        "Napal Putih",
        "Padang Jaya",
        "Putri Hijau",
        "Tanjung Agung Palik",
        "Ulok Kupai",
      )),
      "Kaur" => drupal_map_assoc(array(
        "Kaur Selatan",
        "Kaur Tengah",
        "Kaur Utara",
        "Kelam Tengah",
        "Kinal",
        "Luas",
        "Lungkang Kule",
        "Maje",
        "Muara Sahung",
        "Nasal",
        "Padang Guci Hilir",
        "Padang Guci Hulu",
        "Semidang Gumai (Gumay)",
        "Tanjung Kemuning",
        "Tetap (Muara Tetap)",
      )),
      "Kepahiang" => drupal_map_assoc(array(
        "Bermani Ilir",
        "Kebawetan (Kabawetan)",
        "Kepahiang",
        "Merigi",
        "Muara Kemumu",
        "Seberang Musi",
        "Tebat Karai",
        "Ujan Mas",
      )),
      "Lebong" => drupal_map_assoc(array(
        "Amen",
        "Bingin Kuning",
        "Lebong Atas",
        "Lebong Sakti",
        "Lebong Selatan",
        "Lebong Tengah",
        "Lebong Utara",
        "Pelabai",
        "Pinang Belapis",
        "Rimbo Pengadang",
        "Topos",
        "Uram Jaya",
      )),
      "Muko Muko" => drupal_map_assoc(array(
        "Air Dikit",
        "Air Majunto",
        "Air Rami",
        "Ipuh (Muko-Muko Selatan)",
        "Kota Mukomuko (Mukomuko Utara)",
        "Lubuk Pinang",
        "Malin Deman",
        "Penarik",
        "Pondok Suguh",
        "Selagan Raya",
        "Sungai Rumbai",
        "Teramang Jaya",
        "Teras Terunjam",
        "V Koto",
        "XIV Koto",
      )),
      "Rejang Lebong" => drupal_map_assoc(array(
        "Bermani Ulu",
        "Bermani Ulu Raya",
        "Binduriang",
        "Curup",
        "Curup Selatan",
        "Curup Tengah",
        "Curup Timur",
        "Curup Utara",
        "Kota Padang",
        "Padang Ulak Tanding",
        "Selupu Rejang",
        "Sindang Beliti Ilir",
        "Sindang Beliti Ulu",
        "Sindang Daratan",
        "Sindang Kelingi",
      )),
      "Seluma" => drupal_map_assoc(array(
        "Air Periukan",
        "Ilir Talo",
        "Lubuk Sandi",
        "Seluma",
        "Seluma Barat",
        "Seluma Selatan",
        "Seluma Timur",
        "Seluma Utara",
        "Semidang Alas",
        "Semidang Alas Maras",
        "Sukaraja",
        "Talo",
        "Talo Kecil",
        "Ulu Talo",
      )),
    ),
    "DI Yogyakarta" => array(
      "Bantul" => drupal_map_assoc(array(
        "Bambang Lipuro",
        "Banguntapan",
        "Bantul",
        "Dlingo",
        "Imogiri",
        "Jetis",
        "Kasihan",
        "Kretek",
        "Pajangan",
        "Pandak",
        "Piyungan",
        "Pleret",
        "Pundong",
        "Sanden",
        "Sedayu",
        "Sewon",
        "Srandakan",
      )),
      "Gunung Kidul" => drupal_map_assoc(array(
        "Gedang Sari",
        "Girisubo",
        "Karangmojo",
        "Ngawen",
        "Nglipar",
        "Paliyan",
        "Panggang",
        "Patuk",
        "Playen",
        "Ponjong",
        "Purwosari",
        "Rongkop",
        "Sapto Sari",
        "Semanu",
        "Semin",
        "Tanjungsari",
        "Tepus",
        "Wonosari",
      )),
      "Kulon Progo" => drupal_map_assoc(array(
        "Galur",
        "Girimulyo",
        "Kalibawang",
        "Kokap",
        "Lendah",
        "Nanggulan",
        "Panjatan",
        "Pengasih",
        "Samigaluh",
        "Sentolo",
        "Temon",
        "Wates",
      )),
      "Sleman" => drupal_map_assoc(array(
        "Berbah",
        "Cangkringan",
        "Depok",
        "Gamping",
        "Godean",
        "Kalasan",
        "Minggir",
        "Mlati",
        "Moyudan",
        "Ngaglik",
        "Ngemplak",
        "Pakem",
        "Prambanan",
        "Seyegan",
        "Sleman",
        "Tempel",
        "Turi",
      )),
      "Yogyakarta" => drupal_map_assoc(array(
        "Danurejan",
        "Gedong Tengen",
        "Gondokusuman",
        "Gondomanan",
        "Jetis",
        "Kotagede",
        "Kraton",
        "Mantrijeron",
        "Mergangsan",
        "Ngampilan",
        "Pakualaman",
        "Tegalrejo",
        "Umbulharjo",
        "Wirobrajan",
      )),
    ),
    "DKI Jakarta" => array(
      "Jakarta Barat" => drupal_map_assoc(array(
        "Cengkareng",
        "Grogol Petamburan",
        "Kalideres",
        "Kebon Jeruk",
        "Kembangan",
        "Palmerah",
        "Taman Sari",
        "Tambora",
      )),
      "Jakarta Pusat" => drupal_map_assoc(array(
        "Cempaka Putih",
        "Gambir",
        "Johar Baru",
        "Kemayoran",
        "Menteng",
        "Sawah Besar",
        "Senen",
        "Tanah Abang",
      )),
      "Jakarta Selatan" => drupal_map_assoc(array(
        "Cilandak",
        "Jagakarsa",
        "Kebayoran Baru",
        "Kebayoran Lama",
        "Mampang Prapatan",
        "Pancoran",
        "Pasar Minggu",
        "Pesanggrahan",
        "Setia Budi",
        "Tebet",
      )),
      "Jakarta Timur" => drupal_map_assoc(array(
        "Cakung",
        "Cipayung",
        "Ciracas",
        "Duren Sawit",
        "Jatinegara",
        "Kramat Jati",
        "Makasar",
        "Matraman",
        "Pasar Rebo",
        "Pulo Gadung",
      )),
      "Jakarta Utara" => drupal_map_assoc(array(
        "Cilincing",
        "Kelapa Gading",
        "Koja",
        "Pademangan",
        "Penjaringan",
        "Tanjung Priok",
      )),
      "Kepulauan Seribu" => drupal_map_assoc(array(
        "Kepulauan Seribu Selatan",
        "Kepulauan Seribu Utara",
      )),
    ),
    "Gorontalo" => array(
      "Boalemo" => drupal_map_assoc(array(
        "Botumoita (Botumoito)",
        "Dulupi",
        "Mananggu",
        "Paguyaman",
        "Paguyaman Pantai",
        "Tilamuta",
        "Wonosari",
      )),
      "Bone Bolango" => drupal_map_assoc(array(
        "Bone",
        "Bone Raya",
        "Bonepantai",
        "Botu Pingge",
        "Bulango Selatan",
        "Bulango Timur",
        "Bulango Ulu",
        "Bulango Utara",
        "Bulawa",
        "Kabila",
        "Kabila Bone",
        "Pinogu",
        "Suwawa",
        "Suwawa Selatan",
        "Suwawa Tengah",
        "Suwawa Timur",
        "Tapa",
        "Tilongkabila",
      )),
      "Gorontalo (Kabupaten)" => drupal_map_assoc(array(
        "Asparaga",
        "Batudaa",
        "Batudaa Pantai",
        "Bilato",
        "Biluhu",
        "Boliohuto (Boliyohuto)",
        "Bongomeme",
        "Dungaliyo",
        "Limboto",
        "Limboto Barat",
        "Mootilango",
        "Pulubala",
        "Tabongo",
        "Telaga",
        "Telaga Biru",
        "Telaga Jaya",
        "Tibawa",
        "Tilango",
        "Tolangohula",
      )),
      "Gorontalo (Kota)" => drupal_map_assoc(array(
        "Dumbo Raya",
        "Dungingi",
        "Hulonthalangi",
        "Kota Barat",
        "Kota Selatan",
        "Kota Tengah",
        "Kota Timur",
        "Kota Utara",
        "Sipatana",
      )),
      "Gorontalo Utara" => drupal_map_assoc(array(
        "Anggrek",
        "Atinggola",
        "Biau",
        "Gentuma Raya",
        "Kwandang",
        "Monano",
        "Ponelo Kepulauan",
        "Sumalata",
        "Sumalata Timur",
        "Tolinggula",
        "Tomolito",
      )),
      "Pohuwato" => drupal_map_assoc(array(
        "Buntulia",
        "Dengilo",
        "Duhiadaa",
        "Lemito",
        "Marisa",
        "Paguat",
        "Patilanggio",
        "Popayato",
        "Popayato Barat",
        "Popayato Timur",
        "Randangan",
        "Taluditi (Taluduti)",
        "Wanggarasi",
      )),
    ),
    "Jambi" => array(
      "Batang Hari" => drupal_map_assoc(array(
        "Bajubang",
        "Batin XXIV",
        "Maro Sebo Ilir",
        "Maro Sebo Ulu",
        "Mersam",
        "Muara Bulian",
        "Muara Tembesi",
        "Pemayung",
      )),
      "Bungo" => drupal_map_assoc(array(
        "Bathin II Babeko",
        "Bathin II Pelayang",
        "Bathin III",
        "Bathin III Ulu",
        "Bungo Dani",
        "Jujuhan",
        "Jujuhan Ilir",
        "Limbur Lubuk Mengkuang",
        "Muko-Muko Batin VII",
        "Pasar Muara Bungo",
        "Pelepat",
        "Pelepat Ilir",
        "Rantau Pandan",
        "Rimbo Tengah",
        "Tanah Sepenggal",
        "Tanah Sepenggal Lintas",
        "Tanah Tumbuh",
      )),
      "Jambi" => drupal_map_assoc(array(
        "Danau Teluk",
        "Jambi Selatan",
        "Jambi Timur",
        "Jelutung",
        "Kota Baru",
        "Pasar Jambi",
        "Pelayangan",
        "Telanaipura",
      )),
      "Kerinci" => drupal_map_assoc(array(
        "Air Hangat",
        "Air Hangat Barat",
        "Air Hangat Timur",
        "Batang Merangin",
        "Bukitkerman",
        "Danau Kerinci",
        "Depati Tujuh",
        "Gunung Kerinci",
        "Gunung Raya",
        "Gunung Tujuh",
        "Kayu Aro",
        "Kayu Aro Barat",
        "Keliling Danau",
        "Sitinjau Laut",
        "Siulak",
        "Siulak Mukai",
      )),
      "Merangin" => drupal_map_assoc(array(
        "Bangko",
        "Bangko Barat",
        "Batang Masumai",
        "Jangkat",
        "Lembah Masurai",
        "Margo Tabir",
        "Muara Siau",
        "Nalo Tantan",
        "Pamenang",
        "Pamenang Barat",
        "Pamenang Selatan",
        "Pangkalan Jambu",
        "Renah Pembarap",
        "Renah Pemenang",
        "Sungai Manau",
        "Sungai Tenang",
        "Tabir",
        "Tabir Barat",
        "Tabir Ilir",
        "Tabir Lintas",
        "Tabir Selatan",
        "Tabir Timur",
        "Tabir Ulu",
        "Tiang Pumpung",
      )),
      "Muaro Jambi" => drupal_map_assoc(array(
        "Bahar Selatan",
        "Bahar Utara",
        "Jambi Luar Kota",
        "Kumpeh",
        "Kumpeh Ulu",
        "Maro Sebo",
        "Mestong",
        "Sekernan",
        "Sungai Bahar",
        "Sungai Gelam",
        "Taman Rajo / Rejo",
      )),
      "Sarolangun" => drupal_map_assoc(array(
        "Air Hitam",
        "Batang Asai",
        "Bathin VIII (Batin VIII)",
        "Cermin Nan Gadang",
        "Limun",
        "Mandiangin",
        "Pauh",
        "Pelawan",
        "Sarolangun",
        "Singkut",
      )),
      "Sungaipenuh" => drupal_map_assoc(array(
        "Hamparan Rawang",
        "Koto Baru",
        "Kumun Debai",
        "Pesisir Bukit",
        "Pondok Tinggi",
        "Sungai Bungkal",
        "Sungai Penuh",
        "Tanah Kampung",
      )),
      "Tanjung Jabung Barat" => drupal_map_assoc(array(
        "Batang Asam",
        "Betara",
        "Bram Itam",
        "Kuala Betara",
        "Merlung",
        "Muara Papalik",
        "Pengabuan",
        "Renah Mendaluh",
        "Seberang Kota",
        "Senyerang",
        "Tebing Tinggi",
        "Tungkal Ilir",
        "Tungkal Ulu",
      )),
      "Tanjung Jabung Timur" => drupal_map_assoc(array(
        "Berbak",
        "Dendang",
        "Geragai",
        "Kuala Jambi",
        "Mendahara",
        "Mendahara Ulu",
        "Muara Sabak Barat",
        "Muara Sabak Timur",
        "Nipah Panjang",
        "Rantau Rasau",
        "Sadu",
      )),
      "Tebo" => drupal_map_assoc(array(
        "Muara Tabir",
        "Rimbo Bujang",
        "Rimbo Ilir",
        "Rimbo Ulu",
        "Serai Serumpun",
        "Sumay",
        "Tebo Ilir",
        "Tebo Tengah",
        "Tebo Ulu",
        "Tengah Ilir",
        "VII Koto",
        "VII Koto Ilir",
      )),
    ),
    "Jawa Barat" => array(
      "Bandung (Kabupaten)" => drupal_map_assoc(array(
        "Arjasari",
        "Baleendah",
        "Banjaran",
        "Bojongsoang",
        "Cangkuang",
        "Cicalengka",
        "Cikancung",
        "Cilengkrang",
        "Cileunyi",
        "Cimaung",
        "Cimeunyan",
        "Ciparay",
        "Ciwidey",
        "Dayeuhkolot",
        "Ibun",
        "Katapang",
        "Kertasari",
        "Kutawaringin",
        "Majalaya",
        "Margaasih",
        "Margahayu",
        "Nagreg",
        "Pacet",
        "Pameungpeuk",
        "Pangalengan",
        "Paseh",
        "Pasirjambu",
        "Ranca Bali",
        "Rancaekek",
        "Solokan Jeruk",
        "Soreang",
      )),
      "Bandung (Kota)" => drupal_map_assoc(array(
        "Andir",
        "Antapani (Cicadas)",
        "Arcamanik",
        "Astana Anyar",
        "Babakan Ciparay",
        "Bandung Kidul",
        "Bandung Kulon",
        "Bandung Wetan",
        "Batununggal",
        "Bojongloa Kaler",
        "Bojongloa Kidul",
        "Buahbatu (Margacinta)",
        "Cibeunying Kaler",
        "Cibeunying Kidul",
        "Cibiru",
        "Cicendo",
        "Cidadap",
        "Cinambo",
        "Coblong",
        "Gedebage",
        "Kiaracondong",
        "Lengkong",
        "Mandalajati",
        "Panyileukan",
        "Rancasari",
        "Regol",
        "Sukajadi",
        "Sukasari",
        "Sumur Bandung",
        "Ujung Berung",
      )),
      "Bandung Barat" => drupal_map_assoc(array(
        "Batujajar",
        "Cihampelas",
        "Cikalong Wetan",
        "Cililin",
        "Cipatat",
        "Cipeundeuy",
        "Cipongkor",
        "Cisarua",
        "Gununghalu",
        "Lembang",
        "Ngamprah",
        "Padalarang",
        "Parongpong",
        "Rongga",
        "Saguling",
        "Sindangkerta",
      )),
      "Banjar (Kota)" => drupal_map_assoc(array(
        "Banjar",
        "Langensari",
        "Pataruman",
        "Purwaharja",
      )),
      "Bekasi (Kabupaten)" => drupal_map_assoc(array(
        "Babelan",
        "Bojongmangu",
        "Cabangbungin",
        "Cibarusah",
        "Cibitung",
        "Cikarang Barat",
        "Cikarang Pusat",
        "Cikarang Selatan",
        "Cikarang Timur",
        "Cikarang Utara",
        "Karangbahagia",
        "Kedung Waringin",
        "Muara Gembong",
        "Pebayuran",
        "Serang Baru",
        "Setu",
        "Sukakarya",
        "Sukatani",
        "Sukawangi",
        "Tambelang",
        "Tambun Selatan",
        "Tambun Utara",
        "Tarumajaya",
      )),
      "Bekasi (Kota)" => drupal_map_assoc(array(
        "Bantar Gebang",
        "Bekasi Barat",
        "Bekasi Selatan",
        "Bekasi Timur",
        "Bekasi Utara",
        "Jati Sampurna",
        "Jatiasih",
        "Medan Satria",
        "Mustika Jaya",
        "Pondok Gede",
        "Pondok Melati",
        "Rawalumbu",
      )),
      "Bogor (Kabupaten)" => drupal_map_assoc(array(
        "Babakan Madang",
        "Bojonggede",
        "Caringin",
        "Cariu",
        "Ciampea",
        "Ciawi",
        "Cibinong",
        "Cibungbulang",
        "Cigombong",
        "Cigudeg",
        "Cijeruk",
        "Cileungsi",
        "Ciomas",
        "Cisarua",
        "Ciseeng",
        "Citeureup",
        "Dramaga",
        "Gunung Putri",
        "Gunung Sindur",
        "Jasinga",
        "Jonggol",
        "Kemang",
        "Klapa Nunggal (Kelapa Nunggal)",
        "Leuwiliang",
        "Leuwisadeng",
        "Megamendung",
        "Nanggung",
        "Pamijahan",
        "Parung",
        "Parung Panjang",
        "Ranca Bungur",
        "Rumpin",
        "Sukajaya",
        "Sukamakmur",
        "Sukaraja",
        "Tajurhalang",
        "Tamansari",
        "Tanjungsari",
        "Tenjo",
        "Tenjolaya",
      )),
      "Bogor (Kota)" => drupal_map_assoc(array(
        "Bogor Barat - Kota",
        "Bogor Selatan - Kota",
        "Bogor Tengah - Kota",
        "Bogor Timur - Kota",
        "Bogor Utara - Kota",
        "Tanah Sereal",
      )),
      "Ciamis" => drupal_map_assoc(array(
        "Banjarsari",
        "Baregbeg",
        "Ciamis",
        "Cidolog",
        "Cihaurbeuti",
        "Cijeungjing",
        "Cikoneng",
        "Cimaragas",
        "Cipaku",
        "Cisaga",
        "Jatinagara",
        "Kawali",
        "Lakbok",
        "Lumbung",
        "Pamarican",
        "Panawangan",
        "Panjalu",
        "Panumbangan",
        "Purwadadi",
        "Rajadesa",
        "Rancah",
        "Sadananya",
        "Sindangkasih",
        "Sukadana",
        "Sukamantri",
        "Tambaksari",
      )),
      "Cianjur" => drupal_map_assoc(array(
        "Agrabinta",
        "Bojongpicung",
        "Campaka",
        "Campaka Mulya",
        "Cianjur",
        "Cibeber",
        "Cibinong",
        "Cidaun",
        "Cijati",
        "Cikadu",
        "Cikalongkulon",
        "Cilaku",
        "Cipanas",
        "Ciranjang",
        "Cugenang",
        "Gekbrong",
        "Haurwangi",
        "Kadupandak",
        "Karangtengah",
        "Leles",
        "Mande",
        "Naringgul",
        "Pacet",
        "Pagelaran",
        "Pasirkuda",
        "Sindangbarang",
        "Sukaluyu",
        "Sukanagara",
        "Sukaresmi",
        "Takokak",
        "Tanggeung",
        "Warungkondang",
      )),
      "Cimahi" => drupal_map_assoc(array(
        "Cimahi Selatan",
        "Cimahi Tengah",
        "Cimahi Utara",
      )),
      "Cirebon (Kabupaten)" => drupal_map_assoc(array(
        "Arjawinangun",
        "Astanajapura",
        "Babakan",
        "Beber",
        "Ciledug",
        "Ciwaringin",
        "Depok",
        "Dukupuntang",
        "Gebang",
        "Gegesik",
        "Gempol",
        "Greged (Greget)",
        "Gunung Jati (Cirebon Utara)",
        "Jamblang",
        "Kaliwedi",
        "Kapetakan",
        "Karangsembung",
        "Karangwareng",
        "Kedawung",
        "Klangenan",
        "Lemahabang",
        "Losari",
        "Mundu",
        "Pabedilan",
        "Pabuaran",
        "Palimanan",
        "Pangenan",
        "Panguragan",
        "Pasaleman",
        "Plered",
        "Plumbon",
        "Sedong",
        "Sumber",
        "Suranenggala",
        "Susukan",
        "Susukan Lebak",
        "Talun (Cirebon Selatan)",
        "Tengah Tani",
        "Waled",
        "Weru",
      )),
      "Cirebon (Kota)" => drupal_map_assoc(array(
        "Harjamukti",
        "Kejaksan",
        "Kesambi",
        "Lemahwungkuk",
        "Pekalipan",
      )),
      "Depok" => drupal_map_assoc(array(
        "Beji",
        "Bojongsari",
        "Cilodong",
        "Cimanggis",
        "Cinere",
        "Cipayung",
        "Limo",
        "Pancoran Mas",
        "Sawangan",
        "Sukmajaya",
        "Tapos",
      )),
      "Garut" => drupal_map_assoc(array(
        "Banjarwangi",
        "Banyuresmi",
        "Bayongbong",
        "Blubur Limbangan",
        "Bungbulang",
        "Caringin",
        "Cibalong",
        "Cibatu",
        "Cibiuk",
        "Cigedug",
        "Cihurip",
        "Cikajang",
        "Cikelet",
        "Cilawu",
        "Cisewu",
        "Cisompet",
        "Cisurupan",
        "Garut Kota",
        "Kadungora",
        "Karangpawitan",
        "Karangtengah",
        "Kersamanah",
        "Leles",
        "Leuwigoong",
        "Malangbong",
        "Mekarmukti",
        "Pakenjeng",
        "Pameungpeuk",
        "Pamulihan",
        "Pangatikan",
        "Pasirwangi",
        "Peundeuy",
        "Samarang",
        "Selaawi",
        "Singajaya",
        "Sucinaraja",
        "Sukaresmi",
        "Sukawening",
        "Talegong",
        "Tarogong Kaler",
        "Tarogong Kidul",
        "Wanaraja",
      )),
      "Indramayu" => drupal_map_assoc(array(
        "Anjatan",
        "Arahan",
        "Balongan",
        "Bangodua",
        "Bongas",
        "Cantigi",
        "Cikedung",
        "Gabuswetan",
        "Gantar",
        "Haurgeulis",
        "Indramayu",
        "Jatibarang",
        "Juntinyuat",
        "Kandanghaur",
        "Karangampel",
        "Kedokan Bunder",
        "Kertasemaya",
        "Krangkeng",
        "Kroya",
        "Lelea",
        "Lohbener",
        "Losarang",
        "Pasekan",
        "Patrol",
        "Sindang",
        "Sliyeg",
        "Sukagumiwang",
        "Sukra",
        "Trisi/Terisi",
        "Tukdana",
        "Widasari",
      )),
      "Karawang" => drupal_map_assoc(array(
        "Banyusari",
        "Batujaya",
        "Ciampel",
        "Cibuaya",
        "Cikampek",
        "Cilamaya Kulon",
        "Cilamaya Wetan",
        "Cilebar",
        "Jatisari",
        "Jayakerta",
        "Karawang Barat",
        "Karawang Timur",
        "Klari",
        "Kotabaru",
        "Kutawaluya",
        "Lemahabang",
        "Majalaya",
        "Pakisjaya",
        "Pangkalan",
        "Pedes",
        "Purwasari",
        "Rawamerta",
        "Rengasdengklok",
        "Talagasari",
        "Tegalwaru",
        "Telukjambe Barat",
        "Telukjambe Timur",
        "Tempuran",
        "Tirtajaya",
        "Tirtamulya",
      )),
      "Kuningan" => drupal_map_assoc(array(
        "Ciawigebang",
        "Cibeureum",
        "Cibingbin",
        "Cidahu",
        "Cigandamekar",
        "Cigugur",
        "Cilebak",
        "Cilimus",
        "Cimahi",
        "Ciniru",
        "Cipicung",
        "Ciwaru",
        "Darma",
        "Garawangi",
        "Hantara",
        "Jalaksana",
        "Japara",
        "Kadugede",
        "Kalimanggis",
        "Karangkancana",
        "Kramat Mulya",
        "Kuningan",
        "Lebakwangi",
        "Luragung",
        "Maleber",
        "Mandirancan",
        "Nusaherang",
        "Pancalang",
        "Pasawahan",
        "Selajambe",
        "Sindangagung",
        "Subang",
      )),
      "Majalengka" => drupal_map_assoc(array(
        "Argapura",
        "Banjaran",
        "Bantarujeg",
        "Cigasong",
        "Cikijing",
        "Cingambul",
        "Dawuan",
        "Jatitujuh",
        "Jatiwangi",
        "Kadipaten",
        "Kasokandel",
        "Kertajati",
        "Lemahsugih",
        "Leuwimunding",
        "Ligung",
        "Maja",
        "Majalengka",
        "Malausma",
        "Palasah",
        "Panyingkiran",
        "Rajagaluh",
        "Sindang",
        "Sindangwangi",
        "Sukahaji",
        "Sumberjaya",
        "Talaga",
      )),
      "Pangandaran" => drupal_map_assoc(array(
        "Cigugur",
        "Cijulang",
        "Cimerak",
        "Kalipucang",
        "Langkaplancar",
        "Mangunjaya",
        "Padaherang",
        "Pangandaran",
        "Parigi",
        "Sidamulih",
      )),
      "Purwakarta" => drupal_map_assoc(array(
        "Babakancikao",
        "Bojong",
        "Bungursari",
        "Campaka",
        "Cibatu",
        "Darangdan",
        "Jatiluhur",
        "Kiarapedes",
        "Maniis",
        "Pasawahan",
        "Plered",
        "Pondoksalam",
        "Purwakarta",
        "Sukasari",
        "Sukatani",
        "Tegal Waru",
        "Wanayasa",
      )),
      "Subang" => drupal_map_assoc(array(
        "Binong",
        "Blanakan",
        "Ciasem",
        "Ciater",
        "Cibogo",
        "Cijambe",
        "Cikaum",
        "Cipeundeuy",
        "Cipunagara",
        "Cisalak",
        "Compreng",
        "Dawuan",
        "Jalancagak",
        "Kalijati",
        "Kasomalang",
        "Legonkulon",
        "Pabuaran",
        "Pagaden",
        "Pagaden Barat",
        "Pamanukan",
        "Patokbeusi",
        "Purwadadi",
        "Pusakajaya",
        "Pusakanagara",
        "Sagalaherang",
        "Serangpanjang",
        "Subang",
        "Sukasari",
        "Tambakdahan",
        "Tanjungsiang",
      )),
      "Sukabumi (Kabupaten)" => drupal_map_assoc(array(
        "Bantargadung",
        "Bojong Genteng",
        "Caringin",
        "Ciambar",
        "Cibadak",
        "Cibitung",
        "Cicantayan",
        "Cicurug",
        "Cidadap",
        "Cidahu",
        "Cidolog",
        "Ciemas",
        "Cikakak",
        "Cikembar",
        "Cikidang",
        "Cimanggu",
        "Ciracap",
        "Cireunghas",
        "Cisaat",
        "Cisolok",
        "Curugkembar",
        "Geger Bitung",
        "Gunung Guruh",
        "Jampang Kulon",
        "Jampang Tengah",
        "Kabandungan",
        "Kadudampit",
        "Kalapa Nunggal",
        "Kali Bunder",
        "Kebonpedes",
        "Lengkong",
        "Nagrak",
        "Nyalindung",
        "Pabuaran",
        "Parakan Salak",
        "Parung Kuda",
        "Pelabuhan/Palabuhan Ratu",
        "Purabaya",
        "Sagaranten",
        "Simpenan",
        "Sukabumi",
        "Sukalarang",
        "Sukaraja",
        "Surade",
        "Tegal Buleud",
        "Waluran",
        "Warung Kiara",
      )),
      "Sukabumi (Kota)" => drupal_map_assoc(array(
        "Baros",
        "Cibeureum",
        "Cikole",
        "Citamiang",
        "Gunung Puyuh",
        "Lembursitu",
        "Warudoyong",
      )),
      "Sumedang" => drupal_map_assoc(array(
        "Buahdua",
        "Cibugel",
        "Cimalaka",
        "Cimanggung",
        "Cisarua",
        "Cisitu",
        "Conggeang",
        "Darmaraja",
        "Ganeas",
        "Jatigede",
        "Jatinangor",
        "Jatinunggal",
        "Pamulihan",
        "Paseh",
        "Rancakalong",
        "Situraja",
        "Sukasari",
        "Sumedang Selatan",
        "Sumedang Utara",
        "Surian",
        "Tanjungkerta",
        "Tanjungmedar",
        "Tanjungsari",
        "Tomo",
        "Ujungjaya",
        "Wado",
      )),
      "Tasikmalaya (Kabupaten)" => drupal_map_assoc(array(
        "Bantarkalong",
        "Bojongasih",
        "Bojonggambir",
        "Ciawi",
        "Cibalong",
        "Cigalontang",
        "Cikalong",
        "Cikatomas",
        "Cineam",
        "Cipatujah",
        "Cisayong",
        "Culamega",
        "Gunung Tanjung",
        "Jamanis",
        "Jatiwaras",
        "Kadipaten",
        "Karang Jaya",
        "Karangnunggal",
        "Leuwisari",
        "Mangunreja",
        "Manonjaya",
        "Padakembang",
        "Pagerageung",
        "Pancatengah",
        "Parungponteng",
        "Puspahiang",
        "Rajapolah",
        "Salawu",
        "Salopa",
        "Sariwangi",
        "Singaparna",
        "Sodonghilir",
        "Sukahening",
        "Sukaraja",
        "Sukarame",
        "Sukaratu",
        "Sukaresik",
        "Tanjungjaya",
        "Taraju",
      )),
      "Tasikmalaya (Kota)" => drupal_map_assoc(array(
        "Bungursari",
        "Cibeureum",
        "Cihideung",
        "Cipedes",
        "Indihiang",
        "Kawalu",
        "Mangkubumi",
        "Purbaratu",
        "Tamansari",
        "Tawang",
      )),
    ),
    "Jawa Tengah" => array(
      "Banjarnegara" => drupal_map_assoc(array(
        "Banjarmangu",
        "Banjarnegara",
        "Batur",
        "Bawang",
        "Kalibening",
        "Karangkobar",
        "Madukara",
        "Mandiraja",
        "Pagedongan",
        "Pagentan",
        "Pandanarum",
        "Pejawaran",
        "Punggelan",
        "Purwonegoro",
        "Purworejo Klampok",
        "Rakit",
        "Sigaluh",
        "Susukan",
        "Wanadadi (Wonodadi)",
        "Wanayasa",
      )),
      "Banyumas" => drupal_map_assoc(array(
        "Ajibarang",
        "Banyumas",
        "Baturaden",
        "Cilongok",
        "Gumelar",
        "Jatilawang",
        "Kalibagor",
        "Karanglewas",
        "Kebasen",
        "Kedung Banteng",
        "Kembaran",
        "Kemranjen",
        "Lumbir",
        "Patikraja",
        "Pekuncen",
        "Purwojati",
        "Purwokerto Barat",
        "Purwokerto Selatan",
        "Purwokerto Timur",
        "Purwokerto Utara",
        "Rawalo",
        "Sokaraja",
        "Somagede",
        "Sumbang",
        "Sumpiuh",
        "Tambak",
        "Wangon",
      )),
      "Batang" => drupal_map_assoc(array(
        "Bandar",
        "Banyuputih",
        "Batang",
        "Bawang",
        "Blado",
        "Gringsing",
        "Kandeman",
        "Limpung",
        "Pecalungan",
        "Reban",
        "Subah",
        "Tersono",
        "Tulis",
        "Warungasem",
        "Wonotunggal",
      )),
      "Blora" => drupal_map_assoc(array(
        "Banjarejo",
        "Blora kota",
        "Bogorejo",
        "Cepu",
        "Japah",
        "Jati",
        "Jepon",
        "Jiken",
        "Kedungtuban",
        "Kradenan",
        "Kunduran",
        "Ngawen",
        "Randublatung",
        "Sambong",
        "Todanan",
        "Tunjungan",
      )),
      "Boyolali" => drupal_map_assoc(array(
        "Ampel",
        "Andong",
        "Banyudono",
        "Boyolali",
        "Cepogo",
        "Juwangi",
        "Karanggede",
        "Kemusu",
        "Klego",
        "Mojosongo",
        "Musuk",
        "Ngemplak",
        "Nogosari",
        "Sambi",
        "Sawit",
        "Selo",
        "Simo",
        "Teras",
        "Wonosegoro",
      )),
      "Brebes" => drupal_map_assoc(array(
        "Banjarharjo",
        "Bantarkawung",
        "Brebes",
        "Bulakamba",
        "Bumiayu",
        "Jatibarang",
        "Kersana",
        "Ketanggungan",
        "Larangan",
        "Losari",
        "Paguyangan",
        "Salem",
        "Sirampog",
        "Songgom",
        "Tanjung",
        "Tonjong",
        "Wanasari",
      )),
      "Cilacap" => drupal_map_assoc(array(
        "Adipala",
        "Bantarsari",
        "Binangun",
        "Cilacap Selatan",
        "Cilacap Tengah",
        "Cilacap Utara",
        "Cimanggu",
        "Cipari",
        "Dayeuhluhur",
        "Gandrungmangu",
        "Jeruklegi",
        "Kampung Laut",
        "Karangpucung",
        "Kawunganten",
        "Kedungreja",
        "Kesugihan",
        "Kroya",
        "Majenang",
        "Maos",
        "Nusawungu",
        "Patimuan",
        "Sampang",
        "Sidareja",
        "Wanareja",
      )),
      "Demak" => drupal_map_assoc(array(
        "Bonang",
        "Demak",
        "Dempet",
        "Gajah",
        "Guntur",
        "Karang Tengah",
        "Karanganyar",
        "Karangawen",
        "Kebonagung",
        "Mijen",
        "Mranggen",
        "Sayung",
        "Wedung",
        "Wonosalam",
      )),
      "Grobogan" => drupal_map_assoc(array(
        "Brati",
        "Gabus",
        "Geyer",
        "Godong",
        "Grobogan",
        "Gubug",
        "Karangrayung",
        "Kedungjati",
        "Klambu",
        "Kradenan",
        "Ngaringan",
        "Penawangan",
        "Pulokulon",
        "Purwodadi",
        "Tanggungharjo",
        "Tawangharjo",
        "Tegowanu",
        "Toroh",
        "Wirosari",
      )),
      "Jepara" => drupal_map_assoc(array(
        "Bangsri",
        "Batealit",
        "Donorojo",
        "Jepara",
        "Kalinyamatan",
        "Karimunjawa",
        "Kedung",
        "Keling",
        "Kembang",
        "Mayong",
        "Mlonggo",
        "Nalumsari",
        "Pakis Aji",
        "Pecangaan",
        "Tahunan",
        "Welahan",
      )),
      "Karanganyar" => drupal_map_assoc(array(
        "Colomadu",
        "Gondangrejo",
        "Jaten",
        "Jatipuro",
        "Jatiyoso",
        "Jenawi",
        "Jumantono",
        "Jumapolo",
        "Karanganyar",
        "Karangpandan",
        "Kebakkramat",
        "Kerjo",
        "Matesih",
        "Mojogedang",
        "Ngargoyoso",
        "Tasikmadu",
        "Tawangmangu",
      )),
      "Kebumen" => drupal_map_assoc(array(
        "Adimulyo",
        "Alian/Aliyan",
        "Ambal",
        "Ayah",
        "Bonorowo",
        "Buayan",
        "Buluspesantren",
        "Gombong",
        "Karanganyar",
        "Karanggayam",
        "Karangsambung",
        "Kebumen",
        "Klirong",
        "Kutowinangun",
        "Kuwarasan",
        "Mirit",
        "Padureso",
        "Pejagoan",
        "Petanahan",
        "Poncowarno",
        "Prembun",
        "Puring",
        "Rowokele",
        "Sadang",
        "Sempor",
        "Sruweng",
      )),
      "Kendal" => drupal_map_assoc(array(
        "Boja",
        "Brangsong",
        "Cepiring",
        "Gemuh",
        "Kaliwungu",
        "Kaliwungu Selatan",
        "Kangkung",
        "Kendal",
        "Limbangan",
        "Ngampel",
        "Pagerruyung",
        "Patean",
        "Patebon",
        "Pegandon",
        "Plantungan",
        "Ringinarum",
        "Rowosari",
        "Singorojo",
        "Sukorejo",
        "Weleri",
      )),
      "Klaten" => drupal_map_assoc(array(
        "Bayat",
        "Cawas",
        "Ceper",
        "Delanggu",
        "Gantiwarno",
        "Jatinom",
        "Jogonalan",
        "Juwiring",
        "Kalikotes",
        "Karanganom",
        "Karangdowo",
        "Karangnongko",
        "Kebonarum",
        "Kemalang",
        "Klaten Selatan",
        "Klaten Tengah",
        "Klaten Utara",
        "Manisrenggo",
        "Ngawen",
        "Pedan",
        "Polanharjo",
        "Prambanan",
        "Trucuk",
        "Tulung",
        "Wedi",
        "Wonosari",
      )),
      "Kudus" => drupal_map_assoc(array(
        "Bae",
        "Dawe",
        "Gebog",
        "Jati",
        "Jekulo",
        "Kaliwungu",
        "Kudus Kota",
        "Mejobo",
        "Undaan",
      )),
      "Magelang (Kabupaten)" => drupal_map_assoc(array(
        "Bandongan",
        "Borobudur",
        "Candimulyo",
        "Dukun",
        "Grabag",
        "Kajoran",
        "Kaliangkrik",
        "Mertoyudan",
        "Mungkid",
        "Muntilan",
        "Ngablak",
        "Ngluwar",
        "Pakis",
        "Salam",
        "Salaman",
        "Sawangan",
        "Secang",
        "Srumbung",
        "Tegalrejo",
        "Tempuran",
        "Windusari",
      )),
      "Magelang (Kota)" => drupal_map_assoc(array(
        "Magelang Selatan",
        "Magelang Tengah",
        "Magelang Utara",
      )),
      "Pati" => drupal_map_assoc(array(
        "Batangan",
        "Cluwak",
        "Dukuhseti",
        "Gabus",
        "Gembong",
        "Gunungwungkal",
        "Jaken",
        "Jakenan",
        "Juwana",
        "Kayen",
        "Margorejo",
        "Margoyoso",
        "Pati",
        "Pucakwangi",
        "Sukolilo",
        "Tambakromo",
        "Tayu",
        "Tlogowungu",
        "Trangkil",
        "Wedarijaksa",
        "Winong",
      )),
      "Pekalongan (Kabupaten)" => drupal_map_assoc(array(
        "Bojong",
        "Buaran",
        "Doro",
        "Kajen",
        "Kandangserang",
        "Karanganyar",
        "Karangdadap",
        "Kedungwuni",
        "Kesesi",
        "Lebakbarang",
        "Paninggaran",
        "Petungkriono/Petungkriyono",
        "Siwalan",
        "Sragi",
        "Talun",
        "Tirto",
        "Wiradesa",
        "Wonokerto",
        "Wonopringgo",
      )),
      "Pekalongan (Kota)" => drupal_map_assoc(array(
        "Pekalongan Barat",
        "Pekalongan Selatan",
        "Pekalongan Timur",
        "Pekalongan Utara",
      )),
      "Pemalang" => drupal_map_assoc(array(
        "Ampelgading",
        "Bantarbolang",
        "Belik",
        "Bodeh",
        "Comal",
        "Moga",
        "Pemalang",
        "Petarukan",
        "Pulosari",
        "Randudongkal",
        "Taman",
        "Ulujami",
        "Warungpring",
        "Watukumpul",
      )),
      "Purbalingga" => drupal_map_assoc(array(
        "Bobotsari",
        "Bojongsari",
        "Bukateja",
        "Kaligondang",
        "Kalimanah",
        "Karanganyar",
        "Karangjambu",
        "Karangmoncol",
        "Karangreja",
        "Kejobong",
        "Kemangkon",
        "Kertanegara",
        "Kutasari",
        "Mrebet",
        "Padamara",
        "Pengadegan",
        "Purbalingga",
        "Rembang",
      )),
      "Purworejo" => drupal_map_assoc(array(
        "Bagelen",
        "Banyuurip",
        "Bayan",
        "Bener",
        "Bruno",
        "Butuh",
        "Gebang",
        "Grabag",
        "Kaligesing",
        "Kemiri",
        "Kutoarjo",
        "Loano",
        "Ngombol",
        "Pituruh",
        "Purwodadi",
        "Purworejo",
      )),
      "Rembang" => drupal_map_assoc(array(
        "Bulu",
        "Gunem",
        "Kaliori",
        "Kragan",
        "Lasem",
        "Pamotan",
        "Pancur",
        "Rembang",
        "Sale",
        "Sarang",
        "Sedan",
        "Sluke",
        "Sulang",
        "Sumber",
      )),
      "Salatiga" => drupal_map_assoc(array(
        "Argomulyo",
        "Sidomukti",
        "Sidorejo",
        "Tingkir",
      )),
      "Semarang (Kabupaten)" => drupal_map_assoc(array(
        "Ambarawa",
        "Bancak",
        "Bandungan",
        "Banyubiru",
        "Bawen",
        "Bergas",
        "Bringin",
        "Getasan",
        "Jambu",
        "Kaliwungu",
        "Pabelan",
        "Pringapus",
        "Sumowono",
        "Suruh",
        "Susukan",
        "Tengaran",
        "Tuntang",
        "Ungaran Barat",
        "Ungaran Timur",
      )),
      "Semarang (Kota)" => drupal_map_assoc(array(
        "Banyumanik",
        "Candisari",
        "Gajah Mungkur",
        "Gayamsari",
        "Genuk",
        "Gunungpati",
        "Mijen",
        "Ngaliyan",
        "Pedurungan",
        "Semarang Barat",
        "Semarang Selatan",
        "Semarang Tengah",
        "Semarang Timur",
        "Semarang Utara",
        "Tembalang",
        "Tugu",
      )),
      "Sragen" => drupal_map_assoc(array(
        "Gemolong",
        "Gesi",
        "Gondang",
        "Jenar",
        "Kalijambe",
        "Karangmalang",
        "Kedawung",
        "Masaran",
        "Miri",
        "Mondokan",
        "Ngrampal",
        "Plupuh",
        "Sambirejo",
        "Sambung Macan",
        "Sidoharjo",
        "Sragen",
        "Sukodono",
        "Sumberlawang",
        "Tangen",
        "Tanon",
      )),
      "Sukoharjo" => drupal_map_assoc(array(
        "Baki",
        "Bendosari",
        "Bulu",
        "Gatak",
        "Grogol",
        "Kartasura",
        "Mojolaban",
        "Nguter",
        "Polokarto",
        "Sukoharjo",
        "Tawangsari",
        "Weru",
      )),
      "Surakarta (Solo)" => drupal_map_assoc(array(
        "Banjarsari",
        "Jebres",
        "Laweyan",
        "Pasar Kliwon",
        "Serengan",
      )),
      "Tegal (Kabupaten)" => drupal_map_assoc(array(
        "Adiwerna",
        "Balapulang",
        "Bojong",
        "Bumijawa",
        "Dukuhturi",
        "Dukuhwaru",
        "Jatinegara",
        "Kedung Banteng",
        "Kramat",
        "Lebaksiu",
        "Margasari",
        "Pagerbarang",
        "Pangkah",
        "Slawi",
        "Surodadi",
        "Talang",
        "Tarub",
        "Warurejo",
      )),
      "Tegal (Kota)" => drupal_map_assoc(array(
        "Margadana",
        "Tegal Barat",
        "Tegal Selatan",
        "Tegal Timur",
      )),
      "Temanggung" => drupal_map_assoc(array(
        "Bansari",
        "Bejen",
        "Bulu",
        "Candiroto",
        "Gemawang",
        "Jumo",
        "Kaloran",
        "Kandangan",
        "Kedu",
        "Kledung",
        "Kranggan",
        "Ngadirejo",
        "Parakan",
        "Pringsurat",
        "Selopampang",
        "Temanggung",
        "Tembarak",
        "Tlogomulyo",
        "Tretep",
        "Wonoboyo",
      )),
      "Wonogiri" => drupal_map_assoc(array(
        "Baturetno",
        "Batuwarno",
        "Bulukerto",
        "Eromoko",
        "Girimarto",
        "Giritontro",
        "Giriwoyo",
        "Jatipurno",
        "Jatiroto",
        "Jatisrono",
        "Karangtengah",
        "Kismantoro",
        "Manyaran",
        "Ngadirojo",
        "Nguntoronadi",
        "Paranggupito",
        "Pracimantoro",
        "Puhpelem",
        "Purwantoro",
        "Selogiri",
        "Sidoharjo",
        "Slogohimo",
        "Tirtomoyo",
        "Wonogiri",
        "Wuryantoro",
      )),
      "Wonosobo" => drupal_map_assoc(array(
        "Garung",
        "Kalibawang",
        "Kalikajar",
        "Kaliwiro",
        "Kejajar",
        "Kepil",
        "Kertek",
        "Leksono",
        "Mojotengah",
        "Sapuran",
        "Selomerto",
        "Sukoharjo",
        "Wadaslintang",
        "Watumalang",
        "Wonosobo",
      )),
    ),
    "Jawa Timur" => array(
      "Bangkalan" => drupal_map_assoc(array(
        "Arosbaya",
        "Bangkalan",
        "Blega",
        "Burneh",
        "Galis",
        "Geger",
        "Kamal",
        "Klampis",
        "Kokop",
        "Konang",
        "Kwanyar",
        "Labang",
        "Modung",
        "Sepulu",
        "Socah",
        "Tanah Merah",
        "Tanjungbumi",
        "Tragah",
      )),
      "Banyuwangi" => drupal_map_assoc(array(
        "Bangorejo",
        "Banyuwangi",
        "Cluring",
        "Gambiran",
        "Genteng",
        "Giri",
        "Glagah",
        "Glenmore",
        "Kabat",
        "Kalibaru",
        "Kalipuro",
        "Licin",
        "Muncar",
        "Pesanggaran",
        "Purwoharjo",
        "Rogojampi",
        "Sempu",
        "Siliragung",
        "Singojuruh",
        "Songgon",
        "Srono",
        "Tegaldlimo",
        "Tegalsari",
        "Wongsorejo",
      )),
      "Batu" => drupal_map_assoc(array(
        "Batu",
        "Bumiaji",
        "Junrejo",
      )),
      "Blitar (Kabupaten)" => drupal_map_assoc(array(
        "Bakung",
        "Binangun",
        "Doko",
        "Gandusari",
        "Garum",
        "Kademangan",
        "Kanigoro",
        "Kesamben",
        "Nglegok",
        "Panggungrejo",
        "Ponggok",
        "Sanan Kulon",
        "Selopuro",
        "Selorejo",
        "Srengat",
        "Sutojayan",
        "Talun",
        "Udanawu",
        "Wates",
        "Wlingi",
        "Wonodadi",
        "Wonotirto",
      )),
      "Blitar (Kota)" => drupal_map_assoc(array(
        "Kepanjen Kidul",
        "Sanan Wetan",
        "Sukorejo",
      )),
      "Bojonegoro" => drupal_map_assoc(array(
        "Balen",
        "Baureno",
        "Bojonegoro",
        "Bubulan",
        "Dander",
        "Gayam",
        "Gondang",
        "Kalitidu",
        "Kanor",
        "Kapas",
        "Kasiman",
        "Kedewan",
        "Kedungadem",
        "Kepoh Baru",
        "Malo",
        "Margomulyo",
        "Ngambon",
        "Ngasem",
        "Ngraho",
        "Padangan",
        "Purwosari",
        "Sekar",
        "Sugihwaras",
        "Sukosewu",
        "Sumberrejo",
        "Tambakrejo",
        "Temayang",
        "Trucuk",
      )),
      "Bondowoso" => drupal_map_assoc(array(
        "Binakal",
        "Bondowoso",
        "Botolinggo",
        "Cermee",
        "Curahdami",
        "Grujugan",
        "Jambe Sari Darus Sholah",
        "Klabang",
        "Maesan",
        "Pakem",
        "Prajekan",
        "Pujer",
        "Sempol",
        "Sukosari",
        "Sumber Wringin",
        "Taman Krocok",
        "Tamanan",
        "Tapen",
        "Tegalampel",
        "Tenggarang",
        "Tlogosari",
        "Wonosari",
        "Wringin",
      )),
      "Gresik" => drupal_map_assoc(array(
        "Balong Panggang",
        "Benjeng",
        "Bungah",
        "Cerme",
        "Driyorejo",
        "Duduk Sampeyan",
        "Dukun",
        "Gresik",
        "Kebomas",
        "Kedamean",
        "Manyar",
        "Menganti",
        "Panceng",
        "Sangkapura",
        "Sidayu",
        "Tambak",
        "Ujung Pangkah",
        "Wringin Anom",
      )),
      "Jember" => drupal_map_assoc(array(
        "Ajung",
        "Ambulu",
        "Arjasa",
        "Balung",
        "Bangsalsari",
        "Gumuk Mas",
        "Jelbuk",
        "Jenggawah",
        "Jombang",
        "Kalisat",
        "Kaliwates",
        "Kencong",
        "Ledokombo",
        "Mayang",
        "Mumbulsari",
        "Pakusari",
        "Panti",
        "Patrang",
        "Puger",
        "Rambipuji",
        "Semboro",
        "Silo",
        "Sukorambi",
        "Sukowono",
        "Sumber Baru",
        "Sumber Jambe",
        "Sumber Sari",
        "Tanggul",
        "Tempurejo",
        "Umbulsari",
        "Wuluhan",
      )),
      "Jombang" => drupal_map_assoc(array(
        "Bandar Kedung Mulyo",
        "Bareng",
        "Diwek",
        "Gudo",
        "Jogoroto",
        "Jombang",
        "Kabuh",
        "Kesamben",
        "Kudu",
        "Megaluh",
        "Mojoagung",
        "Mojowarno",
        "Ngoro",
        "Ngusikan",
        "Perak",
        "Peterongan",
        "Plandaan",
        "Ploso",
        "Sumobito",
        "Tembelang",
        "Wonosalam",
      )),
      "Kediri (Kabupaten)" => drupal_map_assoc(array(
        "Badas",
        "Banyakan",
        "Gampengrejo",
        "Grogol",
        "Gurah",
        "Kandangan",
        "Kandat",
        "Kayen Kidul",
        "Kepung",
        "Kras",
        "Kunjang",
        "Mojo",
        "Ngadiluwih",
        "Ngancar",
        "Ngasem",
        "Pagu",
        "Papar",
        "Pare",
        "Plemahan",
        "Plosoklaten",
        "Puncu",
        "Purwoasri",
        "Ringinrejo",
        "Semen",
        "Tarokan",
        "Wates",
      )),
      "Kediri (Kota)" => drupal_map_assoc(array(
        "Kediri Kota",
        "Mojoroto",
        "Pesantren",
      )),
      "Lamongan" => drupal_map_assoc(array(
        "Babat",
        "Bluluk",
        "Brondong",
        "Deket",
        "Glagah",
        "Kalitengah",
        "Karang Geneng",
        "Karangbinangun",
        "Kedungpring",
        "Kembangbahu",
        "Lamongan",
        "Laren",
        "Maduran",
        "Mantup",
        "Modo",
        "Ngimbang",
        "Paciran",
        "Pucuk",
        "Sambeng",
        "Sarirejo",
        "Sekaran",
        "Solokuro",
        "Sugio",
        "Sukodadi",
        "Sukorame",
        "Tikung",
        "Turi",
      )),
      "Lumajang" => drupal_map_assoc(array(
        "Candipuro",
        "Gucialit",
        "Jatiroto",
        "Kedungjajang",
        "Klakah",
        "Kunir",
        "Lumajang",
        "Padang",
        "Pasirian",
        "Pasrujambe/Pasujambe",
        "Pronojiwo",
        "Randuagung",
        "Ranuyoso",
        "Rowokangkung",
        "Senduro",
        "Sukodono",
        "Sumbersuko",
        "Tekung",
        "Tempeh",
        "Tempursari",
        "Yosowilangun",
      )),
      "Madiun (Kabupaten)" => drupal_map_assoc(array(
        "Balerejo",
        "Dagangan",
        "Dolopo",
        "Geger",
        "Gemarang",
        "Jiwan",
        "Kare",
        "Kebonsari",
        "Madiun",
        "Mejayan",
        "Pilangkenceng",
        "Saradan",
        "Sawahan",
        "Wonoasri",
        "Wungu",
      )),
      "Madiun (Kota)" => drupal_map_assoc(array(
        "Kartoharjo",
        "Manguharjo",
        "Taman",
      )),
      "Magetan" => drupal_map_assoc(array(
        "Barat",
        "Bendo",
        "Karangrejo",
        "Karas",
        "Kartoharjo (Kertoharjo)",
        "Kawedanan",
        "Lembeyan",
        "Magetan",
        "Maospati",
        "Ngariboyo",
        "Nguntoronadi",
        "Panekan",
        "Parang",
        "Plaosan",
        "Poncol",
        "Sidorejo",
        "Sukomoro",
        "Takeran",
      )),
      "Malang (Kabupaten)" => drupal_map_assoc(array(
        "Ampelgading",
        "Bantur",
        "Bululawang",
        "Dampit",
        "Dau",
        "Donomulyo",
        "Gedangan",
        "Gondanglegi",
        "Jabung",
        "Kalipare",
        "Karangploso",
        "Kasembon",
        "Kepanjen",
        "Kromengan",
        "Lawang",
        "Ngajung (Ngajum)",
        "Ngantang",
        "Pagak",
        "Pagelaran",
        "Pakis",
        "Pakisaji",
        "Poncokusumo",
        "Pujon",
        "Singosari",
        "Sumbermanjing Wetan",
        "Sumberpucung",
        "Tajinan",
        "Tirtoyudo",
        "Tumpang",
        "Turen",
        "Wagir",
        "Wajak",
        "Wonosari",
      )),
      "Malang (Kota)" => drupal_map_assoc(array(
        "Blimbing",
        "Kedungkandang",
        "Klojen",
        "Lowokwaru",
        "Sukun",
      )),
      "Mojokerto (Kabupaten)" => drupal_map_assoc(array(
        "Bangsal",
        "Dawar Blandong",
        "Dlanggu",
        "Gedeg",
        "Gondang",
        "Jatirejo",
        "Jetis",
        "Kemlagi",
        "Kutorejo",
        "Mojoanyar",
        "Mojosari",
        "Ngoro",
        "Pacet",
        "Pungging",
        "Puri",
        "Sooko",
        "Trawas",
        "Trowulan",
      )),
      "Mojokerto (Kota)" => drupal_map_assoc(array(
        "Magersari",
        "Prajurit Kulon",
      )),
      "Nganjuk" => drupal_map_assoc(array(
        "Bagor",
        "Baron",
        "Berbek",
        "Gondang",
        "Jatikalen",
        "Kertosono",
        "Lengkong",
        "Loceret",
        "Nganjuk",
        "Ngetos",
        "Ngluyu",
        "Ngronggot",
        "Pace",
        "Patianrowo",
        "Prambon",
        "Rejoso",
        "Sawahan",
        "Sukomoro",
        "Tanjunganom",
        "Wilangan",
      )),
      "Ngawi" => drupal_map_assoc(array(
        "Bringin",
        "Geneng",
        "Gerih",
        "Jogorogo",
        "Karanganyar",
        "Karangjati",
        "Kasreman",
        "Kedunggalar",
        "Kendal",
        "Kwadungan",
        "Mantingan",
        "Ngawi",
        "Ngrambe",
        "Padas",
        "Pangkur",
        "Paron",
        "Pitu",
        "Sine",
        "Widodaren",
      )),
      "Pacitan" => drupal_map_assoc(array(
        "Arjosari",
        "Bandar",
        "Donorojo",
        "Kebon Agung",
        "Nawangan",
        "Ngadirojo",
        "Pacitan",
        "Pringkuku",
        "Punung",
        "Sudimoro",
        "Tegalombo",
        "Tulakan",
      )),
      "Pamekasan" => drupal_map_assoc(array(
        "Batumarmar",
        "Galis",
        "Kadur",
        "Larangan",
        "Pademawu",
        "Pakong",
        "Palenga'an",
        "Pamekasan",
        "Pasean",
        "Pegantenan",
        "Proppo",
        "Tlanakan",
        "Waru",
      )),
      "Pasuruan (Kabupaten)" => drupal_map_assoc(array(
        "Bangil",
        "Beji",
        "Gempol",
        "Gondang Wetan",
        "Grati",
        "Kejayan",
        "Kraton",
        "Lekok",
        "Lumbang",
        "Nguling",
        "Pandaan",
        "Pasrepan",
        "Pohjentrek",
        "Prigen",
        "Purwodadi",
        "Purwosari",
        "Puspo",
        "Rejoso",
        "Rembang",
        "Sukorejo",
        "Tosari",
        "Tutur",
        "Winongan",
        "Wonorejo",
      )),
      "Pasuruan (Kota)" => drupal_map_assoc(array(
        "Bugul Kidul",
        "Gadingrejo",
        "Panggungrejo",
        "Purworejo",
      )),
      "Ponorogo" => drupal_map_assoc(array(
        "Babadan",
        "Badegan",
        "Balong",
        "Bungkal",
        "Jambon",
        "Jenangan",
        "Jetis",
        "Kauman",
        "Mlarak",
        "Ngebel",
        "Ngrayun",
        "Ponorogo",
        "Pudak",
        "Pulung",
        "Sambit",
        "Sampung",
        "Sawoo",
        "Siman",
        "Slahung",
        "Sooko",
        "Sukorejo",
      )),
      "Probolinggo (Kabupaten)" => drupal_map_assoc(array(
        "Bantaran",
        "Banyu Anyar",
        "Besuk",
        "Dringu",
        "Gading",
        "Gending",
        "Kota Anyar",
        "Kraksaan",
        "Krejengan",
        "Krucil",
        "Kuripan",
        "Leces",
        "Lumbang",
        "Maron",
        "Paiton",
        "Pajarakan",
        "Pakuniran",
        "Sukapura",
        "Sumber",
        "Sumberasih",
        "Tegal Siwalan",
        "Tiris",
        "Tongas",
        "Wonomerto",
      )),
      "Probolinggo (Kota)" => drupal_map_assoc(array(
        "Kademangan",
        "Kanigaran",
        "Kedopok (Kedopak)",
        "Mayangan",
        "Wonoasih",
      )),
      "Sampang" => drupal_map_assoc(array(
        "Banyuates",
        "Camplong",
        "Jrengik",
        "Karang Penang",
        "Kedungdung",
        "Ketapang",
        "Omben",
        "Pangarengan",
        "Robatal",
        "Sampang",
        "Sokobanah",
        "Sreseh",
        "Tambelangan",
        "Torjun",
      )),
      "Sidoarjo" => drupal_map_assoc(array(
        "Balongbendo",
        "Buduran",
        "Candi",
        "Gedangan",
        "Jabon",
        "Krembung",
        "Krian",
        "Porong",
        "Prambon",
        "Sedati",
        "Sidoarjo",
        "Sukodono",
        "Taman",
        "Tanggulangin",
        "Tarik",
        "Tulangan",
        "Waru",
        "Wonoayu",
      )),
      "Situbondo" => drupal_map_assoc(array(
        "Arjasa",
        "Asembagus",
        "Banyuglugur",
        "Banyuputih",
        "Besuki",
        "Bungatan",
        "Jangkar",
        "Jatibanteng",
        "Kapongan",
        "Kendit",
        "Mangaran",
        "Mlandingan",
        "Panarukan",
        "Panji",
        "Situbondo",
        "Suboh",
        "Sumbermalang",
      )),
      "Sumenep" => drupal_map_assoc(array(
        "Ambunten",
        "Arjasa",
        "Batang Batang",
        "Batuan",
        "Batuputih",
        "Bluto",
        "Dasuk",
        "Dungkek",
        "Ganding",
        "Gapura",
        "Gayam",
        "Gili Ginting (Giligenteng)",
        "Guluk Guluk",
        "Kalianget",
        "Kangayan",
        "Kota Sumenep",
        "Lenteng",
        "Manding",
        "Masalembu",
        "Nonggunong",
        "Pasongsongan",
        "Pragaan",
        "Ra'as (Raas)",
        "Rubaru",
        "Sapeken",
        "Saronggi",
        "Talango",
      )),
      "Surabaya" => drupal_map_assoc(array(
        "Asemrowo",
        "Benowo",
        "Bubutan",
        "Bulak",
        "Dukuh Pakis",
        "Gayungan",
        "Genteng",
        "Gubeng",
        "Gununganyar",
        "Jambangan",
        "Karangpilang",
        "Kenjeran",
        "Krembangan",
        "Lakar Santri",
        "Mulyorejo",
        "Pabean Cantikan",
        "Pakal",
        "Rungkut",
        "Sambikerep",
        "Sawahan",
        "Semampir",
        "Simokerto",
        "Sukolilo",
        "Sukomanunggal",
        "Tambaksari",
        "Tandes",
        "Tegalsari",
        "Tenggilis Mejoyo",
        "Wiyung",
        "Wonocolo",
        "Wonokromo",
      )),
      "Trenggalek" => drupal_map_assoc(array(
        "Bendungan",
        "Dongko",
        "Durenan",
        "Gandusari",
        "Kampak",
        "Karangan",
        "Munjungan",
        "Panggul",
        "Pogalan",
        "Pule",
        "Suruh",
        "Trenggalek",
        "Tugu",
        "Watulimo",
      )),
      "Tuban" => drupal_map_assoc(array(
        "Bancar",
        "Bangilan",
        "Grabagan",
        "Jatirogo",
        "Jenu",
        "Kenduruan",
        "Kerek",
        "Merakurak",
        "Montong",
        "Palang",
        "Parengan",
        "Plumpang",
        "Rengel",
        "Semanding",
        "Senori",
        "Singgahan",
        "Soko",
        "Tambakboyo",
        "Tuban",
        "Widang",
      )),
      "Tulungagung" => drupal_map_assoc(array(
        "Bandung",
        "Besuki",
        "Boyolangu",
        "Campur Darat",
        "Gondang",
        "Kalidawir",
        "Karang Rejo",
        "Kauman",
        "Kedungwaru",
        "Ngantru",
        "Ngunut",
        "Pagerwojo",
        "Pakel",
        "Pucanglaban",
        "Rejotangan",
        "Sendang",
        "Sumbergempol",
        "Tanggung Gunung",
        "Tulungagung",
      )),
    ),
    "Kalimantan Barat" => array(
      "Bengkayang" => drupal_map_assoc(array(
        "Bengkayang",
        "Capkala",
        "Jagoi Babang",
        "Ledo",
        "Lembah Bawang",
        "Lumar",
        "Monterado",
        "Samalantan",
        "Sanggau Ledo",
        "Seluas",
        "Siding",
        "Sungai Betung",
        "Sungai Raya",
        "Sungai Raya Kepulauan",
        "Suti Semarang",
        "Teriak",
        "Tujuh Belas",
      )),
      "Kapuas Hulu" => drupal_map_assoc(array(
        "Badau",
        "Batang Lupar",
        "Bika",
        "Boyan Tanjung",
        "Bunut Hilir",
        "Bunut Hulu",
        "Embaloh Hilir",
        "Embaloh Hulu",
        "Empanang",
        "Hulu Gurung",
        "Jongkong (Jengkong)",
        "Kalis",
        "Mentebah",
        "Pengkadan (Batu Datu)",
        "Puring Kencana",
        "Putussibau Selatan",
        "Putussibau Utara",
        "Seberuang",
        "Selimbau",
        "Semitau",
        "Silat Hilir",
        "Silat Hulu",
        "Suhaid",
      )),
      "Kayong Utara" => drupal_map_assoc(array(
        "Kepulauan Karimata",
        "Pulau Maya (Pulau Maya Karimata)",
        "Seponti",
        "Simpang Hilir",
        "Sukadana",
        "Teluk Batang",
      )),
      "Ketapang" => drupal_map_assoc(array(
        "Air Upas",
        "Benua Kayong",
        "Delta Pawan",
        "Hulu Sungai",
        "Jelai Hulu",
        "Kendawangan",
        "Manis Mata",
        "Marau",
        "Matan Hilir Selatan",
        "Matan Hilir Utara",
        "Muara Pawan",
        "Nanga Tayap",
        "Pemahan",
        "Sandai",
        "Simpang Dua",
        "Simpang Hulu",
        "Singkup",
        "Sungai Laur",
        "Sungai Melayu Rayak",
        "Tumbang Titi",
      )),
      "Kubu Raya" => drupal_map_assoc(array(
        "Batu Ampar",
        "Kuala Mandor-B",
        "Kubu",
        "Rasau Jaya",
        "Sei/Sungai Ambawang",
        "Sei/Sungai Kakap",
        "Sei/Sungai Raya",
        "Teluk/Telok Pakedai",
        "Terentang",
      )),
      "Landak" => drupal_map_assoc(array(
        "Air Besar",
        "Banyuke Hulu",
        "Jelimpo",
        "Kuala Behe",
        "Mandor",
        "Mempawah Hulu",
        "Menjalin",
        "Menyuke",
        "Meranti",
        "Ngabang",
        "Sebangki",
        "Sengah Temila",
        "Sompak",
      )),
      "Melawi" => drupal_map_assoc(array(
        "Belimbing",
        "Belimbing Hulu",
        "Ella Hilir",
        "Menukung",
        "Nanga Pinoh",
        "Pinoh Selatan",
        "Pinoh Utara",
        "Sayan",
        "Sokan",
        "Tanah Pinoh",
        "Tanah Pinoh Barat",
      )),
      "Pontianak (Kabupaten)" => drupal_map_assoc(array(
        "Anjongan",
        "Mempawah Hilir",
        "Mempawah Timur",
        "Sadaniang",
        "Segedong",
        "Sei/Sungai Kunyit",
        "Sei/Sungai Pinyuh",
        "Siantan",
        "Toho",
      )),
      "Pontianak (Kota)" => drupal_map_assoc(array(
        "Pontianak Barat",
        "Pontianak Kota",
        "Pontianak Selatan",
        "Pontianak Tenggara",
        "Pontianak Timur",
        "Pontianak Utara",
      )),
      "Sambas" => drupal_map_assoc(array(
        "Galing",
        "Jawai",
        "Jawai Selatan",
        "Paloh",
        "Pemangkat",
        "Sajad",
        "Sajingan Besar",
        "Salatiga",
        "Sambas",
        "Sebawi",
        "Sejangkung",
        "Selakau",
        "Selakau Timur",
        "Semparuk",
        "Subah",
        "Tangaran",
        "Tebas",
        "Tekarang",
        "Teluk Keramat",
      )),
      "Sanggau" => drupal_map_assoc(array(
        "Balai",
        "Beduai (Beduwai)",
        "Bonti",
        "Entikong",
        "Jangkang",
        "Kapuas (Sanggau Kapuas)",
        "Kembayan",
        "Meliau",
        "Mukok",
        "Noyan",
        "Parindu",
        "Sekayam",
        "Tayan Hilir",
        "Tayan Hulu",
        "Toba",
      )),
      "Sekadau" => drupal_map_assoc(array(
        "Belitang",
        "Belitang Hilir",
        "Belitang Hulu",
        "Nanga Mahap",
        "Nanga Taman",
        "Sekadau Hilir",
        "Sekadau Hulu",
      )),
      "Singkawang" => drupal_map_assoc(array(
        "Singkawang Barat",
        "Singkawang Selatan",
        "Singkawang Tengah",
        "Singkawang Timur",
        "Singkawang Utara",
      )),
      "Sintang" => drupal_map_assoc(array(
        "Ambalau",
        "Binjai Hulu",
        "Dedai",
        "Kayan Hilir",
        "Kayan Hulu",
        "Kelam Permai",
        "Ketungau Hilir",
        "Ketungau Hulu",
        "Ketungau Tengah",
        "Sepauk",
        "Serawai (Nanga Serawai)",
        "Sintang",
        "Sungai Tebelian",
        "Tempunak",
      )),
    ),
    "Kalimantan Selatan" => array(
      "Balangan" => drupal_map_assoc(array(
        "Awayan",
        "Batu Mandi",
        "Halong",
        "Juai",
        "Lampihong",
        "Paringin",
        "Paringin Selatan",
        "Tebing Tinggi",
      )),
      "Banjar (Kabupaten)" => drupal_map_assoc(array(
        "Aluh-Aluh",
        "Aranio",
        "Astambul",
        "Beruntung Baru",
        "Gambut",
        "Karang Intan",
        "Kertak Hanyar",
        "Martapura Barat",
        "Martapura Kota",
        "Martapura Timur",
        "Mataraman",
        "Pengaron",
        "Peramasan",
        "Sambung Makmur",
        "Sei/Sungai Pinang",
        "Sei/Sungai Tabuk",
        "Simpang Empat",
        "Tatah Makmur",
        "Telaga Bauntung",
      )),
      "Banjarbaru" => drupal_map_assoc(array(
        "Banjar Baru Selatan",
        "Banjar Baru Utara",
        "Cempaka",
        "Landasan Ulin",
        "Liang Anggang",
      )),
      "Banjarmasin" => drupal_map_assoc(array(
        "Banjarmasin Barat",
        "Banjarmasin Selatan",
        "Banjarmasin Tengah",
        "Banjarmasin Timur",
        "Banjarmasin Utara",
      )),
      "Barito Kuala" => drupal_map_assoc(array(
        "Alalak",
        "Anjir Muara",
        "Anjir Pasar",
        "Bakumpai",
        "Barambai",
        "Belawang",
        "Cerbon",
        "Jejangkit",
        "Kuripan",
        "Mandastana",
        "Marabahan",
        "Mekar Sari",
        "Rantau Badauh",
        "Tabukan",
        "Tabunganen",
        "Tamban",
        "Wanaraya",
      )),
      "Hulu Sungai Selatan" => drupal_map_assoc(array(
        "Angkinang",
        "Daha Barat",
        "Daha Selatan",
        "Daha Utara",
        "Kalumpang (Kelumpang)",
        "Kandangan",
        "Loksado",
        "Padang Batung",
        "Simpur",
        "Sungai Raya",
        "Telaga Langsat",
      )),
      "Hulu Sungai Tengah" => drupal_map_assoc(array(
        "Barabai",
        "Batang Alai Selatan",
        "Batang Alai Timur",
        "Batang Alai Utara",
        "Batu Benawa",
        "Hantakan",
        "Haruyan",
        "Labuan Amas Selatan",
        "Labuan Amas Utara",
        "Limpasu",
        "Pandawan",
      )),
      "Hulu Sungai Utara" => drupal_map_assoc(array(
        "Amuntai Selatan",
        "Amuntai Tengah",
        "Amuntai Utara",
        "Babirik",
        "Banjang",
        "Danau Panggang",
        "Haur Gading",
        "Paminggir",
        "Sungai Pandan",
        "Sungai Tabukan",
      )),
      "Kotabaru" => drupal_map_assoc(array(
        "Hampang",
        "Kelumpang Barat",
        "Kelumpang Hilir",
        "Kelumpang Hulu",
        "Kelumpang Selatan",
        "Kelumpang Tengah",
        "Kelumpang Utara",
        "Pamukan Barat",
        "Pamukan Selatan",
        "Pamukan Utara",
        "Pulau Laut Barat",
        "Pulau Laut Kepulauan",
        "Pulau Laut Selatan",
        "Pulau Laut Tanjung Selayar",
        "Pulau Laut Tengah",
        "Pulau Laut Timur",
        "Pulau Laut Utara",
        "Pulau Sebuku",
        "Pulau Sembilan",
        "Sampanahan",
        "Sungai Durian",
      )),
      "Tabalong" => drupal_map_assoc(array(
        "Banua Lawas",
        "Bintang Ara",
        "Haruai",
        "Jaro",
        "Kelua (Klua)",
        "Muara Harus",
        "Muara Uya",
        "Murung Pudak",
        "Pugaan",
        "Tanjung",
        "Tanta",
        "Upau",
      )),
      "Tanah Bumbu" => drupal_map_assoc(array(
        "Angsana",
        "Batulicin",
        "Karang Bintang",
        "Kuranji",
        "Kusan Hilir",
        "Kusan Hulu",
        "Mantewe",
        "Satui",
        "Simpang Empat",
        "Sungai Loban",
      )),
      "Tanah Laut" => drupal_map_assoc(array(
        "Bajuin",
        "Bati-Bati",
        "Batu Ampar",
        "Bumi Makmur",
        "Jorong",
        "Kintap",
        "Kurau",
        "Panyipatan",
        "Pelaihari",
        "Takisung",
        "Tambang Ulang",
      )),
      "Tapin" => drupal_map_assoc(array(
        "Bakarangan",
        "Binuang",
        "Bungur",
        "Candi Laras Selatan",
        "Candi Laras Utara",
        "Hatungun",
        "Lokpaikat",
        "Piani",
        "Salam Babaris",
        "Tapin Selatan",
        "Tapin Tengah",
        "Tapin Utara",
      )),
    ),
    "Kalimantan Tengah" => array(
      "Barito Selatan" => drupal_map_assoc(array(
        "Dusun Hilir",
        "Dusun Selatan",
        "Dusun Utara",
        "Gunung Bintang Awai",
        "Jenamas",
        "Karau Kuala",
      )),
      "Barito Timur" => drupal_map_assoc(array(
        "Awang",
        "Benua Lima",
        "Dusun Tengah",
        "Dusun Timur",
        "Karusen Janang",
        "Paju Epat",
        "Paku",
        "Patangkep Tutui",
        "Pematang Karau",
        "Raren Batuah",
      )),
      "Barito Utara" => drupal_map_assoc(array(
        "Gunung Purei",
        "Gunung Timang",
        "Lahei",
        "Lahei Barat",
        "Montallat (Montalat)",
        "Teweh Baru",
        "Teweh Selatan",
        "Teweh Tengah",
        "Teweh Timur",
      )),
      "Gunung Mas" => drupal_map_assoc(array(
        "Damang Batu",
        "Kahayan Hulu Utara",
        "Kurun",
        "Manuhing",
        "Manuhing Raya",
        "Mihing Raya",
        "Miri Manasa",
        "Rungan",
        "Rungan Barat",
        "Rungan Hulu",
        "Sepang (Sepang Simin)",
        "Tewah",
      )),
      "Kapuas" => drupal_map_assoc(array(
        "Basarang",
        "Bataguh",
        "Dadahup",
        "Kapuas Barat",
        "Kapuas Hilir",
        "Kapuas Hulu",
        "Kapuas Kuala",
        "Kapuas Murung",
        "Kapuas Tengah",
        "Kapuas Timur",
        "Mandau Talawang",
        "Mantangai",
        "Pasak Talawang",
        "Pulau Petak",
        "Selat",
        "Tamban Catur",
        "Timpah",
      )),
      "Katingan" => drupal_map_assoc(array(
        "Bukit Raya",
        "Kamipang",
        "Katingan Hilir",
        "Katingan Hulu",
        "Katingan Kuala",
        "Katingan Tengah",
        "Marikit",
        "Mendawai",
        "Petak Malai",
        "Pulau Malan",
        "Sanaman Mantikei (Senamang Mantikei)",
        "Tasik Payawan",
        "Tewang Sanggalang Garing (Sangalang)",
      )),
      "Kotawaringin Barat" => drupal_map_assoc(array(
        "Arut Selatan",
        "Arut Utara",
        "Kotawaringin Lama",
        "Kumai",
        "Pangkalan Banteng",
        "Pangkalan Lada",
      )),
      "Kotawaringin Timur" => drupal_map_assoc(array(
        "Antang Kalang",
        "Baamang",
        "Bukit Santuei",
        "Cempaga",
        "Cempaga Hulu",
        "Kota Besi",
        "Mentawa Baru (Ketapang)",
        "Mentaya Hilir Selatan",
        "Mentaya Hilir Utara",
        "Mentaya Hulu",
        "Parenggean",
        "Pulau Hanaut",
        "Seranau",
        "Telaga Antang",
        "Telawang",
        "Teluk Sampit",
        "Tualan Hulu",
      )),
      "Lamandau" => drupal_map_assoc(array(
        "Batangkawa",
        "Belantikan Raya",
        "Bulik",
        "Bulik Timur",
        "Delang",
        "Lamandau",
        "Menthobi Raya",
        "Sematu Jaya",
      )),
      "Murung Raya" => drupal_map_assoc(array(
        "Barito Tuhup Raya",
        "Laung Tuhup",
        "Murung",
        "Permata Intan",
        "Seribu Riam",
        "Sumber Barito",
        "Sungai Babuat",
        "Tanah Siang",
        "Tanah Siang Selatan",
        "Uut Murung",
      )),
      "Palangka Raya" => drupal_map_assoc(array(
        "Bukit Batu",
        "Jekan Raya",
        "Pahandut",
        "Rakumpit",
        "Sebangau",
      )),
      "Pulang Pisau" => drupal_map_assoc(array(
        "Banama Tingang",
        "Jabiren Raya",
        "Kahayan Hilir",
        "Kahayan Kuala",
        "Kahayan Tengah",
        "Maliku",
        "Pandih Batu",
        "Sebangau Kuala",
      )),
      "Seruyan" => drupal_map_assoc(array(
        "Batu Ampar",
        "Danau Seluluk",
        "Danau Sembuluh",
        "Hanau",
        "Seruyan Hilir",
        "Seruyan Hilir Timur",
        "Seruyan Hulu",
        "Seruyan Raya",
        "Seruyan Tengah",
        "Suling Tambun",
      )),
      "Sukamara" => drupal_map_assoc(array(
        "Balai Riam",
        "Jelai",
        "Pantai Lunci",
        "Permata Kecubung",
        "Sukamara",
      )),
    ),
    "Kalimantan Timur" => array(
      "Balikpapan" => drupal_map_assoc(array(
        "Balikpapan Barat",
        "Balikpapan Kota",
        "Balikpapan Selatan",
        "Balikpapan Tengah",
        "Balikpapan Timur",
        "Balikpapan Utara",
      )),
      "Berau" => drupal_map_assoc(array(
        "Batu Putih",
        "Biatan",
        "Biduk-Biduk",
        "Derawan (Pulau Derawan)",
        "Gunung Tabur",
        "Kelay",
        "Maratua",
        "Sambaliung",
        "Segah",
        "Tabalar",
        "Talisayan",
        "Tanjung Redeb",
        "Teluk Bayur",
      )),
      "Bontang" => drupal_map_assoc(array(
        "Bontang Barat",
        "Bontang Selatan",
        "Bontang Utara",
      )),
      "Kutai Barat" => drupal_map_assoc(array(
        "Barong Tongkok",
        "Bentian Besar",
        "Bongan",
        "Damai",
        "Jempang",
        "Laham",
        "Linggang Bigung",
        "Long Apari",
        "Long Bagun",
        "Long Hubung",
        "Long Iram",
        "Long Pahangai",
        "Manor Bulatin (Mook Manaar Bulatn)",
        "Melak",
        "Muara Lawa",
        "Muara Pahu",
        "Nyuatan",
        "Penyinggahan",
        "Sekolaq Darat",
        "Siluq Ngurai",
        "Tering",
      )),
      "Kutai Kartanegara" => drupal_map_assoc(array(
        "Anggana",
        "Kembang Janggut",
        "Kenohan",
        "Kota Bangun",
        "Loa Janan",
        "Loa Kulu",
        "Marang Kayu",
        "Muara Badak",
        "Muara Jawa",
        "Muara Kaman",
        "Muara Muntai",
        "Muara Wis",
        "Samboja (Semboja)",
        "Sanga-Sanga",
        "Sebulu",
        "Tabang",
        "Tenggarong",
        "Tenggarong Seberang",
      )),
      "Kutai Timur" => drupal_map_assoc(array(
        "Batu Ampar",
        "Bengalon",
        "Busang",
        "Kaliorang",
        "Karangan",
        "Kaubun",
        "Kongbeng",
        "Long Mesangat (Mesengat)",
        "Muara Ancalong",
        "Muara Bengkal",
        "Muara Wahau",
        "Rantau Pulung",
        "Sandaran",
        "Sangatta Selatan",
        "Sangatta Utara",
        "Sangkulirang",
        "Telen",
        "Teluk Pandan",
      )),
      "Paser" => drupal_map_assoc(array(
        "Batu Engau",
        "Batu Sopang",
        "Kuaro",
        "Long Ikis",
        "Long Kali",
        "Muara Komam",
        "Muara Samu",
        "Pasir Belengkong",
        "Tanah Grogot",
        "Tanjung Harapan",
      )),
      "Penajam Paser Utara" => drupal_map_assoc(array(
        "Babulu",
        "Penajam",
        "Sepaku",
        "Waru",
      )),
      "Samarinda" => drupal_map_assoc(array(
        "Loa Janan Ilir",
        "Palaran",
        "Samarinda Ilir",
        "Samarinda Kota",
        "Samarinda Seberang",
        "Samarinda Ulu",
        "Samarinda Utara",
        "Sambutan",
        "Sungai Kunjang",
        "Sungai Pinang",
      )),
    ),
    "Kalimantan Utara" => array(
      "Bulungan (Bulongan)" => drupal_map_assoc(array(
        "Peso",
        "Peso Hilir/Ilir",
        "Pulau Bunyu",
        "Sekatak",
        "Tanjung Palas",
        "Tanjung Palas Barat",
        "Tanjung Palas Tengah",
        "Tanjung Palas Timur",
        "Tanjung Palas Utara",
        "Tanjung Selor",
      )),
      "Malinau" => drupal_map_assoc(array(
        "Bahau Hulu",
        "Kayan Hilir",
        "Kayan Hulu",
        "Kayan Selatan",
        "Malinau Barat",
        "Malinau Kota",
        "Malinau Selatan",
        "Malinau Selatan Hilir",
        "Malinau Selatan Hulu",
        "Malinau Utara",
        "Mentarang",
        "Mentarang Hulu",
        "Pujungan",
        "Sungai Boh",
        "Sungai Tubu",
      )),
      "Nunukan" => drupal_map_assoc(array(
        "Krayan",
        "Krayan Selatan",
        "Lumbis",
        "Lumbis Ogong",
        "Nunukan",
        "Nunukan Selatan",
        "Sebatik",
        "Sebatik Barat",
        "Sebatik Tengah",
        "Sebatik Timur",
        "Sebatik Utara",
        "Sebuku",
        "Sei Menggaris",
        "Sembakung",
        "Tulin Onsoi",
      )),
      "Tana Tidung" => drupal_map_assoc(array(
        "Betayau",
        "Sesayap",
        "Sesayap Hilir",
        "Tana Lia (Tanah Lia)",
      )),
      "Tarakan" => drupal_map_assoc(array(
        "Tarakan Barat",
        "Tarakan Tengah",
        "Tarakan Timur",
        "Tarakan Utara",
      )),
    ),
    "Kepulauan Riau" => array(
      "Batam" => drupal_map_assoc(array(
        "Batam Kota",
        "Batu Aji",
        "Batu Ampar",
        "Belakang Padang",
        "Bengkong",
        "Bulang",
        "Galang",
        "Lubuk Baja",
        "Nongsa",
        "Sagulung",
        "Sei/Sungai Beduk",
        "Sekupang",
      )),
      "Bintan" => drupal_map_assoc(array(
        "Bintan Pesisir",
        "Bintan Timur",
        "Bintan Utara",
        "Gunung Kijang",
        "Mantang",
        "Seri/Sri Kuala Lobam",
        "Tambelan",
        "Teluk Bintan",
        "Teluk Sebong",
        "Toapaya",
      )),
      "Karimun" => drupal_map_assoc(array(
        "Belat",
        "Buru",
        "Durai",
        "Karimun",
        "Kundur",
        "Kundur Barat",
        "Kundur Utara",
        "Meral",
        "Meral Barat",
        "Moro",
        "Tebing",
        "Ungar",
      )),
      "Kepulauan Anambas" => drupal_map_assoc(array(
        "Jemaja",
        "Jemaja Timur",
        "Palmatak",
        "Siantan",
        "Siantan Selatan",
        "Siantan Tengah",
        "Siantan Timur",
      )),
      "Lingga" => drupal_map_assoc(array(
        "Lingga",
        "Lingga Timur",
        "Lingga Utara",
        "Selayar",
        "Senayang",
        "Singkep",
        "Singkep Barat",
        "Singkep Pesisir",
      )),
      "Natuna" => drupal_map_assoc(array(
        "Bunguran Barat",
        "Bunguran Selatan",
        "Bunguran Tengah",
        "Bunguran Timur",
        "Bunguran Timur Laut",
        "Bunguran Utara",
        "Midai",
        "Pulau Laut",
        "Pulau Tiga",
        "Serasan",
        "Serasan Timur",
        "Subi",
      )),
      "Tanjung Pinang" => drupal_map_assoc(array(
        "Bukit Bestari",
        "Tanjung Pinang Barat",
        "Tanjung Pinang Kota",
        "Tanjung Pinang Timur",
      )),
    ),
    "Lampung" => array(
      "Bandar Lampung" => drupal_map_assoc(array(
        "Bumi Waras",
        "Enggal",
        "Kedamaian",
        "Kedaton",
        "Kemiling",
        "Labuhan Ratu",
        "Langkapura",
        "Panjang",
        "Rajabasa",
        "Sukabumi",
        "Sukarame",
        "Tanjung Karang Barat",
        "Tanjung Karang Pusat",
        "Tanjung Karang Timur",
        "Tanjung Senang",
        "Telukbetung Barat",
        "Telukbetung Selatan",
        "Telukbetung Timur",
        "Telukbetung Utara",
        "Way Halim",
      )),
      "Lampung Barat" => drupal_map_assoc(array(
        "Air Hitam",
        "Balik Bukit",
        "Bandar Negeri Suoh",
        "Batu Brak",
        "Batu Ketulis",
        "Belalau",
        "Gedung Surian",
        "Kebun Tebu",
        "Lumbok Seminung",
        "Pagar Dewa",
        "Sekincau",
        "Sukau",
        "Sumber Jaya",
        "Suoh",
        "Way Tenong",
      )),
      "Lampung Selatan" => drupal_map_assoc(array(
        "Bakauheni",
        "Candipuro",
        "Jati Agung",
        "Kalianda",
        "Katibung",
        "Ketapang",
        "Merbau Mataram",
        "Natar",
        "Palas",
        "Penengahan",
        "Rajabasa",
        "Sidomulyo",
        "Sragi",
        "Tanjung Bintang",
        "Tanjung Sari",
        "Way Panji",
        "Way Sulan",
      )),
      "Lampung Tengah" => drupal_map_assoc(array(
        "Anak Ratu Aji",
        "Anak Tuha",
        "Bandar Mataram",
        "Bandar Surabaya",
        "Bangunrejo",
        "Bekri",
        "Bumi Nabung",
        "Bumi Ratu Nuban",
        "Gunung Sugih",
        "Kalirejo",
        "Kota Gajah",
        "Padang Ratu",
        "Pubian",
        "Punggur",
        "Putra Rumbia",
        "Rumbia",
        "Selagai Lingga",
        "Sendang Agung",
        "Seputih Agung",
        "Seputih Banyak",
        "Seputih Mataram",
        "Seputih Raman",
        "Seputih Surabaya",
        "Terbanggi Besar",
        "Terusan Nunyai",
        "Trimurjo",
        "Way Pangubuan (Pengubuan)",
        "Way Seputih",
      )),
      "Lampung Timur" => drupal_map_assoc(array(
        "Bandar Sribawono",
        "Batanghari",
        "Batanghari Nuban",
        "Braja Slebah",
        "Bumi Agung",
        "Gunung Pelindung",
        "Jabung",
        "Labuhan Maringgai",
        "Labuhan Ratu",
        "Marga Sekampung",
        "Margatiga",
        "Mataram Baru",
        "Melinting",
        "Metro Kibang",
        "Pasir Sakti",
        "Pekalongan",
        "Purbolinggo",
        "Raman Utara",
        "Sekampung",
        "Sekampung Udik",
        "Sukadana",
        "Waway Karya",
        "Way Bungur (Purbolinggo Utara)",
        "Way Jepara",
      )),
      "Lampung Utara" => drupal_map_assoc(array(
        "Abung Barat",
        "Abung Kunang",
        "Abung Pekurun",
        "Abung Selatan",
        "Abung Semuli",
        "Abung Surakarta",
        "Abung Tengah",
        "Abung Timur",
        "Abung Tinggi",
        "Blambangan Pagar",
        "Bukit Kemuning",
        "Bunga Mayang",
        "Hulu Sungkai",
        "Kotabumi",
        "Kotabumi Selatan",
        "Kotabumi Utara",
        "Muara Sungkai",
        "Sungkai Barat",
        "Sungkai Jaya",
        "Sungkai Selatan",
        "Sungkai Tengah",
        "Sungkai Utara",
        "Tanjung Raja",
      )),
      "Mesuji" => drupal_map_assoc(array(
        "Mesuji",
        "Mesuji Timur",
        "Panca Jaya",
        "Rawa Jitu Utara",
        "Simpang Pematang",
        "Tanjung Raya",
        "Way Serdang",
      )),
      "Metro" => drupal_map_assoc(array(
        "Metro Barat",
        "Metro Pusat",
        "Metro Selatan",
        "Metro Timur",
        "Metro Utara",
      )),
      "Pesawaran" => drupal_map_assoc(array(
        "Gedong Tataan (Gedung Tataan)",
        "Kedondong",
        "Marga Punduh",
        "Negeri Katon",
        "Padang Cermin",
        "Punduh Pidada (Pedada)",
        "Tegineneng",
        "Way Khilau",
        "Way Lima",
      )),
      "Pesisir Barat" => drupal_map_assoc(array(
        "Bengkunat",
        "Bengkunat Belimbing",
        "Karya Penggawa",
        "Krui Selatan",
        "Lemong",
        "Ngambur",
        "Pesisir Selatan",
        "Pesisir Tengah",
        "Pesisir Utara",
        "Pulau Pisang",
        "Way Krui",
      )),
      "Pringsewu" => drupal_map_assoc(array(
        "Adi Luwih",
        "Ambarawa",
        "Banyumas",
        "Gading Rejo",
        "Pagelaran",
        "Pagelaran Utara",
        "Pardasuka",
        "Pringsewu",
        "Sukoharjo",
      )),
      "Tanggamus" => drupal_map_assoc(array(
        "Air Naningan",
        "Bandar Negeri Semuong",
        "Bulok",
        "Cukuh Balak",
        "Gisting",
        "Gunung Alip",
        "Kelumbayan",
        "Kelumbayan Barat",
        "Kota Agung (Kota Agung Pusat)",
        "Kota Agung Barat",
        "Kota Agung Timur",
        "Limau",
        "Pematang Sawa",
        "Pugung",
        "Pulau Panggung",
        "Semaka",
        "Sumberejo",
        "Talang Padang",
        "Ulubelu",
        "Wonosobo",
      )),
      "Tulang Bawang" => drupal_map_assoc(array(
        "Banjar Agung",
        "Banjar Baru",
        "Banjar Margo",
        "Dente Teladas",
        "Gedung Aji",
        "Gedung Aji Baru",
        "Gedung Meneng",
        "Menggala",
        "Menggala Timur",
        "Meraksa Aji",
        "Penawar Aji",
        "Penawar Tama",
        "Rawa Pitu",
        "Rawajitu Selatan",
        "Rawajitu Timur",
      )),
      "Tulang Bawang Barat" => drupal_map_assoc(array(
        "Gunung Agung",
        "Gunung Terang",
        "Lambu Kibang",
        "Pagar Dewa",
        "Tulang Bawang Tengah",
        "Tulang Bawang Udik",
        "Tumijajar",
        "Way Kenanga",
      )),
      "Way Kanan" => drupal_map_assoc(array(
        "Bahuga",
        "Banjit",
        "Baradatu",
        "Blambangan Umpu",
        "Buay Bahuga",
        "Bumi Agung",
        "Gunung Labuhan",
        "Kasui",
        "Negara Batin",
        "Negeri Agung",
        "Negeri Besar",
        "Pakuan Ratu",
        "Rebang Tangkas",
        "Way Tuba",
      )),
    ),
    "Maluku" => array(
      "Ambon" => drupal_map_assoc(array(
        "Baguala",
        "Leitimur Selatan",
        "Nusaniwe (Nusanive)",
        "Sirimau",
        "Teluk Ambon",
      )),
      "Buru" => drupal_map_assoc(array(
        "Airbuaya",
        "Batabual",
        "Fena Leisela",
        "Lilialy",
        "Lolong Guba",
        "Namlea",
        "Teluk Kaiely",
        "Waeapo",
        "Waelata",
        "Waplau",
      )),
      "Buru Selatan" => drupal_map_assoc(array(
        "Ambalau",
        "Fena Fafan",
        "Kepala Madan",
        "Leksula",
        "Namrole",
        "Waesama",
      )),
      "Kepulauan Aru" => drupal_map_assoc(array(
        "Aru Selatan",
        "Aru Selatan Timur",
        "Aru Selatan Utara",
        "Aru Tengah",
        "Aru Tengah Selatan",
        "Aru Tengah Timur",
        "Aru Utara",
        "Aru Utara Timur Batuley",
        "Pulau-Pulau Aru",
        "Sir-Sir",
      )),
      "Maluku Barat Daya" => drupal_map_assoc(array(
        "Damer",
        "Dawelor Dawera",
        "Kepulauan Romang",
        "Kisar Utara",
        "Mdona Hyera/Hiera",
        "Moa Lakor",
        "Pulau Lakor",
        "Pulau Letti (Leti Moa Lakor)",
        "Pulau Masela",
        "Pulau Pulau Babar",
        "Pulau Pulau Terselatan",
        "Pulau Wetang",
        "Pulau-Pulau Babar Timur",
        "Wetar",
        "Wetar Barat",
        "Wetar Timur",
        "Wetar Utara",
      )),
      "Maluku Tengah" => drupal_map_assoc(array(
        "Amahai",
        "Banda",
        "Leihitu",
        "Leihitu Barat",
        "Masohi Kota",
        "Nusalaut",
        "Pulau Haruku",
        "Salahutu",
        "Saparua",
        "Saparua Timur",
        "Seram Utara",
        "Seram Utara Barat",
        "Seram Utara Timur Kobi",
        "Seram Utara Timur Seti",
        "Tehoru",
        "Teluk Elpaputih",
        "Telutih",
        "Teon Nila Serua",
      )),
      "Maluku Tenggara" => drupal_map_assoc(array(
        "Hoat Sorbay",
        "Kei Besar",
        "Kei Besar Selatan",
        "Kei Besar Selatan Barat",
        "Kei Besar Utara Barat",
        "Kei Besar Utara Timur",
        "Kei Kecil",
        "Kei Kecil Barat",
        "Kei Kecil Timur",
        "Kei Kecil Timur Selatan",
        "Manyeuw",
      )),
      "Maluku Tenggara Barat" => drupal_map_assoc(array(
        "Kormomolin",
        "Molu Maru",
        "Nirunmas",
        "Selaru",
        "Tanimbar Selatan",
        "Tanimbar Utara",
        "Wermakatian (Wer Maktian)",
        "Wertamrian",
        "Wuarlabobar",
        "Yaru",
      )),
      "Seram Bagian Barat" => drupal_map_assoc(array(
        "Amalatu",
        "Elpaputih",
        "Huamual",
        "Huamual Belakang (Waisala)",
        "Inamosol",
        "Kairatu",
        "Kairatu Barat",
        "Kepulauan Manipa",
        "Seram Barat",
        "Taniwel",
        "Taniwel Timur",
      )),
      "Seram Bagian Timur" => drupal_map_assoc(array(
        "Bula",
        "Bula Barat",
        "Gorom Timur",
        "Kian Darat",
        "Kilmury",
        "Pulau Gorong (Gorom)",
        "Pulau Panjang",
        "Seram Timur",
        "Siritaun Wida Timur",
        "Siwalalat",
        "Teluk Waru",
        "Teor",
        "Tutuk Tolu",
        "Wakate",
        "Werinama",
      )),
      "Tual" => drupal_map_assoc(array(
        "Kur Selatan",
        "Pulau Dullah Selatan",
        "Pulau Dullah Utara",
        "Pulau Tayando Tam",
        "Pulau-Pulau Kur",
      )),
    ),
    "Maluku Utara" => array(
      "Halmahera Barat" => drupal_map_assoc(array(
        "Ibu",
        "Ibu Selatan",
        "Ibu Utara",
        "Jailolo",
        "Jailolo Selatan",
        "Loloda",
        "Sahu",
        "Sahu Timur",
      )),
      "Halmahera Selatan" => drupal_map_assoc(array(
        "Bacan",
        "Bacan Barat",
        "Bacan Barat Utara",
        "Bacan Selatan",
        "Bacan Timur",
        "Bacan Timur Selatan",
        "Bacan Timur Tengah",
        "Gane Barat",
        "Gane Barat Selatan",
        "Gane Barat Utara",
        "Gane Timur",
        "Gane Timur Selatan",
        "Gane Timur Tengah",
        "Kasiruta Barat",
        "Kasiruta Timur",
        "Kayoa",
        "Kayoa Barat",
        "Kayoa Selatan",
        "Kayoa Utara",
        "Kepulauan Botanglomang",
        "Kepulauan Joronga",
        "Makian (Pulau Makian)",
        "Makian Barat (Pulau Makian)",
        "Mandioli Selatan",
        "Mandioli Utara",
        "Obi",
        "Obi Barat",
        "Obi Selatan",
        "Obi Timur",
        "Obi Utara",
      )),
      "Halmahera Tengah" => drupal_map_assoc(array(
        "Patani",
        "Patani Barat",
        "Patani Utara",
        "Pulau Gebe",
        "Weda",
        "Weda Selatan",
        "Weda Tengah",
        "Weda Utara",
      )),
      "Halmahera Timur" => drupal_map_assoc(array(
        "Kota Maba",
        "Maba",
        "Maba Selatan",
        "Maba Tengah",
        "Maba Utara",
        "Wasile",
        "Wasile Selatan",
        "Wasile Tengah",
        "Wasile Timur",
        "Wasile Utara",
      )),
      "Halmahera Utara" => drupal_map_assoc(array(
        "Galela",
        "Galela Barat",
        "Galela Selatan",
        "Galela Utara",
        "Kao",
        "Kao Barat",
        "Kao Teluk",
        "Kao Utara",
        "Loloda Kepulauan",
        "Loloda Utara",
        "Malifut",
        "Tobelo",
        "Tobelo Barat",
        "Tobelo Selatan",
        "Tobelo Tengah",
        "Tobelo Timur",
        "Tobelo Utara",
      )),
      "Kepulauan Sula" => drupal_map_assoc(array(
        "Lede",
        "Mangoli Barat",
        "Mangoli Selatan",
        "Mangoli Tengah",
        "Mangoli Timur",
        "Mangoli Utara",
        "Mangoli Utara Timur",
        "Sanana",
        "Sanana Utara",
        "Sulabesi Barat",
        "Sulabesi Selatan",
        "Sulabesi Tengah",
        "Sulabesi Timur",
        "Taliabu Barat",
        "Taliabu Barat Laut",
        "Taliabu Selatan",
        "Taliabu Timur",
        "Taliabu Timur Selatan",
        "Taliabu Utara",
      )),
      "Pulau Morotai" => drupal_map_assoc(array(
        "Morotai Jaya",
        "Morotai Selatan",
        "Morotai Selatan Barat",
        "Morotai Timur",
        "Morotai Utara",
      )),
      "Ternate" => drupal_map_assoc(array(
        "Moti (Pulau Moti)",
        "Pulau Batang Dua",
        "Pulau Hiri",
        "Pulau Ternate",
        "Ternate Selatan (Kota)",
        "Ternate Tengah (Kota)",
        "Ternate Utara (Kota)",
      )),
      "Tidore Kepulauan" => drupal_map_assoc(array(
        "Oba",
        "Oba Selatan",
        "Oba Tengah",
        "Oba Utara",
        "Tidore (Pulau Tidore)",
        "Tidore Selatan",
        "Tidore Timur (Pulau Tidore)",
        "Tidore Utara",
      )),
    ),
    "Nanggroe Aceh Darussalam (NAD)" => array(
      "Aceh Barat" => drupal_map_assoc(array(
        "Arongan Lambalek",
        "Bubon",
        "Johan Pahlawan",
        "Kaway XVI",
        "Meureubo",
        "Pante Ceureumen (Pantai Ceuremen)",
        "Panton Reu",
        "Samatiga",
        "Sungai Mas",
        "Woyla",
        "Woyla Barat",
        "Woyla Timur",
      )),
      "Aceh Barat Daya" => drupal_map_assoc(array(
        "Babah Rot",
        "Blang Pidie",
        "Jeumpa",
        "Kuala Batee",
        "Lembah Sabil",
        "Manggeng",
        "Setia",
        "Susoh",
        "Tangan-Tangan",
      )),
      "Aceh Besar" => drupal_map_assoc(array(
        "Baitussalam",
        "Blank Bintang",
        "Darul Imarah",
        "Darul Kamal",
        "Darussalam",
        "Indrapuri",
        "Ingin Jaya",
        "Kota Cot Glie (Kuta Cot Glie)",
        "Kota Jantho",
        "Kota Malaka (Kuta Malaka)",
        "Krueng Barona Jaya",
        "Kuta Baro",
        "Lembah Seulawah",
        "Leupung",
        "Lhoknga (Lho'nga)",
        "Lhoong",
        "Mantasiek (Montasik)",
        "Mesjid Raya",
        "Peukan Bada",
        "Pulo Aceh",
        "Seulimeum",
        "Simpang Tiga",
        "Suka Makmur",
      )),
      "Aceh Jaya" => drupal_map_assoc(array(
        "Darul Hikmah",
        "Indra Jaya",
        "Jaya",
        "Keude Panga",
        "Krueng Sabee",
        "Pasie Raya",
        "Sampoiniet",
        "Setia Bakti",
        "Teunom",
      )),
      "Aceh Selatan" => drupal_map_assoc(array(
        "Bakongan",
        "Bakongan Timur",
        "Kluet Selatan",
        "Kluet Tengah",
        "Kluet Timur",
        "Kluet Utara",
        "Kota Bahagia",
        "Labuhan Haji",
        "Labuhan Haji Barat",
        "Labuhan Haji Timur",
        "Meukek",
        "Pasie Raja",
        "Sama Dua",
        "Sawang",
        "Tapak Tuan",
        "Trumon",
        "Trumon Tengah",
        "Trumon Timur",
      )),
      "Aceh Singkil" => drupal_map_assoc(array(
        "Danau Paris",
        "Gunung Meriah (Mariah)",
        "Kota Baharu",
        "Kuala Baru",
        "Pulau Banyak",
        "Pulau Banyak Barat",
        "Simpang Kanan",
        "Singkil",
        "Singkil Utara",
        "Singkohor",
        "Suro Makmur",
      )),
      "Aceh Tamiang" => drupal_map_assoc(array(
        "Banda Mulia",
        "Bandar Pusaka",
        "Bendahara",
        "Karang Baru",
        "Kejuruan Muda",
        "Kota Kuala Simpang",
        "Manyak Payed",
        "Rantau",
        "Sekerak",
        "Seruway",
        "Tamiang Hulu",
        "Tenggulun",
      )),
      "Aceh Tengah" => drupal_map_assoc(array(
        "Atu Lintang",
        "Bebesen",
        "Bies",
        "Bintang",
        "Celala",
        "Jagong Jeget",
        "Kebayakan",
        "Ketol",
        "Kute Panang",
        "Linge",
        "Lut Tawar",
        "Pegasing",
        "Rusip Antara",
        "Silih Nara",
      )),
      "Aceh Tenggara" => drupal_map_assoc(array(
        "Babul Makmur",
        "Babul Rahmah",
        "Babussalam",
        "Badar",
        "Bambel",
        "Bukit Tusam",
        "Darul Hasanah",
        "Deleng Pokhisen",
        "Ketambe",
        "Lawe Alas",
        "Lawe Bulan",
        "Lawe Sigala-Gala",
        "Lawe Sumur",
        "Leuser",
        "Semadam",
        "Tanah Alas",
      )),
      "Aceh Timur" => drupal_map_assoc(array(
        "Banda Alam",
        "Birem Bayeun",
        "Darul Aman",
        "Darul Falah",
        "Darul Iksan (Ihsan)",
        "Idi Rayeuk",
        "Idi Timur",
        "Idi Tunong",
        "Indra Makmur",
        "Julok",
        "Madat",
        "Nurussalam",
        "Pante Bidari (Beudari)",
        "Peudawa",
        "Peunaron",
        "Peureulak",
        "Peureulak Barat",
        "Peureulak Timur",
        "Rantau Selamat",
        "Ranto Peureulak",
        "Serba Jadi",
        "Simpang Jernih",
        "Simpang Ulim",
        "Sungai Raya",
      )),
      "Aceh Utara" => drupal_map_assoc(array(
        "Baktiya",
        "Baktiya Barat",
        "Banda Baro",
        "Cot Girek",
        "Dewantara",
        "Geuredong Pase",
        "Kuta Makmur",
        "Langkahan",
        "Lapang",
        "Lhoksukon",
        "Matangkuli",
        "Meurah Mulia",
        "Muara Batu",
        "Nibong",
        "Nisam",
        "Nisam Antara",
        "Paya Bakong",
        "Pirak Timur",
        "Samudera",
        "Sawang",
        "Seunuddon (Seunudon)",
        "Simpang Kramat (Keramat)",
        "Syamtalira Aron",
        "Syamtalira Bayu",
        "Tanah Jambo Aye",
        "Tanah Luas",
        "Tanah Pasir",
      )),
      "Banda Aceh" => drupal_map_assoc(array(
        "Baiturrahman",
        "Banda Raya",
        "Jaya Baru",
        "Kuta Alam",
        "Kuta Raja",
        "Lueng Bata",
        "Meuraxa",
        "Syiah Kuala",
        "Ulee Kareng",
      )),
      "Bener Meriah" => drupal_map_assoc(array(
        "Bandar",
        "Bener Kelipah",
        "Bukit",
        "Gajah Putih",
        "Mesidah",
        "Permata",
        "Pintu Rime Gayo",
        "Syiah Utama",
        "Timang Gajah",
        "Wih Pesam",
      )),
      "Bireuen" => drupal_map_assoc(array(
        "Ganda Pura",
        "Jangka",
        "Jeumpa",
        "Jeunieb",
        "Juli",
        "Kota Juang",
        "Kuala",
        "Kuta Blang",
        "Makmur",
        "Pandrah",
        "Peudada",
        "Peulimbang (Plimbang)",
        "Peusangan",
        "Peusangan Selatan",
        "Peusangan Siblah Krueng",
        "Samalanga",
        "Simpang Mamplam",
      )),
      "Gayo Lues" => drupal_map_assoc(array(
        "Blang Jerango",
        "Blang Kejeren",
        "Blang Pegayon",
        "Dabun Gelang (Debun Gelang)",
        "Kuta Panjang",
        "Pantan Cuaca",
        "Pining (Pinding)",
        "Putri Betung",
        "Rikit Gaib",
        "Terangun (Terangon)",
        "Teripe/Tripe Jaya",
      )),
      "Langsa" => drupal_map_assoc(array(
        "Langsa Barat",
        "Langsa Baro",
        "Langsa Kota",
        "Langsa Lama",
        "Langsa Timur",
      )),
      "Lhokseumawe" => drupal_map_assoc(array(
        "Banda Sakti",
        "Blang Mangat",
        "Muara Dua",
        "Muara Satu",
      )),
      "Nagan Raya" => drupal_map_assoc(array(
        "Beutong",
        "Beutong Ateuh Banggalang",
        "Darul Makmur",
        "Kuala",
        "Kuala Pesisir",
        "Seunagan",
        "Seunagan Timur",
        "Suka Makmue",
        "Tadu Raya",
        "Tripa Makmur",
      )),
      "Pidie" => drupal_map_assoc(array(
        "Batee",
        "Delima",
        "Geumpang",
        "Glumpang Baro",
        "Glumpang Tiga (Geulumpang Tiga)",
        "Grong Grong",
        "Indrajaya",
        "Kembang Tanjong (Tanjung)",
        "Keumala",
        "Kota Sigli",
        "Mane",
        "Mila",
        "Muara Tiga",
        "Mutiara",
        "Mutiara Timur",
        "Padang Tiji",
        "Peukan Baro",
        "Pidie",
        "Sakti",
        "Simpang Tiga",
        "Tangse",
        "Tiro/Truseb",
        "Titeue",
      )),
      "Pidie Jaya" => drupal_map_assoc(array(
        "Bandar Baru",
        "Bandar Dua",
        "Jangka Buya",
        "Meurah Dua",
        "Meureudu",
        "Panteraja",
        "Trienggadeng",
        "Ulim",
      )),
      "Sabang" => drupal_map_assoc(array(
        "Sukajaya",
        "Sukakarya",
      )),
      "Simeulue" => drupal_map_assoc(array(
        "Alapan (Alafan)",
        "Salang",
        "Simeuleu Barat",
        "Simeuleu Tengah",
        "Simeuleu Timur",
        "Simeulue Cut",
        "Teluk Dalam",
        "Teupah Barat",
        "Teupah Selatan",
        "Teupah Tengah",
      )),
      "Subulussalam" => drupal_map_assoc(array(
        "Longkib",
        "Penanggalan",
        "Rundeng",
        "Simpang Kiri",
        "Sultan Daulat",
      )),
    ),
    "Nusa Tenggara Barat (NTB)" => array(
      "Bima (Kabupaten)" => drupal_map_assoc(array(
        "Ambalawi",
        "Belo",
        "Bolo",
        "Donggo",
        "Lambitu",
        "Lambu",
        "Langgudu",
        "Madapangga",
        "Monta",
        "Palibelo",
        "Parado",
        "Sanggar",
        "Sape",
        "Soromandi",
        "Tambora",
        "Wawo",
        "Wera",
        "Woha",
      )),
      "Bima (Kota)" => drupal_map_assoc(array(
        "Asakota",
        "Mpunda",
        "Raba",
        "Rasanae Barat",
        "Rasanae Timur",
      )),
      "Dompu" => drupal_map_assoc(array(
        "Dompu",
        "Hu'u",
        "Kempo",
        "Kilo",
        "Menggelewa (Manggelewa)",
        "Pajo",
        "Pekat",
        "Woja",
      )),
      "Lombok Barat" => drupal_map_assoc(array(
        "Batu Layar",
        "Gerung",
        "Gunungsari",
        "Kediri",
        "Kuripan",
        "Labuapi",
        "Lembar",
        "Lingsar",
        "Narmada",
        "Sekotong",
      )),
      "Lombok Tengah" => drupal_map_assoc(array(
        "Batukliang",
        "Batukliang Utara",
        "Janapria",
        "Jonggat",
        "Kopang",
        "Praya",
        "Praya Barat",
        "Praya Barat Daya",
        "Praya Tengah",
        "Praya Timur",
        "Pringgarata",
        "Pujut",
      )),
      "Lombok Timur" => drupal_map_assoc(array(
        "Aikmel",
        "Jerowaru",
        "Keruak",
        "Labuhan Haji",
        "Masbagik",
        "Montong Gading",
        "Pringgabaya",
        "Pringgasela",
        "Sakra",
        "Sakra Barat",
        "Sakra Timur",
        "Sambalia (Sambelia)",
        "Selong",
        "Sembalun",
        "Sikur",
        "Suela (Suwela)",
        "Sukamulia",
        "Suralaga",
        "Terara",
        "Wanasaba",
      )),
      "Lombok Utara" => drupal_map_assoc(array(
        "Bayan",
        "Gangga",
        "Kayangan",
        "Pemenang",
        "Tanjung",
      )),
      "Mataram" => drupal_map_assoc(array(
        "Ampenan",
        "Cakranegara",
        "Mataram",
        "Sandubaya (Sandujaya)",
        "Sekarbela",
        "Selaparang (Selaprang)",
      )),
      "Sumbawa" => drupal_map_assoc(array(
        "Alas",
        "Alas Barat",
        "Batulanteh",
        "Buer",
        "Empang",
        "Labangka",
        "Labuhan Badas",
        "Lantung",
        "Lape (Lape Lopok)",
        "Lenangguar",
        "Lopok",
        "Lunyuk",
        "Maronge",
        "Moyo Hilir",
        "Moyo Hulu",
        "Moyo Utara",
        "Orong Telu",
        "Plampang",
        "Rhee",
        "Ropang",
        "Sumbawa",
        "Tarano",
        "Unter Iwes (Unterwiris)",
        "Utan",
      )),
      "Sumbawa Barat" => drupal_map_assoc(array(
        "Brang Ene",
        "Brang Rea",
        "Jereweh",
        "Maluk",
        "Poto Tano",
        "Sateluk (Seteluk)",
        "Sekongkang",
        "Taliwang",
      )),
    ),
    "Nusa Tenggara Timur (NTT)" => array(
      "Alor" => drupal_map_assoc(array(
        "Alor Barat Daya",
        "Alor Barat Laut",
        "Alor Selatan",
        "Alor Tengah Utara",
        "Alor Timur",
        "Alor Timur Laut",
        "Kabola",
        "Lembur",
        "Mataru",
        "Pantar",
        "Pantar Barat",
        "Pantar Barat Laut",
        "Pantar Tengah",
        "Pantar Timur",
        "Pulau Pura",
        "Pureman",
        "Teluk Mutiara",
      )),
      "Belu" => drupal_map_assoc(array(
        "Atambua Barat",
        "Atambua Kota",
        "Atambua Selatan",
        "Botin Leo Bele",
        "Io Kufeu",
        "Kakuluk Mesak",
        "Kobalima",
        "Kobalima Timur",
        "Laen Manen",
        "Lamaknen",
        "Lamaknen Selatan",
        "Lasiolat",
        "Malaka Barat",
        "Malaka Tengah",
        "Malaka Timur",
        "Nanaet Duabesi",
        "Raihat",
        "Raimanuk",
        "Rinhat",
        "Sasitamean",
        "Tasifeto Barat",
        "Tasifeto Timur",
        "Weliman",
        "Wewiku",
      )),
      "Ende" => drupal_map_assoc(array(
        "Detukeli",
        "Detusoko",
        "Ende",
        "Ende Selatan",
        "Ende Tengah",
        "Ende Timur",
        "Ende Utara",
        "Kelimutu",
        "Kotabaru",
        "Lepembusu Kelisoke",
        "Lio Timur",
        "Maukaro",
        "Maurole",
        "Nangapanda",
        "Ndona",
        "Ndona Timur",
        "Ndori",
        "Pulau Ende",
        "Wewaria",
        "Wolojita",
        "Wolowaru",
      )),
      "Flores Timur" => drupal_map_assoc(array(
        "Adonara",
        "Adonara Barat",
        "Adonara Tengah",
        "Adonara Timur",
        "Demon Pagong",
        "Ile Boleng",
        "Ile Bura",
        "Ile Mandiri",
        "Kelubagolit (Klubagolit)",
        "Larantuka",
        "Lewolema",
        "Solor Barat",
        "Solor Selatan",
        "Solor Timur",
        "Tanjung Bunga",
        "Titehena",
        "Witihama (Watihama)",
        "Wotan Ulumado",
        "Wulanggitang",
      )),
      "Kupang (Kabupaten)" => drupal_map_assoc(array(
        "Amabi Oefeto",
        "Amabi Oefeto Timur",
        "Amarasi",
        "Amarasi Barat",
        "Amarasi Selatan",
        "Amarasi Timur",
        "Amfoang Barat Daya",
        "Amfoang Barat Laut",
        "Amfoang Selatan",
        "Amfoang Tengah",
        "Amfoang Timur",
        "Amfoang Utara",
        "Fatuleu",
        "Fatuleu Barat",
        "Fatuleu Tengah",
        "Kupang Barat",
        "Kupang Tengah",
        "Kupang Timur",
        "Nekamese",
        "Semau",
        "Semau Selatan",
        "Sulamu",
        "Taebenu",
        "Takari",
      )),
      "Kupang (Kota)" => drupal_map_assoc(array(
        "Alak",
        "Kelapa Lima",
        "Kota Lama",
        "Kota Raja",
        "Maulafa",
        "Oebobo",
      )),
      "Lembata" => drupal_map_assoc(array(
        "Atadei",
        "Buyasuri (Buyasari)",
        "Ile Ape",
        "Ile Ape Timur",
        "Lebatukan",
        "Nagawutung",
        "Nubatukan",
        "Omesuri",
        "Wulandoni (Wulandioni)",
      )),
      "Manggarai" => drupal_map_assoc(array(
        "Cibal",
        "Cibal Barat",
        "Langke Rembong",
        "Lelak",
        "Rahong Utara",
        "Reok",
        "Reok Barat",
        "Ruteng",
        "Satar Mese",
        "Satar Mese Barat",
        "Wae Rii",
      )),
      "Manggarai Barat" => drupal_map_assoc(array(
        "Boleng",
        "Komodo",
        "Kuwus",
        "Lembor",
        "Lembor Selatan",
        "Macang Pacar",
        "Mbeliling",
        "Ndoso",
        "Sano Nggoang",
        "Welak",
      )),
      "Manggarai Timur" => drupal_map_assoc(array(
        "Borong",
        "Elar",
        "Elar Selatan",
        "Kota Komba",
        "Lamba Leda",
        "Poco Ranaka",
        "Poco Ranaka Timur",
        "Rana Mese",
        "Sambi Rampas",
      )),
      "Nagekeo" => drupal_map_assoc(array(
        "Aesesa",
        "Aesesa Selatan",
        "Boawae",
        "Keo Tengah",
        "Mauponggo",
        "Nangaroro",
        "Wolowae",
      )),
      "Ngada" => drupal_map_assoc(array(
        "Aimere",
        "Bajawa",
        "Bajawa Utara",
        "Golewa",
        "Golewa Barat",
        "Golewa Selatan",
        "Inerie",
        "Jerebuu",
        "Riung",
        "Riung Barat",
        "Soa",
        "Wolomeze (Riung Selatan)",
      )),
      "Rote Ndao" => drupal_map_assoc(array(
        "Landu Leko",
        "Lobalain",
        "Ndao Nuse",
        "Pantai Baru",
        "Rote Barat",
        "Rote Barat Daya",
        "Rote Barat Laut",
        "Rote Selatan",
        "Rote Tengah",
        "Rote Timur",
      )),
      "Sabu Raijua" => drupal_map_assoc(array(
        "Hawu Mehara",
        "Raijua",
        "Sabu Barat",
        "Sabu Liae",
        "Sabu Tengah",
        "Sabu Timur",
      )),
      "Sikka" => drupal_map_assoc(array(
        "Alok",
        "Alok Barat",
        "Alok Timur",
        "Bola",
        "Doreng",
        "Hewokloang",
        "Kangae",
        "Kewapante",
        "Koting",
        "Lela",
        "Magepanda",
        "Mapitara",
        "Mego",
        "Nelle (Maumerei)",
        "Nita",
        "Paga",
        "Palue",
        "Talibura",
        "Tana Wawo",
        "Waiblama",
        "Waigete",
      )),
      "Sumba Barat" => drupal_map_assoc(array(
        "Kota Waikabubak",
        "Lamboya",
        "Lamboya Barat",
        "Loli",
        "Tana Righu",
        "Wanokaka",
      )),
      "Sumba Barat Daya" => drupal_map_assoc(array(
        "Kodi",
        "Kodi Balaghar",
        "Kodi Bangedo",
        "Kodi Utara",
        "Kota Tambolaka",
        "Loura (Laura)",
        "Wewewa Barat",
        "Wewewa Selatan",
        "Wewewa Tengah (Wewera Tengah)",
        "Wewewa Timur",
        "Wewewa Utara",
      )),
      "Sumba Tengah" => drupal_map_assoc(array(
        "Katikutana",
        "Katikutana Selatan",
        "Mamboro",
        "Umbu Ratu Nggay",
        "Umbu Ratu Nggay Barat",
      )),
      "Sumba Timur" => drupal_map_assoc(array(
        "Haharu",
        "Kahaunguweti (Kahaungu Eti)",
        "Kambata Mapambuhang",
        "Kambera",
        "Kanatang",
        "Karera",
        "Katala Hamu Lingu",
        "Kota Waingapu",
        "Lewa",
        "Lewa Tidahu",
        "Mahu",
        "Matawai Lappau (La Pawu)",
        "Ngadu Ngala",
        "Nggaha Oriangu",
        "Paberiwai",
        "Pahunga Lodu",
        "Pandawai",
        "Pinupahar (Pirapahar)",
        "Rindi",
        "Tabundung",
        "Umalulu",
        "Wula Waijelu",
      )),
      "Timor Tengah Selatan" => drupal_map_assoc(array(
        "Amanatun Selatan",
        "Amanatun Utara",
        "Amanuban Barat",
        "Amanuban Selatan",
        "Amanuban Tengah",
        "Amanuban Timur",
        "Batu Putih",
        "Boking",
        "Fatukopa",
        "Fatumnasi",
        "Fautmolo",
        "Kie (Ki'e)",
        "Kok Baun",
        "Kolbano",
        "Kot Olin",
        "Kota Soe",
        "Kualin",
        "Kuanfatu",
        "Kuatnana",
        "Mollo Barat",
        "Mollo Selatan",
        "Mollo Tengah",
        "Mollo Utara",
        "Noebana",
        "Noebeba",
        "Nunbena",
        "Nunkolo",
        "Oenino",
        "Polen",
        "Santian",
        "Tobu",
        "Toianas",
      )),
      "Timor Tengah Utara" => drupal_map_assoc(array(
        "Biboki Anleu",
        "Biboki Feotleu",
        "Biboki Moenleu",
        "Biboki Selatan",
        "Biboki Tan Pah",
        "Biboki Utara",
        "Bikomi Nilulat",
        "Bikomi Selatan",
        "Bikomi Tengah",
        "Bikomi Utara",
        "Insana",
        "Insana Barat",
        "Insana Fafinesu",
        "Insana Tengah",
        "Insana Utara",
        "Kota Kefamenanu",
        "Miomaffo Barat",
        "Miomaffo Tengah",
        "Miomaffo Timur",
        "Musi",
        "Mutis",
        "Naibenu",
        "Noemuti",
        "Noemuti Timur",
      )),
    ),
    "Papua" => array(
      "Asmat" => drupal_map_assoc(array(
        "Agats",
        "Akat",
        "Atsy / Atsj",
        "Ayip",
        "Betcbamu",
        "Der Koumur",
        "Fayit",
        "Jetsy",
        "Joerat",
        "Kolf Braza",
        "Kopay",
        "Pantai Kasuari",
        "Pulau Tiga",
        "Safan",
        "Sawa Erma",
        "Sirets",
        "Suator",
        "Suru-suru",
        "Unir Sirau",
      )),
      "Biak Numfor" => drupal_map_assoc(array(
        "Aimando Padaido",
        "Andey (Andei)",
        "Biak Barat",
        "Biak Kota",
        "Biak Timur",
        "Biak Utara",
        "Bondifuar",
        "Bruyadori",
        "Numfor Barat",
        "Numfor Timur",
        "Oridek",
        "Orkeri",
        "Padaido",
        "Poiru",
        "Samofa",
        "Swandiwe",
        "Warsa",
        "Yawosi",
        "Yendidori",
      )),
      "Boven Digoel" => drupal_map_assoc(array(
        "Ambatkwi (Ambatkui)",
        "Arimop",
        "Bomakia",
        "Firiwage",
        "Fofi",
        "Iniyandit",
        "Jair",
        "Kawagit",
        "Ki",
        "Kombay",
        "Kombut",
        "Kouh",
        "Mandobo",
        "Manggelum",
        "Mindiptana",
        "Ninati",
        "Sesnuk",
        "Subur",
        "Waropko",
        "Yaniruma",
      )),
      "Deiyai (Deliyai)" => drupal_map_assoc(array(
        "Bowobado",
        "Kapiraya",
        "Tigi",
        "Tigi Barat",
        "Tigi Timur",
      )),
      "Dogiyai" => drupal_map_assoc(array(
        "Dogiyai",
        "Kamu",
        "Kamu Selatan",
        "Kamu Timur",
        "Kamu Utara (Ikrar/Ikrat)",
        "Mapia",
        "Mapia Barat",
        "Mapia Tengah",
        "Piyaiye (Sukikai)",
        "Sukikai Selatan",
      )),
      "Intan Jaya" => drupal_map_assoc(array(
        "Agisiga",
        "Biandoga",
        "Hitadipa",
        "Homeo (Homeyo)",
        "Sugapa",
        "Wandai",
      )),
      "Jayapura (Kabupaten)" => drupal_map_assoc(array(
        "Airu",
        "Demta",
        "Depapre",
        "Ebungfau (Ebungfa)",
        "Gresi Selatan",
        "Kaureh",
        "Kemtuk",
        "Kemtuk Gresi",
        "Nambluong",
        "Nimbokrang",
        "Nimboran",
        "Ravenirara",
        "Sentani",
        "Sentani Barat",
        "Sentani Timur",
        "Unurum Guay",
        "Waibu",
        "Yapsi",
        "Yokari",
      )),
      "Jayapura (Kota)" => drupal_map_assoc(array(
        "Abepura",
        "Heram",
        "Jayapura Selatan",
        "Jayapura Utara",
        "Muara Tami",
      )),
      "Jayawijaya" => drupal_map_assoc(array(
        "Asologaima (Asalogaima)",
        "Asolokobal",
        "Asotipo",
        "Bolakme",
        "Bpiri",
        "Bugi",
        "Hubikiak",
        "Hubikosi (Hobikosi)",
        "Ibele",
        "Itlay Hisage",
        "Koragi",
        "Kurulu",
        "Libarek",
        "Maima",
        "Molagalome",
        "Muliama",
        "Musatfak",
        "Napua",
        "Pelebaga",
        "Piramid",
        "Pisugi",
        "Popugoba",
        "Siepkosi",
        "Silo Karno Doga",
        "Taelarek",
        "Tagime",
        "Tagineri",
        "Trikora",
        "Usilimo",
        "Wadangku",
        "Walaik",
        "Walelagama",
        "Wame",
        "Wamena",
        "Welesi",
        "Wesaput",
        "Wita Waya",
        "Wollo (Wolo)",
        "Wouma",
        "Yalengga",
      )),
      "Keerom" => drupal_map_assoc(array(
        "Arso",
        "Arso Timur",
        "Senggi",
        "Skamto (Skanto)",
        "Towe",
        "Waris",
        "Web",
      )),
      "Kepulauan Yapen (Yapen Waropen)" => drupal_map_assoc(array(
        "Angkaisera",
        "Kepulauan Ambai",
        "Kosiwo",
        "Poom",
        "Pulau Kurudu",
        "Pulau Yerui",
        "Raimbawi",
        "Teluk Ampimoi",
        "Windesi",
        "Wonawa",
        "Yapen Barat",
        "Yapen Selatan",
        "Yapen Timur",
        "Yapen Utara",
      )),
      "Lanny Jaya" => drupal_map_assoc(array(
        "Balingga",
        "Dimba",
        "Gamelia",
        "Kuyawage",
        "Makki (Maki)",
        "Malagaineri (Malagineri)",
        "Pirime",
        "Poga",
        "Tiom",
        "Tiomneri",
      )),
      "Mamberamo Raya" => drupal_map_assoc(array(
        "Benuki",
        "Mamberamo Hilir/Ilir",
        "Mamberamo Hulu/Ulu",
        "Mamberamo Tengah",
        "Mamberamo Tengah Timur",
        "Rofaer (Rufaer)",
        "Sawai",
        "Waropen Atas",
      )),
      "Mamberamo Tengah" => drupal_map_assoc(array(
        "Eragayam",
        "Ilugwa",
        "Kelila",
        "Kobakma",
        "Megabilis (Megambilis)",
      )),
      "Mappi" => drupal_map_assoc(array(
        "Assue",
        "Bamgi",
        "Citakmitak",
        "Edera",
        "Haju",
        "Kaibar",
        "Minyamur",
        "Nambioman Bapai (Mambioman)",
        "Obaa",
        "Passue",
        "Passue Bawah",
        "Syahcame",
        "Ti Zain",
        "Venaha",
        "Yakomi",
      )),
      "Merauke" => drupal_map_assoc(array(
        "Animha",
        "Eligobel",
        "Ilyawab",
        "Jagebob",
        "Kaptel",
        "Kimaam",
        "Kurik",
        "Malind",
        "Merauke",
        "Muting",
        "Naukenjerai",
        "Ngguti (Nggunti)",
        "Okaba",
        "Semangga",
        "Sota",
        "Tabonji",
        "Tanah Miring",
        "Tubang",
        "Ulilin",
        "Waan",
      )),
      "Mimika" => drupal_map_assoc(array(
        "Agimuga",
        "Jila",
        "Jita",
        "Kuala Kencana",
        "Mimika Barat (Mibar)",
        "Mimika Barat Jauh",
        "Mimika Barat Tengah",
        "Mimika Baru",
        "Mimika Timur",
        "Mimika Timur Jauh",
        "Mimika Timur Tengah",
        "Tembagapura",
      )),
      "Nabire" => drupal_map_assoc(array(
        "Dipa",
        "Makimi",
        "Menou",
        "Moora",
        "Nabire",
        "Nabire Barat",
        "Napan",
        "Siriwo",
        "Teluk Kimi",
        "Teluk Umar",
        "Uwapa",
        "Wanggar",
        "Wapoga",
        "Yaro (Yaro Kabisay)",
        "Yaur",
      )),
      "Nduga" => drupal_map_assoc(array(
        "Alama",
        "Dal",
        "Embetpen",
        "Gearek",
        "Geselma (Geselema)",
        "Inikgal",
        "Iniye",
        "Kegayem",
        "Kenyam",
        "Kilmid",
        "Kora",
        "Koroptak",
        "Krepkuri",
        "Mam",
        "Mapenduma",
        "Mbua (Mbuga)",
        "Mbua Tengah",
        "Mbulmu Yalma",
        "Mebarok",
        "Moba",
        "Mugi",
        "Nenggeagin",
        "Nirkuri",
        "Paro",
        "Pasir Putih",
        "Pija",
        "Wosak",
        "Wusi",
        "Wutpaga",
        "Yal",
        "Yenggelo",
        "Yigi",
      )),
      "Paniai" => drupal_map_assoc(array(
        "Aradide",
        "Bibida",
        "Bogobaida",
        "Dumadama",
        "Ekadide",
        "Kebo",
        "Paniai Barat",
        "Paniai Timur",
        "Siriwo",
        "Yatamo",
      )),
      "Pegunungan Bintang" => drupal_map_assoc(array(
        "Aboy",
        "Alemsom",
        "Awinbon",
        "Batani",
        "Batom",
        "Bime",
        "Borme",
        "Eipumek",
        "Iwur (Okiwur)",
        "Jetfa",
        "Kalomdol",
        "Kawor",
        "Kiwirok",
        "Kiwirok Timur",
        "Mofinop",
        "Murkim",
        "Nongme",
        "Ok Aom",
        "Okbab",
        "Okbape",
        "Okbemtau",
        "Okbibab",
        "Okhika",
        "Oklip",
        "Oksamol",
        "Oksebang",
        "Oksibil",
        "Oksop",
        "Pamek",
        "Pepera",
        "Serambakon",
        "Tarup",
        "Teiraplu",
        "Weime",
      )),
      "Puncak" => drupal_map_assoc(array(
        "Agadugume",
        "Beoga",
        "Doufu",
        "Gome",
        "Ilaga",
        "Pogoma",
        "Sinak",
        "Wangbe",
      )),
      "Puncak Jaya" => drupal_map_assoc(array(
        "Fawi",
        "Ilu",
        "Jigonikme",
        "Mewoluk (Mewulok)",
        "Mulia",
        "Tingginambut",
        "Torere",
        "Yamo",
      )),
      "Sarmi" => drupal_map_assoc(array(
        "Apawer Hulu",
        "Bonggo",
        "Bonggo Timur",
        "Pantai Barat",
        "Pantai Timur",
        "Pantai Timur Barat",
        "Sarmi",
        "Sarmi Selatan",
        "Sarmi Timur",
        "Tor Atas",
      )),
      "Supiori" => drupal_map_assoc(array(
        "Kepulauan Aruri",
        "Supiori Barat",
        "Supiori Selatan",
        "Supiori Timur",
        "Supiori Utara",
      )),
      "Tolikara" => drupal_map_assoc(array(
        "Airgaram",
        "Anawi",
        "Aweku",
        "Bewani",
        "Biuk",
        "Bogonuk",
        "Bokondini",
        "Bokoneri",
        "Danime",
        "Dow",
        "Dundu (Ndundu)",
        "Egiam",
        "Geya",
        "Gika",
        "Gilubandu (Gilumbandu/Gilimbandu)",
        "Goyage",
        "Gundagi (Gudage)",
        "Kai",
        "Kamboneri",
        "Kanggime (Kanggima )",
        "Karubaga",
        "Kembu",
        "Kondaga (Konda)",
        "Kuari",
        "Kubu",
        "Li Anogomma",
        "Nabunage",
        "Nelawi",
        "Numba",
        "Nunggawi (Munggawi)",
        "Panaga",
        "Poganeri",
        "Tagime",
        "Tagineri",
        "Telenggeme",
        "Timori",
        "Umagi",
        "Wakuwo",
        "Wari (Taiyeve)",
        "Wenam",
        "Wina",
        "Wonoki (Woniki)",
        "Wugi",
        "Wunin (Wumin)",
        "Yuko",
        "Yuneri",
      )),
      "Waropen" => drupal_map_assoc(array(
        "Demba Masirei",
        "Inggerus",
        "Kirihi",
        "Masirei",
        "Oudate Waropen",
        "Risei Sayati",
        "Ureifasei",
        "Wapoga Inggerus",
        "Waropen Bawah",
      )),
      "Yahukimo" => drupal_map_assoc(array(
        "Amuma",
        "Anggruk",
        "Bomela",
        "Dekai",
        "Dirwemna (Diruwena)",
        "Duram",
        "Endomen",
        "Hereapini (Hereanini)",
        "Hilipuk",
        "Hogio (Hugio)",
        "Holuon",
        "Kabianggama (Kabianggema)",
        "Kayo",
        "Kona",
        "Koropun (Korupun)",
        "Kosarek",
        "Kurima",
        "Kwelemdua (Kwelamdua)",
        "Kwikma",
        "Langda",
        "Lolat",
        "Mugi",
        "Musaik",
        "Nalca",
        "Ninia",
        "Nipsan",
        "Obio",
        "Panggema",
        "Pasema",
        "Pronggoli (Proggoli)",
        "Puldama",
        "Samenage",
        "Sela",
        "Seredela (Seredala)",
        "Silimo",
        "Soba",
        "Sobaham",
        "Soloikma",
        "Sumo",
        "Suntamon",
        "Suru Suru",
        "Talambo",
        "Tangma",
        "Ubahak",
        "Ubalihi",
        "Ukha",
        "Walma",
        "Werima",
        "Wusuma",
        "Yahuliambut",
        "Yogosem",
      )),
      "Yalimo" => drupal_map_assoc(array(
        "Abenaho",
        "Apalapsili",
        "Benawa",
        "Elelim",
        "Welarek",
      )),
    ),
    "Papua Barat" => array(
      "Fakfak" => drupal_map_assoc(array(
        "Bombarai (Bomberay)",
        "Fakfak",
        "Fakfak Barat",
        "Fakfak Tengah",
        "Fakfak Timur",
        "Karas",
        "Kokas",
        "Kramongmongga (Kramamongga)",
        "Teluk Patipi",
      )),
      "Kaimana" => drupal_map_assoc(array(
        "Buruway",
        "Kaimana",
        "Kambraw (Kamberau)",
        "Teluk Arguni Atas",
        "Teluk Arguni Bawah (Yerusi)",
        "Teluk Etna",
        "Yamor",
      )),
      "Manokwari" => drupal_map_assoc(array(
        "Manokwari Barat",
        "Manokwari Selatan",
        "Manokwari Timur",
        "Manokwari Utara",
        "Masni",
        "Prafi",
        "Sidey",
        "Tanah Rubuh",
        "Warmare",
      )),
      "Manokwari Selatan" => drupal_map_assoc(array(
        "Dataran Isim",
        "Momi Waren",
        "Neney (Nenei)",
        "Oransbari",
        "Ransiki",
        "Tahota (Tohota)",
      )),
      "Maybrat" => drupal_map_assoc(array(
        "Aifat",
        "Aifat Selatan",
        "Aifat Timur",
        "Aifat Timur Jauh",
        "Aifat Timur Selatan",
        "Aifat Timur Tengah",
        "Aifat Utara",
        "Aitinyo",
        "Aitinyo Barat",
        "Aitinyo Raya",
        "Aitinyo Tengah",
        "Aitinyo Utara",
        "Ayamaru",
        "Ayamaru Barat",
        "Ayamaru Jaya",
        "Ayamaru Selatan",
        "Ayamaru Selatan Jaya",
        "Ayamaru Tengah",
        "Ayamaru Timur",
        "Ayamaru Timur Selatan",
        "Ayamaru Utara",
        "Ayamaru Utara Timur",
        "Mare",
        "Mare Selatan",
      )),
      "Pegunungan Arfak" => drupal_map_assoc(array(
        "Anggi",
        "Anggi Gida",
        "Catubouw",
        "Didohu",
        "Hingk",
        "Membey",
        "Menyambouw (Minyambouw)",
        "Sururey",
        "Taige",
        "Testega",
      )),
      "Raja Ampat" => drupal_map_assoc(array(
        "Ayau",
        "Batanta Selatan",
        "Batanta Utara",
        "Kepulauan Ayau",
        "Kepulauan Sembilan",
        "Kofiau",
        "Kota Waisai",
        "Meos Mansar",
        "Misool (Misool Utara)",
        "Misool Barat",
        "Misool Selatan",
        "Misool Timur",
        "Salawati Barat",
        "Salawati Tengah",
        "Salawati Utara (Samate)",
        "Supnin",
        "Teluk Mayalibit",
        "Tiplol Mayalibit",
        "Waigeo Barat",
        "Waigeo Barat Kepulauan",
        "Waigeo Selatan",
        "Waigeo Timur",
        "Waigeo Utara",
        "Warwabomi",
      )),
      "Sorong (Kabupaten)" => drupal_map_assoc(array(
        "Aimas",
        "Beraur",
        "Klabot",
        "Klamono",
        "Klaso",
        "Klawak",
        "Klayili",
        "Makbon",
        "Mariat",
        "Maudus",
        "Mayamuk",
        "Moisegen",
        "Salawati",
        "Salawati Selatan",
        "Sayosa",
        "Seget",
        "Segun",
      )),
      "Sorong (Kota)" => drupal_map_assoc(array(
        "Sorong",
        "Sorong Barat",
        "Sorong Kepulauan",
        "Sorong Manoi",
        "Sorong Timur",
        "Sorong Utara",
      )),
      "Sorong Selatan" => drupal_map_assoc(array(
        "Fokour",
        "Inanwatan (Inawatan)",
        "Kais (Matemani Kais)",
        "Kokoda",
        "Kokoda Utara",
        "Konda",
        "Matemani",
        "Moswaren",
        "Saifi",
        "Sawiat",
        "Seremuk",
        "Teminabuan",
        "Wayer",
      )),
      "Tambrauw" => drupal_map_assoc(array(
        "Abun",
        "Amberbaken",
        "Fef (Peef)",
        "Kebar",
        "Kwoor",
        "Miyah (Meyah)",
        "Moraid",
        "Mubrani",
        "Sausapor",
        "Senopi",
        "Syujak",
        "Yembun",
      )),
      "Teluk Bintuni" => drupal_map_assoc(array(
        "Aranday",
        "Aroba",
        "Babo",
        "Bintuni",
        "Biscoop",
        "Dataran Beimes",
        "Fafurwar (Irorutu)",
        "Kaitaro",
        "Kamundan",
        "Kuri",
        "Manimeri",
        "Masyeta",
        "Mayado",
        "Merdey",
        "Moskona Barat",
        "Moskona Selatan",
        "Moskona Timur",
        "Moskona Utara",
        "Sumuri (Simuri)",
        "Tembuni",
        "Tomu",
        "Tuhiba",
        "Wamesa (Idoor)",
        "Weriagar",
      )),
      "Teluk Wondama" => drupal_map_assoc(array(
        "Kuri Wamesa",
        "Naikere (Wasior Barat)",
        "Nikiwar",
        "Rasiei",
        "Roon",
        "Roswar",
        "Rumberpon",
        "Soug Jaya",
        "Teluk Duairi (Wasior Utara)",
        "Wamesa",
        "Wasior",
        "Windesi",
        "Wondiboy (Wasior Selatan)",
      )),
    ),
    "Riau" => array(
      "Bengkalis" => drupal_map_assoc(array(
        "Bantan",
        "Bengkalis",
        "Bukit Batu",
        "Mandau",
        "Pinggir",
        "Rupat",
        "Rupat Utara",
        "Siak Kecil",
      )),
      "Dumai" => drupal_map_assoc(array(
        "Bukit Kapur",
        "Dumai Barat",
        "Dumai Kota",
        "Dumai Selatan",
        "Dumai Timur",
        "Medang Kampai",
        "Sungai Sembilan",
      )),
      "Indragiri Hilir" => drupal_map_assoc(array(
        "Batang Tuaka",
        "Concong",
        "Enok",
        "Gaung",
        "Gaung Anak Serka",
        "Kateman",
        "Kempas",
        "Kemuning",
        "Keritang",
        "Kuala Indragiri",
        "Mandah",
        "Pelangiran",
        "Pulau Burung",
        "Reteh",
        "Sungai Batang",
        "Tanah Merah",
        "Teluk Belengkong",
        "Tembilahan",
        "Tembilahan Hulu",
        "Tempuling",
      )),
      "Indragiri Hulu" => drupal_map_assoc(array(
        "Batang Cenaku",
        "Batang Gansal",
        "Batang Peranap",
        "Kelayang",
        "Kuala Cenaku",
        "Lirik",
        "Lubuk Batu Jaya",
        "Pasir Penyu",
        "Peranap",
        "Rakit Kulim",
        "Rengat",
        "Rengat Barat",
        "Seberida",
        "Sungai Lala",
      )),
      "Kampar" => drupal_map_assoc(array(
        "Bangkinang",
        "Bangkinang Seberang",
        "Gunung Sahilan",
        "Kampar",
        "Kampar Kiri",
        "Kampar Kiri Hilir",
        "Kampar Kiri Hulu",
        "Kampar Kiri Tengah",
        "Kampar Timur",
        "Kampar Utara",
        "Koto Kampar Hulu",
        "Kuok (Bangkinang Barat)",
        "Perhentian Raja",
        "Rumbio Jaya",
        "Salo",
        "Siak Hulu",
        "Tambang",
        "Tapung",
        "Tapung Hilir",
        "Tapung Hulu",
        "XIII Koto Kampar",
      )),
      "Kepulauan Meranti" => drupal_map_assoc(array(
        "Merbau",
        "Pulaumerbau",
        "Rangsang",
        "Rangsang Barat",
        "Rangsang Pesisir",
        "Tasik Putri Puyu",
        "Tebing Tinggi",
        "Tebing Tinggi Barat",
        "Tebing Tinggi Timur",
      )),
      "Kuantan Singingi" => drupal_map_assoc(array(
        "Benai",
        "Cerenti",
        "Gunung Toar",
        "Hulu Kuantan",
        "Inuman",
        "Kuantan Hilir",
        "Kuantan Hilir Seberang",
        "Kuantan Mudik",
        "Kuantan Tengah",
        "Logas Tanah Darat",
        "Pangean",
        "Pucuk Rantau",
        "Sentajo Raya",
        "Singingi",
        "Singingi Hilir",
      )),
      "Pekanbaru" => drupal_map_assoc(array(
        "Bukit Raya",
        "Lima Puluh",
        "Marpoyan Damai",
        "Payung Sekaki",
        "Pekanbaru Kota",
        "Rumbai",
        "Rumbai Pesisir",
        "Sail",
        "Senapelan",
        "Sukajadi",
        "Tampan",
        "Tenayan Raya",
      )),
      "Pelalawan" => drupal_map_assoc(array(
        "Bandar Petalangan",
        "Bandar Sei Kijang",
        "Bunut",
        "Kerumutan",
        "Kuala Kampar",
        "Langgam",
        "Pangkalan Kerinci",
        "Pangkalan Kuras",
        "Pangkalan Lesung",
        "Pelalawan",
        "Teluk Meranti",
        "Ukui",
      )),
      "Rokan Hilir" => drupal_map_assoc(array(
        "Bagan Sinembah",
        "Bangko",
        "Bangko Pusaka (Pusako)",
        "Batu Hampar",
        "Kubu",
        "Kubu Babussalam",
        "Pasir Limau Kapas",
        "Pekaitan",
        "Pujud",
        "Rantau Kopar",
        "Rimba Melintang",
        "Simpang Kanan",
        "Sinaboi (Senaboi)",
        "Tanah Putih",
        "Tanah Putih Tanjung Melawan",
      )),
      "Rokan Hulu" => drupal_map_assoc(array(
        "Bangun Purba",
        "Bonai Darussalam",
        "Kabun",
        "Kepenuhan",
        "Kepenuhan Hulu",
        "Kunto Darussalam",
        "Pagaran Tapah Darussalam",
        "Pendalian IV Koto",
        "Rambah",
        "Rambah Hilir",
        "Rambah Samo",
        "Rokan IV Koto",
        "Tambusai",
        "Tambusai Utara",
        "Tandun",
        "Ujung Batu",
      )),
      "Siak" => drupal_map_assoc(array(
        "Bunga Raya",
        "Dayun",
        "Kandis",
        "Kerinci Kanan",
        "Koto Gasib",
        "Lubuk Dalam",
        "Mempura",
        "Minas",
        "Pusako",
        "Sabak Auh",
        "Siak",
        "Sungai Apit",
        "Sungai Mandau",
        "Tualang",
      )),
    ),
    "Sulawesi Barat" => array(
      "Majene" => drupal_map_assoc(array(
        "Banggae",
        "Banggae Timur",
        "Malunda",
        "Pamboang",
        "Sendana",
        "Tammeredo Sendana",
        "Tubo (Tubo Sendana)",
        "Ulumunda",
      )),
      "Mamasa" => drupal_map_assoc(array(
        "Aralle (Arrale)",
        "Balla",
        "Bambang",
        "Buntumalangka",
        "Mamasa",
        "Mambi",
        "Mehalaan",
        "Messawa",
        "Nosu",
        "Pana",
        "Rantebulahan Timur",
        "Sesena Padang",
        "Sumarorong",
        "Tabang",
        "Tabulahan",
        "Tanduk Kalua",
        "Tawalian",
      )),
      "Mamuju" => drupal_map_assoc(array(
        "Bonehau",
        "Budong-Budong",
        "Kalukku",
        "Kalumpang",
        "Karossa",
        "Kep. Bala Balakang",
        "Mamuju",
        "Pangale",
        "Papalang",
        "Sampaga",
        "Simboro dan Kepulauan",
        "Tapalang",
        "Tapalang Barat",
        "Tobadak",
        "Tommo",
        "Topoyo",
      )),
      "Mamuju Utara" => drupal_map_assoc(array(
        "Bambaira",
        "Bambalamotu",
        "Baras",
        "Bulu Taba",
        "Dapurang",
        "Duripoku",
        "Lariang",
        "Pasangkayu",
        "Pedongga",
        "Sarjo",
        "Sarudu",
        "Tikke Raya",
      )),
      "Polewali Mandar" => drupal_map_assoc(array(
        "Alu (Allu)",
        "Anreapi",
        "Balanipa",
        "Binuang",
        "Bulo",
        "Campalagian",
        "Limboro",
        "Luyo",
        "Mapilli",
        "Matakali",
        "Matangnga",
        "Polewali",
        "Tapango",
        "Tinambung",
        "Tubbi Taramanu (Tutar/Tutallu)",
        "Wonomulyo",
      )),
    ),
    "Sulawesi Selatan" => array(
      "Bantaeng" => drupal_map_assoc(array(
        "Bantaeng",
        "Bissappu",
        "Eremerasa",
        "Gantarang Keke (Gantareng Keke)",
        "Pajukukang",
        "Sinoa",
        "Tompobulu",
        "Uluere",
      )),
      "Barru" => drupal_map_assoc(array(
        "Balusu",
        "Barru",
        "Mallusetasi",
        "Pujananting",
        "Soppeng Riaja",
        "Tanete Riaja",
        "Tanete Rilau",
      )),
      "Bone" => drupal_map_assoc(array(
        "Ajangale",
        "Amali",
        "Awangpone",
        "Barebbo",
        "Bengo",
        "Bontocani",
        "Cenrana",
        "Cina",
        "Dua Boccoe",
        "Kahu",
        "Kajuara",
        "Lamuru",
        "Lappariaja",
        "Libureng",
        "Mare",
        "Palakka",
        "Patimpeng",
        "Ponre",
        "Salomekko",
        "Sibulue",
        "Tanete Riattang",
        "Tanete Riattang Barat",
        "Tanete Riattang Timur",
        "Tellu Limpoe",
        "Tellu Siattinge",
        "Tonra",
        "Ulaweng",
      )),
      "Bulukumba" => drupal_map_assoc(array(
        "Bonto Bahari",
        "Bontotiro",
        "Bulukumba (Bulukumpa)",
        "Gantorang/Gantarang (Gangking)",
        "Hero Lange-Lange (Herlang)",
        "Kajang",
        "Kindang",
        "Rilau Ale",
        "Ujung Bulu",
        "Ujung Loe",
      )),
      "Enrekang" => drupal_map_assoc(array(
        "Alla",
        "Anggeraja",
        "Baraka",
        "Baroko",
        "Bungin",
        "Buntu Batu",
        "Cendana",
        "Curio",
        "Enrekang",
        "Maiwa",
        "Malua",
        "Masalle",
      )),
      "Gowa" => drupal_map_assoc(array(
        "Bajeng",
        "Bajeng Barat",
        "Barombong",
        "Biringbulu",
        "Bontolempangang",
        "Bontomarannu",
        "Bontonompo",
        "Bontonompo Selatan",
        "Bungaya",
        "Manuju",
        "Pallangga",
        "Parangloe",
        "Parigi",
        "Pattallassang",
        "Somba Opu (Upu)",
        "Tinggimoncong",
        "Tombolo Pao",
        "Tompobulu",
      )),
      "Jeneponto" => drupal_map_assoc(array(
        "Arungkeke",
        "Bangkala",
        "Bangkala Barat",
        "Batang",
        "Binamu",
        "Bontoramba",
        "Kelara",
        "Rumbia",
        "Tamalatea",
        "Tarowang",
        "Turatea",
      )),
      "Luwu" => drupal_map_assoc(array(
        "Bajo",
        "Bajo Barat",
        "Basse Sangtempe Utara",
        "Bassesang Tempe (Bastem)",
        "Belopa",
        "Belopa Utara",
        "Bua",
        "Bua Ponrang (Bupon)",
        "Kamanre",
        "Lamasi",
        "Lamasi Timur",
        "Larompong",
        "Larompong Selatan",
        "Latimojong",
        "Ponrang",
        "Ponrang Selatan",
        "Suli",
        "Suli Barat",
        "Walenrang",
        "Walenrang Barat",
        "Walenrang Timur",
        "Walenrang Utara",
      )),
      "Luwu Timur" => drupal_map_assoc(array(
        "Angkona",
        "Burau",
        "Kalaena",
        "Malili",
        "Mangkutana",
        "Nuha",
        "Tomoni",
        "Tomoni Timur",
        "Towuti",
        "Wasuponda",
        "Wotu",
      )),
      "Luwu Utara" => drupal_map_assoc(array(
        "Baebunta",
        "Bone-Bone",
        "Limbong",
        "Malangke",
        "Malangke Barat",
        "Mappedeceng",
        "Masamba",
        "Rampi",
        "Sabbang",
        "Seko",
        "Sukamaju",
        "Tana Lili",
      )),
      "Makassar" => drupal_map_assoc(array(
        "Biring Kanaya",
        "Bontoala",
        "Makassar",
        "Mamajang",
        "Manggala",
        "Mariso",
        "Panakkukang",
        "Rappocini",
        "Tallo",
        "Tamalanrea",
        "Tamalate",
        "Ujung Pandang",
        "Ujung Tanah",
        "Wajo",
      )),
      "Maros" => drupal_map_assoc(array(
        "Bantimurung",
        "Bontoa (Maros Utara)",
        "Camba",
        "Cenrana",
        "Lau",
        "Mallawa",
        "Mandai",
        "Maros Baru",
        "Marusu",
        "Moncongloe",
        "Simbang",
        "Tanralili",
        "Tompu Bulu",
        "Turikale",
      )),
      "Palopo" => drupal_map_assoc(array(
        "Bara",
        "Mungkajang",
        "Sendana",
        "Telluwanua",
        "Wara",
        "Wara Barat",
        "Wara Selatan",
        "Wara Timur",
        "Wara Utara",
      )),
      "Pangkajene Kepulauan" => drupal_map_assoc(array(
        "Balocci",
        "Bungoro",
        "Labakkang",
        "Liukang Kalmas (Kalukuang Masalima)",
        "Liukang Tangaya",
        "Liukang Tupabbiring",
        "Liukang Tupabbiring Utara",
        "Mandalle",
        "Marang (Ma Rang)",
        "Minasa Tene",
        "Pangkajene",
        "Segeri",
        "Tondong Tallasa",
      )),
      "Parepare" => drupal_map_assoc(array(
        "Bacukiki",
        "Bacukiki Barat",
        "Soreang",
        "Ujung",
      )),
      "Pinrang" => drupal_map_assoc(array(
        "Batulappa",
        "Cempa",
        "Duampanua",
        "Lanrisang",
        "Lembang",
        "Mattiro Bulu",
        "Mattiro Sompe",
        "Paleteang",
        "Patampanua",
        "Suppa",
        "Tiroang",
        "Watang Sawitto",
      )),
      "Selayar (Kepulauan Selayar)" => drupal_map_assoc(array(
        "Benteng",
        "Bontoharu",
        "Bontomanai",
        "Bontomatene",
        "Bontosikuyu",
        "Buki",
        "Pasilambena",
        "Pasimarannu",
        "Pasimassunggu",
        "Pasimasunggu Timur",
        "Takabonerate",
      )),
      "Sidenreng Rappang/Rapang" => drupal_map_assoc(array(
        "Baranti",
        "Dua Pitue",
        "Kulo",
        "Maritengngae",
        "Panca Lautan (Lautang)",
        "Panca Rijang",
        "Pitu Raise/Riase",
        "Pitu Riawa",
        "Tellu Limpoe",
        "Watang Pulu",
        "Wattang Sidenreng (Watang Sidenreng)",
      )),
      "Sinjai" => drupal_map_assoc(array(
        "Bulupoddo",
        "Pulau Sembilan",
        "Sinjai Barat",
        "Sinjai Borong",
        "Sinjai Selatan",
        "Sinjai Tengah",
        "Sinjai Timur",
        "Sinjai Utara",
        "Tellu Limpoe",
      )),
      "Soppeng" => drupal_map_assoc(array(
        "Citta",
        "Donri-Donri",
        "Ganra",
        "Lalabata",
        "Lili Rilau",
        "Liliraja (Lili Riaja)",
        "Mario Riawa",
        "Mario Riwawo",
      )),
      "Takalar" => drupal_map_assoc(array(
        "Galesong",
        "Galesong Selatan",
        "Galesong Utara",
        "Mangara Bombang",
        "Mappakasunggu",
        "Patallassang",
        "Polombangkeng Selatan (Polobangkeng)",
        "Polombangkeng Utara (Polobangkeng)",
        "Sanrobone",
      )),
      "Tana Toraja" => drupal_map_assoc(array(
        "Bittuang",
        "Bonggakaradeng",
        "Gandang Batu Sillanan",
        "Kurra",
        "Makale",
        "Makale Selatan",
        "Makale Utara",
        "Malimbong Balepe",
        "Mappak",
        "Masanda",
        "Mengkendek",
        "Rano",
        "Rantetayo",
        "Rembon",
        "Saluputti",
        "Sangalla (Sanggala)",
        "Sangalla Selatan",
        "Sangalla Utara",
        "Simbuang",
      )),
      "Toraja Utara" => drupal_map_assoc(array(
        "Awan Rante Karua",
        "Balusu",
        "Bangkelekila",
        "Baruppu",
        "Buntao",
        "Buntu Pepasan",
        "Dende' Piongan Napo",
        "Kapalla Pitu (Kapala Pitu)",
        "Kesu",
        "Nanggala",
        "Rantebua",
        "Rantepao",
        "Rindingallo",
        "Sa'dan",
        "Sanggalangi",
        "Sesean",
        "Sesean Suloara",
        "Sopai",
        "Tallunglipu",
        "Tikala",
        "Tondon",
      )),
      "Wajo" => drupal_map_assoc(array(
        "Belawa",
        "Bola",
        "Gilireng",
        "Keera",
        "Majauleng",
        "Maniang Pajo",
        "Pammana",
        "Penrang",
        "Pitumpanua",
        "Sabbang Paru",
        "Sajoanging",
        "Takkalalla",
        "Tana Sitolo",
        "Tempe",
      )),
    ),
    "Sulawesi Tengah" => array(
      "Banggai" => drupal_map_assoc(array(
        "Balantak",
        "Balantak Selatan",
        "Balantak Utara",
        "Batui",
        "Batui Selatan",
        "Bualemo (Boalemo)",
        "Bunta",
        "Kintom",
        "Lamala",
        "Lobu",
        "Luwuk",
        "Luwuk Selatan",
        "Luwuk Timur",
        "Luwuk Utara",
        "Mantoh",
        "Masama",
        "Moilong",
        "Nambo",
        "Nuhon",
        "Pagimana",
        "Simpang Raya",
        "Toili",
        "Toili Barat",
      )),
      "Banggai Kepulauan" => drupal_map_assoc(array(
        "Banggai",
        "Banggai Selatan",
        "Banggai Tengah",
        "Banggai Utara",
        "Bangkurung",
        "Bokan Kepulauan",
        "Buko",
        "Buko Selatan",
        "Bulagi",
        "Bulagi Selatan",
        "Bulagi Utara",
        "Labobo (Lobangkurung)",
        "Liang",
        "Peling Tengah",
        "Tinangkung",
        "Tinangkung Selatan",
        "Tinangkung Utara",
        "Totikum (Totikung)",
        "Totikum Selatan",
      )),
      "Buol" => drupal_map_assoc(array(
        "Biau",
        "Bokat",
        "Bukal",
        "Bunobogu",
        "Gadung",
        "Karamat",
        "Lakea (Lipunoto)",
        "Momunu",
        "Paleleh",
        "Paleleh Barat",
        "Tiloan",
      )),
      "Donggala" => drupal_map_assoc(array(
        "Balaesang",
        "Balaesang Tanjung",
        "Banawa",
        "Banawa Selatan",
        "Banawa Tengah",
        "Damsol (Dampelas Sojol)",
        "Labuan",
        "Pinembani",
        "Rio Pakava (Riopakawa)",
        "Sindue",
        "Sindue Tobata",
        "Sindue Tombusabora",
        "Sirenja",
        "Sojol",
        "Sojol Utara",
        "Tanantovea",
      )),
      "Morowali" => drupal_map_assoc(array(
        "Bahodopi",
        "Bumi Raya",
        "Bungku Barat",
        "Bungku Pesisir",
        "Bungku Selatan",
        "Bungku Tengah",
        "Bungku Timur",
        "Bungku Utara",
        "Lembo",
        "Lembo Raya",
        "Mamosalato",
        "Menui Kepulauan",
        "Mori Atas",
        "Mori Utara",
        "Petasia",
        "Petasia Barat",
        "Petasia Timur",
        "Soyo Jaya",
        "Wita Ponda",
      )),
      "Palu" => drupal_map_assoc(array(
        "Mantikulore",
        "Palu Barat",
        "Palu Selatan",
        "Palu Timur",
        "Palu Utara",
        "Tatanga",
        "Tawaeli",
        "Ulujadi",
      )),
      "Parigi Moutong" => drupal_map_assoc(array(
        "Ampibabo",
        "Balinggi",
        "Bolano",
        "Bolano Lambunu/Lambulu",
        "Kasimbar",
        "Mepanga",
        "Moutong",
        "Ongka Malino",
        "Palasa",
        "Parigi",
        "Parigi Barat",
        "Parigi Selatan",
        "Parigi Tengah",
        "Parigi Utara",
        "Sausu",
        "Siniu",
        "Taopa",
        "Tinombo",
        "Tinombo Selatan",
        "Tomini",
        "Toribulu",
        "Torue",
      )),
      "Poso" => drupal_map_assoc(array(
        "Lage",
        "Lore Barat",
        "Lore Piore",
        "Lore Selatan",
        "Lore Tengah",
        "Lore Timur",
        "Lore Utara",
        "Pamona Barat",
        "Pamona Puselemba",
        "Pamona Selatan",
        "Pamona Tenggara",
        "Pamona Timur",
        "Pamona Utara",
        "Poso Kota",
        "Poso Kota Selatan",
        "Poso Kota Utara",
        "Poso Pesisir",
        "Poso Pesisir Selatan",
        "Poso Pesisir Utara",
      )),
      "Sigi" => drupal_map_assoc(array(
        "Dolo",
        "Dolo Barat",
        "Dolo Selatan",
        "Gumbasa",
        "Kinovaru",
        "Kulawi",
        "Kulawi Selatan",
        "Lindu",
        "Marawola",
        "Marawola Barat",
        "Nokilalaki",
        "Palolo",
        "Pipikoro",
        "Sigi Biromaru",
        "Tanambulava",
      )),
      "Tojo Una-Una" => drupal_map_assoc(array(
        "Ampana Kota",
        "Ampana Tete",
        "Togean",
        "Tojo",
        "Tojo Barat",
        "Ulu Bongka",
        "Una - Una",
        "Walea Besar",
        "Walea Kepulauan",
      )),
      "Toli-Toli" => drupal_map_assoc(array(
        "Baolan",
        "Basidondo",
        "Dako Pamean",
        "Dampal Selatan",
        "Dampal Utara",
        "Dondo",
        "Galang",
        "Lampasio",
        "Ogo Deide",
        "Tolitoli Utara",
      )),
    ),
    "Sulawesi Tenggara" => array(
      "Bau-Bau" => drupal_map_assoc(array(
        "Batupoaro",
        "Betoambari",
        "Bungi",
        "Kokalukuna",
        "Lea-Lea",
        "Murhum",
        "Sora Walio (Sorowalio)",
        "Wolio",
      )),
      "Bombana" => drupal_map_assoc(array(
        "Kabaena",
        "Kabaena Barat",
        "Kabaena Selatan",
        "Kabaena Tengah",
        "Kabaena Timur",
        "Kabaena Utara",
        "Kepulauan Masaloka Raya",
        "Lentarai Jaya S. (Lantari Jaya)",
        "Mata Oleo",
        "Mata Usu",
        "Poleang",
        "Poleang Barat",
        "Poleang Selatan",
        "Poleang Tengah",
        "Poleang Tenggara",
        "Poleang Timur",
        "Poleang Utara",
        "Rarowatu",
        "Rarowatu Utara",
        "Rumbia",
        "Rumbia Tengah",
        "Tontonunu (Tontonuwu)",
      )),
      "Buton" => drupal_map_assoc(array(
        "Batauga",
        "Batu Atas",
        "Gu",
        "Kadatua",
        "Kapontori",
        "Lakudo",
        "Lapandewa",
        "Lasalimu",
        "Lasalimu Selatan",
        "Mawasangka",
        "Mawasangka Tengah",
        "Mawasangka Timur",
        "Pasar Wajo",
        "Sampolawa",
        "Sangia Mambulu",
        "Siompu",
        "Siompu Barat",
        "Siontapia (Siontapina)",
        "Talaga Raya (Telaga Raya)",
        "Wabula",
        "Wolowa",
      )),
      "Buton Utara" => drupal_map_assoc(array(
        "Bonegunu",
        "Kambowa",
        "Kulisusu (Kalingsusu/Kalisusu)",
        "Kulisusu Barat",
        "Kulisusu Utara",
        "Wakorumba Utara",
      )),
      "Kendari" => drupal_map_assoc(array(
        "Abeli",
        "Baruga",
        "Kadia",
        "Kambu",
        "Kendari",
        "Kendari Barat",
        "Mandonga",
        "Poasia",
        "Puuwatu",
        "Wua-Wua",
      )),
      "Kolaka" => drupal_map_assoc(array(
        "Baula",
        "Kolaka",
        "Ladongi",
        "Lalolae",
        "Lambandia (Lambadia)",
        "Latambaga",
        "Loea",
        "Mowewe",
        "Poli Polia",
        "Polinggona",
        "Pomalaa",
        "Samaturu",
        "Tanggetada",
        "Tinondo",
        "Tirawuta",
        "Toari",
        "Uluiwoi",
        "Watumbangga (Watubanggo)",
        "Wolo",
        "Wundulako",
      )),
      "Kolaka Utara" => drupal_map_assoc(array(
        "Batu Putih",
        "Katoi",
        "Kodeoha",
        "Lasusua",
        "Lombai (Lambai)",
        "Ngapa",
        "Pakue",
        "Pakue Tengah",
        "Pakue Utara",
        "Porehu",
        "Ranteangin",
        "Tiwu",
        "Tolala",
        "Watunohu",
        "Wawo",
      )),
      "Konawe" => drupal_map_assoc(array(
        "Abuki",
        "Amonggedo",
        "Anggaberi",
        "Asinua",
        "Besulutu",
        "Bondoala",
        "Kapoiala (Kapoyala)",
        "Konawe",
        "Lalonggasumeeto",
        "Lambuya",
        "Latoma",
        "Meluhu",
        "Onembute",
        "Pondidaha",
        "Puriala",
        "Routa",
        "Sampara",
        "Soropia",
        "Tongauna",
        "Uepai (Uwepai)",
        "Unaaha",
        "Wawonii Barat",
        "Wawonii Selatan",
        "Wawonii Tengah",
        "Wawonii Tenggara",
        "Wawonii Timur",
        "Wawonii Timur Laut",
        "Wawonii Utara",
        "Wawotobi",
        "Wonggeduku",
      )),
      "Konawe Selatan" => drupal_map_assoc(array(
        "Andoolo",
        "Angata",
        "Baito",
        "Basala",
        "Benua",
        "Buke",
        "Kolono",
        "Konda",
        "Laeya",
        "Lainea",
        "Lalembuu / Lalumbuu",
        "Landono",
        "Laonti",
        "Moramo",
        "Moramo Utara",
        "Mowila",
        "Palangga",
        "Palangga Selatan",
        "Ranomeeto",
        "Ranomeeto Barat",
        "Tinanggea",
        "Wolasi",
      )),
      "Konawe Utara" => drupal_map_assoc(array(
        "Andowia",
        "Asera",
        "Langgikima",
        "Lasolo",
        "Lembo",
        "Molawe",
        "Motui",
        "Oheo",
        "Sawa",
        "Wiwirano",
      )),
      "Muna" => drupal_map_assoc(array(
        "Barangka",
        "Batalaiwaru (Batalaiworu)",
        "Batukara",
        "Bone (Bone Tondo)",
        "Duruka",
        "Kabangka",
        "Kabawo",
        "Katobu",
        "Kontu Kowuna",
        "Kontunaga",
        "Kusambi",
        "Lasalepa",
        "Lawa",
        "Lohia",
        "Maginti",
        "Maligano",
        "Marobo",
        "Napabalano",
        "Napano Kusambi",
        "Parigi",
        "Pasi Kolaga",
        "Pasir Putih",
        "Sawerigadi (Sawerigading/Sewergadi)",
        "Tiworo Kepulauan",
        "Tiworo Selatan",
        "Tiworo Tengah",
        "Tiworo Utara",
        "Tongkuno",
        "Tongkuno Selatan",
        "Towea",
        "Wa Daga",
        "Wakorumba Selatan",
        "Watopute",
      )),
      "Wakatobi" => drupal_map_assoc(array(
        "Binongko",
        "Kaledupa",
        "Kaledupa Selatan",
        "Togo Binongko",
        "Tomia",
        "Tomia Timur",
        "Wangi-Wangi",
        "Wangi-Wangi Selatan",
      )),
    ),
    "Sulawesi Utara" => array(
      "Bitung" => drupal_map_assoc(array(
        "Aertembaga (Bitung Timur)",
        "Girian",
        "Lembeh Selatan (Bitung Selatan)",
        "Lembeh Utara",
        "Madidir (Bitung Tengah)",
        "Maesa",
        "Matuari (Bitung Barat)",
        "Ranowulu (Bitung Utara)",
      )),
      "Bolaang Mongondow (Bolmong)" => drupal_map_assoc(array(
        "Bilalang",
        "Bolaang",
        "Bolaang Timur",
        "Dumoga",
        "Dumoga Barat",
        "Dumoga Tengah",
        "Dumoga Tenggara",
        "Dumoga Timur",
        "Dumoga Utara",
        "Lolak",
        "Lolayan",
        "Passi Barat",
        "Passi Timur",
        "Poigar",
        "Sangtombolang",
      )),
      "Bolaang Mongondow Selatan" => drupal_map_assoc(array(
        "Bolaang Uki",
        "Pinolosian",
        "Pinolosian Tengah",
        "Pinolosian Timur",
        "Posigadan",
      )),
      "Bolaang Mongondow Timur" => drupal_map_assoc(array(
        "Kotabunan",
        "Modayag",
        "Modayag Barat",
        "Nuangan",
        "Tutuyan",
      )),
      "Bolaang Mongondow Utara" => drupal_map_assoc(array(
        "Bintauna",
        "Bolang Itang Barat",
        "Bolang Itang Timur",
        "Kaidipang",
        "Pinogaluman",
        "Sangkub",
      )),
      "Kepulauan Sangihe" => drupal_map_assoc(array(
        "Kendahe",
        "Kepulauan Marore",
        "Manganitu",
        "Manganitu Selatan",
        "Nusa Tabukan",
        "Tabukan Selatan",
        "Tabukan Selatan Tengah",
        "Tabukan Selatan Tenggara",
        "Tabukan Tengah",
        "Tabukan Utara",
        "Tahuna",
        "Tahuna Barat",
        "Tahuna Timur",
        "Tamako",
        "Tatoareng",
      )),
      "Kepulauan Siau Tagulandang Biaro (Sitaro)" => drupal_map_assoc(array(
        "Biaro",
        "Siau Barat",
        "Siau Barat Selatan",
        "Siau Barat Utara",
        "Siau Tengah",
        "Siau Timur",
        "Siau Timur Selatan",
        "Tagulandang",
        "Tagulandang Selatan",
        "Tagulandang Utara",
      )),
      "Kepulauan Talaud" => drupal_map_assoc(array(
        "Beo",
        "Beo Selatan",
        "Beo Utara",
        "Damao (Damau)",
        "Essang",
        "Essang Selatan",
        "Gemeh",
        "Kabaruan",
        "Kalongan",
        "Lirung",
        "Melonguane",
        "Melonguane Timur",
        "Miangas",
        "Moronge",
        "Nanusa",
        "Pulutan",
        "Rainis",
        "Salibabu",
        "Tampan Amma",
      )),
      "Kotamobagu" => drupal_map_assoc(array(
        "Kotamobagu Barat",
        "Kotamobagu Selatan",
        "Kotamobagu Timur",
        "Kotamobagu Utara",
      )),
      "Manado" => drupal_map_assoc(array(
        "Bunaken",
        "Bunaken Kepulauan",
        "Malalayang",
        "Mapanget",
        "Paal Dua",
        "Sario",
        "Singkil",
        "Tikala",
        "Tuminiting",
        "Wanea",
        "Wenang",
      )),
      "Minahasa" => drupal_map_assoc(array(
        "Eris",
        "Kakas",
        "Kakas Barat",
        "Kawangkoan",
        "Kawangkoan Barat",
        "Kawangkoan Utara",
        "Kombi",
        "Langowan Barat",
        "Langowan Selatan",
        "Langowan Timur",
        "Langowan Utara",
        "Lembean Timur",
        "Mandolang",
        "Pineleng",
        "Remboken",
        "Sonder",
        "Tombariri",
        "Tombariri Timur",
        "Tombulu",
        "Tompaso",
        "Tompaso Barat",
        "Tondano Barat",
        "Tondano Selatan",
        "Tondano Timur",
        "Tondano Utara",
      )),
      "Minahasa Selatan" => drupal_map_assoc(array(
        "Amurang",
        "Amurang Barat",
        "Amurang Timur",
        "Kumelembuai",
        "Maesaan",
        "Modoinding",
        "Motoling",
        "Motoling Barat",
        "Motoling Timur",
        "Ranoyapo",
        "Sinonsayang",
        "Suluun Tareran",
        "Tareran",
        "Tatapaan",
        "Tenga",
        "Tompaso Baru",
        "Tumpaan",
      )),
      "Minahasa Tenggara" => drupal_map_assoc(array(
        "Belang",
        "Pasan",
        "Pusomaen",
        "Ratahan",
        "Ratahan Timur",
        "Ratatotok",
        "Silian Raya",
        "Tombatu",
        "Tombatu Timur",
        "Tombatu Utara",
        "Touluaan",
        "Touluaan Selatan",
      )),
      "Minahasa Utara" => drupal_map_assoc(array(
        "Airmadidi",
        "Dimembe",
        "Kalawat",
        "Kauditan",
        "Kema",
        "Likupang Barat",
        "Likupang Selatan",
        "Likupang Timur",
        "Talawaan",
        "Wori",
      )),
      "Tomohon" => drupal_map_assoc(array(
        "Tomohon Barat",
        "Tomohon Selatan",
        "Tomohon Tengah",
        "Tomohon Timur",
        "Tomohon Utara",
      )),
    ),
    "Sumatera Barat" => array(
      "Agam" => drupal_map_assoc(array(
        "Ampek Nagari (IV Nagari )",
        "Banuhampu",
        "Baso",
        "Candung",
        "IV Angkat Candung (Ampek Angkek)",
        "IV Koto (Ampek Koto)",
        "Kamang Magek",
        "Lubuk Basung",
        "Malakak",
        "Matur",
        "Palembayan",
        "Palupuh",
        "Sungai Pua (Puar)",
        "Tanjung Mutiara",
        "Tanjung Raya",
        "Tilatang Kamang",
      )),
      "Bukittinggi" => drupal_map_assoc(array(
        "Aur Birugo Tigo Baleh",
        "Guguk Panjang (Guguak Panjang)",
        "Mandiangin Koto Selayan",
      )),
      "Dharmasraya" => drupal_map_assoc(array(
        "Asam Jujuhan",
        "Koto Baru",
        "Koto Besar",
        "Koto Salak",
        "Padang Laweh",
        "Pulau Punjung",
        "Sembilan Koto (IX Koto)",
        "Sitiung",
        "Sungai Rumbai",
        "Timpeh",
        "Tiumang",
      )),
      "Kepulauan Mentawai" => drupal_map_assoc(array(
        "Pagai Selatan",
        "Pagai Utara",
        "Siberut Barat",
        "Siberut Barat Daya",
        "Siberut Selatan",
        "Siberut Tengah",
        "Siberut Utara",
        "Sikakap",
        "Sipora Selatan",
        "Sipora Utara",
      )),
      "Lima Puluh Koto/Kota" => drupal_map_assoc(array(
        "Akabiluru",
        "Bukik Barisan",
        "Guguak (Gugu)",
        "Gunuang Omeh (Gunung Mas)",
        "Harau",
        "Kapur IX/Sembilan",
        "Lareh Sago Halaban",
        "Luak (Luhak)",
        "Mungka",
        "Pangkalan Koto Baru",
        "Payakumbuh",
        "Situjuah Limo/Lima Nagari",
        "Suliki",
      )),
      "Padang" => drupal_map_assoc(array(
        "Bungus Teluk Kabung",
        "Koto Tangah",
        "Kuranji",
        "Lubuk Begalung",
        "Lubuk Kilangan",
        "Nanggalo",
        "Padang Barat",
        "Padang Selatan",
        "Padang Timur",
        "Padang Utara",
        "Pauh",
      )),
      "Padang Panjang" => drupal_map_assoc(array(
        "Padang Panjang Barat",
        "Padang Panjang Timur",
      )),
      "Padang Pariaman" => drupal_map_assoc(array(
        "2 X 11 Enam Lingkung",
        "2 X 11 Kayu Tanam",
        "Batang Anai",
        "Batang Gasan",
        "Enam Lingkung",
        "IV Koto Aur Malintang",
        "Lubuk Alung",
        "Nan Sabaris",
        "Padang Sago",
        "Patamuan",
        "Sintuk/Sintuak Toboh Gadang",
        "Sungai Geringging/Garingging",
        "Sungai Limau",
        "Ulakan Tapakih/Tapakis",
        "V Koto Kampung Dalam",
        "V Koto Timur",
        "VII Koto Sungai Sarik",
      )),
      "Pariaman" => drupal_map_assoc(array(
        "Pariaman Selatan",
        "Pariaman Tengah",
        "Pariaman Timur",
        "Pariaman Utara",
      )),
      "Pasaman" => drupal_map_assoc(array(
        "Bonjol",
        "Duo Koto (II Koto)",
        "Lubuk Sikaping",
        "Mapat Tunggul",
        "Mapat Tunggul Selatan",
        "Padang Gelugur",
        "Panti",
        "Rao",
        "Rao Selatan",
        "Rao Utara",
        "Simpang Alahan Mati",
        "Tigo Nagari (III Nagari)",
      )),
      "Pasaman Barat" => drupal_map_assoc(array(
        "Gunung Tuleh",
        "Kinali",
        "Koto Balingka",
        "Lembah Melintang",
        "Luhak Nan Duo",
        "Pasaman",
        "Ranah Batahan",
        "Sasak Ranah Pasisir/Pesisie",
        "Sei Beremas",
        "Sungai Aur",
        "Talamau",
      )),
      "Payakumbuh" => drupal_map_assoc(array(
        "Lamposi Tigo Nagari",
        "Payakumbuh Barat",
        "Payakumbuh Selatan",
        "Payakumbuh Timur",
        "Payakumbuh Utara",
      )),
      "Pesisir Selatan" => drupal_map_assoc(array(
        "Airpura",
        "Basa Ampek Balai Tapan",
        "Batang Kapas",
        "Bayang",
        "IV Jurai",
        "IV Nagari Bayang Utara",
        "Koto XI Tarusan",
        "Lengayang",
        "Linggo Sari Baganti",
        "Lunang",
        "Pancung Soal",
        "Ranah Ampek Hulu Tapan",
        "Ranah Pesisir",
        "Silaut",
        "Sutera",
      )),
      "Sawah Lunto" => drupal_map_assoc(array(
        "Barangin",
        "Lembah Segar",
        "Silungkang",
        "Talawi",
      )),
      "Sijunjung (Sawah Lunto Sijunjung)" => drupal_map_assoc(array(
        "IV Nagari",
        "Kamang Baru",
        "Koto VII",
        "Kupitan",
        "Lubuak Tarok",
        "Sijunjung",
        "Sumpur Kudus",
        "Tanjung Gadang",
      )),
      "Solok (Kabupaten)" => drupal_map_assoc(array(
        "Bukit Sundi",
        "Danau Kembar",
        "Gunung Talang",
        "Hiliran Gumanti",
        "IX Koto Sei Lasi",
        "Junjung Sirih",
        "Kubung",
        "Lembah Gumanti",
        "Lembang Jaya",
        "Pantai Cermin",
        "Payung Sekaki",
        "Tigo Lurah",
        "X Koto Diatas",
        "X Koto Singkarak",
      )),
      "Solok (Kota)" => drupal_map_assoc(array(
        "Lubuk Sikarah",
        "Tanjung Harapan",
      )),
      "Solok Selatan" => drupal_map_assoc(array(
        "Koto Parik Gadang Diateh",
        "Pauh Duo",
        "Sangir",
        "Sangir Balai Janggo",
        "Sangir Batang Hari",
        "Sangir Jujuan",
        "Sungai Pagu",
      )),
      "Tanah Datar" => drupal_map_assoc(array(
        "Batipuh",
        "Batipuh Selatan",
        "Lima Kaum",
        "Lintau Buo",
        "Lintau Buo Utara",
        "Padang Ganting",
        "Pariangan",
        "Rambatan",
        "Salimpaung",
        "Sepuluh Koto (X Koto)",
        "Sungai Tarab",
        "Sungayang",
        "Tanjung Baru",
        "Tanjung Emas",
      )),
    ),
    "Sumatera Selatan" => array(
      "Banyuasin" => drupal_map_assoc(array(
        "Air Kumbang",
        "Air Salek",
        "Banyuasin I",
        "Banyuasin II",
        "Banyuasin III",
        "Betung",
        "Makarti Jaya",
        "Muara Padang",
        "Muara Sugihan",
        "Muara Telang",
        "Pulau Rimau",
        "Rambutan",
        "Rantau Bayur",
        "Sembawa",
        "Suak Tapeh",
        "Sumber Marga Telang",
        "Talang Kelapa",
        "Tanjung Lago",
        "Tungkal Ilir",
      )),
      "Empat Lawang" => drupal_map_assoc(array(
        "Lintang Kanan",
        "Muara Pinang",
        "Pasemah Air Keruh",
        "Pendopo",
        "Pendopo Barat",
        "Saling",
        "Sikap Dalam",
        "Talang Padang",
        "Tebing Tinggi",
        "Ulu Musi",
      )),
      "Lahat" => drupal_map_assoc(array(
        "Gumay Talang",
        "Gumay Ulu",
        "Jarai",
        "Kikim Barat",
        "Kikim Selatan",
        "Kikim Tengah",
        "Kikim Timur",
        "Kota Agung",
        "Lahat",
        "Merapi Barat",
        "Merapi Selatan",
        "Merapi Timur",
        "Muarapayang",
        "Mulak Ulu",
        "Pagar Gunung",
        "Pajar Bulan",
        "Pseksu",
        "Pulau Pinang",
        "Sukamerindu",
        "Tanjung Sakti Pumi",
        "Tanjung Sakti Pumu",
        "Tanjung Tebat",
      )),
      "Lubuk Linggau" => drupal_map_assoc(array(
        "Lubuk Linggau Barat Dua (II)",
        "Lubuk Linggau Barat Satu (I)",
        "Lubuk Linggau Selatan Dua (II)",
        "Lubuk Linggau Selatan Satu (I)",
        "Lubuk Linggau Timur Dua (II)",
        "Lubuk Linggau Timur Satu (I)",
        "Lubuk Linggau Utara Dua (II)",
        "Lubuk Linggau Utara Satu (I)",
      )),
      "Muara Enim" => drupal_map_assoc(array(
        "Abab",
        "Benakat",
        "Gelumbang",
        "Gunung Megang",
        "Kelekar",
        "Lawang Kidul",
        "Lembak",
        "Lubai",
        "Muara Belida",
        "Muara Enim",
        "Penukal (Penukal Abab)",
        "Penukal Utara",
        "Rambang",
        "Rambang Dangku",
        "Semendo Darat Laut",
        "Semendo Darat Tengah",
        "Semendo Darat Ulu",
        "Sungai Rotan",
        "Talang Ubi",
        "Tanah Abang",
        "Tanjung Agung",
        "Ujan Mas",
      )),
      "Musi Banyuasin" => drupal_map_assoc(array(
        "Babat Supat",
        "Babat Toman",
        "Batanghari Leko",
        "Bayung Lencir",
        "Keluang",
        "Lais",
        "Lalan (Sungai Lalan)",
        "Lawang Wetan",
        "Plakat Tinggi (Pelakat Tinggi)",
        "Sanga Desa",
        "Sekayu",
        "Sungai Keruh",
        "Sungai Lilin",
        "Tungkal Jaya",
      )),
      "Musi Rawas" => drupal_map_assoc(array(
        "Batukuning Lakitan Ulu (BTS)/Cecar",
        "Jaya Loka",
        "Karang Dapo",
        "Karang Jaya",
        "Megang Sakti",
        "Muara Beliti",
        "Muara Kelingi",
        "Muara Lakitan",
        "Nibung",
        "Purwodadi",
        "Rawas Ilir",
        "Rawas Ulu",
        "Rupit",
        "Selangit",
        "STL Ulu Terawas",
        "Sukakarya",
        "Sumber Harta",
        "Tiang Pumpung Kepungut",
        "Tuah Negeri",
        "Tugumulyo",
        "Ulu Rawas",
      )),
      "Ogan Ilir" => drupal_map_assoc(array(
        "Indralaya",
        "Indralaya Selatan",
        "Indralaya Utara",
        "Kandis",
        "Lubuk Keliat",
        "Muara Kuang",
        "Payaraman",
        "Pemulutan",
        "Pemulutan Barat",
        "Pemulutan Selatan",
        "Rambang Kuang",
        "Rantau Alai",
        "Rantau Panjang",
        "Sungai Pinang",
        "Tanjung Batu",
        "Tanjung Raja",
      )),
      "Ogan Komering Ilir" => drupal_map_assoc(array(
        "Air Sugihan",
        "Cengal",
        "Jejawi",
        "Kayu Agung",
        "Lempuing",
        "Lempuing Jaya",
        "Mesuji",
        "Mesuji Makmur",
        "Mesuji Raya",
        "Pampangan",
        "Pangkalan Lampam",
        "Pedamaran",
        "Pedamaran Timur",
        "Sirah Pulau Padang",
        "Sungai Menang",
        "Tanjung Lubuk",
        "Teluk Gelam",
        "Tulung Selapan",
      )),
      "Ogan Komering Ulu" => drupal_map_assoc(array(
        "Baturaja Barat",
        "Baturaja Timur",
        "Lengkiti",
        "Lubuk Batang",
        "Lubuk Raja",
        "Muara Jaya",
        "Pengandonan",
        "Peninjauan",
        "Semidang Aji",
        "Sinar Peninjauan",
        "Sosoh Buay Rayap",
        "Ulu Ogan",
      )),
      "Ogan Komering Ulu Selatan" => drupal_map_assoc(array(
        "Banding Agung",
        "Buana Pemaca",
        "Buay Pemaca",
        "Buay Pematang Ribu Ranau Tengah",
        "Buay Rawan",
        "Buay Runjung",
        "Buay Sandang Aji",
        "Kisam Ilir",
        "Kisam Tinggi",
        "Mekakau Ilir",
        "Muaradua",
        "Muaradua Kisam",
        "Pulau Beringin",
        "Runjung Agung",
        "Simpang",
        "Sindang Danau",
        "Sungai Are",
        "Tiga Dihaji",
        "Warkuk Ranau Selatan",
      )),
      "Ogan Komering Ulu Timur" => drupal_map_assoc(array(
        "Belitang",
        "Belitang II",
        "Belitang III",
        "Belitang Jaya",
        "Belitang Madang Raya",
        "Belitang Mulya",
        "Buay Madang",
        "Buay Madang Timur",
        "Buay Pemuka Bangsa Raja",
        "Buay Pemuka Beliung / Peliung",
        "Bunga Mayang",
        "Cempaka",
        "Jayapura",
        "Madang Suku I",
        "Madang Suku II",
        "Madang Suku III",
        "Martapura",
        "Semendawai Barat",
        "Semendawai Suku III",
        "Semendawai Timur",
      )),
      "Pagar Alam" => drupal_map_assoc(array(
        "Dempo Selatan",
        "Dempo Tengah",
        "Dempo Utara",
        "Pagar Alam Selatan",
        "Pagar Alam Utara",
      )),
      "Palembang" => drupal_map_assoc(array(
        "Alang-Alang Lebar",
        "Bukit Kecil",
        "Gandus",
        "Ilir Barat I",
        "Ilir Barat II",
        "Ilir Timur I",
        "Ilir Timur II",
        "Kalidoni",
        "Kemuning",
        "Kertapati",
        "Plaju",
        "Sako",
        "Seberang Ulu I",
        "Seberang Ulu II",
        "Sematang Borang",
        "Sukarami",
      )),
      "Prabumulih" => drupal_map_assoc(array(
        "Cambai",
        "Prabumulih Barat",
        "Prabumulih Selatan",
        "Prabumulih Timur",
        "Prabumulih Utara",
        "Rambang Kapak Tengah",
      )),
    ),
    "Sumatera Utara" => array(
      "Asahan" => drupal_map_assoc(array(
        "Aek Kuasan",
        "Aek Ledong",
        "Aek Songsongan",
        "Air Batu",
        "Air Joman",
        "Bandar Pasir Mandoge",
        "Bandar Pulau",
        "Buntu Pane",
        "Kisaran Barat Kota",
        "Kisaran Timur Kota",
        "Meranti",
        "Pulau Rakyat",
        "Pulo Bandring",
        "Rahuning",
        "Rawang Panca Arga",
        "Sei Dadap",
        "Sei Kepayang",
        "Sei Kepayang Barat",
        "Sei Kepayang Timur",
        "Setia Janji",
        "Silau Laut",
        "Simpang Empat",
        "Tanjung Balai",
        "Teluk Dalam",
        "Tinggi Raja",
      )),
      "Batu Bara" => drupal_map_assoc(array(
        "Air Putih",
        "Limapuluh",
        "Medang Deras",
        "Sei Balai",
        "Sei Suka",
        "Talawi",
        "Tanjung Tiram",
      )),
      "Binjai" => drupal_map_assoc(array(
        "Binjai Barat",
        "Binjai Kota",
        "Binjai Selatan",
        "Binjai Timur",
        "Binjai Utara",
      )),
      "Dairi" => drupal_map_assoc(array(
        "Berampu (Brampu)",
        "Gunung Sitember",
        "Lae Parira",
        "Parbuluan",
        "Pegagan Hilir",
        "Sidikalang",
        "Siempat Nempu",
        "Siempat Nempu Hilir",
        "Siempat Nempu Hulu",
        "Silahi Sabungan",
        "Silima Pungga-Pungga",
        "Sitinjo",
        "Sumbul",
        "Tanah Pinem",
        "Tiga Lingga",
      )),
      "Deli Serdang" => drupal_map_assoc(array(
        "Bangun Purba",
        "Batang Kuis",
        "Beringin",
        "Biru-Biru",
        "Deli Tua",
        "Galang",
        "Gunung Meriah",
        "Hamparan Perak",
        "Kutalimbaru",
        "Labuhan Deli",
        "Lubuk Pakam",
        "Namo Rambe",
        "Pagar Merbau",
        "Pancur Batu",
        "Pantai Labu",
        "Patumbak",
        "Percut Sei Tuan",
        "Sibolangit",
        "Sinembah Tanjung Muda Hilir",
        "Sinembah Tanjung Muda Hulu",
        "Sunggal",
        "Tanjung Morawa",
      )),
      "Gunungsitoli" => drupal_map_assoc(array(
        "Gunungsitoli",
        "Gunungsitoli Alo'oa",
        "Gunungsitoli Barat",
        "Gunungsitoli Idanoi",
        "Gunungsitoli Selatan",
        "Gunungsitoli Utara",
      )),
      "Humbang Hasundutan" => drupal_map_assoc(array(
        "Bakti Raja",
        "Dolok Sanggul",
        "Lintong Nihuta",
        "Onan Ganjang",
        "Pakkat",
        "Paranginan",
        "Parlilitan",
        "Pollung",
        "Sijama Polang",
        "Tara Bintang",
      )),
      "Karo" => drupal_map_assoc(array(
        "Barus Jahe",
        "Brastagi (Berastagi)",
        "Dolat Rayat",
        "Juhar",
        "Kabanjahe",
        "Kuta Buluh",
        "Laubaleng",
        "Mardinding",
        "Merdeka",
        "Merek",
        "Munte",
        "Nama Teran",
        "Payung",
        "Simpang Empat",
        "Tiga Binanga",
        "Tiga Panah",
        "Tiganderket",
      )),
      "Labuhan Batu" => drupal_map_assoc(array(
        "Bilah Barat",
        "Bilah Hilir",
        "Bilah Hulu",
        "Panai Hilir",
        "Panai Hulu",
        "Panai Tengah",
        "Pangkatan",
        "Rantau Selatan",
        "Rantau Utara",
      )),
      "Labuhan Batu Selatan" => drupal_map_assoc(array(
        "Kampung Rakyat",
        "Kota Pinang",
        "Sei/Sungai Kanan",
        "Silangkitang",
        "Torgamba",
      )),
      "Labuhan Batu Utara" => drupal_map_assoc(array(
        "Aek Kuo",
        "Aek Natas",
        "Kuala Ledong (Kualuh Leidong)",
        "Kualuh Hilir",
        "Kualuh Hulu",
        "Kualuh Selatan",
        "Marbau",
        "Na IX-X",
      )),
      "Langkat" => drupal_map_assoc(array(
        "Babalan",
        "Bahorok",
        "Batang Serangan",
        "Besitang",
        "Binjai",
        "Brandan Barat",
        "Gebang",
        "Hinai",
        "Kuala",
        "Kutambaru",
        "Padang Tualang",
        "Pangkalan Susu",
        "Pematang Jaya",
        "Salapian",
        "Sawit Seberang",
        "Secanggang",
        "Sei Binge (Bingai)",
        "Sei Lepan",
        "Selesai",
        "Sirapit (Serapit)",
        "Stabat",
        "Tanjungpura",
        "Wampu",
      )),
      "Mandailing Natal" => drupal_map_assoc(array(
        "Batahan",
        "Batang Natal",
        "Bukit Malintang",
        "Huta Bargot",
        "Kotanopan",
        "Langga Bayu (Lingga Bayu)",
        "Lembah Sorik Merapi",
        "Muara Batang Gadis",
        "Muara Sipongi",
        "Naga Juang",
        "Natal",
        "Pakantan",
        "Panyabungan Barat",
        "Panyabungan Kota",
        "Panyabungan Selatan",
        "Panyabungan Timur",
        "Panyabungan Utara",
        "Puncak Sorik Marapi/Merapi",
        "Ranto Baek/Baik",
        "Siabu",
        "Sinunukan",
        "Tambangan",
        "Ulu Pungkut",
      )),
      "Medan" => drupal_map_assoc(array(
        "Medan Amplas",
        "Medan Area",
        "Medan Barat",
        "Medan Baru",
        "Medan Belawan Kota",
        "Medan Deli",
        "Medan Denai",
        "Medan Helvetia",
        "Medan Johor",
        "Medan Kota",
        "Medan Labuhan",
        "Medan Maimun",
        "Medan Marelan",
        "Medan Perjuangan",
        "Medan Petisah",
        "Medan Polonia",
        "Medan Selayang",
        "Medan Sunggal",
        "Medan Tembung",
        "Medan Timur",
        "Medan Tuntungan",
      )),
      "Nias" => drupal_map_assoc(array(
        "Bawolato",
        "Botomuzoi",
        "Gido",
        "Hili Serangkai (Hilisaranggu)",
        "Hiliduho",
        "Idano Gawo",
        "Ma'u",
        "Sogae Adu (Sogaeadu)",
        "Somolo-Molo (Samolo)",
        "Ulugawo",
      )),
      "Nias Barat" => drupal_map_assoc(array(
        "Lahomi (Gahori)",
        "Lolofitu Moi",
        "Mandrehe",
        "Mandrehe Barat",
        "Mandrehe Utara",
        "Moro'o",
        "Sirombu",
        "Ulu Moro'o (Ulu Narwo)",
      )),
      "Nias Selatan" => drupal_map_assoc(array(
        "Amandraya",
        "Aramo",
        "Boronadu",
        "Fanayama",
        "Gomo",
        "Hibala",
        "Hilimegai",
        "Hilisalawa'ahe (Hilisalawaahe)",
        "Huruna",
        "Lahusa",
        "Lolomatua",
        "Lolowau",
        "Maniamolo",
        "Mazino",
        "Mazo",
        "O'o'u (Oou)",
        "Onohazumba",
        "Pulau-Pulau Batu",
        "Pulau-Pulau Batu Barat",
        "Pulau-Pulau Batu Timur",
        "Pulau-Pulau Batu Utara",
        "Sidua'ori",
        "Simuk",
        "Somambawa",
        "Susua",
        "Tanah Masa",
        "Teluk Dalam",
        "Toma",
        "Ulunoyo",
        "Ulususua",
        "Umbunasi",
      )),
      "Nias Utara" => drupal_map_assoc(array(
        "Afulu",
        "Alasa",
        "Alasa Talumuzoi",
        "Lahewa",
        "Lahewa Timur",
        "Lotu",
        "Namohalu Esiwa",
        "Sawo",
        "Sitolu Ori",
        "Tugala Oyo",
        "Tuhemberua",
      )),
      "Padang Lawas" => drupal_map_assoc(array(
        "Aek Nabara Barumun",
        "Barumun",
        "Barumun Selatan",
        "Barumun Tengah",
        "Batang Lubu Sutam",
        "Huristak",
        "Huta Raja Tinggi",
        "Lubuk Barumun",
        "Sihapas Barumun",
        "Sosa",
        "Sosopan",
        "Ulu Barumun",
      )),
      "Padang Lawas Utara" => drupal_map_assoc(array(
        "Batang Onang",
        "Dolok",
        "Dolok Sigompulon",
        "Halongonan",
        "Hulu Sihapas",
        "Padang Bolak",
        "Padang Bolak Julu",
        "Portibi",
        "Simangambat",
      )),
      "Padang Sidempuan" => drupal_map_assoc(array(
        "Padang Sidempuan Angkola Julu",
        "Padang Sidempuan Batunadua",
        "Padang Sidempuan Hutaimbaru",
        "Padang Sidempuan Selatan",
        "Padang Sidempuan Tenggara",
        "Padang Sidempuan Utara (Padangsidimpuan)",
      )),
      "Pakpak Bharat" => drupal_map_assoc(array(
        "Kerajaan",
        "Pagindar",
        "Pergetteng Getteng Sengkut",
        "Salak",
        "Siempat Rube",
        "Sitellu Tali Urang Jehe",
        "Sitellu Tali Urang Julu",
        "Tinada",
      )),
      "Pematang Siantar" => drupal_map_assoc(array(
        "Siantar Barat",
        "Siantar Marihat",
        "Siantar Marimbun",
        "Siantar Martoba",
        "Siantar Selatan",
        "Siantar Sitalasari",
        "Siantar Timur",
        "Siantar Utara",
      )),
      "Samosir" => drupal_map_assoc(array(
        "Harian",
        "Nainggolan",
        "Onan Runggu",
        "Palipi",
        "Pangururan",
        "Ronggur Nihuta",
        "Sianjur Mula-Mula",
        "Simanindo",
        "Sitio-Tio",
      )),
      "Serdang Bedagai" => drupal_map_assoc(array(
        "Bandar Khalifah",
        "Bintang Bayu",
        "Dolok Masihul",
        "Dolok Merawan",
        "Kotarih",
        "Pantai Cermin",
        "Pegajahan",
        "Perbaungan",
        "Sei Bamban",
        "Sei Rampah",
        "Serba Jadi",
        "Silinda",
        "Sipispis",
        "Tanjung Beringin",
        "Tebing Syahbandar",
        "Tebing Tinggi",
        "Teluk Mengkudu",
      )),
      "Sibolga" => drupal_map_assoc(array(
        "Sibolga Kota",
        "Sibolga Sambas",
        "Sibolga Selatan",
        "Sibolga Utara",
      )),
      "Simalungun" => drupal_map_assoc(array(
        "Bandar",
        "Bandar Huluan",
        "Bandar Masilam",
        "Bosar Maligas",
        "Dolok Batu Nanggar",
        "Dolok Panribuan",
        "Dolok Pardamean",
        "Dolok Silau",
        "Girsang Sipangan Bolon",
        "Gunung Malela",
        "Gunung Maligas",
        "Haranggaol Horison",
        "Hatonduhan",
        "Huta Bayu Raja",
        "Jawa Maraja Bah Jambi",
        "Jorlang Hataran",
        "Panei",
        "Panombeian Panei",
        "Pematang Bandar",
        "Pematang Sidamanik",
        "Pematang Silima Huta",
        "Purba",
        "Raya",
        "Raya Kahean",
        "Siantar",
        "Sidamanik",
        "Silimakuta",
        "Silou Kahean",
        "Tanah Jawa",
        "Tapian Dolok",
        "Ujung Padang",
      )),
      "Tanjung Balai" => drupal_map_assoc(array(
        "Datuk Bandar",
        "Datuk Bandar Timur",
        "Sei Tualang Raso",
        "Tanjung Balai Selatan",
        "Tanjung Balai Utara",
        "Teluk Nibung",
      )),
      "Tapanuli Selatan" => drupal_map_assoc(array(
        "Aek Bilah",
        "Angkola Barat (Padang Sidempuan)",
        "Angkola Sangkunur",
        "Angkola Selatan (Siais)",
        "Angkola Timur (Padang Sidempuan)",
        "Arse",
        "Batang Angkola",
        "Batang Toru",
        "Marancar",
        "Muara Batang Toru",
        "Saipar Dolok Hole",
        "Sayur Matinggi",
        "Sipirok",
        "Tano Tombangan Angkola",
      )),
      "Tapanuli Tengah" => drupal_map_assoc(array(
        "Andam Dewi",
        "Badiri",
        "Barus",
        "Barus Utara",
        "Kolang",
        "Lumut",
        "Manduamas",
        "Pandan",
        "Pasaribu Tobing",
        "Pinangsori",
        "Sarudik",
        "Sibabangun",
        "Sirandorung",
        "Sitahuis",
        "Sorkam",
        "Sorkam Barat",
        "Sosor Gadong",
        "Suka Bangun",
        "Tapian Nauli",
        "Tukka",
      )),
      "Tapanuli Utara" => drupal_map_assoc(array(
        "Adian Koting",
        "Garoga",
        "Muara",
        "Pagaran",
        "Pahae Jae",
        "Pahae Julu",
        "Pangaribuan",
        "Parmonangan",
        "Purbatua",
        "Siatas Barita",
        "Siborong-Borong",
        "Simangumban",
        "Sipahutar",
        "Sipoholon",
        "Tarutung",
      )),
      "Tebing Tinggi" => drupal_map_assoc(array(
        "Bajenis",
        "Padang Hilir",
        "Padang Hulu",
        "Rambutan",
        "Tebing Tinggi Kota",
      )),
      "Toba Samosir" => drupal_map_assoc(array(
        "Ajibata",
        "Balige",
        "Bonatua Lunasi",
        "Bor-Bor",
        "Habinsaran",
        "Laguboti",
        "Lumban Julu",
        "Nassau",
        "Parmaksian",
        "Pintu Pohan Meranti",
        "Porsea",
        "Siantar Narumonda",
        "Sigumpar",
        "Silaen",
        "Tampahan",
        "Uluan",
      )),
    ),
  );

  return $locality_blocks;
}
