# AddToAny Share Buttons

Share buttons for Drupal including AddToAny's universal sharing button,
Facebook, Mastodon, Pinterest, WhatsApp, Reddit, SMS, email and many more.

Vector share buttons use [AddToAny](https://www.addtoany.com/) SVG sharing
icons. AddToAny vector icons load efficiently, are mathematically precise,
scalable to any size, and stunning on High-PPI screens such as Retina displays.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/addtoany).

Submit feature suggestions, bug reports, or track changes in the
[issue queue](https://www.drupal.org/project/issues/addtoany).


## Table of contents

- Requirements
- Installation
- Configuration
- Features


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-modules).


## Configuration

To configure AddToAny, go to:
`Administration > Configuration > Web services > AddToAny`.

See the Drupal Wiki's documentation:
[Configuring AddToAny](https://www.drupal.org/docs/contributed-modules/addtoany-share-buttons/configuring-addtoany).

Explore AddToAny's documentation:
[Drupal Sharing Customization](https://www.addtoany.com/buttons/customize/drupal).


## Features

The module strives to remain lightweight & efficient while integrating with
core Drupal features and major contributed modules such as:

- Blocks
- Views
- Display Suite (contributed)

AddToAny is optimized to load asynchronously, and many sharing and social
media features come from AddToAny including:

- Universal share menu
- Native share menu
- Share buttons
- Share counters
- Share templates
- Follow buttons
- Custom color buttons
- Custom icons
- Google Analytics integration
- Event tracking (useful for integrating with analytics software)
- Link tracking using Bitly, custom URL shorteners, UTM parameters
- Automatic localization (in over 50 languages)
