<?php

namespace Drupal\Tests\addtocal_augment\Unit;

use Drupal\addtocal_augment\Plugin\DateAugmenter\AddToCal;
use Drupal\Core\Datetime\DrupalDateTime;

class TestAddToCal extends AddToCal {

  /**
   * Override parent::defaultConfiguration()
   * which uses String Translation.
   */
  public function defaultConfiguration() {
    return [
      'event_title' => '',
      'location' => '',
      'description' => '',
      'max_desc' => 60,
      'past_events' => FALSE,
      'label' => 'Add to Calendar',
      'target' => '',
    ];
  }

  /**
   * Override parent::getCurrentDate()
   * Do NOT call parent::getCurrentDate() inside this function
   * or you will receive the original error.
   */
  protected function getCurrentDate() {
    $cdt = new \DateTimeZone('America/Chicago');
    $settings = ['langcode' => 'en'];
    return DrupalDateTime::createFromFormat('Y-m-d H:i:s', '2021-10-27 00:00:00', $cdt, $settings);
  }
}
