<?php

/**
 * @file
 * Admin setting form.
 */

/**
 * Implements hook_settings_form().
 */
function admin_content_notification_settings_form($form) {
  $form = array();
  $form['admin_content_notification_fieldset'] = array(
    '#type' => 'fieldset',
    '#title' => t('Select the content types'),
    '#description' => t('Choose the content type for which you want to send notification on content insert.'),
  );
  $form['admin_content_notification_fieldset']['admin_content_notification_node_types'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Content types'),
    '#default_value' => variable_get('admin_content_notification_node_types', array()),
    '#options' => node_type_get_names(),
  );
  $admin_mail = variable_get('site_mail', ini_get('sendmail_from'));
  $form['admin_content_notification_email'] = array(
    '#type' => 'textfield',
    '#title' => t('Email to whom the notification is to be sent'),
    '#default_value' => variable_get('admin_content_notification_email', $admin_mail),
  );
  $form['admin_content_notification_email_fieldset'] = array(
    '#type' => 'fieldset',
    '#title' => t('Email Settings'),
  );
  $form['admin_content_notification_email_fieldset']['admin_content_notification_email_subject'] = array(
    '#type' => 'textfield',
    '#title' => t('Configurable email subject'),
    '#default_value' => variable_get('admin_content_notification_email_subject', 'A New Content is Posted'),
    '#description' => t('Enter a default subject of the notification email.'),
  );
  $form['admin_content_notification_email_fieldset']['admin_content_notification_email_body'] = array(
    '#type' => 'textarea',
    '#title' => t('Configurable email body'),
    '#default_value' => variable_get('admin_content_notification_email_body', 'A new content has been posted on your site.'),
    '#description' => t('Enter the default email template to notify users about new content posted on the site. Use the following tokens: %posted_by, %content_link'),
  );
  return system_settings_form($form);
}
