<?php

/**
 * @file
 * Admin setting form.
 */

/**
 * Implements hook_settings_form().
 */
function admin_content_notification_settings_form($form) {
  $form = array();
  $form['admin_content_notification_fieldset'] = array(
    '#type' => 'fieldset',
    '#title' => t('Select the content types'),
    '#description' => t('Choose the content type for which you want to send notification on content insert.'),
  );
  $form['admin_content_notification_fieldset']['admin_content_notification_node_types'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Content types'),
    '#default_value' => variable_get('admin_content_notification_node_types', array()),
    '#options' => node_type_get_names(),
  );
  $trigger_node_update = variable_get('admin_content_notification_trigger_on_node_update', FALSE);
  $form['admin_content_notification_trigger_on_node_update'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable on update action'),
    '#default_value' => $trigger_node_update,
    '#description' => t('Please check on it if you want to send notification on update action as well.'),
  );
  $trigger_for_roles = variable_get('admin_content_notification_allowed_roles', array());
  $user_roles = user_roles();
  if (in_array('authenticated user', $user_roles)) {
    unset($user_roles[array_search('authenticated user', $user_roles)]);
  }
  $form['admin_content_notification_allowed_roles'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Select roles'),
    '#options' => $user_roles,
    '#default_value' => $trigger_for_roles,
    '#description' => t('Please select roles for which you want to trigger email notfication on content insert/update'),
  );
  $form['admin_content_notification_email_fieldset'] = array(
    '#type' => 'fieldset',
    '#title' => t('Email Settings'),
  );
  $admin_mail = variable_get('site_mail', ini_get('sendmail_from'));
  $form['admin_content_notification_email_fieldset']['admin_content_notification_email'] = array(
    '#type' => 'textarea',
    '#title' => t("Email Id's to whom the notification is to be sent, add comma separated emails in case of multiple recipients"),
    '#default_value' => variable_get('admin_content_notification_email', $admin_mail),
  );
  $form['admin_content_notification_recepient_fieldset']['admin_content_notification_email_or_markup']['#markup'] = '<strong>OR</strong>';
  $user_roles = user_roles();
  $trigger_to_roles = variable_get('admin_content_notification_send_to_allowed_roles', array());
  $form['admin_content_notification_email_fieldset']['admin_content_notification_send_to_allowed_roles'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Select roles'),
    '#options' => $user_roles,
    '#default_value' => $trigger_to_roles,
    '#description' => t('Please select the roles to whom you want to send email'),
  );
  $form['admin_content_notification_email_fieldset']['admin_content_notification_email_subject'] = array(
    '#type' => 'textfield',
    '#title' => t('Configurable email subject'),
    '#default_value' => variable_get('admin_content_notification_email_subject', 'A New Content is Posted'),
    '#description' => t('Enter a default subject of the notification email.'),
  );
  $form['admin_content_notification_email_fieldset']['admin_content_notification_email_body'] = array(
    '#type' => 'textarea',
    '#title' => t('Configurable email body'),
    '#default_value' => variable_get('admin_content_notification_email_body', 'A new content has been submitted on your site. <br/> Submitted by : !posted_by <br/> Content link : !content_link'),
    '#description' => t('Enter the default email template to notify users about new content posted on the site. Use the following tokens: !posted_by, !content_link, !content_title, !content_type, !action (posted or updated, will update accrodingly).'),
  );
  return system_settings_form($form);
}
