(function ($, Drupal) {

  Drupal.behaviors.AdminDialogsSelector = {
    attach: function (context, settings) {
      let paths = settings.admin_dialogs.paths;
      let selectors = settings.admin_dialogs.selectors;
      if (paths) {
        $('a:not(".admin-dialog-processed")').each(function() {
          // Optional chaining
          let href = $(this).attr('href')?.replace(/(\?.*)|(#.*)/g, "");
          console.log(href);
          if (paths[href] !== undefined) {
            $(this).addClass(paths[href]['class'][0]);
            $(this).attr('data-dialog-options', paths[href]['data-dialog-options']);
            $(this).attr('data-dialog-type', paths[href]['data-dialog-type']);
            if (paths[href]['data-dialog-type'] == 'dialog') {
              $(this).attr('data-dialog-renderer', paths[href]['data-dialog-renderer']);
            }
          }
          $(this).addClass('admin-dialog-processed');
        });
      }
      if (selectors) {
        for (var selector in selectors) {
          let element = $(selector + ':not(".admin-dialog-selector-processed")');
          element.each(function() {
            $(this).addClass(selectors[selector]['class'][0]);
            $(this).attr('data-dialog-options', selectors[selector]['data-dialog-options']);
            $(this).attr('data-dialog-type', selectors[selector]['data-dialog-type']);
            if (selectors[selector]['data-dialog-type'] == 'dialog') {
              $(this).attr('data-dialog-renderer', selectors[selector]['data-dialog-renderer']);
            }
            $(this).addClass('admin-dialog-selector-processed');
          });
        }
      }
    }
  };

})(jQuery, Drupal);
