/**
 * @File
 * Javascript for the Admin Feedback module.
 */

(function ($, Drupal, drupalSettings) {
  $( document ).ready(function() {
    $(".feedback-btn").click(function (event) {
      var yesResponse = drupalSettings.admin_feedback.yes_response;
      var noResponse = drupalSettings.admin_feedback.no_response;
      var feedbackPromptOnYes = drupalSettings.admin_feedback.feedback_prompt_on_yes;
      var feedbackPromptOnNo = drupalSettings.admin_feedback.feedback_prompt_on_no;
      var feedbackPrompt = drupalSettings.admin_feedback.feedback_prompt;
      var feedbackEnablePredefinedAnswers = drupalSettings.admin_feedback.feedback_enable_predefined_answers;
      var nodeId = $(this).data('node-id');
      var feedback = $(this).data('feedback');
      var langCode = drupalSettings.path.currentLanguage;

      $("#edit-feedback-send").prop("disabled", true);
      if (feedbackEnablePredefinedAnswers === true) {
        $("#feedback-msg-answers").click(function() {
          if ($("#feedback-msg-answers input").is(":checked")) {
            $("#edit-feedback-send").prop("disabled", false);
            $("#edit-feedback-send").css("cursor", "pointer");
          }
        });
      } else {
        $('#edit-feedback-msg').val('');
        $('#edit-feedback-msg').keyup(function () {
          if ($(this).val() != '') {
            $('#edit-feedback-send').prop('disabled', false);
            $('#edit-feedback-send').css('cursor', 'pointer');
          } else if ($(this).val() == '') {
            $('#edit-feedback-send').prop('disabled', true);
            $('#edit-feedback-send').css('cursor', 'not-allowed');
          }
        });
      }

      if (feedback == 'yes') {
        if (feedbackPromptOnYes === true) {
          $('#upper-feedback-content').replaceWith('<h2>' + yesResponse + '</h2><p>' + feedbackPrompt + '</p>');
          $('#admin-feedback-form').css('display', 'block');
        } else {
          $('#upper-feedback-content').replaceWith('<h2>' + yesResponse + '</h2>');
        }
      } else if (feedback == 'no') {
        if (feedbackPromptOnNo === true) {
          $('#upper-feedback-content').replaceWith('<h2>' + noResponse + '</h2><p>' + feedbackPrompt + '</p>');
          $('#admin-feedback-form').css('display', 'block');
        } else {
          $('#upper-feedback-content').replaceWith('<h2>' + noResponse + '</h2>');
        }
      }

      var langPrefix = drupalSettings.path.pathPrefix === drupalSettings.path.currentLanguage + '/'
        ? '/' + drupalSettings.path.currentLanguage
        : '';

      $.ajax({
        type: "POST",
        url: langPrefix  + "/feedback_vote",
        data: {"vote": feedback, "node_id": nodeId},
        success: function (data) {
          $('#feedback-id').val(data[0]);
        },
      });
    });
  });
})(jQuery, Drupal, drupalSettings);
