<?php

namespace Drupal\admin_feedback\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Wraps a vote event for event listeners.
 */
class VoteEvent extends Event {
  protected $vote;
  protected $nid;

  const VOTE_EVENT = 'event_subscriber.vote';

  /**
   * @return mixed
   */
  public function getVote()
  {
    return $this->vote;
  }

  /**
   * @param mixed $vote
   */
  public function setVote($vote)
  {
    $this->vote = $vote;
  }

  /**
   * @return mixed
   */
  public function getNid()
  {
    return $this->nid;
  }

  /**
   * @param mixed $nid
   */
  public function setNid($nid)
  {
    $this->nid = $nid;
  }

}
