<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Drupal\admin_notes\Form;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;


/**
* My Custom form.
*/
class AdminNotesForm extends FormBase {
/**
* {@inheritdoc}
*/
public function getFormId() {
return 'admin_notes_form';
}

/**
* {@inheritdoc}
*/
public function buildForm(array $form, FormStateInterface $form_state,$note = NULL) {
     $account = $this->currentUser();
       $form['admin_note'] = array(
            '#type' => 'textarea',
            '#title' => t('Block contents'),
            '#description' => t('This text will appear in the example block.'),
            '#default_value' => $note,
             '#access' => $account->hasPermission('access admin notes'),
        );
        $form['actions'] = ['#type' => 'actions'];
        $form['actions']['delete'] = array(
            '#type' => 'submit',
            '#value' => $this->t('Delete'),
             '#access' => $account->hasPermission('access admin notes'),
            '#attributes' => array(
                'class' => array('delete-button'),
                'style' => 'display: ' . ($note ? ' block' : ' none'),
            ),
        );

$form['actions']['submit'] = array(
            '#type' => 'submit',
            '#value' => ($note ? $this->t('Update') : $this->t('Save')),
     '#access' => $account->hasPermission('access admin notes'),
            '#attributes' => array(
                'class' => array('save-button', ($note ? 'delete-show' : '')),
            ),
        );

return $form;
}
//public function validateForm(array &$form, FormStateInterface $form_state) {
////if ($form_state->getValue('name') == '' ) {
////$form_state->setErrorByName('name', t('This is a required field.'));
////}
//}

/**
* {@inheritdoc}
*/
public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
  
  
  $button_value = $form_state->getValue('op');

  switch($button_value) {
    case 'Delete':    
     $message = self::admin_notes_record_handler($current_path, 'delete');
      break;   
    case 'Save':
    case 'Update':
        $current_path = \Drupal::service('path.current')->getPath();
      $message = self::admin_notes_record_handler($current_path, 'save', $form_state->getValue('admin_note'));
      break;      
  }
//  
  drupal_set_message($message);
}
 static function admin_notes_record_handler($path, $op, $note = '') {

  switch ($op) {
    case 'delete':
      db_delete('admin_notes')
      ->condition('path', $path)
      ->execute();
      
      $message =  t('Your admin note has been deleted.');
    case 'save':
     $user = \Drupal::currentUser();
      $front = Url::fromRoute('<front>');
      $path = \Drupal::service('path.current')->getPath();; 
      // Was there already a note added for this path
   
      if (self::admin_notes_note_exists($path)) {
        db_update('admin_notes')
          ->fields(array(
            'uid' => $user->id(),
            'note' => $note,
            'timestamp' => time(),
          ))
          ->condition('path', $path)
          ->execute();
          
        $message = t('Your admin note has been updated.');
      }
      else {
        db_insert('admin_notes')
          ->fields(array(
            'uid' => $user->id(),
            'note' => $note,
            'path' => $path,
            'timestamp' => time(),
          ))
          ->execute();
          
        $message = t('Your admin note has been saved.');
      }
      
      return $message;
  }
}
static function admin_notes_note_exists($path = '') {

        $front = Url::fromRoute('<front>')->toString();
        $front_page = \Drupal::config('system.site')->get('page.front');
        $page = \Drupal::service('path.current')->getPath();
        if ($front_page == $page) {
            $path = '/';
        } elseif ($path == '') {
            $path = \Drupal::service('path.current')->getPath();
        }

        $result = db_select('admin_notes', 'an')
                ->fields('an')
                ->condition('path', $path)
                ->execute()
                ->fetchAssoc();

        if (is_array($result)) {
            return $result;
        } else {
            return FALSE;
        }
    }

}

/**
 * Handles updating/deleting a record from the admin_notes table.
 */
