<?php

namespace Drupal\admin_status_report;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages admin_status_report plugins.
 *
 * The AdminStatusPluginManager class extends the DefaultPluginManager to
 * provide a way to manage admin_status_report plugins.
 *
 * As well as this class definition, we need to declare our plugin manager class
 * as a service, in the plugin_type_admin_status.services.yml file.
 */
class AdminStatusPluginManager extends DefaultPluginManager {

  /**
   * Creates the discovery object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    $subdir = 'Plugin/AdminStatus';
    $plugin_interface = 'Drupal\admin_status_report\AdminStatusInterface';
    $plugin_definition_annotation_name = 'Drupal\Component\Annotation\Plugin';
    parent::__construct($subdir, $namespaces, $module_handler, $plugin_interface, $plugin_definition_annotation_name);
    $this->setCacheBackend($cache_backend, 'admin_status_info');
  }

}
