<?php

namespace Drupal\admin_status_report\Plugin\AdminStatus;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a default message.
 *
 * @Plugin(
 *   id = "default_message",
 *   name = "Default Message",
 *   admin_permission = "administer admin status",
 * )
 */
class DefaultMsg extends AdminStatusPluginBase {

  /**
   * {@inheritdoc}
   */
  public function description() {
    return $this->t('Display a generic message.');
  }

  /**
   * {@inheritdoc}
   */
  public function configForm(
    array $form,
    FormStateInterface $form_state,
    array $configValues,
  ) {
    $form = [
      'type' => [
        '#type' => 'select',
        '#title' => $this->t('Message type'),
        '#options' => [
          'status' => $this->t('status'),
          'warning' => $this->t('warning'),
          'error' => $this->t('error'),
        ],
        '#default_value' => empty($configValues['type']) ? '' : $configValues['type'],
      ],
      'message' => [
        '#type' => 'textfield',
        '#title' => $this->t('Message text'),
        '#default_value' => empty($configValues['message']) ? '' : $configValues['message'],
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function configValidateForm(
    array $form,
    FormStateInterface $form_state,
    array $configValues,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function configSubmitForm(
    array $form,
    FormStateInterface $form_state,
    array $configValues,
  ) {
    $config = $form_state->getValue(
      ['plugins', 'default_message', 'config']);
    return $config;
  }

  /**
   * {@inheritdoc}
   */
  public function message(array $configValues) {
    return [
      [
        'status' => $configValues['type'],
        'message' => $configValues['message'],
      ],
    ];
  }

}
