<?php

namespace Drupal\admin_toolbar_content\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AdminToolbarContentSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'admin_toolbar_content';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'admin_toolbar_content.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

    $config = $this->config('admin_toolbar_content.settings');

    $form['#title'] = $this->t('Admin Toolbar Content');
    $form['#tree'] = true;

    $form['recent_items'] = [
      '#type' => 'textfield',
      '#title' => 'Show recent content',
      '#description' => 'Show recent content items. Leave empty or 0 to show none.',
      '#default_value' => $config->get('recent_items') ?? 10
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $config = $this->config('admin_toolbar_content.settings');
    $config->set('recent_items',  $form_state->getValue('recent_items', ''));
    $config->save();

    // Clear cache so admin menu can rebuild.
    \Drupal::service('plugin.manager.menu.link')->rebuild();

    parent::submitForm($form, $form_state);
  }

}