<?php
namespace Drupal\admin_toolbar_content\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Component\Utility\NestedArray;
use Drupal\Core\Entity\EntityAccessControlHandlerInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

class CategoriesMenuLinkDerivative extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static();
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $links = [];

    $links['categories'] = [
        'title' => (string) $this->t('Categories'),
        'route_name' => 'entity.taxonomy_vocabulary.collection',
        'route_parameters' => [],
        'menu_name' => 'admin',
        'parent' => 'system.admin',
        'weight' => -9,
      ] + $base_plugin_definition;

    /** @var \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager */
    $entityTypeManager = \Drupal::service('entity_type.manager');

    // Add a list terms for each vocabulary.
    $vocabularies = $entityTypeManager->getStorage('taxonomy_vocabulary')->loadMultiple();

    foreach ($vocabularies as $vocabulary) {
      $this->addVocabularyLink($vocabulary, $links, $base_plugin_definition);
    }

    return $links;
  }

  protected function addVocabularyLink($vocabulary, &$links, $base_plugin_definition) {

    $links['categories.' . $vocabulary->id()] = [
        'title' => $this->t($vocabulary->label()),
        'route_name' => 'entity.taxonomy_vocabulary.overview_form',
        'route_parameters' => [
          'taxonomy_vocabulary' => $vocabulary->id()
        ],
        'menu_name' => 'admin',
        'parent' =>  $base_plugin_definition['id'] . ':' . 'categories',
        'metadata' => [
          'entity_type' => 'taxonomy_vocabulary',
          'entity_id' => $vocabulary->id()
        ]
      ] + $base_plugin_definition;

    $links['categories.' . $vocabulary->id() . '.add'] = [
        'title' => $this->t('Add new'),
        'route_name' => "entity.taxonomy_term.add_form",
        'route_parameters' => [
          'taxonomy_vocabulary' => $vocabulary->id()
        ],
        'menu_name' => 'admin',
        'parent' =>  $base_plugin_definition['id'] . ':' . 'categories.' . $vocabulary->id(),
        'metadata' => [
          'entity_type' => 'taxonomy_vocabulary',
          'entity_id' => $vocabulary->id()
        ]
      ] + $base_plugin_definition;

  }
}