<?php
namespace Drupal\admin_toolbar_content\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Component\Utility\NestedArray;
use Drupal\Core\Entity\EntityAccessControlHandlerInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

class MediaMenuLinkDerivative extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static();
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $links = [];

    $links['media'] = [
      'title' => (string) $this->t('Media'),
      'route_name' => 'view.media_library.page',
      'route_parameters' => [],
      'menu_name' => 'admin',
      'parent' => 'system.admin',
      'weight' => -8,
    ] + $base_plugin_definition;

    $links['media.files'] = [
        'title' => (string) $this->t('Files'),
        'route_name' => 'view.files.page_1',
        'route_parameters' => [],
        'menu_name' => 'admin',
        'parent' => $base_plugin_definition['id'] . ':' . 'media',
        'weight' => -8,
      ] + $base_plugin_definition;

    /** @var \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager */
    $entityTypeManager = \Drupal::service('entity_type.manager');

    // Add a list terms for each vocabulary.
    $media_types = $entityTypeManager->getStorage('media_type')->loadMultiple();

    foreach ($media_types as $media_type) {
      $this->addMediaTypeLink($media_type, $links, $base_plugin_definition);
    }

    return $links;
  }

  protected function addMediaTypeLink($media_type, &$links, $base_plugin_definition) {

    $links['media.' . $media_type->id()] = [
        'title' => $this->t($media_type->label()),
        'route_name' => 'entity.media.collection',
        'route_parameters' => [
          'type' => $media_type->id()
        ],
        'menu_name' => 'admin',
        'parent' =>  $base_plugin_definition['id'] . ':' . 'media',
      ] + $base_plugin_definition;

    $links['media.' . $media_type->id() . '.add'] = [
        'title' => $this->t('Add new'),
        'route_name' => "entity.media.add_form",
        'route_parameters' => [
          'media_type' => $media_type->id()
        ],
        'menu_name' => 'admin',
        'parent' =>  $base_plugin_definition['id'] . ':' . 'media.' . $media_type->id(),
        'metadata' => [
          'entity_type' => 'media_type',
          'entity_id' => $media_type->id()
        ]
      ] + $base_plugin_definition;

  }
}