<?php

namespace Drupal\admin_toolbar_content\Plugin\Menu;

use Drupal\admin_toolbar_tools\Plugin\Menu\MenuLinkEntity;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a menu link plugins for configuration entities.
 */
class RecentMenuLinkEntity extends MenuLinkEntity {

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $entity_type_manager = $container->get('entity_type.manager');
    $storage = $entity_type_manager->getStorage($plugin_definition['metadata']['entity_type']);
    $type = $entity_type_manager->getDefinition($plugin_definition['metadata']['entity_type']);
    // Get the n-th entity (entity_count) this user is allowed to see.
    $id = current(
      $storage->getQuery()
        ->condition($type->getKey('bundle'), $plugin_definition['metadata']['entity_bundle'])
        ->sort('changed', 'DESC')
        ->sort($type->getKey('id'), 'DESC')
        ->range($plugin_definition['metadata']['entity_count'], 1)
        ->accessCheck()
        ->execute()
    );

    // Make sure the correct entity is loaded in the parent call.
    $plugin_definition['metadata']['entity_id'] = $id ?: 0;

    // Override the placeholder in route parameters with the real entity id.
    $plugin_definition['route_parameters'][$plugin_definition['metadata']['entity_type']] = $id ?: 0;

    return parent::create($container, $configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts() {
    $contexts = parent::getCacheContexts();
    $contexts[] = 'user';
    return $contexts;
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    if (!$this->entity) {
      $description = (string) $this->pluginDefinition['description'];
    }
    return $description ?? parent::getDescription();
  }

}
