<?php

namespace Drupal\admin_toolbar_messages;

use Drupal\Core\DependencyInjection\AutowireTrait;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Routing\AdminContext;
use Drupal\Core\Security\Attribute\TrustedCallback;
use Drupal\Core\StringTranslation\StringTranslationTrait;

final class AdminToolbarMessagesBuilder implements ContainerInjectionInterface {
  use AutowireTrait;
  use StringTranslationTrait;

  public function __construct(
    private readonly AdminAwareMessenger $messenger,
    private readonly AdminContext $adminContext,
  ) {}

  #[TrustedCallback]
  public function build(): array {
    if ($this->adminContext->isAdminRoute()) {
      return [];
    }

    $messages = $this->messenger->deleteAllAdmin();

    if (empty($messages)) {
      return [];
    }

    return [
      '#theme' => 'status_messages__admin_toolbar_messages',
      '#message_list' => $messages,
      '#status_headings' => [
        'status' => $this->t('Status message'),
        'error' => $this->t('Error message'),
        'warning' => $this->t('Warning message'),
      ],
    ];
  }

}
