<?php

declare(strict_types=1);

namespace Drupal\admin_toolbar_messages\Hook;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Hook\Attribute\Hook;

final class ThemeHooks {

  public function __construct(
    private readonly ModuleHandlerInterface $moduleHandler,
  ) {}

  #[Hook('theme')]
  public function onInfo(): array {
    return [
      'status_messages__admin_toolbar_messages' => [
        'base hook' => 'status_messages',
        'variables' => ['status_headings' => [], 'message_list' => NULL],
      ],
    ];
  }

  #[Hook('library_info_alter')]
  public function onLibraryInfoAlter(array &$libraries, string $extension): void {
    if ($extension === 'admin_toolbar_messages'
      && $this->moduleHandler->moduleExists('navigation')
      && $this->moduleHandler->moduleExists('gin_toolbar')
    ) {
      unset($libraries['navigation']['css']['theme']['css/navigation.css']);
      $libraries['navigation']['css']['theme']['css/navigation.gin.css'] = [];
    }
  }

}
