<?php

declare(strict_types=1);

namespace Drupal\admin_toolbar_messages\Hook;

use Drupal\admin_toolbar_messages\AdminToolbarMessagesBuilder;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\AdminContext;

final class ToolbarHooks {

  public function __construct(
    private readonly AdminContext $adminContext,
  ) {}

  #[Hook('toolbar')]
  public function onBuild(): array {
    if ($this->adminContext->isAdminRoute()) {
      return [];
    }

    $items['admin_toolbar_messages'] = [
      'tab' => [
        'messages' => [
          '#lazy_builder' => [AdminToolbarMessagesBuilder::class . '::build', []],
          '#create_placeholder' => TRUE,
        ],
      ],
      '#attached' => [
        'library' => [
          'admin_toolbar_messages/toolbar',
        ],
      ],
      '#weight' => 1100,
      '#wrapper_attributes' => [
        'class' => ['admin-toolbar-messages-tab'],
      ],
    ];

    return $items;
  }

}
