(function ($, Drupal) {
  Drupal.behaviors.adminToolbarSearch = {
    attach: function (context, settings) {
      if (context != document) {
        return;
      }
      var getUrl = window.location;
      var baseUrl = getUrl .protocol + "//" + getUrl.host + "/";
      var $self = this;
      this.links = [];
      $('a[data-drupal-link-system-path]').each(function() {

        if (this.href != baseUrl) {
          $self.links.push({
            'value': $(this).attr('href'),
            'label': this.text + ' ' + $(this).attr('href')
          });
        }
      });

      $( "#admin-toolbar-search-input").autocomplete({
        source: $self.links,
        open: function(){
          var zIndex = $('#toolbar-item-administration-search-tray').css("z-index")+1;
          $(this).autocomplete('widget').css('z-index', zIndex);
          return false;
        },
        select: function( event, ui ) {
          if (ui.item.value) {
            location.href = ui.item.value;
            return false;
          }
        }
      });
    }
  };
})(jQuery, Drupal);
