<?php

namespace Drupal\admin_toolbar_toggle;

use Drupal\Core\Security\TrustedCallbackInterface;

class AdminToolbarToggle implements TrustedCallbackInterface {

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks(): array {
    return ['preRender'];
  }

  /**
   * Attach AdminToolbarToggle settings.
   */
  public static function preRender(array $element): array {
    $config = \Drupal::config('admin_toolbar_toggle.settings');
    $element['#attached']['drupalSettings']['admin_toolbar_toggle'] = ['key' => $config->get('key')];

    return $element;
  }

}
