<?php

namespace Drupal\Tests\admin_ui_only\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Admin UI Only module.
 *
 * @group admin_ui_only
 */
class AdminUiOnlyTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['node', 'admin_ui_only'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->createContentType(['type' => 'article']);
  }

  /**
   * Tests the normal operation of the module.
   */
  public function testAdminUiOnlyHappyPath(): void {
    // Login as an admin user to set up VG Wort, use the field UI and create
    // content.
    $admin_user = $this->createUser([], 'site admin', TRUE);
    $this->drupalLogin($admin_user);

    // Save a node and ensure we are redirected to admin/content.
    $this->drupalGet('node/add/article');
    $this->assertSession()->fieldExists('title[0][value]')->setValue('Test node');
    $this->submitForm([], 'Save');
    $this->assertSession()->addressEquals('admin/content');

    // Ensure accessing the node via HTML results in a 404.
    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(404);

    $this->drupalLogout();

    // 404 for anonymous users too.
    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(404);

    // Ensure the module can be uninstalled without everything breaking.
    $this->drupalLogin($admin_user);
    $this->drupalGet('admin/modules/uninstall');
    $this->assertSession()->fieldExists('uninstall[admin_ui_only]')->check();
    $this->submitForm([], 'Uninstall');
    $this->submitForm([], 'Uninstall');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->fieldNotExists('uninstall[admin_ui_only]');
    $this->drupalLogout();

    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(200);

    // Install the module again to ensure it can be.
    $this->drupalLogin($admin_user);
    $this->drupalGet('admin/modules');
    $this->assertSession()->fieldExists('modules[admin_ui_only][enable]')->check();
    $this->submitForm([], 'Install');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Module Admin UI Only has been enabled.');

    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(404);
  }

}
