<?php

namespace Drupal\admintoolbar_bgcolor\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class initialization.
 */
class AtbgColorSettingsForm extends ConfigFormBase {

  /**
   * Function to get form id.
   */
  public function getFormId() {
    return 'admintoolbar_bgcolor_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['admintoolbar_bgcolor.settings'];
  }

  /**
   * Build method.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('admintoolbar_bgcolor.settings');

    // Attach the color_field color picker.
    $form['admintoolbar_bgcolor'] = [
      '#type' => 'color',
      '#title' => $this->t('CSS Background Color Value for Admin Toolbar'),
      '#default_value' => $config->get('admintoolbar_bgcolor') ?: '#ffffff',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * Submit method.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('admintoolbar_bgcolor.settings')
      ->set('admintoolbar_bgcolor', $form_state->getValue('admintoolbar_bgcolor'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
