<?php
/**
 * @file
 * Contains Batch API callbacks used during installation.
 */

/**
 * BatchAPI callback.
 *
 * Enables a single module.
 *
 * @see ads_install_additional_modules()
 */
function _ads_enable_module($module, $module_name, &$context) {
  module_enable(array($module), FALSE);
  $context['message'] = st('Installed %module module.', array('%module' => $module_name));
}

/**
 * BatchAPI callback.
 *
 * Flushes all caches.
 *
 * @see ads_cleanup()
 */
function _ads_flush_caches($operation, &$context) {
  $context['message'] = t('@operation', array('@operation' => $operation));
  drupal_flush_all_caches();
}

/**
 * Batch API callback.
 *
 * Reverts all installed ads features.
 *
 * @see ads_cleanup()
 */
function _ads_revert_all_features($operation, &$context) {
  $context['message'] = t('@operation', array('@operation' => $operation));
  features_revert();
}

/**
 * BatchAPI callback.
 *
 * Imports a migration.
 *
 * @see ads_import_content()
 */
function _ads_import($operation, $type, &$context) {
  $context['message'] = t('@operation', array('@operation' => $type));
  $migration =  Migration::getInstance($operation);
  $migration->processImport();
}

/**
 * BatchAPI callback.
 *
 * Rolls back a migration.
 *
 * @see ads_core_demo_rollback()
 */
function _ads_rollback($operation, $type, &$context) {
  $context['message'] = t('@operation', array('@operation' => $type));
  $migration =  Migration::getInstance($operation);
  $migration->processRollback();
}

/**
 * BatchAPI callback.
 *
 * Sets titles for FacetAPI blocks.
 *
 * @see ads_cleanup()
 */
function _ads_facet_block_titles($delta, $title, $operation, &$context) {
  $context['message'] = t('@operation', array('@operation' => $operation));

  db_update('block')
    ->fields(array('title' => $title))
    ->condition('module', 'facetapi', '=')
    ->condition('theme', 'cloudy', '=')
    ->condition('delta', $delta, '=')
    ->execute();
}

/**
 * Batch API finished callback.
 *
 * @see ads_import_content()
 * @see ads_core_demo_import()
 */
function ads_import_content_finished($success, $results) {
  // Remove messages generated by Migrate.
  // drupal_get_messages(NULL, TRUE);

  if ($success) {
    drupal_set_message(t('Finished importing demo content.'), 'status', FALSE);
  }
  else {
    drupal_set_message(t('Error importing demo content.'), 'error', FALSE);
  }
}

/**
 * Batch API finished callback.
 *
 * @see ads_core_demo_rollback()
 */
function ads_rollback_content_finished($success, $results) {
  // Remove messages generated by Migrate.
  // drupal_get_messages(NULL, TRUE);

  if ($success) {
    drupal_set_message(t('Finished removing demo content.'), 'status', FALSE);
  }
  else {
    drupal_set_message(t('Error removing demo content.'), 'error', FALSE);
  }
}


/**
 * Batch API finished callback.
 *
 * @see ads_cleanup()
 */
function ads_cleanup_finished($success, $results) {
  // Remove any lingering messages.
  // drupal_get_messages(NULL, TRUE);

  if ($success) {
    drupal_set_message(t('Post-install cleanup successful.'), 'status', FALSE);
  }
  else {
    drupal_set_message(t('Error perfoming post-install cleanup.'), 'error', FALSE);
  }
}
