<?php

namespace Drupal\advance_importer\Plugin\Processor;

use Drupal\advance_importer\Plugin\ProcessorBase;

/**
 * Class JSON Processor.
 *
 * @Processor(
 *   id = "json_processor",
 *   label = @Translation("JSON")
 * )
 */
class JSON extends ProcessorBase {

  protected const DELIMITER = ';';

  protected const EXTENSION = '.json';

  /**
   * @return array key|value
   * */
  public function getContents($start, $end) {
    $json = file_get_contents($this->getFilePath());
    $json = json_decode($json, TRUE);
    return array_slice($json, $start, ($end - $start));
  }

  /**
   * @return array
   * */
  public function getHeader() {
    $json = file_get_contents($this->getFilePath());
    $json = json_decode($json, TRUE);
    return array_keys($json[0]);
  }

  /**
   * @return int
   * */
  public function getTotalRows() {
    $json = file_get_contents($this->getFilePath());
    $json = json_decode($json, TRUE);
    return count($json);
  }

  /**
   * {@inheritdoc}
   * Export
   */
  public function parseContent($data, $FILE_EXPORT, $HEADER_KEY_VALUE_DELIMITER, $MULTI_DELIMITER, $batch_contents) {
    $separate_flag = TRUE;
    if ($batch_contents['end'] == $batch_contents['total']) {
      $separate_flag = FALSE;
    }
    $filename = $this->configuration['entity_type'] . '_' . $this->configuration['entity_type_bundle'] . self::EXTENSION;
    $h_file = fopen($FILE_EXPORT . $filename, 'r');
    $header = fread($h_file, 10);
    fclose($h_file);
    [$header_entity, $fields] = $data;
    $file = fopen($FILE_EXPORT . $filename, 'a');
    if (empty($header)) {
      fwrite($file, '[');
    }
    foreach ($fields as $index => $field) {
      fwrite($file, json_encode($field));
      if ($separate_flag) {
        fwrite($file, ',');
      }

      if ($separate_flag == FALSE && count($fields) != ($index + 1)) {
        fwrite($file, ',');
      }

      if ($separate_flag == FALSE && count($fields) == ($index + 1)) {
        fwrite($file, ']');
      }
    }
    fclose($file);
  }

  /**
   * {@inheritdoc}
   * Export
   */
  public function initFile($FILE_EXPORT) {
    $filename = $this->configuration['entity_type'] . '_' . $this->configuration['entity_type_bundle'] . self::EXTENSION;
    $file = fopen($FILE_EXPORT . $filename, 'w');
    fclose($file);
  }

}
